;RM82TS8,16,24,32,40,48
; Updated 11/20/90

;============================================================================
;   Copyright (C) Copr. 1990 by Sidney J. Kelly
;           All Rights Reserved.
;           Sidney J. Kelly
;           150 Woodhaven Drive
;           Pittsburgh, PA 15228
;           home phone 412-561-0950 (7pm to 9:30pm EST)
;============================================================================

;===========================================================================
;DECLARE FUNCTION S2BUFF  ;put text screen in buffer
;DECLARE FUNCTION BUFF2S  ;get text screen from buffer
;
; Allows movement of text screens, page 0 to and from a buffer.
; Modified to handle a CGA display so will NOT cause SNOW on a CGA
;
; Handles  80 x 25, 80 x 43, and 80 x 50 displays.  Checks current status
; each time it makes a shift.
;
; Storage in Code Segment used to save space in DGROUP, makes DATA near
; without using up the limited amount of DGROUP space.  However prevents
; use of program in OS/2 which prohibits any change to CodeSeg values.
;===========================================================================

DOSSEG
.MODEL MEDIUM

        PUBLIC   S2BUFF, BUFF2S

.data
	;external data so all video routines can access
	EVEN
	EXTRN  B$DVIDEOSEG:WORD
	EXTRN  B$DVIDEOPORT:WORD
	EXTRN  B$DVIDEOINSTL:BYTE
.code
 EXTRN   Get_Adapter:FAR
 INCLUDE  NOWAIT.INC      ;all the video common macros
;------------------------------Data Area----------------------------------
	EVEN            ;speed up access on an 80286,8086 machine
	BUFF            DW      4000 DUP(?) ;allow 80 x 25 to 80 x 50 display

EVEN
S2BUFF   PROC    FAR
	Push            BP             ;Save current display in the buffer
	Push            DS
	Push            SI
	Push            DI

        Assume          DS:@data

	Cmp             B$DVIDEOINSTL,1
	JE              Skip_Ahead
	Call 		Get_Adapter      ;get display information

Skip_Ahead:
				         ;determine video page size
				         ;do it the hard way because of error
				         ;in certain HERC clones
	Xor   		AX,AX            ;clear AX
	Mov   		ES,AX            ;set ES to BIOS ram
	Xor   		BH,BH            ;clear high byte
	Mov   		BL,Byte Ptr ES:[0484h]  ;read ROW from BIOS ram
	Or    		BL,BL   ;is ROW 0? (i.e. is this CGA, HERC or MONO?)
	JNZ   		@f               ;nope, it is a EGA, MCGA or VGA
	Mov   		BL,24            ;set default ROW to 24
@@:
	Inc   		BL               ;remove 0 bias of ROW
	Mov   		AX,ES:[044Ah]    ;read COLUMN from BIOS ram
	Mul   		BX               ;multiply ROW times COLUMN
	Mov		CX,AX		 ;load counter

	Mov		DX,B$DVIDEOPORT  ;DX =  VIDEOPORT address or 0
        Mov             AX,CS            ;point ES to CS
	Mov             ES,AX

	;have to be finished with stack or .data before can change DS
        Mov             DS,B$DVIDEOSEG ;DS points to video buffer

	;MUST KEEP THESE TO USE OFFSET RELATIVE TO THE CODE SEGMENT
	Assume		DS:NOTHING, ES:NOTHING

        Mov             DI,OFFSET CS:BUFF
	Xor             SI,SI          ;offset of display page 0
        Cld                            ;all data moves below will be forward
        Or              DL,DL          ;monochrome or EGA (is DL=0)?
	JZ              Mono           ;yes, skip over the retrace stuff

EVEN
CGA_Loop:
        CLI                            ;prevent interrupts
	Wait_CGA_Retrace               ;run CGA retrace macro
	Movsw                          ;move the data in one operation
	STI                            ;allow interrupts again
	Loop            CGA_Loop       ;loop until done

	Jmp             Short Exit     ;skip over the mono routine and exit

Mono:
	Rep             Movsw          ;move the data in one operation
				       ;Move DS:SI to ES:DI
Exit:
	Pop             DI             ;restore stack
	Pop             SI
	Pop             DS

        Assume          DS:@data

	Pop             BP
	Ret
S2BUFF   ENDP

;===========================================================================
; Restores saved buffer to screen
;===========================================================================

EVEN
BUFF2S   PROC    FAR
	Push            BP                ;Save registers
	Push            DS
	Push            SI
	Push            DI

        Assume          DS:@data

	Cmp             B$DVIDEOINSTL,1
	JE              skip_over
	Call 		Get_Adapter     ;get display information

skip_over:
				         ;determine video page size
				         ;do it the hard way because of error
				         ;in certain HERC clones
	Xor   		AX,AX            ;clear AX
	Mov   		ES,AX            ;set ES to BIOS ram
	Xor   		BH,BH            ;clear high byte
	Mov   		BL,Byte Ptr ES:[0484h]  ; read ROW from BIOS ram
	Or    		BL,BL   ; is ROW 0? (i.e. is this CGA, HERC or MONO?)
	JNZ   		@f               ;nope, it is a EGA, MCGA or VGA
	Mov   		BL,24            ;set default ROW to 24
@@:
	Inc   		BL               ;remove 0 bias of ROW
	Mov   		AX,ES:[044Ah]    ;read COLUMN from BIOS ram
	Mul   		BX               ;multiply ROW times COLUMN
	Mov		CX,AX		 ;load counter
	
	Mov             ES,B$DVIDEOSEG  ;ES points to video buffer
	Mov             DX,B$DVIDEOPORT ;DX contains B$DVIDEOPORT address or 0

	Mov             AX,CS           ;set DS to code segment
	Mov             DS,AX

        ;MUST KEEP THESE TO USE OFFSET RELATIVE TO THE CODE SEGMENT
	Assume		DS:NOTHING, ES:NOTHING

	Mov             SI, OFFSET CS:BUFF
	Xor             DI,DI        ;offset on screen page 0

	Cld                          ;all data moves below will be forward
	Or              DL,DL        ;monochrome or EGA (is DL = 0)?
	JZ              Mono1        ;yes, skip over the retrace stuff

EVEN
CGA1:

	CLI                          ;prevent interrupts
	Wait_CGA_Retrace             ;run CGA retrace macro
	Movsw                        ;move data by words  DS:SI to ES:DI
	STI                          ;allow interrupts again
	Loop            CGA1         ;loop until done
	Jmp             Short Exit1  ;skip over the mono routine and exit

Mono1:
	Rep             Movsw        ;move the data in one operation
				     ;Move DS:SI to ES:DI
Exit1:
	Pop             DI           ;restore stack
	Pop             SI
	Pop             DS

        Assume          DS:@data

	Pop             BP
	Ret
BUFF2S   ENDP
END
