REM $DYNAMIC
DEFINT A-Z

'--- Types
TYPE Colrs
     Red  AS STRING * 1
     Green AS STRING * 1
     Blue AS STRING * 1
END TYPE
TYPE AMP
     CurrentX  AS INTEGER
     CurrentY  AS INTEGER
     StartX    AS INTEGER
     StartY    AS INTEGER
     EndX      AS INTEGER
     EndY      AS INTEGER
     Stage     AS STRING * 1
     Direction AS INTEGER
END TYPE

DECLARE SUB Set80x25 ()
DECLARE SUB Set320x200 ()
DECLARE SUB Set320x240 ()
DECLARE SUB Set320x400 ()
DECLARE SUB Set360x480 ()

DECLARE SUB Put240 (BYVAL X1%, BYVAL Y1%, SEG Array AS ANY)
DECLARE SUB Put360 (BYVAL X1%, BYVAL Y1%, SEG Array AS ANY)

DECLARE SUB Get200 (BYVAL X1%, BYVAL Y1%, BYVAL X2%, BYVAL Y2%, SEG Array AS ANY)
DECLARE SUB Put200 (BYVAL X1%, BYVAL Y1%, SEG Array AS ANY, BYVAL Attr%)
DECLARE SUB TPut200 (BYVAL X1%, BYVAL Y1%, SEG Array AS ANY)
DECLARE SUB RPUT200 (BYVAL X1%, BYVAL Y1%, SEG Array AS ANY)
DECLARE SUB VPut (SEG Array1 AS ANY, BYVAL X%, BYVAL Y%, SEG Array2 AS ANY)
DECLARE SUB VTPUT (SEG Array1 AS ANY, BYVAL X%, BYVAL Y%, SEG Array2 AS ANY)
DECLARE SUB VGET (SEG Array1 AS ANY, BYVAL X1%, BYVAL Y1%, BYVAL X2%, BYVAL Y2%, SEG Array2 AS ANY)
DECLARE SUB CreateVirtualScreen (SEG Array AS ANY, BYVAL NumCols%, BYVAL NumRows%)
DECLARE SUB RestorePal (SEG Array AS ANY)

DECLARE SUB Keystroke (First%, Second%)
DECLARE SUB DrawMan ()
DECLARE SUB DrawScreen ()

DIM SHARED VScreen%(0 TO 19000)
DIM SHARED Blank%(0 TO 19000)
DIM SHARED Active%(0 TO 19000)

DIM SHARED Colors(0 TO 256) AS Colrs
DIM SHARED Man AS AMP

DIM SHARED Walls%(0 TO 2000)
DIM SHARED Figure%(0 TO 2000)
DIM SHARED Map$(1 TO 30)

SCREEN 0
CLS

LOCATE 1, 1
PRINT "Select Type of Character:"

LOCATE 3, 1
PRINT "   A)  Ranger "
PRINT "   B)  Thief  "
PRINT "   C)  Paladin"
PRINT "   D)  Mage   "
i$ = UCASE$(INKEY$)
WHILE i$ <> CHR$(27) AND (i$ < "A" OR i$ > "D")
      i$ = UCASE$(INKEY$)
WEND
IF i$ = CHR$(27) THEN GOTO AllDone
SELECT CASE i$
       CASE "A"
            Char$ = "Ranger"
       CASE "B"
            Char$ = "Thief"
       CASE "C"
            Char$ = "Paladin"
       CASE "D"
            Char$ = "Mage"
END SELECT

CLS
LOCATE 1, 1
PRINT "Select Mode To Run:"
LOCATE 3, 1
PRINT "   1)  320x200"
PRINT "   2)  320x240"
PRINT "   3)  320x400"
PRINT "   4)  360x480"
i$ = INKEY$
WHILE i$ <> CHR$(27) AND (i$ < "1" OR i$ > "4")
      i$ = INKEY$
WEND
IF i$ = CHR$(27) THEN GOTO AllDone
Mode$ = i$

Set320x200

'---Load the sprites for this animation
    DEF SEG = VARSEG(Walls%(0))
    BLOAD "Walls.Dat", VARPTR(Walls%(0))
    DEF SEG

    DEF SEG = VARSEG(Figure%(0))
    BLOAD Char$ + ".Dat", VARPTR(Figure%(0))

'---Load the palette for this animation
    DEF SEG = VARSEG(Colors(0))
    BLOAD "Scroll.Plt", VARPTR(Colors(0))
    DEF SEG
   
'---Set intial paramters
    Man.CurrentX = 3
    Man.CurrentY = 4
    Man.StartX = 1
    Man.StartY = 1
    Man.EndX = 9
    Man.EndY = 9
    Man.Stage = "1"
    Man.Direction = 2

'---The Map
    Map$(1) = " Ŀ        Ŀ       Ŀ "
    Map$(2) = " Ŀ          "
    Map$(3) = "           "
    Map$(4) = " Ŀ  Ŀ        "
    Map$(5) = "             "
    Map$(6) = "             "
    Map$(7) = " Ŀ     Ŀ "
    Map$(8) = "   Ŀ      Ŀ                 "
    Map$(9) = "              Ŀ "
    Map$(10) = "               "
    Map$(11) = " Ŀ      Ŀ        "
    Map$(12) = "   Ŀ                    "
    Map$(13) = "  "
    Map$(14) = "  "
    Map$(15) = " Ŀ "
    Map$(16) = "         Ŀ            "
    Map$(17) = " Ŀ              "
    Map$(18) = "               "
    Map$(19) = " Ŀ  Ŀ            "
    Map$(20) = "                 "
    Map$(21) = "                 "
    Map$(22) = " Ŀ     Ŀ     "
    Map$(23) = "   Ŀ      Ŀ                 "
    Map$(24) = "                        "
    Map$(25) = "                        "
    Map$(26) = " Ŀ      Ŀ                 "
    Map$(27) = "   Ŀ                             "
    Map$(28) = "                     "
    Map$(29) = "                     "
    Map$(30) = "                     "

'---Create Virtual Screen
    Get200 0, 0, 160, 160, VScreen%(0)
    Get200 0, 0, 160, 160, Blank%(0)

    SELECT CASE VAL(Mode$)
           CASE 1
                Set320x200
                RestorePal Colors(0)
           CASE 2
                Set320x240
                RestorePal Colors(0)
           CASE 3
                Set320x400
                RestorePal Colors(0)
           CASE 4
                Set360x480
                RestorePal Colors(0)
    END SELECT

'---Draw Screem
    DrawScreen
  
'--Draw Man
    DrawMan

'---Display Screen
    SELECT CASE VAL(Mode$)
           CASE 1
                Put200 0, 0, Active%(0), 0
           CASE 2
                Put240 0, 0, Active%(0)
           CASE 3
                Put240 0, 0, Active%(0)
           CASE 4
                Put360 0, 0, Active%(0)
    END SELECT

'---Wait for a Keystroke
    Keystroke First%, Second%

'---The Loop
    DO
      IF First% > 0 THEN
         IF First% = 27 THEN
            EXIT DO
         END IF
      ELSE
         SELECT CASE Second%
                CASE 71
                     Man.Direction = 1
                     X% = Man.CurrentX - 1
                     Y% = Man.CurrentY - 1
                     IF ASC(MID$(Map$(X%), Y%, 1)) = 254 THEN
                        Man.CurrentX = X%
                        Man.CurrentY = Y%
                     END IF
                CASE 72
                     Man.Direction = 1
                     X% = Man.CurrentX - 1
                     Y% = Man.CurrentY
                     IF ASC(MID$(Map$(X%), Y%, 1)) = 254 THEN
                        Man.CurrentX = X%
                     END IF
                CASE 73
                     Man.Direction = 1
                     X% = Man.CurrentX - 1
                     Y% = Man.CurrentY + 1
                     IF ASC(MID$(Map$(X%), Y%, 1)) = 254 THEN
                        Man.CurrentX = X%
                        Man.CurrentY = Y%
                     END IF
                CASE 75
                     Man.Direction = 4
                     X% = Man.CurrentX
                     Y% = Man.CurrentY - 1
                     IF ASC(MID$(Map$(X%), Y%, 1)) = 254 THEN
                        Man.CurrentY = Y%
                     END IF
                CASE 77
                     Man.Direction = 2
                     X% = Man.CurrentX
                     Y% = Man.CurrentY + 1
                     IF ASC(MID$(Map$(X%), Y%, 1)) = 254 THEN
                        Man.CurrentY = Y%
                     END IF
                CASE 79
                     Man.Direction = 3
                     X% = Man.CurrentX + 1
                     Y% = Man.CurrentY - 1
                     IF ASC(MID$(Map$(X%), Y%, 1)) = 254 THEN
                        Man.CurrentX = X%
                        Man.CurrentY = Y%
                     END IF
                CASE 80
                     Man.Direction = 3
                     X% = Man.CurrentX + 1
                     Y% = Man.CurrentY
                     IF ASC(MID$(Map$(X%), Y%, 1)) = 254 THEN
                        Man.CurrentX = X%
                     END IF
                CASE 81
                     Man.Direction = 3
                     X% = Man.CurrentX + 1
                     Y% = Man.CurrentY + 1
                     IF ASC(MID$(Map$(X%), Y%, 1)) = 254 THEN
                        Man.CurrentX = X%
                        Man.CurrentY = Y%
                     END IF

         END SELECT
      END IF
      DrawScreen
      DrawMan
      SELECT CASE VAL(Mode$)
             CASE 1
                  Put200 0, 0, Active%(0), 0
             CASE 2
                  Put240 0, 0, Active%(0)
             CASE 3
                  Put240 0, 0, Active%(0)
             CASE 4
                  Put360 0, 0, Active%(0)
      END SELECT
      Keystroke First%, Second%
    LOOP

'---All Done
AllDone:
    Set80x25
    CLS

    PRINT "SCROLL DEMO.  (C) Copyright 1991, SCN Creative Solutions"
    PRINT " "
    PRINT "Thanks for trying out the VGALIB scrolling DEMO.  Remember: If you register,"
    PRINT "you'll get the source code and data files for this demo."
    PRINT " "
    COLOR 15
    PRINT "To Register, send Check or Money Order To:"
    COLOR 14
    PRINT ""
    PRINT "           John Cressman        "
    PRINT "       1043 Main Street, Flr 2  "
    PRINT "         Emerald, PA  18080     "
    PRINT ""
    COLOR 7
    END

REM $STATIC
SUB DrawMan
    A$ = Man.Stage
    SELECT CASE A$
           CASE "1"
                Man.Stage = "2"
                Offset% = 0
           CASE "2"
                Man.Stage = "3"
                Offset% = 130
           CASE "3"
                Man.Stage = "1"
                Offset% = 260
    END SELECT
    A% = Man.Direction
    SELECT CASE A%
           CASE 1
                Offset% = Offset% + 0
           CASE 2
                Offset% = Offset% + 390
           CASE 3
                Offset% = Offset% + 780
           CASE 4
                Offset% = Offset% + 1170
    END SELECT
   
    StartX% = Man.CurrentX% - 4
    EndX% = Man.CurrentX% + 4
    IF StartX% < 1 THEN
       StartX% = 1
       EndX% = StartX% + 8
    END IF
    IF EndX% > 30 THEN
       EndX% = 30
       StartX% = EndX% - 8
    END IF
      
    StartY% = Man.CurrentY% - 4
    EndY% = Man.CurrentY% + 4
    IF StartY% < 1 THEN
       StartY% = 1
       EndY% = StartY% + 8
    END IF
    IF EndY% > 50 THEN
       EndY% = 50
       StartY% = EndY% - 8
    END IF


    OffsetY% = 0
    OffsetX% = 0
    FOR X% = StartX% TO EndX%
        FOR Y% = StartY% TO EndY%
            IF X% = Man.CurrentX% AND Y% = Man.CurrentY% THEN
               VTPUT Active%(0), OffsetY%, OffsetX%, Figure%(Offset%)
               EXIT FOR
            END IF
            OffsetY% = OffsetY% + 16
        NEXT Y%
        OffsetX% = OffsetX% + 16
        OffsetY% = 0
    NEXT X%
END SUB

SUB DrawScreen
   
    '---Clear Virtual Screen
        VPut VScreen%(0), 0, 0, Blank%(0)
   
    '---Set Draw More
        DrawMore% = 1

    '---Set Offsets
        OffsetX% = 0
        OffsetY% = 0

    '---Set StartX%, StartY%
        StartX% = Man.CurrentX% - 4
        EndX% = Man.CurrentX% + 4
        IF StartX% < 1 THEN
           StartX% = 1
           EndX% = StartX% + 8
        END IF
        IF EndX% > 30 THEN
           EndX% = 30
           StartX% = EndX% - 8
        END IF
       
        StartY% = Man.CurrentY% - 4
        EndY% = Man.CurrentY% + 4
        IF StartY% < 1 THEN
           StartY% = 1
           EndY% = StartY% + 8
        END IF
        IF EndY% > 50 THEN
           EndY% = 50
           StartY% = EndY% - 8
        END IF

    '---Do For...Next Loop to Draw the Virtual Screen
       
        FOR i = StartX TO EndX%
            OffsetX% = 0
            'IF MID$(Map$(i), Man.StartY, 10) = SPACE$(10) THEN EXIT FOR
           
            FOR t = StartY% TO EndY%
                A% = ASC(MID$(Map$(i), t, 1))
                IF t = 1 THEN
                   B% = 0
                ELSE
                   B% = ASC(MID$(Map$(i), t - 1, 1))
                END IF

                IF t = 50 THEN
                   C% = 0
                ELSE
                   C% = ASC(MID$(Map$(i), t + 1, 1))
                END IF
                SELECT CASE A%
                       CASE 179
                            VTPUT VScreen%(0), OffsetX%, OffsetY%, Walls%(0)
                       CASE 196
                            VTPUT VScreen%(0), OffsetX%, OffsetY%, Walls%(130)
                       CASE 191
                            IF C% = 254 THEN
                               VPut VScreen%(0), OffsetX%, OffsetY%, Walls%(780)
                               VTPUT VScreen%(0), OffsetX%, OffsetY%, Walls%(260)
                            ELSE
                               VTPUT VScreen%(0), OffsetX%, OffsetY%, Walls%(260)
                            END IF
                       CASE 192
                            IF B% = 254 THEN
                               VPut VScreen%(0), OffsetX%, OffsetY%, Walls%(780)
                               VTPUT VScreen%(0), OffsetX%, OffsetY%, Walls%(390)
                            ELSE
                               VTPUT VScreen%(0), OffsetX%, OffsetY%, Walls%(390)
                            END IF
                       CASE 217
                            VTPUT VScreen%(0), OffsetX%, OffsetY%, Walls%(520)
                       CASE 218
                            VTPUT VScreen%(0), OffsetX%, OffsetY%, Walls%(650)
                       CASE 254
                            VPut VScreen%(0), OffsetX%, OffsetY%, Walls%(780)
                END SELECT
                OffsetX% = OffsetX% + 16
            NEXT t
            OffsetY% = OffsetY% + 16
        NEXT i

        VGET VScreen%(0), 0, 0, 160, 160, Active%(0)

END SUB

SUB Keystroke (First%, Second%)
    i$ = INKEY$
    WHILE i$ = ""
          i$ = INKEY$
    WEND
    IF LEN(i$) = 1 THEN
       First% = ASC(i$)
       Second% = 0
    ELSE
       First% = 0
       Second% = ASC(RIGHT$(i$, 1))
    END IF

END SUB

