'
'       This is a demo program created by one of VGALIB's registered users,
'       RICHARD HINTSALA, and distributed with his permission.  It was
'       written by Richard, and then converted to use VGALIB routines by
'       myself...the result is a good demonstration of the power of VGALIB.
'
'
'
'       (c) Copyright, 1992.  Richard Hintsala.


'$DYNAMIC
DECLARE FUNCTION Shade& (red!, green!, blue!)
DECLARE SUB InitPalette ()
DECLARE SUB Sphere (xc%, yc%, RADIUS!)

'--- GET/PUT Commands for the 320x200 mode
     DECLARE SUB Get200 (BYVAL X1%, BYVAL Y1%, BYVAL X2%, BYVAL Y2%, SEG Array AS ANY)
     DECLARE SUB PUT200 (BYVAL X1%, BYVAL Y1%, SEG Array AS ANY, BYVAL Attr%)
     DECLARE SUB PUT360 (BYVAL X1%, BYVAL Y1%, SEG Array AS ANY, BYVAL Attr%)
     DECLARE SUB BoxF200 (BYVAL X1%, BYVAL Y1%, BYVAL X2%, BYVAL Y2%, BYVAL Colr%)

'--- Virtual Screen Commands
     DECLARE SUB VPUT (SEG Array1 AS ANY, BYVAL X%, BYVAL Y%, SEG Array2 AS ANY)
     DECLARE SUB VTPUT (SEG Array1 AS ANY, BYVAL X%, BYVAL Y%, SEG Array2 AS ANY)
     DECLARE SUB VGET (SEG Array1 AS ANY, BYVAL X1%, BYVAL Y1%, BYVAL X2%, BYVAL Y2%, SEG Array2 AS ANY)
       
     DIM SHARED VScreen&(16100)
     DIM SHARED Blank&(16100)
     BoxF200 0, 0, 319, 199, 255
     Get200 0, 0, 319, 199, VScreen&(0)
     Get200 0, 0, 319, 199, Blank&(0)
   
     RANDOMIZE TIMER
     DIM SHARED IGM(12, 3)
     DIM ORG(12, 3)
     SCREEN 13

dist = 600: MX = 6: MY = 4: MZ = 30
FOR Q = 0 TO 11
READ A, b, c
A = A - 1
b = b - 1
ORG(Q, 0) = A * 2.4
ORG(Q, 1) = b * 2.4
ORG(Q, 2) = c * 2.4
NEXT Q
CALL InitPalette

        BoxF200 0, 0, 319, 199, 255
        RADIUS = 2
        X1% = 0
        Y1% = 0
        X2% = (RADIUS * 2) * 1.333
        Y2% = (RADIUS * 2)
        xrange% = X2% - X1% + 1: yrange% = Y2% - Y1% + 1
        numbytes% = 4 + INT((xrange% * 8 + 7) / 8) * yrange%
        arrsize% = (numbytes% - 1) \ 2
        DIM SHARED Img1%(arrsize%)
        X% = RADIUS: Y% = Y2% - RADIUS
        CALL Sphere(X%, Y%, RADIUS - 1)
        Get200 X1%, Y1%, X2%, Y2%, Img1%(0)
       
        BoxF200 0, 0, 319, 199, 255
        RADIUS = 3
        X1% = 0
        Y1% = 0
        X2% = (RADIUS * 2) * 1.333
        Y2% = (RADIUS * 2)
        xrange% = X2% - X1% + 1: yrange% = Y2% - Y1% + 1
        numbytes% = 4 + INT((xrange% * 8 + 7) / 8) * yrange%
        arrsize% = (numbytes% - 1) \ 2
        DIM SHARED Img2%(arrsize%)
        X% = RADIUS: Y% = Y2% - RADIUS
        CALL Sphere(X%, Y%, RADIUS - 1)
        Get200 X1%, Y1%, X2%, Y2%, Img2%(0)
       
        BoxF200 0, 0, 319, 199, 255
        RADIUS = 4
        X1% = 0
        Y1% = 0
        X2% = (RADIUS * 2) * 1.333
        Y2% = (RADIUS * 2)
        xrange% = X2% - X1% + 1: yrange% = Y2% - Y1% + 1
        numbytes% = 4 + INT((xrange% * 8 + 7) / 8) * yrange%
        arrsize% = (numbytes% - 1) \ 2
        DIM SHARED Img3%(arrsize%)
        X% = RADIUS: Y% = Y2% - RADIUS
        CALL Sphere(X%, Y%, RADIUS - 1)
        Get200 X1%, Y1%, X2%, Y2%, Img3%(0)
       
        BoxF200 0, 0, 319, 199, 255
        RADIUS = 5
        X1% = 0
        Y1% = 0
        X2% = (RADIUS * 2) * 1.333
        Y2% = (RADIUS * 2)
        xrange% = X2% - X1% + 1: yrange% = Y2% - Y1% + 1
        numbytes% = 4 + INT((xrange% * 8 + 7) / 8) * yrange%
        arrsize% = (numbytes% - 1) \ 2
        DIM SHARED Img4%(arrsize%)
        X% = RADIUS: Y% = Y2% - RADIUS
        CALL Sphere(X%, Y%, RADIUS - 1)
        Get200 X1%, Y1%, X2%, Y2%, Img4%(0)
       
        BoxF200 0, 0, 319, 199, 255
        RADIUS = 6
        X1% = 0
        Y1% = 0
        X2% = (RADIUS * 2) * 1.333
        Y2% = (RADIUS * 2)
        xrange% = X2% - X1% + 1: yrange% = Y2% - Y1% + 1
        numbytes% = 4 + INT((xrange% * 8 + 7) / 8) * yrange%
        arrsize% = (numbytes% - 1) \ 2
        DIM SHARED Img5%(arrsize%)
        X% = RADIUS: Y% = Y2% - RADIUS
        CALL Sphere(X%, Y%, RADIUS - 1)
        Get200 X1%, Y1%, X2%, Y2%, Img5%(0)
       
        BoxF200 0, 0, 319, 199, 255
        RADIUS = 7
        X1% = 0
        Y1% = 0
        X2% = (RADIUS * 2) * 1.333
        Y2% = (RADIUS * 2)
        xrange% = X2% - X1% + 1: yrange% = Y2% - Y1% + 1
        numbytes% = 4 + INT((xrange% * 8 + 7) / 8) * yrange%
        arrsize% = (numbytes% - 1) \ 2
        DIM SHARED Img6%(arrsize%)
        X% = RADIUS: Y% = Y2% - RADIUS
        CALL Sphere(X%, Y%, RADIUS - 1)
        Get200 X1%, Y1%, X2%, Y2%, Img6%(0)
       
        BoxF200 0, 0, 319, 199, 255
        RADIUS = 8
        X1% = 0
        Y1% = 0
        X2% = (RADIUS * 2) * 1.333
        Y2% = (RADIUS * 2)
        xrange% = X2% - X1% + 1: yrange% = Y2% - Y1% + 1
        numbytes% = 4 + INT((xrange% * 8 + 7) / 8) * yrange%
        arrsize% = (numbytes% - 1) \ 2
        DIM SHARED Img7%(arrsize%)
        X% = RADIUS: Y% = Y2% - RADIUS
        CALL Sphere(X%, Y%, RADIUS - 1)
        Get200 X1%, Y1%, X2%, Y2%, Img7%(0)
       
        BoxF200 0, 0, 319, 199, 255
        RADIUS = 9
        X1% = 0
        Y1% = 0
        X2% = (RADIUS * 2) * 1.333
        Y2% = (RADIUS * 2)
        xrange% = X2% - X1% + 1: yrange% = Y2% - Y1% + 1
        numbytes% = 4 + INT((xrange% * 8 + 7) / 8) * yrange%
        arrsize% = (numbytes% - 1) \ 2
        DIM SHARED Img8%(arrsize%)
        X% = RADIUS: Y% = Y2% - RADIUS
        CALL Sphere(X%, Y%, RADIUS - 1)
        Get200 X1%, Y1%, X2%, Y2%, Img8%(0)
       
        BoxF200 0, 0, 319, 199, 255
        RADIUS = 10
        X1% = 0
        Y1% = 0
        X2% = (RADIUS * 2) * 1.333
        Y2% = (RADIUS * 2)
        xrange% = X2% - X1% + 1: yrange% = Y2% - Y1% + 1
        numbytes% = 4 + INT((xrange% * 8 + 7) / 8) * yrange%
        arrsize% = (numbytes% - 1) \ 2
        DIM SHARED Img9%(arrsize%)
        X% = RADIUS: Y% = Y2% - RADIUS
        CALL Sphere(X%, Y%, RADIUS - 1)
        Get200 X1%, Y1%, X2%, Y2%, Img9%(0)
       
        BoxF200 0, 0, 319, 199, 255
        RADIUS = 11
        X1% = 0
        Y1% = 0
        X2% = (RADIUS * 2) * 1.333
        Y2% = (RADIUS * 2)
        xrange% = X2% - X1% + 1: yrange% = Y2% - Y1% + 1
        numbytes% = 4 + INT((xrange% * 8 + 7) / 8) * yrange%
        arrsize% = (numbytes% - 1) \ 2
        DIM SHARED Img10%(arrsize%)
        X% = RADIUS: Y% = Y2% - RADIUS
        CALL Sphere(X%, Y%, RADIUS - 1)
        Get200 X1%, Y1%, X2%, Y2%, Img10%(0)
       
        CLS


DO
 R1 = R1 + .01
 R2 = R2 + .01
 R3 = R3 + .01
 sr1 = SIN(R1)
 CR1 = COS(R1)
 SR2 = SIN(R2)
 CR2 = COS(R2)
 SR3 = SIN(R3)
 CR3 = COS(R3)

 FOR Q = 0 TO 11
    X = ORG(Q, 0): Y = ORG(Q, 1): Z = ORG(Q, 2)
    X = (-1) * X
    XA = CR1 * X - sr1 * Z
    ZA = sr1 * X + CR1 * Z
    X = CR2 * XA + SR2 * Y
    YA = CR2 * Y - SR2 * XA
    Z = CR3 * ZA - SR3 * YA
    Y = SR3 * ZA + CR3 * YA
    X = X + MX
    Y = Y + MY
    Z = Z + MZ
    sx = dist * X / Z
    sy = dist * Y / Z
    SZ = Z
    IGM(Q, 0) = sx + 30
    IGM(Q, 1) = sy
    IGM(Q, 2) = SZ
 NEXT Q

 VPUT VScreen&(0), 0, 0, Blank&(0)
 FOR X = 0 TO 11
     SELECT CASE IGM(X, 2)
            CASE 0 TO 23
                 VTPUT VScreen&(0), IGM(X, 0), IGM(X, 1), Img1%(0)
            CASE 23 TO 24
                 VTPUT VScreen&(0), IGM(X, 0), IGM(X, 1), Img2%(0)
            CASE 24 TO 25
                 VTPUT VScreen&(0), IGM(X, 0), IGM(X, 1), Img3%(0)
            CASE 25 TO 26
                 VTPUT VScreen&(0), IGM(X, 0), IGM(X, 1), Img4%(0)
            CASE 26 TO 27
                 VTPUT VScreen&(0), IGM(X, 0), IGM(X, 1), Img5%(0)
            CASE 27 TO 28
                 VTPUT VScreen&(0), IGM(X, 0), IGM(X, 1), Img6%(0)
            CASE 28 TO 29
                 VTPUT VScreen&(0), IGM(X, 0), IGM(X, 1), Img7%(0)
            CASE 29 TO 30
                 VTPUT VScreen&(0), IGM(X, 0), IGM(X, 1), Img8%(0)
            CASE 30 TO 31
                 VTPUT VScreen&(0), IGM(X, 0), IGM(X, 1), Img9%(0)
             CASE 31 TO 34
                 VTPUT VScreen&(0), IGM(X, 0), IGM(X, 1), Img10%(0)
     END SELECT
 NEXT X
 PUT360 0, 0, VScreen&(0), 0
LOOP UNTIL INKEY$ <> ""

CLS
SCREEN 0: WIDTH 80, 25

DATA 1.0,2.24,0.6
DATA -0.18,1.38,0.6
DATA 0.27,0.0,0.6
DATA 1.73,0.0,0.6
DATA 2.18,1.38,0.6
DATA 1.0,-0.24,-0.6
DATA 2.18,0.62,-0.6
DATA 1.73,2.0,-0.6
DATA 0.27,2.0,-0.6
DATA -0.18,0.62,-0.6
DATA 1.0,1.0,1.6
DATA 1.0,1.0,-1.6

REM $STATIC
SUB InitPalette STATIC
        FOR i% = 0 TO 255
                r! = i% / 255
                g! = i% / 255
                b! = i% / 255
                PALETTE i%, Shade&(r!, g!, b!)
        NEXT i%
        PALETTE 255, 0
END SUB

FUNCTION Shade& (red!, green!, blue!) STATIC
        r& = red! * 63!
        'g& = green! * 63!
        b& = blue! * 63!
        Shade& = r& + g& * 256& + b& * 65536
END FUNCTION

SUB Sphere (xc%, yc%, RADIUS) STATIC
STATIC xx%, yy%
ambient = 10
Q = 255
b = .2: r = .6
DIM N(3), L(3), H(3)
L(1) = -.3: L(2) = -.3: L(3) = .72    'Light source position (vector w/0,0,0)

P = 1:                             ' A XOR LE control the size XOR
A = 30: LE = 1.86                  ' drop-off rate (specularity)
                                                                   ' of the PHONG. (as does the L vector)
ratio = 1.33333
'ratio = 1
xi% = xc%                             ' Ratio control for resolution.
yi% = yc%                          ' (stXORard rectangular pixels = 1.33333)
                                                                  ' xi% XOR yi% center sphere inside GUI box

rsqr = RADIUS * RADIUS
FOR yy = (yi% - RADIUS) TO (yi% + RADIUS)
FOR xx = (xi% - RADIUS) TO (xi% + RADIUS) * ratio STEP (1 / ratio)
   IF (xx - xi%) * (xx - xi%) + (yy - yi%) * (yy - yi%) < rsqr THEN
                 Z = SQR(rsqr - (xx - xi%) * (xx - xi%) - (yy - yi%) * (yy - yi%))
                 N(1) = (xx - xi%) / RADIUS
                 N(2) = (yy - yi%) / RADIUS
                 N(3) = Z / RADIUS
                 H(1) = L(1) / LE
                 H(2) = L(2) / LE
                 H(3) = (L(3) + 1) / LE
                 HdotN = H(1) * N(1) + H(2) * N(2) + H(3) * N(3)
                 ShN = ABS(1 * HdotN ^ A)
                 LdotN = L(1) * N(1) + L(2) * N(2) + L(3) * N(3)
                 ShL = P * LdotN * r
                 Sh = ShL + ShN + b * r
                 Sh = Sh * 255                ' Convert RGB (0-1) to palette (0-255)
                 IF Sh < 1 THEN Sh = ambient  ' Set Sh to black if it drops down into
                 IF Sh > 255 THEN Sh = 255    ' the 16 reserved colors, which is LOSSY
                 PSET (xx * ratio, yy), Sh    ' but necessary for GUI to remain ON.
           IF k$ <> "" THEN END               ' Ideal sphere would use all 256 colors.
           k$ = INKEY$                        ' (well, actually there's just 64...)
                 END IF                       ' break early on keypress - for testing only
        NEXT xx
NEXT yy
END SUB

