'
'
'
'
REM $DYNAMIC                                    'Make Arrays Dynamic
DEFINT A-Z                                      'Set up variables as integers

TYPE Chars                                      'Set up TYPE for Bits in Characters
     Bytes AS STRING * 1
END TYPE
TYPE Ltrs
     Lines AS STRING * 8
END TYPE
TYPE Fna
     NName AS STRING * 8
END TYPE
TYPE Nec
     NeedToBeSaved AS STRING * 1
END TYPE



DECLARE SUB BlinkCursor ()                      'Declare subroutines
DECLARE SUB ClearBit (X%, Y%)
DECLARE SUB DrawScreen ()
DECLARE SUB EraseDot ()
DECLARE SUB FillDot ()
DECLARE SUB HandleKeyStroke (First%, Second%)
DECLARE SUB Help ()
DECLARE SUB SetBit (X%, Y%)
DECLARE SUB WaitForKeyStroke (i$)
DECLARE SUB RedrawCharacter ()
DECLARE SUB DisplayBottomRow ()
DECLARE SUB LoadCharSet ()
DECLARE SUB SaveCharSet ()
DECLARE SUB GetValue (X%, Y%, i$, Value%)
DECLARE SUB CopyRange ()
DECLARE SUB GetString (Text$)

DECLARE SUB SetFont200 (SEG Array AS ANY)

SCREEN 13                                       'Go into Graphics Mode 320 x 200 in 256 colors
COLOR 15

DIM SHARED Bits(1 TO 8) AS Chars                'Dimension Array for Character info
DIM SHARED CharSet(0 TO 256) AS Ltrs            'Dimension Array for Character Set info
DIM SHARED Original(0 TO 256) AS Ltrs           'Dimension Array for Character Set info
DIM SHARED Values%(1 TO 8)                      'Dimension Array for Bit Values
DIM SHARED FontFile AS Fna                      'Dimension String for Filename
DIM SHARED Font AS Nec                          'Dimension String for Paramamters

'SetFont200 Original(0)


FOR i = 0 TO 256
    CharSet(i).Lines = Original(i).Lines
NEXT i


Values%(1) = 128                                'Load values for BITS
Values%(2) = 64
Values%(3) = 32
Values%(4) = 16
Values%(5) = 8
Values%(6) = 4
Values%(7) = 2
Values%(8) = 1
                                               

BeginChar% = 1                                  'Define Begin Character to print at bottom row
EndChar% = 18                                   'Last character to print on bottom row
CurrentChar% = 1                                'This contains which character we are on

DrawScreen                                      'Subroutine to Draw Initial Screen
DisplayBottomRow                                'Sub to draw the bottom character display box

BlinkTime! = .3                                 'How often we blink the edit cursor
CX% = 1                                         'Cursor X, Y positions for edit window
CY% = 1

FontFile.NName = SPACE$(8)
C$ = COMMAND$
IF C$ <> "" THEN
   FontFile.NName = UCASE$(LTRIM$(RTRIM$(C$)))
   DEF SEG = VARSEG(CharSet(0))
   BLOAD FontFile.NName + ".FNT", VARPTR(CharSet(0))
   DEF SEG
END IF

Font.NeedToBeSaved = "N"

WaitForKeyStroke i$                             'Wait until they press a useful key


DO
  IF LEN(i$) = 1 THEN                           'They pressed a standard key (Which is one character long)
     First% = ASC(UCASE$(i$))
     Second% = 0
  ELSE                                          'Otherwise they pressed an extended key (cursor key, etc)
     First% = 0
     Second% = ASC(RIGHT$(i$, 1))
  END IF
  HandleKeyStroke First%, Second%               'Sub to handle keystrokes
  WaitForKeyStroke i$                           'Wait for another keystroke
LOOP UNTIL i$ = CHR$(27)

REM $STATIC
SUB BlinkCursor STATIC
    SHARED CX%, CY%

    IF (CCX% > 0) AND (CCX% <> CX% OR CCY% <> CY%) THEN
       x1% = (CCX% * 9 - 9) + 51
       y1% = (CCY% * 9 - 9) + 21
       x2% = x1% + 9
       y2% = y1% + 9
       LINE (x1%, y1%)-(x2%, y2%), 0, B         ' Erase previous Box
    END IF

    x1% = (CX% * 9 - 9) + 51
    y1% = (CY% * 9 - 9) + 21
    x2% = x1% + 9
    y2% = y1% + 9
    IF Stat% = 1 THEN
       LINE (x1%, y1%)-(x2%, y2%), 4, B         ' Draw Box on Edit Window
    ELSE
       LINE (x1%, y1%)-(x2%, y2%), 0, B           ' Erase Box on Edit Window
    END IF

    CCX% = CX%
    CCY% = CY%
    IF Stat% = 1 THEN
       Stat% = 0
    ELSE
       Stat% = 1
    END IF
END SUB

SUB ClearBit (X%, Y%)
    DIM a%(1 TO 8)                      'Array to Hold Bit Values

    B% = ASC(Bits(Y%).Bytes)            'B%=ASCII value of Byte
  
    a%(1) = (B% AND 128)
    a%(2) = (B% AND 64)
    a%(3) = (B% AND 32)
    a%(4) = (B% AND 16)
    a%(5) = (B% AND 8)
    a%(6) = (B% AND 4)
    a%(7) = (B% AND 2)
    a%(8) = (B% AND 1)

    a%(X%) = 0                         'Set the Bit

    B% = 0
    FOR i = 1 TO 8
        B% = B% + a%(i)
    NEXT i

    Bits(Y%).Bytes = CHR$(B%)
END SUB

SUB CopyRange
    SHARED CX%, CY%
    SHARED BeginChar%, EndChar%, CurrentChar%
    DIM a%(6000)
    GET (60, 52)-(244, 108), a%(0)
    LINE (60, 52)-(244, 108), 0, BF
    LINE (61, 53)-(243, 107), 1, B
    LINE (62, 54)-(242, 106), 1, B
   
    LOCATE 8, 10
    PRINT "Copy Range"

    LOCATE 10, 10
    PRINT "From:     ";
    LOCATE 11, 10
    PRINT "To:       ";
    LOCATE 13, 10
    PRINT "How Many: ";


    Value% = CurrentChar%
    X% = 10
    Y% = 20
    i$ = INKEY$
    DO
     GetValue X%, Y%, i$, Value%
    LOOP UNTIL i$ = CHR$(13) OR i$ = CHR$(27)
    IF i$ = CHR$(27) THEN GOTO RestoreTheScreen
    FromChar% = Value%

    Value% = CurrentChar%
    X% = 11
    Y% = 20
    i$ = INKEY$
    DO
     GetValue X%, Y%, i$, Value%
    LOOP UNTIL i$ = CHR$(13) OR i$ = CHR$(27)
    IF i$ = CHR$(27) THEN GOTO RestoreTheScreen
    ToChar% = Value%

    Value% = 1
    X% = 13
    Y% = 20
    i$ = INKEY$
    DO
     GetValue X%, Y%, i$, Value%
    LOOP UNTIL i$ = CHR$(13) OR i$ = CHR$(27)
    IF i$ = CHR$(27) THEN GOTO RestoreTheScreen
    NumToCopy% = Value%

    FOR i% = FromChar% TO FromChar% + NumToCopy%
        IF i% > 255 OR ToChar% > 255 THEN EXIT FOR
        CharSet(ToChar%) = CharSet(i%)
        ToChar% = ToChar% + 1
    NEXT i%

RestoreTheScreen:
    PUT (60, 52), a%(0), PSET
    ERASE a%
    DisplayBottomRow
END SUB

SUB DisplayBottomRow
    SHARED BeginChar%, EndChar%, CurrentChar%
    COLOR 15
    LOCATE 6, 20
    PRINT USING "Current Char: ###"; CurrentChar%

    Cur% = BeginChar%

    FOR i = 1 TO EndChar% - BeginChar% + 1
        X% = i * 16 - 16
        IF Cur% = CurrentChar% THEN
           Colr% = 4
        ELSE
           Colr% = 15
        END IF
        LOCATE 21, i * 2 - 1

        Num% = Cur% MOD 10
        IF Num% = 0 THEN
          
           Third% = Cur% - 100
           IF Third% >= 0 THEN
              Third% = FIX(Cur% \ 100)
              LOCATE 19, i * 2 - 1
              PRINT USING "#"; Third%;

              Top% = FIX((Cur% \ 10) - Third% * 10)
             
              LOCATE 20, i * 2 - 1
              PRINT USING "#"; Top%;
           ELSE
              Top% = Cur% \ 10
              LOCATE 20, i * 2 - 1
              PRINT USING "#"; Top%;
           END IF

        ELSE
           LOCATE 19, i * 2 - 1
           PRINT " ";
           LOCATE 20, i * 2 - 1
           PRINT " ";
        END IF
        LOCATE 21, i * 2 - 1
        PRINT USING "#"; Num%;
        LINE (X%, 170)-(X% + 12, 183), Colr%, B
        Cur% = Cur% + 1
    NEXT i

    CharNum% = 1
   
    FOR Chars% = BeginChar% TO EndChar% STEP 1

        a$ = CharSet(Chars%).Lines
        xx% = CharNum% * 16 - 16 + 2

        FOR Lin% = 1 TO 8
            B% = ASC(MID$(a$, Lin%, 1))
            yy% = 172 + Lin%
          
            IF (B% AND 128) THEN PSET (xx% + 1, yy%), 14 ELSE PSET (xx% + 1, yy%), 0
            IF (B% AND 64) THEN PSET (xx% + 2, yy%), 14 ELSE PSET (xx% + 2, yy%), 0
            IF (B% AND 32) THEN PSET (xx% + 3, yy%), 14 ELSE PSET (xx% + 3, yy%), 0
            IF (B% AND 16) THEN PSET (xx% + 4, yy%), 14 ELSE PSET (xx% + 4, yy%), 0
            IF (B% AND 8) THEN PSET (xx% + 5, yy%), 14 ELSE PSET (xx% + 5, yy%), 0
            IF (B% AND 4) THEN PSET (xx% + 6, yy%), 14 ELSE PSET (xx% + 6, yy%), 0
            IF (B% AND 2) THEN PSET (xx% + 7, yy%), 14 ELSE PSET (xx% + 7, yy%), 0
            IF (B% AND 1) THEN PSET (xx% + 8, yy%), 14 ELSE PSET (xx% + 8, yy%), 0

        NEXT Lin%
        CharNum% = CharNum% + 1
    NEXT Chars%
    RedrawCharacter
END SUB

SUB DrawCharacter
    SHARED CX%, CY%
    SHARED BeginChar%, EndChar%, CurrentChar%
    FOR Y% = 1 TO 8
        IF ASC(Bits(Y%).Bytes) AND 1 THEN PSET (22, Y% + 21), 15
        IF ASC(Bits(Y%).Bytes) AND 2 THEN PSET (23, Y% + 21), 15
        IF ASC(Bits(Y%).Bytes) AND 4 THEN PSET (24, Y% + 21), 15
        IF ASC(Bits(Y%).Bytes) AND 8 THEN PSET (25, Y% + 21), 15
        IF ASC(Bits(Y%).Bytes) AND 16 THEN PSET (26, Y% + 21), 15
        IF ASC(Bits(Y%).Bytes) AND 32 THEN PSET (27, Y% + 21), 15
        IF ASC(Bits(Y%).Bytes) AND 64 THEN PSET (28, Y% + 21), 15
        IF ASC(Bits(Y%).Bytes) AND 128 THEN PSET (29, Y% + 21), 15
    NEXT Y%
END SUB

SUB DrawScreen
    SHARED BeginChar%, EndChar%, CurrentChar%
    COLOR 4
    LOCATE 1, 9
    PRINT "VGALIB FONT EDITOR";
   
    COLOR 8
    LOCATE 25, 5
    PRINT "Copyright 1991, John Cressman";
   
    COLOR 15
    LOCATE 6, 20
    PRINT USING "Current Char: ###"; 1

    
    COLOR 15

    LINE (20, 20)-(31, 31), 15, B                       'Box around character display window
    LINE (50, 20)-(124, 94), 1, B                       'Box around edit window
    FOR Y% = 1 TO 8
        FOR X% = 1 TO 8
            x1% = (X% * 9 - 9) + 52
            y1% = (Y% * 9 - 9) + 22
            x2% = x1% + 7
            y2% = y1% + 7
            LINE (x1%, y1%)-(x2%, y2%), 15, B
        NEXT X%
    NEXT Y%
END SUB

SUB EraseDot
    SHARED CX%, CY%                             ' Cursor Coordinates

    x1% = (CX% * 9 - 9) + 52
    y1% = (CY% * 9 - 9) + 22
    x2% = x1% + 7
    y2% = y1% + 7

    LINE (x1%, y1%)-(x2%, y2%), 0, BF           ' Draw Box on Edit Window
    LINE (x1%, y1%)-(x2%, y2%), 15, B           ' Draw Box on Edit Window

    PSET (CX% + 21, CY% + 21), 0                ' Draw pixel in View Frame
 
    ClearBit CX%, CY%
END SUB

SUB FillDot
    SHARED CX%, CY%                             ' Cursor Coordinates

    x1% = (CX% * 9 - 9) + 52
    y1% = (CY% * 9 - 9) + 22
    x2% = x1% + 7
    y2% = y1% + 7

    LINE (x1%, y1%)-(x2%, y2%), 15, BF          ' Draw Box on Edit Window

    PSET (CX% + 21, CY% + 21), 15               ' Draw pixel in View Frame
  
    SetBit CX%, CY%

END SUB

SUB GetString (Text$)
    X% = CSRLIN
    Y% = POS(0)
    TotLength% = LEN(Text$)
   
    X$ = LTRIM$(RTRIM$(Text$))

DisplayString:
    COLOR 15
    LOCATE X%, Y%, 0
    PRINT X$ + "" + SPACE$(TotLength% - LEN(X$));
    LOCATE X%, Y% + LEN(X$), 1

GetKey:
    i$ = INKEY$
    WHILE i$ = ""
          i$ = INKEY$
    WEND
    
DoSomething:
    SELECT CASE ASC(i$)
           CASE 8
                Le% = LEN(X$)
                IF Le% = 1 THEN
                   X$ = ""
                ELSEIF Le% > 1 THEN
                   X$ = LEFT$(X$, Le% - 1)
                END IF
           CASE 13
                Text$ = X$
                EXIT SUB
           CASE 27
                Text$ = CHR$(27)
                EXIT SUB
           CASE 65 TO 87, 97 TO 122, 123, 124, 48 TO 57, 95
                IF LEN(X$) < TotLength% THEN
                   X$ = X$ + UCASE$(i$)
                ELSE
                   BEEP
                END IF
    END SELECT
GOTO DisplayString
END SUB

SUB GetValue (X%, Y%, i$, Value%)
    SELECT CASE i$
           CASE CHR$(13)
                EXIT SUB
           CASE CHR$(27)
                EXIT SUB
           CASE CHR$(0) + CHR$(75)
                Value% = Value% - 1
                IF Value% < 1 THEN Value% = 255
           CASE CHR$(0) + CHR$(77)
                Value% = Value% + 1
                IF Value% > 255 THEN Value% = 1
    END SELECT
    LOCATE X%, Y%
    PRINT Value%;

    i$ = INKEY$
    DO
     i$ = INKEY$
    LOOP UNTIL i$ <> ""
END SUB

SUB HandleKeyStroke (First%, Second%)
    SHARED CX%, CY%
    SHARED BeginChar%, EndChar%, CurrentChar%
    SELECT CASE First%
           CASE 13                              ' Enter
                IF POINT(CX% + 21, CY% + 21) THEN
                   EraseDot
                ELSE
                   FillDot
                END IF
                Font.NeedToBeSaved = "Y"
           CASE ASC("C")                        ' Enter
                CopyRange
                Font.NeedToBeSaved = "Y"
           CASE 0
                SELECT CASE Second%
                       CASE 31
                            SaveCharSet
                       CASE 38
                            LoadCharSet
                       CASE 59
                            Help
                       CASE 72
                            CY% = CY% - 1
                            IF CY% < 1 THEN CY% = 1
                       CASE 75
                            CX% = CX% - 1
                            IF CX% < 1 THEN CX% = 1
                       CASE 77
                            CX% = CX% + 1
                            IF CX% > 8 THEN CX% = 8
                       CASE 80
                            CY% = CY% + 1
                            IF CY% > 8 THEN CY% = 8
                       CASE 115
                            a$ = ""
                            FOR i = 1 TO 8
                                a$ = a$ + Bits(i).Bytes
                            NEXT i
                            CharSet(CurrentChar%).Lines = a$

                            CC% = CurrentChar% - 1

                            IF CC% >= 1 THEN
                               CurrentChar% = CC%
                               IF CurrentChar% < BeginChar% THEN
                                  BeginChar% = CurrentChar%
                                  EndChar% = BeginChar% + 17
                               END IF
                              a$ = ""
                              FOR i = 1 TO 8
                                  Bits(i).Bytes = MID$(CharSet(CurrentChar%).Lines, i, 1)
                              NEXT i
                              DisplayBottomRow
                            END IF
                       CASE 116
                            a$ = ""
                            FOR i = 1 TO 8
                                a$ = a$ + Bits(i).Bytes
                            NEXT i
                            CharSet(CurrentChar%).Lines = a$
                            CC% = CurrentChar% + 1
                            IF CC% <= 255 THEN
                               CurrentChar% = CC%
                               IF CurrentChar% > EndChar% THEN
                                  EndChar% = CurrentChar%
                                  BeginChar% = EndChar% - 17
                               END IF
                               FOR i = 1 TO 8
                                   Bits(i).Bytes = MID$(CharSet(CurrentChar%).Lines, i, 1)
                               NEXT i
                               DisplayBottomRow
                            END IF
                       CASE 118
                            a$ = ""
                            FOR i = 1 TO 8
                                a$ = a$ + Bits(i).Bytes
                            NEXT i
                            CharSet(CurrentChar%).Lines = a$
                            CC% = CurrentChar% + 10
                            IF CC% <= 255 THEN
                               CurrentChar% = CC%
                               IF CurrentChar% > EndChar% THEN
                                  EndChar% = CurrentChar%
                                  BeginChar% = EndChar% - 17
                               END IF
                               FOR i = 1 TO 8
                                   Bits(i).Bytes = MID$(CharSet(CurrentChar%).Lines, i, 1)
                               NEXT i
                               DisplayBottomRow
                            END IF
                       CASE 132
                            a$ = ""
                            FOR i = 1 TO 8
                                a$ = a$ + Bits(i).Bytes
                            NEXT i
                            CharSet(CurrentChar%).Lines = a$

                            CC% = CurrentChar% - 10

                            IF CC% >= 1 THEN
                               CurrentChar% = CC%
                               IF CurrentChar% < BeginChar% THEN
                                  BeginChar% = CurrentChar%
                                  EndChar% = BeginChar% + 17
                               END IF
                              a$ = ""
                              FOR i = 1 TO 8
                                  Bits(i).Bytes = MID$(CharSet(CurrentChar%).Lines, i, 1)
                              NEXT i
                              DisplayBottomRow
                            END IF
                END SELECT
                BlinkCursor
    END SELECT
END SUB

SUB Help
    DIM B&(32100)
    GET (0, 0)-(319, 199), B&(0)
    LINE (0, 0)-(319, 199), 15, B
    LINE (1, 1)-(318, 198), 1, B
    LINE (2, 2)-(317, 197), 1, B
    LINE (3, 3)-(316, 196), 0, BF

    LOCATE 2, 11
    COLOR 4
    PRINT "Character Editor Help"

    COLOR 15
    LOCATE 4, 3
    PRINT "This  character  editor  uses 8x8"
    LOCATE 5, 3
    PRINT "font files saved in regular BLOAD"
    LOCATE 6, 3
    PRINT "format.                          "
    LOCATE 7, 3
    PRINT "                                 "
    LOCATE 8, 3
    PRINT "                                 "
    LOCATE 9, 3
    PRINT "                                 "
    LOCATE 10, 3
    PRINT "                                 "
    LOCATE 11, 3
    PRINT "                                 "
    LOCATE 12, 3
    PRINT "                                 "
    LOCATE 13, 3
    PRINT "                                 "
    LOCATE 14, 3
    PRINT "                                 "
    LOCATE 15, 3
    PRINT "Commands:   F1    = Help         "
    LOCATE 16, 3
    PRINT "            Alt-L = Load Font    "
    LOCATE 17, 3
    PRINT "            Alt-S = Save Font    "

    WHILE INKEY$ = "": WEND
    PUT (0, 0), B&(0), PSET
    ERASE B&
END SUB

SUB LoadCharSet
    SHARED CX%, CY%
    SHARED BeginChar%, EndChar%, CurrentChar%
    FOR i = 1 TO 8
        a$ = a$ + Bits(i).Bytes
    NEXT i
    CharSet(CurrentChar%).Lines = a$
    DIM B%(6000)
    GET (60, 52)-(244, 108), B%(0)
    LINE (60, 52)-(244, 108), 0, BF
    LINE (61, 53)-(243, 107), 15, B
    LINE (62, 54)-(242, 106), 1, B

    IF Font.NeedToBeSaved = "Y" THEN
       COLOR 15
       LOCATE 9, 10
       PRINT "Save this character";
       LOCATE 10, 10
       PRINT "set?";
      
       LOCATE 12, 10
       PRINT "(Y/N/Esc to Cancel)";
       i$ = UCASE$(INKEY$)
       DO
        i$ = UCASE$(INKEY$)
       LOOP UNTIL i$ = "Y" OR i$ = "N" OR i$ = CHR$(27)
       SELECT CASE i$
              CASE "Y"
                   SaveCharSet
              CASE CHR$(27)
                   GOTO EndLoad
       END SELECT
    END IF
    LINE (63, 55)-(241, 105), 0, BF


    COLOR 15
    LOCATE 8, 10
    PRINT "LOAD CHARACTER SET";
   
    LOCATE 10, 10
    PRINT "LOAD: ";
    COLOR 14
    Text$ = FontFile.NName

    GetString Text$
    COLOR 15

    IF Text$ = CHR$(27) THEN GOTO EndLoad

    FontFile.NName = Text$
    DEF SEG = VARSEG(CharSet(0))
    BLOAD FontFile.NName + ".FNT", VARPTR(CharSet(0))
    DEF SEG
   
    Font.NeedToBeSaved = "N"
EndLoad:
    PUT (60, 52), B%(0), PSET
    ERASE B%
    CurrentChar% = 1
    BeginChar% = 1
    EndChar% = BeginChar% + 17
    FOR i = 1 TO 8
        Bits(i).Bytes = MID$(CharSet(CurrentChar%).Lines, i, 1)
    NEXT i
    DisplayBottomRow
END SUB

SUB RedrawCharacter
    SHARED CX%, CY%                             ' Cursor Coordinates
    SHARED BeginChar%, EndChar%, CurrentChar%

    DIM a%(1 TO 8)                              'Array to Hold Bit Values

    FOR CY% = 1 TO 8
        B% = ASC(Bits(CY%).Bytes)            'B%=ASCII value of Byte

        a%(1) = (B% AND 128)
        a%(2) = (B% AND 64)
        a%(3) = (B% AND 32)
        a%(4) = (B% AND 16)
        a%(5) = (B% AND 8)
        a%(6) = (B% AND 4)
        a%(7) = (B% AND 2)
        a%(8) = (B% AND 1)
       
        FOR CX% = 1 TO 8
            x1% = (CX% * 9 - 9) + 52
            y1% = (CY% * 9 - 9) + 22
            x2% = x1% + 7
            y2% = y1% + 7

            IF a%(CX%) > 0 THEN
               LINE (x1%, y1%)-(x2%, y2%), 15, BF          ' Draw Box on Edit Window
               PSET (CX% + 21, CY% + 21), 15               ' Draw pixel in View Frame
            ELSE
               LINE (x1% + 1, y1% + 1)-(x2% - 1, y2% - 1), 0, BF   ' Draw Box on Edit Window
               PSET (CX% + 21, CY% + 21), 0                ' Draw pixel in View Frame
            END IF

        NEXT CX%

    NEXT CY%
    CX% = 1
    CY% = 1
END SUB

SUB SaveCharSet
    SHARED CX%, CY%
    SHARED BeginChar%, EndChar%, CurrentChar%
    FOR i = 1 TO 8
        a$ = a$ + Bits(i).Bytes
    NEXT i
    CharSet(CurrentChar%).Lines = a$
    DIM a%(6000)
    GET (60, 52)-(244, 108), a%(0)
    LINE (60, 52)-(244, 108), 0, BF
    LINE (61, 53)-(243, 107), 1, B
    LINE (62, 54)-(242, 106), 1, B
  
    LOCATE 8, 10
    PRINT "SAVE CHARACTER SET";
    
    LOCATE 10, 10
    PRINT "Save: ";
    COLOR 14
    Text$ = FontFile.NName

    GetString Text$
    COLOR 15

    IF Text$ = CHR$(27) THEN GOTO EndSave

    FontFile.NName = Text$
    DEF SEG = VARSEG(CharSet(0))
    BSAVE FontFile.NName + ".FNT", VARPTR(CharSet(0)), 256 * 8
    DEF SEG

EndSave:
    PUT (60, 52), a%(0), PSET
    ERASE a%
END SUB

SUB SetBit (X%, Y%)
    DIM a%(1 TO 8)                      'Array to Hold Bit Values

    B% = ASC(Bits(Y%).Bytes)            'B%=ASCII value of Byte
   
    a%(1) = (B% AND 128)
    a%(2) = (B% AND 64)
    a%(3) = (B% AND 32)
    a%(4) = (B% AND 16)
    a%(5) = (B% AND 8)
    a%(6) = (B% AND 4)
    a%(7) = (B% AND 2)
    a%(8) = (B% AND 1)

    a%(X%) = Values%(X%)                'Set the Bit

    B% = 0
    FOR i = 1 TO 8
        B% = B% + a%(i)
    NEXT i

    Bits(Y%).Bytes = CHR$(B%)
END SUB

SUB WaitForKeyStroke (i$)
    SHARED CX%, CY%, BlinkTime!

    i$ = INKEY$
    T! = TIMER + BlinkTime!
    WHILE i$ = ""
          IF T! <= TIMER THEN
             BlinkCursor
             T! = TIMER + BlinkTime!
          END IF
          i$ = INKEY$
    WEND
END SUB

