DECLARE FUNCTION ArraySize% (X1%, Y1%, X2%, Y2%)
REM $DYNAMIC
DEFINT A-Z

'--- Types
TYPE A1
     a AS STRING * 1
END TYPE
TYPE Colr
     Red  AS STRING * 1
     Green AS STRING * 1
     Blue AS STRING * 1
END TYPE
DECLARE SUB Set80x25 ()
DECLARE SUB Set320x200 ()
DECLARE SUB Set320x240 ()
DECLARE SUB Set320x400 ()
DECLARE SUB Set360x480 ()

DECLARE SUB Put240 (BYVAL X1%, BYVAL Y1%, SEG Array AS ANY)
DECLARE SUB Put360 (BYVAL X1%, BYVAL Y1%, SEG Array AS ANY)

DECLARE SUB BoxF200 (BYVAL X1%, BYVAL Y1%, BYVAL X2%, BYVAL Y2%, BYVAL Colr%)

DECLARE SUB Get200 (BYVAL X1%, BYVAL Y1%, BYVAL X2%, BYVAL Y2%, SEG Array AS ANY)
DECLARE SUB Put200 (BYVAL X1%, BYVAL Y1%, SEG Array AS ANY, BYVAL Attr%)
DECLARE SUB TPut200 (BYVAL X1%, BYVAL Y1%, SEG Array AS ANY)
DECLARE SUB RPUT200 (BYVAL X1%, BYVAL Y1%, SEG Array AS ANY)
DECLARE SUB VPut (SEG Array1 AS ANY, BYVAL X%, BYVAL Y%, SEG Array2 AS ANY)
DECLARE SUB VTPut (SEG Array1 AS ANY, BYVAL X%, BYVAL Y%, SEG Array2 AS ANY)
DECLARE SUB VGET (SEG Array1 AS ANY, BYVAL X1%, BYVAL Y1%, BYVAL X2%, BYVAL Y2%, SEG Array2 AS ANY)
DECLARE SUB CreateVirtualScreen (SEG Array AS ANY, BYVAL NumCols%, BYVAL NumRows%)
DECLARE SUB LookingUp (CX%, CY%)
DECLARE SUB LookingDown (CX%, CY%)
DECLARE SUB MoveForward (CX%, CY%, Di%)
DECLARE SUB LookingLeft (CX%, CY%)
DECLARE SUB LookingRight (CX%, CY%)
DECLARE SUB RestorePal (SEG Array AS ANY)

DIM SHARED Blank(0 TO 1) AS A1
DIM SHARED VScreen(0 TO 1) AS A1
DIM SHARED Floor(0 TO 1) AS A1
DIM SHARED Ceiling(0 TO 1) AS A1
DIM SHARED RWall1(0 TO 1) AS A1
DIM SHARED LWall1(0 TO 1) AS A1
DIM SHARED FWall1(0 TO 1) AS A1
DIM SHARED RWall2(0 TO 1) AS A1
DIM SHARED LWall2(0 TO 1) AS A1
DIM SHARED FWall2(0 TO 1) AS A1
DIM SHARED RWall3(0 TO 1) AS A1
DIM SHARED LWall3(0 TO 1) AS A1
DIM SHARED FWall3(0 TO 1) AS A1
DIM SHARED RWall4(0 TO 1) AS A1
DIM SHARED LWall4(0 TO 1) AS A1
DIM SHARED FWall4(0 TO 1) AS A1
DIM SHARED Colors(0 TO 256) AS Colr
DIM SHARED PalArray&(256)

DIM SHARED Level$(1 TO 30)

Level$(1) = ""
Level$(2) = "              "
Level$(3) = "                         "
Level$(4) = "                          "
Level$(5) = "                 "
Level$(6) = "                   "
Level$(7) = "           "
Level$(8) = "                           "
Level$(9) = "  "
Level$(10) = "  "
Level$(11) = "                           "
Level$(12) = "     "
Level$(13) = "                         "
Level$(14) = "                          "
Level$(15) = "                 "
Level$(16) = "                   "
Level$(17) = "           "
Level$(18) = "                           "
Level$(19) = "  "
Level$(20) = "  "
Level$(21) = "                           "
Level$(22) = "     "
Level$(23) = "                         "
Level$(24) = "                          "
Level$(25) = "                 "
Level$(26) = "                   "
Level$(27) = "           "
Level$(28) = "                           "
Level$(29) = "                           "
Level$(30) = ""

SCREEN 0
CLS
LOCATE 1, 1
PRINT "Choose Mode: ";
LOCATE 3, 1
PRINT "   1) 320x200 "
PRINT "   2) 320x240 "
PRINT "   3) 320x400 "
PRINT "   4) 360x480 "
i$ = INKEY$
WHILE i$ <> CHR$(27) AND (i$ < "1" OR i$ > "4")
      i$ = INKEY$
WEND
IF i$ = CHR$(27) THEN GOTO AllDone ELSE Mode$ = i$

DEF SEG = VARSEG(Colors(0))
BLOAD "3-D.Plt", VARPTR(Colors(0))
DEF SEG

Set320x200
RestorePal Colors(0)

X1% = 0
Y1% = 0
X2% = 176
Y2% = 119
BoxF200 X1%, Y1%, X2%, Y2%, 255

REDIM VScreen(21300) AS A1
REDIM Blank(21300) AS A1
Get200 X1%, Y1%, X2%, Y2%, VScreen(0)
Get200 X1%, Y1%, X2%, Y2%, Blank(0)
   
'---Arrays
    REDIM Floor(0 TO 11600) AS A1
    REDIM Ceiling(0 TO 5600) AS A1
    REDIM RWall1(0 TO 3100) AS A1
    REDIM LWall1(0 TO 3200) AS A1
    REDIM FWall1(0 TO 12600) AS A1
    REDIM RWall2(0 TO 4700) AS A1
    REDIM LWall2(0 TO 4600) AS A1
    REDIM FWall2(0 TO 4900) AS A1
    REDIM RWall3(0 TO 3850) AS A1
    REDIM LWall3(0 TO 3850) AS A1
    REDIM FWall3(0 TO 5050) AS A1
    REDIM RWall4(0 TO 2350) AS A1
    REDIM LWall4(0 TO 2350) AS A1
    REDIM FWall4(0 TO 2100) AS A1

'--- The Floor
    DEF SEG = VARSEG(Floor(0))
    BLOAD "Floor.dat", VARPTR(Floor(0))
'---The Ceiling
    DEF SEG = VARSEG(Ceiling(0))
    BLOAD "Ceiling.dat", VARPTR(Ceiling(0))
'---1st Walls
    DEF SEG = VARSEG(RWall1(0))
    BLOAD "RWall1.dat", VARPTR(RWall1(0))
    DEF SEG = VARSEG(LWall1(0))
    BLOAD "LWall1.dat", VARPTR(LWall1(0))
    DEF SEG = VARSEG(FWall1(0))
    BLOAD "FWall1.dat", VARPTR(FWall1(0))
'---The 2nd Walls
    DEF SEG = VARSEG(RWall2(0))
    BLOAD "RWall2.dat", VARPTR(RWall2(0))
    DEF SEG = VARSEG(LWall2(0))
    BLOAD "LWall2.dat", VARPTR(LWall2(0))
    DEF SEG = VARSEG(FWall2(0))
    BLOAD "FWall2.dat", VARPTR(FWall2(0))
'--3rd Walls
    DEF SEG = VARSEG(RWall3(0))
    BLOAD "RWall3.dat", VARPTR(RWall3(0))
    DEF SEG = VARSEG(LWall3(0))
    BLOAD "LWall3.dat", VARPTR(LWall3(0))
    DEF SEG = VARSEG(FWall3(0))
    BLOAD "FWall3.dat", VARPTR(FWall3(0))
'--- 4th Front Wall
    DEF SEG = VARSEG(LWall4(0))
    BLOAD "LWall4.dat", VARPTR(LWall4(0))
    DEF SEG = VARSEG(RWall4(0))
    BLOAD "RWall4.dat", VARPTR(RWall4(0))
    DEF SEG = VARSEG(FWall4(0))
    BLOAD "FWall4.dat", VARPTR(FWall4(0))

CX% = 15
CY% = 14
Di% = 1

SELECT CASE VAL(Mode$)
       CASE 1
            Set320x200
       CASE 2
            Set320x240
       CASE 3
            Set320x400
       CASE 4
            Set360x480
END SELECT
RestorePal Colors(0)



SELECT CASE Di%
       CASE 1
            LookingUp CX%, CY%
       CASE 2
            LookingRight CX%, CY%
       CASE 3
            LookingDown CX%, CY%
       CASE 4
            LookingLeft CX%, CY%
END SELECT


i$ = INKEY$
WHILE i$ = ""
      i$ = INKEY$
WEND

DO
  SELECT CASE i$
         CASE CHR$(0) + CHR$(72)          ' Move Forward
              Mx% = CX%
              My% = CY%
              MoveForward CX%, CY%, Di%
              IF Mx% = CX% AND My% = CY% THEN
                 '
              ELSE
                 Redraw = 1
              END IF
         CASE CHR$(0) + CHR$(75)          ' Turn CounterClockwise
              Di% = Di% - 1
              IF Di% = 0 THEN Di% = 4
              Redraw = 1
         CASE CHR$(0) + CHR$(77)          ' Turn Clockwise
              Di% = Di% + 1
              IF Di% = 5 THEN Di% = 1
              Redraw = 1
  END SELECT
  IF Redraw = 1 THEN
     SELECT CASE Di%
            CASE 1
                 LookingUp CX%, CY%
            CASE 2
                 LookingRight CX%, CY%
            CASE 3
                 LookingDown CX%, CY%
            CASE 4
                 LookingLeft CX%, CY%
     END SELECT
     Redraw = 0
  END IF

  i$ = INKEY$
  WHILE i$ = ""
        i$ = INKEY$
  WEND
LOOP UNTIL i$ = CHR$(27)


AllDone:
    Set80x25
    CLS

    PRINT "3-D ADVENTURE DEMO.  (C) Copyright 1991, SCN Creative Solutions"
    PRINT " "
    PRINT "Thanks for trying out the VGALIB 3-D DEMO.  Remember: If you register,"
    PRINT "you'll get the source code and data files for this demo."
    PRINT " "
    COLOR 15
    PRINT "To Register, send Check or Money Order To:"
    COLOR 14
    PRINT ""
    PRINT "           John Cressman        "
    PRINT "       1043 Main Street, Flr 2  "
    PRINT "         Emerald, PA  18080     "
    PRINT ""
  
    END

REM $STATIC
FUNCTION ArraySize% (X1%, Y1%, X2%, Y2%)
         DX% = ABS(X2% - X1%) + 1
         DY% = ABS(Y2% - Y1%) + 1
         ArraySize% = DX% * DY% + 4
END FUNCTION

SUB DrawMap
    SHARED CX%, CY%, Di%

    Lin% = 1
    StartX% = CX% - 6
    Le% = 13
    IF StartX% < 1 THEN
       StartX% = 1
    END IF
    IF StartX% + Le% > 30 THEN
       StartX% = StartX% - (30 - Le%)
    END IF

    Y1% = CY% - 6
    Le% = 13
    IF Y1% <= 0 THEN
       Y1% = 1
    END IF
    IF Y1% + Le% > 30 THEN
       Y1% = Y1% - (30 - Y1% + Le%)
    END IF


    FOR i = StartX% TO StartX% + Le%
        LOCATE Lin, 25
        PRINT MID$(Level$(i), Y1%, Le%);
        Lin% = Lin% + 1
    NEXT i


    DX% = CX% - StartX% + 1
    DY% = CY% - Y1% + 25
   
    LOCATE DX%, DY%
    SELECT CASE Di%
           CASE 1
                PRINT CHR$(24);
           CASE 2
                PRINT CHR$(26);
           CASE 3
                PRINT CHR$(25);
           CASE 4
                PRINT CHR$(27);
    END SELECT

    LOCATE 24, 35
    PRINT MID$(Level$(CX% - 1), CY%, 1);


END SUB

SUB LookingDown (CX%, CY%)
    SHARED Mode$
    VPut VScreen(0), 0, 0, Blank(0)

    VPut VScreen(0), 0, 0, Ceiling(0)
    VPut VScreen(0), 0, 55, Floor(0)

'----------------------------------------------------------------
    IF CX% + 3 < 31 THEN
       IF ASC(MID$(Level$(CX% + 3), CY% + 1, 1)) <> 32 THEN VTPut VScreen(0), 11, 27, LWall4(0)
       IF ASC(MID$(Level$(CX% + 3), CY% - 1, 1)) <> 32 THEN VTPut VScreen(0), 105, 27, RWall4(0)
       IF ASC(MID$(Level$(CX% + 3), CY%, 1)) <> 32 THEN VTPut VScreen(0), 64, 27, FWall4(0)
    END IF
'----------------------------------------------------------------
    IF CX% + 2 < 31 THEN
       IF ASC(MID$(Level$(CX% + 2), CY% + 1, 1)) <> 32 THEN VTPut VScreen(0), 0, 20, LWall3(0)
       IF ASC(MID$(Level$(CX% + 2), CY% - 1, 1)) <> 32 THEN VTPut VScreen(0), 113, 20, RWall3(0)
       IF ASC(MID$(Level$(CX% + 2), CY%, 1)) <> 32 THEN VTPut VScreen(0), 48, 20, FWall3(0)
    END IF
'----------------------------------------------------------------
    IF CX% + 1 < 31 THEN
       IF ASC(MID$(Level$(CX% + 1), CY% + 1, 1)) <> 32 THEN VTPut VScreen(0), 0, 9, LWall2(0)
       IF ASC(MID$(Level$(CX% + 1), CY% - 1, 1)) <> 32 THEN VTPut VScreen(0), 128, 9, RWall2(0)
       IF ASC(MID$(Level$(CX% + 1), CY%, 1)) <> 32 THEN VTPut VScreen(0), 23, 8, FWall1(0)
    END IF

'----------------------------------------------------------------
    IF ASC(MID$(Level$(CX%), CY% + 1, 1)) <> 32 THEN VTPut VScreen(0), 0, 1, LWall1(0)
    IF ASC(MID$(Level$(CX%), CY% - 1, 1)) <> 32 THEN VTPut VScreen(0), 152, 0, RWall1(0)
   
    SELECT CASE VAL(Mode$)
           CASE 1
                Put200 0, 0, VScreen(0), 0
           CASE 2
                Put240 0, 0, VScreen(0)
           CASE 3
                Put240 0, 0, VScreen(0)
           CASE 4
                Put360 0, 0, VScreen(0)
    END SELECT
END SUB

SUB LookingLeft (CX%, CY%)
    SHARED Mode$
    VPut VScreen(0), 0, 0, Blank(0)

    VPut VScreen(0), 0, 0, Ceiling(0)
    VPut VScreen(0), 0, 55, Floor(0)

'----------------------------------------------------------------
    IF CY% - 3 > 0 THEN
       IF ASC(MID$(Level$(CX% + 1), CY% - 3, 1)) <> 32 THEN VTPut VScreen(0), 11, 27, LWall4(0)
       IF ASC(MID$(Level$(CX% - 1), CY% - 3, 1)) <> 32 THEN VTPut VScreen(0), 105, 27, RWall4(0)
       IF ASC(MID$(Level$(CX%), CY% - 3, 1)) <> 32 THEN VTPut VScreen(0), 64, 27, FWall4(0)
    END IF
'----------------------------------------------------------------
    IF CY% - 2 > 0 THEN
       IF ASC(MID$(Level$(CX% + 1), CY% - 2, 1)) <> 32 THEN VTPut VScreen(0), 0, 20, LWall3(0)
       IF ASC(MID$(Level$(CX% - 1), CY% - 2, 1)) <> 32 THEN VTPut VScreen(0), 113, 20, RWall3(0)
       IF ASC(MID$(Level$(CX%), CY% - 2, 1)) <> 32 THEN VTPut VScreen(0), 48, 20, FWall3(0)
    END IF
'----------------------------------------------------------------
    IF CY% - 1 > 0 THEN
       IF ASC(MID$(Level$(CX% + 1), CY% - 1, 1)) <> 32 THEN VTPut VScreen(0), 0, 9, LWall2(0)
       IF ASC(MID$(Level$(CX% - 1), CY% - 1, 1)) <> 32 THEN VTPut VScreen(0), 128, 9, RWall2(0)
       IF ASC(MID$(Level$(CX%), CY% - 1, 1)) <> 32 THEN VTPut VScreen(0), 23, 8, FWall1(0)
    END IF

'----------------------------------------------------------------
    IF ASC(MID$(Level$(CX% + 1), CY%, 1)) <> 32 THEN VTPut VScreen(0), 0, 1, LWall1(0)
    IF ASC(MID$(Level$(CX% - 1), CY%, 1)) <> 32 THEN VTPut VScreen(0), 152, 0, RWall1(0)

    SELECT CASE VAL(Mode$)
           CASE 1
                Put200 0, 0, VScreen(0), 0
           CASE 2
                Put240 0, 0, VScreen(0)
           CASE 3
                Put240 0, 0, VScreen(0)
           CASE 4
                Put360 0, 0, VScreen(0)
    END SELECT
END SUB

SUB LookingRight (CX%, CY%)
    SHARED Mode$
   
    VPut VScreen(0), 0, 0, Blank(0)

    VPut VScreen(0), 0, 0, Ceiling(0)
    VPut VScreen(0), 0, 55, Floor(0)

'----------------------------------------------------------------
    IF CY% + 3 < 31 THEN
       IF ASC(MID$(Level$(CX% - 1), CY% + 3, 1)) <> 32 THEN VTPut VScreen(0), 11, 27, LWall4(0)
       IF ASC(MID$(Level$(CX% + 1), CY% + 3, 1)) <> 32 THEN VTPut VScreen(0), 105, 27, RWall4(0)
       IF ASC(MID$(Level$(CX%), CY% + 3, 1)) <> 32 THEN VTPut VScreen(0), 64, 27, FWall4(0)
    END IF
'----------------------------------------------------------------
    IF CY% + 2 < 31 THEN
       IF ASC(MID$(Level$(CX% - 1), CY% + 2, 1)) <> 32 THEN VTPut VScreen(0), 0, 20, LWall3(0)
       IF ASC(MID$(Level$(CX% + 1), CY% + 2, 1)) <> 32 THEN VTPut VScreen(0), 113, 20, RWall3(0)
       IF ASC(MID$(Level$(CX%), CY% + 2, 1)) <> 32 THEN VTPut VScreen(0), 48, 20, FWall3(0)
    END IF
'----------------------------------------------------------------
    IF CY% + 1 < 31 THEN
       IF ASC(MID$(Level$(CX% - 1), CY% + 1, 1)) <> 32 THEN VTPut VScreen(0), 0, 9, LWall2(0)
       IF ASC(MID$(Level$(CX% + 1), CY% + 1, 1)) <> 32 THEN VTPut VScreen(0), 128, 9, RWall2(0)
       IF ASC(MID$(Level$(CX%), CY% + 1, 1)) <> 32 THEN VTPut VScreen(0), 23, 8, FWall1(0)
    END IF

'----------------------------------------------------------------
    IF ASC(MID$(Level$(CX% - 1), CY%, 1)) <> 32 THEN VTPut VScreen(0), 0, 1, LWall1(0)
    IF ASC(MID$(Level$(CX% + 1), CY%, 1)) <> 32 THEN VTPut VScreen(0), 152, 0, RWall1(0)
   
    SELECT CASE VAL(Mode$)
           CASE 1
                Put200 0, 0, VScreen(0), 0
           CASE 2
                Put240 0, 0, VScreen(0)
           CASE 3
                Put240 0, 0, VScreen(0)
           CASE 4
                Put360 0, 0, VScreen(0)
    END SELECT
END SUB

SUB LookingUp (CX%, CY%)
    SHARED Mode$
    VPut VScreen(0), 0, 0, Blank(0)

    VPut VScreen(0), 0, 0, Ceiling(0)
    VPut VScreen(0), 0, 55, Floor(0)

'----------------------------------------------------------------
    IF CX% - 3 > 0 THEN
       IF ASC(MID$(Level$(CX% - 3), CY% - 1, 1)) <> 32 THEN VTPut VScreen(0), 11, 27, LWall4(0)
       IF ASC(MID$(Level$(CX% - 3), CY% + 1, 1)) <> 32 THEN VTPut VScreen(0), 105, 27, RWall4(0)
       IF ASC(MID$(Level$(CX% - 3), CY%, 1)) <> 32 THEN VTPut VScreen(0), 64, 27, FWall4(0)
    END IF
'----------------------------------------------------------------
    IF CX% - 2 > 0 THEN
       IF ASC(MID$(Level$(CX% - 2), CY% - 1, 1)) <> 32 THEN VTPut VScreen(0), 0, 20, LWall3(0)
       IF ASC(MID$(Level$(CX% - 2), CY% + 1, 1)) <> 32 THEN VTPut VScreen(0), 113, 20, RWall3(0)
       IF ASC(MID$(Level$(CX% - 2), CY%, 1)) <> 32 THEN VTPut VScreen(0), 47, 20, FWall3(0)
    END IF
'----------------------------------------------------------------
    IF CX% - 1 > 0 THEN
       IF ASC(MID$(Level$(CX% - 1), CY% - 1, 1)) <> 32 THEN VTPut VScreen(0), 0, 9, LWall2(0)
       IF ASC(MID$(Level$(CX% - 1), CY% + 1, 1)) <> 32 THEN VTPut VScreen(0), 128, 9, RWall2(0)
       IF ASC(MID$(Level$(CX% - 1), CY%, 1)) <> 32 THEN VTPut VScreen(0), 23, 8, FWall1(0)
    END IF

'----------------------------------------------------------------
    IF ASC(MID$(Level$(CX%), CY% - 1, 1)) <> 32 THEN VTPut VScreen(0), 0, 1, LWall1(0)
    IF ASC(MID$(Level$(CX%), CY% + 1, 1)) <> 32 THEN VTPut VScreen(0), 152, 0, RWall1(0)


    SELECT CASE VAL(Mode$)
           CASE 1
                Put200 0, 0, VScreen(0), 0
           CASE 2
                Put240 0, 0, VScreen(0)
           CASE 3
                Put240 0, 0, VScreen(0)
           CASE 4
                Put360 0, 0, VScreen(0)
    END SELECT
END SUB

SUB MoveForward (CX%, CY%, Di%)
    NewX% = CX%
    NewY% = CY%
    SELECT CASE Di%
           CASE 1
                NewX% = NewX% - 1
                IF NewX% < 1 THEN
                   NewX% = 1
                END IF
                IF ASC(MID$(Level$(NewX%), NewY%, 1)) <> 32 THEN
                   NewX% = CX%
                   NewY% = CY%
                END IF
           CASE 2
                NewY% = NewY% + 1
                IF NewY% > 30 THEN
                   NewY% = 30
                END IF
                IF ASC(MID$(Level$(NewX%), NewY%, 1)) <> 32 THEN
                   NewX% = CX%
                   NewY% = CY%
                END IF
           CASE 3
                NewX% = NewX% + 1
                IF NewX% > 30 THEN
                   NewX% = 30
                END IF
                IF ASC(MID$(Level$(NewX%), NewY%, 1)) <> 32 THEN
                   NewX% = CX%
                   NewY% = CY%
                END IF
           CASE 4
                NewY% = NewY% - 1
                IF NewY% < 1 THEN
                   NewY% = 1
                END IF
                IF ASC(MID$(Level$(NewX%), NewY%, 1)) <> 32 THEN
                   NewX% = CX%
                   NewY% = CY%
                END IF

    END SELECT
    CX% = NewX%
    CY% = NewY%
END SUB

