'   Program: QUTILDEM.BAS   -   QuickBASIC Utility Set Demonstration
'
'   By: Traveller Software - Copyright 1988
'
'   Release: 4 - 12 December 1988
' --------------------------------------------------------------------------
'
DECLARE SUB Cprint (Row%, Col%, Fore%, Back%, Prompt$)
DECLARE SUB DriveType (Drive$, DrvType$, DrvType%)
DECLARE SUB GetDirectory (Drive$)
DECLARE SUB GetDirData (Path$, DirEntry$(), Attribute$, EntryCount%)
DECLARE SUB GetDosVer (DosVer$)
DECLARE SUB GetDrive (Drive$)
DECLARE SUB GetDriveAllocation (Drive$, Clustors%, Sectors%, Bytes%, Available%)
DECLARE SUB GetDriveFree (Drive$, Total&, Free&, Used&)
DECLARE SUB GetEquipment (PrinterPorts%, CommPorts%, GameAdapter%, CoProcessor%, Drives%)
DECLARE SUB GetMemorySize (Memory%)
DECLARE SUB GetPrinterPort (PrinterPort%, Status%)
DECLARE SUB InkeyBox (Row%, Col%, Fore%, Back%, Prompt$, Reply$)
DECLARE SUB MakeBox (Row1%, Col1%, Row2%, Col2%, BoxType%, Fore%, Back%, Title$)
DECLARE SUB MakeLine (Row1%, Col1%, Row2%, Col2%, LType%, Fore%, Back%)
DECLARE SUB MakeMenu (Row1%, Col1%, MType%, IType%, TFore%, Fore%, Back%, Menu%, Menu$(), VReply$, Reply%)
DECLARE SUB Make123 (Row1%, Col1%, MType%, TFore%, Fore%, Back%, Menu$, Title$, Reply%)
DECLARE SUB Motion (Row%, CCol%, Fore%, Back%, X$)
DECLARE SUB Oops ()
DECLARE SUB RestScreen (ScrnSave%())
DECLARE SUB SaveScreen (ScrnSave%())
DECLARE SUB ScrlList (Row%, Col%, TFore%, Fore%, Back%, Btype%, ListLen%, ShowLen%, ShowWid%, Items$(), Prompt$, Reply%, Mark$)
DECLARE SUB ShowDir (Row%, Col%, TFore%, Fore%, Back%, BoxType%, ShowType%, ShowLen%, DirEntry$(), Reply%, Mark$)
DECLARE SUB TypeLine (Row%, Col%, InLn%, Fore%, Back%, Prompt$, Reply$)
DECLARE SUB PrinterStatus (PrinterPort%, Status%)
DECLARE SUB Delay (Seconds%)
DECLARE SUB ViewFile (Name$, MaxLength%, Row%, Col%, TFore%, Fore%, Back%, Btype%, LineCount%, ShowLen%, ShowWid%, Prompt$, AScroll%)
DECLARE SUB GetVerify (Flag%)
DECLARE SUB ValidDrives (Drives$)
DECLARE SUB GetVideo (VideoMode%, CharCol%, VideoPage%)
DECLARE SUB MakeBitNum (BitString$, Number%)
DECLARE SUB MakeBitStr (Number%, BitString$)
DECLARE SUB CheckBitNum (Number%, BitCheck%, Status%)
DECLARE SUB CheckBitStr (BitString$, BitCheck%, Status%)
DECLARE SUB GetHighLow (Number%, High%, Low%)
DECLARE SUB SetHighLow (High%, Low%, Number%)
'
' --------------------------------------------------------------------------
'
    DEFINT A-Z
    DIM ScrnSave(3440)      '   For SaveScreen & RestScreen
    DIM DirEntry$(255, 4)   '   For GetDirData
    DIM Menu$(10)           '   For MakeMenu
    DIM Answer$(1), BAnswer$(1)
    Answer$(0) = "No": Answer$(1) = "Yes"
    BAnswer$(0) = "Off": BAnswer$(1) = "On"
    Release$ = "The QuickBASIC Utility Set - Release #4, 12 December 1988"
' --------------------------------------------------------------------------
'   Lets Get Started!
' --------------------------------------------------------------------------
    COLOR 15, 3: CLS
    CALL MakeBox(4, 10, 14, 70, 7, 7, 1, "")
    LOCATE 5, 12: COLOR 15, 1: PRINT "     /|"; : COLOR 14: PRINT "  ----- "; : COLOR 15: PRINT "Traveller"
    LOCATE 6, 12: COLOR 15: PRINT "   /  |"; : COLOR 4: PRINT "\"; : COLOR 14: PRINT "   ------"
    LOCATE 7, 12: COLOR 15: PRINT " <  T |"; : COLOR 4: PRINT "  >"; : COLOR 14: PRINT "   -------"
    LOCATE 8, 12: COLOR 15: PRINT "   \  |"; : COLOR 4: PRINT "/ "; : COLOR 14: PRINT "  ------  "
    LOCATE 9, 12: COLOR 15: PRINT "     \|"; : COLOR 14: PRINT "  ----- "; : COLOR 15: PRINT "Software"
    CALL Cprint(7, 40, 14, 1, "P R E S E N T S:")
    CALL MakeLine(10, 10, 10, 70, 3, 7, 1)
    CALL Cprint(11, 0, 14, 1, Release$)
    CALL Cprint(12, 0, 15, 1, "By: Traveller Software and Associates")
    CALL Cprint(13, 0, 15, 1, "Copyright (c) 1987 - 1988")
    CALL Delay(6)
' --------------------------------------------------------------------------
'   Tell them what this is all about.
' --------------------------------------------------------------------------
    COLOR 15, 3: CLS
    CALL MakeBox(3, 10, 5, 70, 7, 7, 5, "")
    CALL Cprint(4, 0, 15, 5, Release$)
    CALL MakeBox(19, 10, 22, 70, 7, 7, 4, "[ Information ]")
    CALL Cprint(20, 12, 15, 4, "Use the Up/Down, Page-Up/Down, Home/End Cursor keys to")
    CALL Cprint(21, 12, 15, 4, "Scroll through the text. Press the ESCAPE key to continue.")
   
    FileName$ = "INTRO40.DOC"
    CALL ViewFile(FileName$, 20, 8, 10, 15, 14, 1, 5, ListLen%, 7, 57, "[ Introduction ]", 0)
    IF ListLen% < 1 THEN GOTO FileError
' --------------------------------------------------------------------------
'   Utility Set Areas of Investigation
' --------------------------------------------------------------------------
MainMenu:
    COLOR 15, 3: CLS
    CALL MakeBox(3, 10, 5, 70, 7, 7, 5, "")
    CALL Cprint(4, 0, 15, 5, Release$)
   
    CALL MakeBox(15, 10, 18, 70, 7, 7, 4, "[ Information ]")
    CALL Cprint(16, 0, 15, 4, "Use the Left and Right Cursor Keys to select a topic.")
    CALL Cprint(17, 0, 15, 4, "Press the ENTER key to continue.")
   
    Menu$ = "DOS BIOS VIDEO BITS OTHER END-Program"
    CALL Make123(9, 13, 6, 15, 0, 2, Menu$, "[ Utility Set Areas of Investigation ]", SubMenu)
    IF SubMenu = 6 THEN
        COLOR 15, 3: CLS
        CALL MakeBox(3, 10, 5, 70, 7, 7, 5, "")
        CALL Cprint(4, 0, 15, 5, Release$)
        CALL MakeBox(19, 10, 22, 70, 7, 7, 4, "[ Information ]")
        CALL Cprint(20, 12, 15, 4, "Use the Up/Down, Page-Up/Down, Home/End Cursor keys to")
        CALL Cprint(21, 12, 15, 4, "Scroll through the text. Press the ESCAPE key to continue.")
  
        FileName$ = "FINALCOM.DOC"
        CALL ViewFile(FileName$, 40, 8, 10, 15, 14, 1, 5, ListLen%, 7, 57, "[ Final Comments ]", 0)
        IF ListLen% < 1 THEN GOTO FileError
        COLOR 15, 0: CLS : END
    END IF
    IF SubMenu = 1 THEN GOTO DOSDemos
    IF SubMenu = 2 THEN GOTO BIOSDemos
    IF SubMenu = 3 THEN GOTO VideoDemos
    IF SubMenu = 4 THEN GOTO BITSDemos
    GOTO OTHERDemos

' --------------------------------------------------------------------------
'   Demonstration of some the BIOSUTIL Functions
' --------------------------------------------------------------------------
BIOSDemos:
    COLOR 15, 3: CLS
    CALL MakeBox(3, 10, 5, 70, 7, 7, 5, "")
    CALL Cprint(4, 0, 15, 5, Release$)
    CALL MakeBox(19, 10, 22, 70, 7, 7, 4, "[ Information ]")
    CALL Cprint(20, 12, 15, 4, "Use the Up/Down, Page-Up/Down, Home/End Cursor keys to")
    CALL Cprint(21, 12, 15, 4, "Scroll through the text. Press the ESCAPE key to continue.")
 
    FileName$ = "BIOSINFO.DOC"
    CALL ViewFile(FileName$, 40, 8, 10, 15, 14, 1, 5, ListLen%, 7, 57, "[ BIOS Comments ]", 0)
    IF ListLen% < 1 THEN GOTO FileError
   
    COLOR 15, 3: CLS
    CALL MakeBox(2, 5, 16, 75, 2, 7, 0, "[ BIOS Demonstration ]")
    CALL Cprint(3, 0, 14, 0, "These utilities can check out your system setup.")
    CALL MakeLine(4, 5, 4, 75, 2, 7, 0)
    CALL MakeLine(6, 5, 6, 75, 4, 7, 0)
 
    CALL GetMemorySize(Memory)
    CALL GetEquipment(Printers, Comm, Game, CoProc, Drives)
 
    CALL GetPrinterPort(1, Port1): CALL PrinterStatus(1, Port1Stat)
    CALL GetPrinterPort(2, Port2): CALL PrinterStatus(2, Port2Stat)
    CALL GetPrinterPort(3, Port3): CALL PrinterStatus(3, Port3Stat)
 
'
'   Print the Information
'
    COLOR 15, 0: LOCATE 5, 7: PRINT "On-Board System Memory (Standard): ";
        COLOR 14, 0: PRINT USING "###k"; Memory
 
    COLOR 15, 0: LOCATE 7, 7: PRINT "Floppy Disk Drives Installed: ";
        COLOR 14, 0: PRINT Drives
    COLOR 15, 0: LOCATE 8, 7: PRINT "Serial Ports Installed:       ";
        COLOR 14, 0: PRINT Comm
    COLOR 15, 0: LOCATE 9, 7: PRINT "Game Adapter Installed:        ";
        COLOR 14, 0: PRINT Answer$(Game)
    COLOR 15, 0: LOCATE 10, 7: PRINT "Math Co-Processor Installed:   ";
        COLOR 14, 0: PRINT Answer$(CoProc)
 
    CALL MakeLine(11, 5, 11, 75, 4, 7, 0)
    COLOR 15, 0: LOCATE 12, 7: PRINT "Printer Ports Installed: ";
        COLOR 14, 0: PRINT Printers
    COLOR 15, 0: LOCATE 13, 7: PRINT "Parallel Printer Port #1: ";
    IF Port1 = 1 THEN
            COLOR 14, 0: PRINT "Available - ";
            IF Port1Stat = 0 THEN PRINT "On-Line" ELSE PRINT "Off-Line"
        ELSE
            COLOR 14, 0: PRINT "Not Available"
    END IF
    COLOR 15, 0: LOCATE 14, 7: PRINT "Parallel Printer Port #2: ";
    IF Port2 = 1 THEN
            COLOR 14, 0: PRINT "Available - ";
            IF Port2Stat = 0 THEN PRINT "On-Line" ELSE PRINT "Off-Line"
        ELSE
            COLOR 14, 0: PRINT "Not Available"
    END IF
    COLOR 15, 0: LOCATE 15, 7: PRINT "Parallel Printer Port #3: ";
    IF Port3 = 1 THEN
            COLOR 14, 0: PRINT "Available - ";
            IF Port3Stat = 0 THEN PRINT "On-Line" ELSE PRINT "Off-Line"
        ELSE
            COLOR 14, 0: PRINT "Not Available"
    END IF
    CALL Motion(24, 0, 14, 3, "Press any key to continue.. ")
    GOTO MainMenu:

' --------------------------------------------------------------------------
'   Demonstration of the Directory Utilities
' --------------------------------------------------------------------------
DOSDemos:
    COLOR 15, 3: CLS
    CALL MakeBox(3, 10, 5, 70, 7, 7, 5, "")
    CALL Cprint(4, 0, 15, 5, Release$)
    CALL MakeBox(19, 10, 22, 70, 7, 7, 4, "[ Information ]")
    CALL Cprint(20, 12, 15, 4, "Use the Up/Down, Page-Up/Down, Home/End Cursor keys to")
    CALL Cprint(21, 12, 15, 4, "Scroll through the text. Press the ESCAPE key to continue.")
 
    FileName$ = "DOSINFO.DOC"
    CALL ViewFile(FileName$, 40, 8, 10, 15, 14, 1, 5, ListLen%, 7, 57, "[ DOS Comments ]", 0)
    IF ListLen% < 1 THEN GOTO FileError
   
    COLOR 15, 3: CLS
    CALL MakeBox(2, 5, 19, 75, 2, 7, 0, "[ DOS Demonstration ]")
    CALL Cprint(3, 0, 14, 0, "These utilities allow enhanced DOS interfacing.")
    CALL MakeLine(4, 5, 4, 75, 2, 7, 0)
    CALL MakeLine(6, 5, 6, 75, 4, 7, 0)
    CALL MakeLine(15, 5, 15, 75, 4, 7, 0)
   
    CALL GetDosVer(DosVer$)
    CALL GetDirectory(Path$)
    CALL DriveType(Drive$, DrvType$, DrvType)
    CALL GetDriveAllocation(Drive$, Clusters, Sectors, Bytes, Available)
    CALL GetDriveFree(Drive$, Total&, Free&, Used&)
    CALL GetVerify(Verify)
    CALL ValidDrives(VDrives$)

    TotalK& = Total& \ 1024: UsedK& = Used& \ 1024: FreeK& = Free& \ 1024
    TotalM& = TotalK& \ 1000: UsedM& = UsedK& \ 1000: FreeM& = FreeK& \ 1000

    COLOR 15, 0: LOCATE 5, 7: PRINT "Current Default Drive\Directory: ";
        COLOR 14, 0: PRINT Path$

    COLOR 15, 0: LOCATE 7, 7: PRINT "Default Disk Drive Type: ";
        COLOR 14, 0: PRINT DrvType$

    COLOR 15, 0: LOCATE 8, 7: PRINT "Total Clusters:";
        COLOR 14, 0: PRINT USING "         ##,###"; Clusters
    COLOR 15, 0: LOCATE 9, 7: PRINT "Available Clusters:";
        COLOR 14, 0: PRINT USING "     ##,###"; Available
    COLOR 15, 0: LOCATE 10, 7: PRINT "Sectors per Cluster:";
        COLOR 14, 0: PRINT USING "    ##,###"; Sectors
    COLOR 15, 0: LOCATE 11, 7: PRINT "Bytes per Sector:";
        COLOR 14, 0: PRINT USING "       ##,###"; Bytes
    COLOR 15, 0: LOCATE 12, 7: PRINT "Total Disk Storage:";
        COLOR 14, 0: PRINT USING "     ##,###,### bytes / ##,###k / ## Meg"; Total&; TotalK&; TotalM&
    COLOR 15, 0: LOCATE 13, 7: PRINT "Used Storage Space:";
        COLOR 14, 0: PRINT USING "     ##,###,### bytes / ##,###k / ## Meg"; Used&; UsedK&; UsedM&
    COLOR 15, 0: LOCATE 14, 7: PRINT "Free Storage Space:";
        COLOR 14, 0: PRINT USING "     ##,###,### bytes / ##,###k / ## Meg"; Free&; FreeK&; FreeM&
         
    COLOR 15, 0: LOCATE 16, 7: PRINT "Disk Operating System (DOS) Version: ";
        COLOR 14, 0: PRINT DosVer$
   
    COLOR 15, 0: LOCATE 17, 7: PRINT "Verify-After-Write Status: ";
        COLOR 14, 0: PRINT Answer$(Verify)

    COLOR 15, 0: LOCATE 18, 7: PRINT "Valid System Disk Dives: ";
        COLOR 14, 0: PRINT VDrives$


    CALL Motion(25, 0, 14, 3, "Press any key to continue.. ")
'
'   Directory Demo
'
    COLOR 15, 3: CLS
    CALL MakeBox(10, 20, 12, 60, 7, 7, 4, "")
    CALL Cprint(11, 0, 15, 4, "Loading Directory Please Wait..")
    CALL GetDirData("", DirEntry$(), "AN", EntryCount)
'
'   If EntryCount = 0 then we can do the Directory Demo
'
    IF EntryCount = 0 THEN
    COLOR 15, 3: CLS
        CALL MakeBox(9, 15, 12, 65, 7, 7, 4, "[ Notice ]")
        CALL Cprint(10, 0, 15, 4, "I was unable to locate any Directory Entries,")
        CALL Cprint(11, 0, 15, 4, "therefore, we must skip the Directory Demo.")
        CALL Delay(6): GOTO MainMenu
    END IF
   
    COLOR 15, 3: CLS
    CALL MakeBox(2, 10, 5, 70, 7, 7, 5, "[ DOS Demonstration ]")
    CALL Cprint(3, 0, 15, 5, "We can also take a look at your drive's directory.")
    CALL Cprint(4, 0, 15, 5, "This can be done several ways....")
   
    CALL MakeBox(16, 8, 19, 72, 2, 7, 4, "[ Information ]")
    CALL Cprint(17, 0, 15, 4, "Use the Up/Down Arrow, Home, End, and Page Up/Down keys to")
    CALL Cprint(18, 0, 15, 4, "scroll through the listing. Press ENTER to select an entry.")
    CALL MakeBox(21, 9, 23, 71, 7, 0, 1, "")
   
    CALL SaveScreen(ScrnSave())
    CALL Cprint(22, 0, 15, 1, "One way will display the FileNames only.")
    CALL ShowDir(8, 30, 15, 0, 2, 2, 0, 5, DirEntry$(), Reply%, "N")

    CALL RestScreen(ScrnSave())
    CALL Cprint(22, 0, 15, 1, "Another will display FileNames and Sizes.")
    CALL ShowDir(8, 25, 15, 0, 2, 2, 1, 5, DirEntry$(), Reply%, "N")
   
    CALL RestScreen(ScrnSave())
    CALL Cprint(22, 0, 15, 1, "Yet another will display FileNames, Sizes, Dates, & Times.")
    CALL ShowDir(8, 15, 15, 0, 2, 2, 2, 5, DirEntry$(), Reply%, "N")

    CALL RestScreen(ScrnSave())
    CALL Cprint(22, 0, 15, 1, "Last but not least, we can add the File Attributes.")
    CALL ShowDir(8, 12, 15, 0, 2, 2, 3, 5, DirEntry$(), Reply%, "N")
    GOTO MainMenu

' --------------------------------------------------------------------------
'   Demonstrate Cprint
' --------------------------------------------------------------------------
    COLOR 15, 3: CLS
    CALL MakeBox(1, 4, 4, 76, 7, 0, 1, "")
    CALL Cprint(2, 0, 15, 1, "Did you every want one command that would Locate, change the Color,")
    CALL Cprint(3, 0, 15, 1, "Center if desired, and then Print the information for you?")
  
    CALL MakeBox(7, 8, 22, 72, 2, 15, 0, "")
    Prompt$ = STRING$(40, 219)
    CALL Cprint(8, 0, 2, 0, "GREEN       - " + Prompt$)
    CALL Cprint(9, 0, 3, 0, "CYAN        - " + Prompt$)
    CALL Cprint(10, 0, 4, 0, "RED         - " + Prompt$)
    CALL Cprint(11, 0, 5, 0, "MAGENTA     - " + Prompt$)
    CALL Cprint(12, 0, 6, 0, "BROWN       - " + Prompt$)
    CALL Cprint(13, 0, 7, 0, "WHITE       - " + Prompt$)
    CALL Cprint(14, 0, 8, 0, "GRAY        - " + Prompt$)
    CALL Cprint(15, 0, 9, 0, "Lt. BLUE    - " + Prompt$)
    CALL Cprint(16, 0, 10, 0, "Lt. GREEN   - " + Prompt$)
    CALL Cprint(17, 0, 11, 0, "Lt. CYAN    - " + Prompt$)
    CALL Cprint(18, 0, 12, 0, "Lt. RED     - " + Prompt$)
    CALL Cprint(19, 0, 13, 0, "Lt. MAGENTA - " + Prompt$)
    CALL Cprint(20, 0, 14, 0, "YELLOW      - " + Prompt$)
    CALL Cprint(21, 0, 15, 0, "Ints. WHITE - " + Prompt$)
    CALL Cprint(23, 0, 15, 3, "We call it Cprint - for Color Print, and it does it all.")
    CALL Motion(25, 0, 14, 3, "Press any Key to Continue....  ")

'
'   Video Demos
'
VideoDemos:
    COLOR 15, 3: CLS
    CALL MakeBox(3, 10, 5, 70, 7, 7, 5, "")
    CALL Cprint(4, 0, 15, 5, Release$)
    CALL MakeBox(19, 10, 22, 70, 7, 7, 4, "[ Information ]")
    CALL Cprint(20, 12, 15, 4, "Use the Up/Down, Page-Up/Down, Home/End Cursor keys to")
    CALL Cprint(21, 12, 15, 4, "Scroll through the text. Press the ESCAPE key to continue.")

    FileName$ = "VIDINFO.DOC"
    CALL ViewFile(FileName$, 40, 8, 10, 15, 14, 1, 5, ListLen%, 7, 57, "[ VIDEO Comments ]", 0)
    IF ListLen% < 1 THEN GOTO FileError

    COLOR 15, 3: CLS
    CALL MakeBox(2, 5, 24, 75, 2, 7, 0, "[ Video Demonstration ]")
    CALL Cprint(3, 0, 14, 0, "These utilities can tell you about your video setup.")
    CALL MakeLine(4, 5, 4, 75, 2, 7, 0)
    CALL MakeLine(6, 5, 6, 75, 4, 7, 0)
   
    CALL GetVideo(VideoMode, CharCol, VideoPage)
  

    CALL Cprint(5, 7, 15, 0, "Current Video Page: ")
        COLOR 14, 0: PRINT VideoPage
   
    IF VideoMode = 0 THEN Fcolor = 14 ELSE Fcolor = 15
    CALL Cprint(7, 7, Fcolor, 0, "40x25 Composite Video")
    IF VideoMode = 1 THEN Fcolor = 14 ELSE Fcolor = 15
    CALL Cprint(8, 7, Fcolor, 0, "40x25      16 Color Text")
    IF VideoMode = 2 THEN Fcolor = 14 ELSE Fcolor = 15
    CALL Cprint(9, 7, Fcolor, 0, "80x25 Composite Video")
    IF VideoMode = 3 THEN Fcolor = 14 ELSE Fcolor = 15
    CALL Cprint(10, 7, Fcolor, 0, "80x25      16 Color Text")
    IF VideoMode = 4 THEN Fcolor = 14 ELSE Fcolor = 15
    CALL Cprint(11, 7, Fcolor, 0, "40x25       4 Color    320x200 Graphics")
    IF VideoMode = 5 THEN Fcolor = 14 ELSE Fcolor = 15
    CALL Cprint(12, 7, Fcolor, 0, "40x25 Composite Video  320x200 Graphics")
    IF VideoMode = 6 THEN Fcolor = 14 ELSE Fcolor = 15
    CALL Cprint(13, 7, Fcolor, 0, "80x25       2 Color    640x200 Grphics")
    IF VideoMode = 7 THEN Fcolor = 14 ELSE Fcolor = 15
    CALL Cprint(14, 7, Fcolor, 0, "80x25       2 Color Monchorme Text")
    IF VideoMode = 13 THEN Fcolor = 14 ELSE Fcolor = 15
    CALL Cprint(15, 7, Fcolor, 0, "40x25      16 Color    320x200 Graphics")
    IF VideoMode = 14 THEN Fcolor = 14 ELSE Fcolor = 15
    CALL Cprint(16, 7, Fcolor, 0, "80x25      16 Color    640x200 Graphics")
    IF VideoMode = 15 THEN Fcolor = 14 ELSE Fcolor = 15
    CALL Cprint(17, 7, Fcolor, 0, "80x25/43    2 Color    640x350 Graphics (Monochrome)")
    IF VideoMode = 16 THEN Fcolor = 14 ELSE Fcolor = 15
    CALL Cprint(18, 7, Fcolor, 0, "80x25/43 4/16 Color    640x350 Graphics")
    IF VideoMode = 17 THEN Fcolor = 14 ELSE Fcolor = 15
    CALL Cprint(19, 7, Fcolor, 0, "80x30/60    2 Color    640x480 Graphics")
    IF VideoMode = 18 THEN Fcolor = 14 ELSE Fcolor = 15
    CALL Cprint(20, 7, Fcolor, 0, "80x30/60   16 Color    640x480 Graphics")
    IF VideoMode = 19 THEN Fcolor = 14 ELSE Fcolor = 15
    CALL Cprint(21, 7, Fcolor, 0, "40x25     256 Color    320x200 Graphics")

    CALL MakeLine(22, 5, 22, 75, 4, 7, 0)
   
    CALL Cprint(23, 7, 15, 0, "Current Character Columns: ")
        COLOR 14, 0: PRINT CharCol

   
    CALL Motion(25, 0, 14, 3, "Press any key to continue.. ")
'
'   Menu Demonstration - Pull Down
'
    COLOR 15, 3: CLS
    CALL MakeBox(2, 6, 4, 74, 7, 7, 5, "[ Video Demonstration ]")
    CALL Cprint(3, 0, 15, 5, "If you like pull-down menu selection style, give this a try.")
        CALL MakeBox(19, 10, 22, 70, 7, 7, 4, "[ Information ]")
        CALL Cprint(20, 0, 15, 4, "Use the Up and Down Cursor Keys to select a topic.")
        CALL Cprint(21, 0, 15, 4, "Press the ENTER key to continue.")
    Menu$(0) = "Pull-Down Menu Demo"
    Menu$(1) = "Selection Item One"
    Menu$(2) = "Selection Item Two"
    Menu$(3) = "Selection Item Three"
    Menu$(4) = "Selection Item Four"
    Menu$(5) = "Selection Item Five"
    CALL MakeMenu(7, 27, 6, 2, 15, 0, 2, 5, Menu$(), "", Reply)
'
'   Key Selection Style
'
    COLOR 15, 3: CLS
    CALL MakeBox(2, 6, 4, 74, 7, 7, 5, "[ Video Demonstration ]")
    CALL Cprint(3, 0, 15, 5, "Or, you could always use a key selection style menu.")
    CALL MakeBox(20, 10, 22, 70, 7, 7, 4, "[ Information ]")
    CALL Cprint(21, 0, 15, 4, "Press a selection key to select a topic.")
    Menu$(0) = "Key Selection Menu Demo"
    Menu$(1) = "A - Key Selection Item One"
    Menu$(2) = "B - Key Selection Item Two"
    Menu$(3) = "C - Key Selection Item Three"
    Menu$(4) = "D - Key Selection Item Four"
    Menu$(5) = "E - Key Selection Item Five"
    Menu$(6) = "Select Items A - E"
    CALL MakeMenu(7, 23, 6, 1, 15, 0, 2, 6, Menu$(), "ABCDE", Reply)

    GOTO MainMenu
'
'   BITS Demos
'
BITSDemos:
    COLOR 15, 3: CLS
    CALL MakeBox(3, 10, 5, 70, 7, 7, 5, "")
    CALL Cprint(4, 0, 15, 5, Release$)
    CALL MakeBox(19, 10, 22, 70, 7, 7, 4, "[ Information ]")
    CALL Cprint(20, 12, 15, 4, "Use the Up/Down, Page-Up/Down, Home/End Cursor keys to")
    CALL Cprint(21, 12, 15, 4, "Scroll through the text. Press the ESCAPE key to continue.")

    FileName$ = "BITSINFO.DOC"
    CALL ViewFile(FileName$, 40, 8, 10, 15, 14, 1, 5, ListLen%, 7, 57, "[ BITS Comments ]", 0)
    IF ListLen% < 1 THEN GOTO FileError
   
    COLOR 15, 3: CLS
    CALL MakeBox(2, 5, 23, 75, 2, 7, 0, "[ BITS Demonstration ]")
    CALL Cprint(3, 0, 14, 0, "These utilities can be used for several bit operations.")
    CALL MakeLine(4, 5, 4, 75, 2, 7, 0)
    CALL MakeLine(4, 39, 23, 39, 7, 7, 0)

    BitNumber$ = "0000110011010000"
    CALL MakeBitNum(BirNumber$, Number)

    Number1 = 32738
    CALL MakeBitStr(Number1, BitString$)


    Number1 = 32738
    CALL MakeBitStr(Number1, BitString$)
    CALL Cprint(5, 7, 15, 0, "MakeBitStr from: ")
        COLOR 14: PRINT Number1
    CALL Cprint(6, 7, 15, 0, "Returns: ")
        COLOR 14: PRINT BitString$

    FOR X = 0 TO 15
        CALL CheckBitNum(Number1, X, Bit)
        IF Bit = 1 THEN Fcolor = 14 ELSE Fcolor = 15
        CALL Cprint(7 + X, 7, Fcolor, 0, "Number Bit" + STR$(X) + " is " + BAnswer$(Bit) + ".")
    NEXT X

    BitNumber$ = "0000110011010000"
    CALL MakeBitNum(BitNumber$, Number)
    CALL Cprint(5, 41, 15, 0, "MakeBitNum from: ")
        COLOR 14: PRINT BitNumber$
    CALL Cprint(6, 41, 15, 0, "Returns: ")
        COLOR 14: PRINT Number

    FOR X = 0 TO 15
        CALL CheckBitStr(BitNumber$, X, Bit)
        IF Bit = 1 THEN Fcolor = 14 ELSE Fcolor = 15
        CALL Cprint(7 + X, 41, Fcolor, 0, "String Bit" + STR$(X) + " is " + BAnswer$(Bit) + ".")
    NEXT X

    CALL Motion(25, 0, 14, 3, "Press any key to continue.. ")
   
    COLOR 15, 3: CLS
    CALL MakeBox(2, 5, 16, 75, 2, 7, 0, "[ BITS Demonstration ]")
    CALL Cprint(3, 0, 14, 0, "Or they can perform 16/8 bit word operations.")
    CALL MakeLine(4, 5, 4, 75, 2, 7, 0)
    CALL MakeLine(4, 50, 16, 50, 7, 7, 0)

    High = 44: Low = 245
    CALL SetHighLow(High, Low, HL1)

    SRow = 5
    CALL Cprint(SRow, 7, 15, 0, "8 Bit High Number: ")
        COLOR 14: PRINT High
        CALL MakeBitStr(High, BitString$)
        CALL Cprint(SRow, 55, 14, 0, RIGHT$(BitString$, 8))
    CALL Cprint(SRow + 1, 7, 15, 0, "8 Bit Low Number:  ")
        COLOR 14: PRINT Low
        CALL MakeBitStr(Low, BitString$)
        CALL Cprint(SRow + 1, 55 + 8, 14, 0, RIGHT$(BitString$, 8))
    CALL Cprint(SRow + 3, 7, 15, 0, "16 Bit Number from SetHighLow: ")
        COLOR 14: PRINT HL1
        CALL MakeBitStr(HL1, BitString$)
        CALL Cprint(SRow + 3, 55, 14, 0, BitString$)
   
    HL2 = 29738
    CALL GetHighLow(HL2, High, Low)
   
    SRow = 12
    CALL Cprint(SRow, 7, 15, 0, "16 Bit Number:     ")
        COLOR 14: PRINT HL2
        CALL MakeBitStr(HL2, BitString$)
        CALL Cprint(SRow, 55, 14, 0, BitString$)
    CALL Cprint(SRow + 2, 7, 15, 0, "8 Bit High Number from GetHighLow: ")
        COLOR 14: PRINT High
        CALL MakeBitStr(High, BitString$)
        CALL Cprint(SRow + 2, 55, 14, 0, RIGHT$(BitString$, 8))
    CALL Cprint(SRow + 3, 7, 15, 0, "8 Bit Low Number from GetHighLow:  ")
        COLOR 14: PRINT Low
        CALL MakeBitStr(Low, BitString$)
        CALL Cprint(SRow + 3, 55 + 8, 14, 0, RIGHT$(BitString$, 8))

    CALL Motion(23, 0, 14, 3, "Press any key to continue.. ")
    GOTO MainMenu
'
'   OTHER Demos
'
OTHERDemos:
    COLOR 15, 3: CLS
    CALL MakeBox(3, 10, 5, 70, 7, 7, 5, "")
    CALL Cprint(4, 0, 15, 5, Release$)
    CALL MakeBox(19, 10, 22, 70, 7, 7, 4, "[ Information ]")
    CALL Cprint(20, 12, 15, 4, "Use the Up/Down, Page-Up/Down, Home/End Cursor keys to")
    CALL Cprint(21, 12, 15, 4, "Scroll through the text. Press the ESCAPE key to continue.")

    FileName$ = "MISCINFO.DOC"
    CALL ViewFile(FileName$, 40, 8, 10, 15, 14, 1, 5, ListLen%, 7, 57, "[ OTHER Comments ]", 0)
    IF ListLen% < 1 THEN GOTO FileError

' --------------------------------------------------------------------------
'   Demonstrate TYPELINE
' --------------------------------------------------------------------------
    COLOR 15, 3: CLS
    CALL MakeBox(1, 8, 4, 72, 7, 7, 5, "[ Other Utilities Demonstation ]")
    CALL Cprint(2, 0, 15, 5, "You can now have Word Processor stype input that allows for")
    CALL Cprint(3, 0, 15, 5, "seperators such as (" + CHR$(34) + " or ,) without giving syntax errors.")
  
    CALL MakeBox(12, 10, 23, 71, 7, 7, 4, "[ Information ]")
    CALL Cprint(13, 13, 15, 4, "HOME - Move cursor to start of Input Line.")
    CALL Cprint(14, 13, 15, 4, "END  - Move cursor to end of Input Line.")
    CALL Cprint(15, 13, 15, 4, "CURSOR " + CHR$(17) + "/" + CHR$(16) + " - Move cursor Right/Left on line.")
    CALL Cprint(16, 13, 15, 4, "INSERT - Toggle Insert/Over-type Modes.")
    CALL Cprint(17, 13, 15, 4, "DELETE - Delete characters from line.")
    CALL Cprint(18, 13, 15, 4, "ESCAPE - Clear the Input Line.")
    CALL Cprint(19, 13, 15, 4, "CTRL+D - Delete rest of text, from cursor to end of text.")
    CALL Cprint(20, 13, 15, 4, "CTRL+T - Delete word.")
    CALL Cprint(21, 13, 15, 4, "CTRL+CURSOR " + CHR$(17) + "/" + CHR$(16) + " - Move Right/Left one word.")
    CALL Cprint(22, 13, 15, 4, "ENTER - Accept Input Line.")

    CALL MakeBox(7, 5, 9, 75, 6, 0, 2, "")
    CALL TypeLine(8, 0, 30, 15, 2, "TypeLine Test (30 chars max.)", A$)
    CALL MakeBox(7, 5, 9, 75, 6, 0, 2, "")
    CALL Cprint(8, 0, 15, 2, "You entered: " + A$)
    CALL Motion(25, 0, 14, 3, "Press any Key to Continue....  ")
'
'   Demonstrate InkeyBox
'
InkeyBoxDemo:
    COLOR 15, 3: CLS
    CALL MakeBox(6, 10, 17, 70, 7, 7, 5, "[ Other Utilities Demonstration ]")
    CALL Cprint(8, 0, 15, 5, "If you need a single key entry from a prompt,")
    CALL Cprint(9, 0, 15, 5, "we have just the thing for you.")
    CALL MakeBox(11, 20, 13, 60, 6, 0, 2, "")
InkeyBoxLoop:
    CALL InkeyBox(12, 0, 15, 2, "[C]ontinue or [R]edraw Screen", A$)
    A$ = UCASE$(A$)
    IF A$ = "R" THEN GOTO InkeyBoxDemo
    IF A$ <> "C" THEN CALL Oops: GOTO InkeyBoxLoop
    GOTO MainMenu


'
'   Handle errors for missing information files
'
FileError:      
    CALL MakeBox(8, 14, 13, 65, 5, 14, 4, "[ File Error! ]")
    CALL Cprint(9, 0, 15, 4, "The DEMO program is unable to find the")
    CALL Cprint(10, 0, 15, 4, FileName$ + " file. This file should be located")
    CALL Cprint(11, 0, 15, 4, "within the default directory for this program to")
    CALL Cprint(12, 0, 15, 4, "function properely.")
    END


