'!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
'!!!        ** [ READ THIS ] ** !!!!!!!! ** [ READ THIS ] **             !!!
'!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
' DATA FILE, ISAMDATA.DAT REQUIRED FOR THIS PROGRAM -- SEE SCRLFILE.DOC
'***************************************************************************
'**** THIS PROGRAM MUST BE USED WITH ONE OF THE FOLLOWING LIBRARIES:    ****
'***************************************************************************
'**** For QB4.50 unenhanced version use QBUNEN.QLB                      ****
'**** For BASIC 7.1 unenhanced version use PDSUNEN.QLB                  ****
'**** For VBDOS 1.0 unenhanced version use VBUNEN.QLB                   ****
'**** For QB4.50 enhanced version use QBALL.QLB or QBNER.QLB            ****
'**** For BASIC 7.1 enhanced version use PDSALL.QLB or PDSNER.QLB       ****
'**** For VBDOS 1.0 enhanced version use VBALL.QLB or VBNER.QLB         ****
'**** Load QB, QBX, or VBDOS with the /L option and the correct library ****
'***************************************************************************
'                              INSTRUCTIONS
'                              ------------
'   1. TSR, PROISAM, MUST BE LOADED BEFORE ATTEMPTING TO RUN THIS
'      PROGRAM. WITH PROISAM.EXE AVAILABLE, TYPE: PROISAM - AT THE DOS PROMPT.
'   2. MAKE SURE THE DATA FILE, ISAMDATA.DAT, IS IN THE DEFAULT
'      DRIVE/DIRECTORY.  IF IT IS NOT AVAILABLE IT CAN BE MADE USING
'      MAKEISAM.BAS ( SEE SCRLFILE.DOC ).
'   3. LOAD QUICKBASIC OR PDS WITH THE CORRECT LIBRARY. ( SEE ABOVE )
'   4. LOAD SCRLISAM.BAS ( THIS FILE ) INTO QB OR QBX.
'   5. RUN THE PROGRAM. ( SHIFT F5 )
'
'          **** SEE SCRLFILE.DOC FOR ADDITIONAL INFORMATION ****
'***************************************************************************
'          ***** NOT FOR USE WITH QB 45 WITHOUT ISAM *****
'---------------------------------------------------------------------------
DECLARE FUNCTION LBUTTON% ()
DECLARE FUNCTION MOUSEINWIND% (W%)
DECLARE FUNCTION MOUSEON% (ONOFF%)
DECLARE FUNCTION CHOICEBAR% (CH$(), TR%, LC%, WD%, ATTR%, HATTR%, EXIT$)
DECLARE FUNCTION CHOICEWIND% (TITLE$, T$(), C$(), TR%, LC%, ATTR%, HATTR%, ESCEX%, BRDR%)

TYPE REC
  MARK AS STRING * 1
  NAM AS STRING * 25
  ADD1 AS STRING * 30
  CITY AS STRING * 25
  STATE AS STRING * 10
  ZIP AS STRING * 9
END TYPE

DIM RECORD AS REC
DIM OLDRECORD AS REC

COLOR 0, 7: CLS

DIM CH$(4)
CH$(1) = "ENTER=SELECT": CH$(2) = "ESC=EXIT": CH$(3) = "F1=FIND"
CH$(4) = "DEL=DELETE"

CALL SETWIND(1, 1, 7, 0, 15)          ' INITIALIZE WINDOW MEMORY.
CALL INPTINIT(1, 1, 0, 1, 1)          ' INITIALIZE INPUT MEMORY.
JUNK% = MOUSEON%(1)                   ' INITIALIZE MOUSE AND TURN IT "ON".
CALL MAKEWIND(1, "", 1, 1, 80, 25, 112, 2)
CALL CUROFF

DO
  ANS$ = ""
  CALL GETANS("Color or Mono (C/M) ?", "CM", ANS$, 100, 100, 143, 0, 11)
  IF ANS$ = "C" THEN COL% = 31 ELSE COL% = 112
LOOP WHILE ANS$ = CHR$(27)

CALL BOXW(21, 7, 64, 3, 2)

IF COL% = 31 THEN A% = 31 ELSE A% = 15
CALL INFOLINE(25, 2, 78, A%)              ' TURN INFO-LINE ON.
                                          ' LEFT MOUSE BUTTON = ESC
'---------------------------------------------------------------------------
' DESCRIPTION WINDOW

 CALL MAKEWIND(2, "@Virtual scroll window template - Using an ISAM data file", 2, 100, 74, 8, COL%, 111)
 CALL PRINTW("         This scroll window scrolls through an ISAM table.  It holds 5", 1, 2)
 CALL PRINTW("records at a time.   This eliminates the need to place the entire file", 2, 2)
 CALL PRINTW("in memory, minimizing precious string space usage.   This template may", 3, 2)
 CALL PRINTW("be used with many other type data files with slight modification.", 4, 2)
'---------------------------------------------------------------------------

' MAKE THE WINDOW TO BE USED AS THE SCROLL WINDOW.
' INITIALIZE VARIABLES

'---------------------------------------------------------------------------

  RTRN% = 1                ' SCROLL BAR OVER 1ST ENTRY.
  ROWS% = 5                ' INTERIOR ROWS IN SCROLL WINDOW.
                           ' IF WINDOW HAS A TITLE BOX ROWS% = NUMBER OF
                           ' WINDOW ROWS - 4 ELSE ROWS% = NUMBER OF WINDOW
                           ' ROWS - 2.
  DIM A$(ROWS%)            ' DIMENSION ARRAY TO HOLD SCROLL WINDOW ENTRIES.
  FC% = 1                  ' THE FIRST CHARACTER FOR ENTRIES IN SCROLL WINDOW
                           ' PRINTS IN THE FIRST COLUMN IN THE WINDOW.
                           ' WITH VIRTUAL SCROLL WINDOWS THE CHARACTER IN THE
                           ' 1st COLUMN IS NOT ALWAYS THE 1st CHARACTER.
  FILENUM% = 1             ' FILE NUMBER
  DATAFILE$ = "ISAMDATA.DAT"   ' PREVIOUSLY CREATED ISAM FILE NAME
  TABLENAME$ = "ALLDATA"       ' PREVIOUSLY CREATED ISAM TABLE
  INDEXNAME$ = "NAME"          ' PREVIOUSLY CREATED ISAM INDEX
  DIM DUMMY$(0)               ' SCROLL WINDOW REQUIRES FOR INFOLINE

  RK% = CHOICEBAR%(CH$(), 23, 5, 70, 112, 0, "VIEW")
  CALL MAKEWIND(20, "", 12, 4, 74, ROWS% + 4, COL%, 111)  ' FOR SCROLL WINDOW.
  CALL PRINTW("[ (+) = Mark  ][ (-) = Unmark ]", 6, 100)

   ' SCROLL WINDOW'S TITLE
  TITLE$ = "NAME                     ADDRESS                       CITY                     STATE     ZIP"

  OPEN "ISAMDATA.DAT" FOR ISAM REC TABLENAME$ AS 1  ' OPEN THE ISAM FILE
  SETINDEX FILENUM%, INDEXNAME$                     ' SET THE INDEX
'---------------------------------------------------------------------------
  'GET RECORDS FOR FIRST SCROLL WINDOW

  MOVEFIRST FILENUM%                                 ' START AT RECORD 1
  GOSUB GETRECORDS                                   ' GET RECORDS

' ---------------------------------------------------------------------------
 ' PRINT THE INSTRUCTIONS AND PLACE THE RECORDS IN THE SCROLL WINDOW.

MAKESCRL:
  CALL INFOFIXED("     Up/Down/Left/Right -- Pgup/Pgdn -- Home/End -- Tab/Shift Tab -- Mouse")
  KIND$ = ""         ' THIS IS A "REGULAR SCROLL WINDOW.

  ' SET EXIT CRITERA , NO MARKED ITEMS
  CALL B4SCRL("MCOTDERX1", SCROLLMARK$, 0, NOREFRESH%)
  NOREFRESH% = 0
  ' ENTER THE SCROLL WINDOW
  KIND$ = "M"
  CALL SCRLWIND(A$(), DUMMY$(), TITLE$, ENTRIES%, KIND$, RTRN%, LI%, FC%, RK%, 0, 0, 0)

  CALL INFOFIXED("")                  ' ERASE THE FIXED INFO STRING.

  IF RK% = 200 OR RK% = 14 OR RK% = 15 THEN    ' Mouse pressed out of scroll window
        CALL PRINTW("", 6, 100)
        RK% = CHOICEBAR%(CH$(), 23, 5, 70, 112, 0, "1EOT")
        SELECT CASE RK%
          CASE 1: RK% = 13             ' simulate ENTER
          CASE -1, 3: RK% = 1          ' simulate F1
          CASE 2: RK% = 27             ' simulate ESC
          CASE 4: RK% = 45
          CASE ELSE: NOREFRESH% = 1    ' Mouse pressed out of a selection
        END SELECT
     'loop if lbutton is pressed with mouse out of scroll window
     DO: LOOP WHILE LBUTTON% = 1 AND MOUSEINWIND%(20) = 0
     CALL PRINTW("", 6, 100)
  END IF

  IF KIND$ = "" THEN KIND$ = SPACE$(ENTRIES%)
'----------------------------------------------------------------------------
 SELECT CASE RK%              ' RK% = EXIT KEY OR CIRCUMSTANCE CAUSING EXIT

'----------------------------------------------------------------------------
' THE DELETE KEY CAUSED THE EXIT -- DELETE A RECORD

    CASE 45
      CALL PRINTINFO(" Press Y to delete the highlighted entry or N to abort deletion.")
      ANS$ = ""
      CALL GETANS("Delete this entry. Are you sure (Y/N)", "YN", ANS$, 11, 100, 15, 0, 11)
      IF ANS$ = "Y" THEN
        IF ONLAST% = 0 THEN                      ' IF CURRENT RECORD IS
           FOR X% = 1 TO ENTRIES% - 1            ' FIRST ENTRY IN THE SCROLL
              MOVENEXT FILENUM%                  ' WINDOW MOVE IT TO THE
           NEXT                                  ' LAST ENTRY.
           ONLAST% = 1
        END IF

        ' IS IT THE LAST SCROLL WINDOW ( LAST RECORD = LAST ENTRY )

        MOVENEXT FILENUM%
        IF EOF(FILENUM%) THEN PASTEND% = 1 ELSE PASTEND% = 0
        MOVEPREVIOUS FILENUM%

        IF ONLAST% = 1 THEN             ' MOVE CURRENT RECORD TO FIRST RECORD
           GOSUB MOVE.TO.START          ' IN THE SCROLL WINDOW
        END IF

        ' IS IT THE FIRST SCROLL WINDOW ( RECORD #1 = FIRST ENTRY )

        MOVEPREVIOUS FILENUM%
        IF BOF(FILENUM%) THEN PASTSTART% = 1 ELSE PASTSTART% = 0
        MOVENEXT FILENUM%

        ' MOVE TO SELECTED RECORD, DELETE IT AND UPDATE ISAM FILE

        FOR X% = 1 TO RTRN% - 1
          MOVENEXT FILENUM%
        NEXT
        DELETE FILENUM%
        CHECKPOINT

        IF PASTSTART% = 1 AND PASTEND% = 1 THEN
           ' ( ALL RECORDS FIT IN ONE WINDOW )
           MOVEFIRST FILENUM%
           IF RTRN% = ENTRIES% THEN RTRN% = RTRN% - 1
           CALL LINEW(ENTRIES%, 0)
        ELSE
           FOR X% = 1 TO RTRN% - 1
              ' ( MOVE BACK TO FIRST RECORD IN THE SCROLL WINDOW )
              MOVEPREVIOUS FILENUM%
           NEXT
           IF PASTSTART% = 0 AND PASTEND% = 1 THEN
              ' ( THIS IS THE LAST SCROLL WINDOW - MOVE TO PREVIOUS RECORD )
              MOVEPREVIOUS FILENUM%
           END IF
        END IF

        ' DECREMENT NUMBER OF RECORDS AND DISPLAY SAME.

        GOSUB GETRECORDS
      END IF

'---------------------------------------------------------------------------
 ' THE ENTER KEY CAUSED THE EXIT ---- AN ENTRY WAS SELECTED.
 ' SELECTION IS A$(RTRN%).  THIS METHOD GETS SELECTION FROM ISAM FILE.
 ' SELECTION COULD BE UPDATED HERE WITH ROUTINE "MULTINPT".

   CASE 13
     NOREFRESH% = 1
     CALL PRINTINFO(" Select OK....")
     IF ONLAST% = 1 THEN               ' MOVE CURRENT RECORD TO FIRST RECORD
       GOSUB MOVE.TO.START             ' IN THE SCROLL WINDOW
     END IF

     ' MOVE TO SELECTED RECORD NUMBER.

     FOR X% = 1 TO RTRN% - 1: MOVENEXT FILENUM%: NEXT

     RETRIEVE FILENUM%, OLDRECORD
     RETRIEVE FILENUM%, RECORD

     '----------------------------------------------------------------------
     ' EDIT RECORD HERE

     REDIM C$(1), T$(4)
     C$(1) = "OK"
     T$(1) = " Using WINDOW R-E-Z's routine MULTINPT,"
     T$(2) = " the selected record could be edited at"
     T$(3) = " this point in the program. See remarks"
     T$(4) = " in the source code."
     J% = CHOICEWIND%("@Selection = " + RTRIM$(RECORD.NAM) + "...", T$(), C$(), 5, 100, 15, 0, 1, 111)

     ' ---------------------------------------------------------------------

     GOSUB COMPAREIT
     IF COMPARE% = 1 THEN                ' NOTHING CHANGED.
        FOR X% = 1 TO RTRN% - 1          ' SET CURRENT RECORD BACK TO
            MOVEPREVIOUS FILENUM%        ' SAME POSITION BEFORE EDIT.
        NEXT
     ELSE
        UPDATE FILENUM%, RECORD          ' UPDATE THE ISAM TABLE
        SEEKEQ FILENUM%, RECORD.NAM      ' GET FIRST MATCH FOR EDITED RECORD.
        DO                               ' FIND EXACT MATCH FOR ALL FIELDS.
           RETRIEVE FILENUM%, OLDRECORD
           GOSUB COMPAREIT
           IF COMPARE% = 1 THEN EXIT DO  ' ALL FIELDS MATCH. CUURENT RECORD
           MOVENEXT FILENUM%             ' IS ON EDITED RECORD.
        LOOP
        GOSUB FOUNDRECORD                 ' PUT RECORD AT POSITION "RTRN%" IN
                                          ' SCROLL WINDOW. (IF POSSIBLE.)
     END IF
'---------------------------------------------------------------------------

   CASE 30                                 ' HOME
      MOVEPREVIOUS FILENUM%
      IF LI% = 1 AND BOF(1) THEN           ' IS SCROLL BAR IS FIRST RECORD?
         CALL DOSOUND
      ELSE
         IF ENTRIES% = ROWS% THEN
         MOVEFIRST FILENUM%              ' MAKE CURRENT RECORD = 1ST RECORD
            GOSUB GETRECORDS             ' GET NEW RECORDS FOR SCROLL WINDOW.
         END IF
      END IF
      MOVEFIRST FILENUM%: ONLAST% = 0
      FC% = 1                              ' FIRST CHARACTER = 1.
      RTRN% = 1                            ' PLACE SCROLL BAR ON 1ST ENTRY

'---------------------------------------------------------------------------
   CASE 35                                       ' END
      MOVENEXT FILENUM%
      IF LI% = ENTRIES% AND EOF(FILENUM%) THEN   ' IS SCROLL BAR ON LAST
         CALL DOSOUND                            ' RECORD?
      ELSE
         IF ENTRIES% = ROWS% THEN                ' SET CURRENT RECORD TO
              MOVELAST FILENUM%                  ' CORRECT RECCORD.
              FOR X% = 1 TO ROWS% - 1            ' ( LAST RECORD - ROWS%+1 )
                 WHILE INKEY$ <> "": WEND        ' CLEAR KEYBOARD
                 MOVEPREVIOUS FILENUM%
              NEXT
              GOSUB GETRECORDS                  ' GET NEW RECORDS.
         END IF
      END IF
      MOVELAST FILENUM%: ONLAST% = 1
      FC% = 1
      RTRN% = ENTRIES%                   ' PLACE SCROLL BAR ON LAST RECORD.

'---------------------------------------------------------------------------
' F1 KEY FOR "FIND" CAUSE ROUTINE SCRLWIND TO BE EXITED

   CASE 1                                       ' FIND
      IF ONLAST% = 1 THEN                       ' MOVE CURRENT RECORD TO
         GOSUB MOVE.TO.START                    ' 1ST ENTRY IN SCROLL WINDOW.
         END IF
      RTRN$ = ""
      CALL PRINTINFO(" Enter the search critera.    ENTER accepts / ESC aborts.")
      FINDNAME$ = ""
      DO
        CALL DOSOUND
        CALL B4INPT("", "QWERTYUIOPASDFGHJKLZXCVBNM0123456789")
        CALL INPTWIND("  Find Record.  Enter A0 to Z9:", "U", 9, 100, 2, 112, 112, FINDNAME$, RKEY2%, 2, 11)
      LOOP WHILE FINDNAME$ = "" AND RKEY2% <> 27
      CALL RSTRINPT(1)

      IF RKEY2% <> 27 THEN
         FOR X% = 1 TO RTRN% - 1   ' MOVE CURRENT RECORD TO RECORD COVERED BY
           MOVENEXT FILENUM%       ' SCROLL BAR WHEN F1 (FIND) WAS PRESSED.
         NEXT
         RETRIEVE FILENUM%, OLDRECORD   ' SAVE THAT RECORD IN OLDRECORD.
      '----------------------------------------------------------------------
      ' THIS COUNTS THE NUMBER OF RECORDS BEFORE THE CURRENT RECORD
      ' THAT ARE A MATCH OF THE OLD CURRENT RECORD (IF ANY). THIS IS
      ' NEEDED IF THE "FIND" FAILS SO THE SCROLL WINDOW CAN BE RE-ENTER
      ' IN THE EXACT SPOT IT WAS BEFORE THE "FIND".  IT'S NOT REQUIRED FOR
      ' THIS SAMPLE, BUT IS BE FOR OTHER DATA FILES THAT HAVE DUPLICATES.

         OFFSET% = 0
         DO
           MOVEPREVIOUS FILENUM%
           IF BOF(FILENUM%) THEN MOVEFIRST FILENUM%: EXIT DO
           RETRIEVE FILENUM%, RECORD
           IF TEXTCOMP(RECORD.NAM, OLDRECORD.NAM) <> 0 THEN EXIT DO
           OFFSET% = OFFSET% + 1
         LOOP
      ' ---------------------------------------------------------------------
      ' SINCE THE SEEK IS "EQUAL TO OR GREATER THAN" TEXTCOMP CHECKS FOR
      ' AN EXACT MATCH.  IF THERE IS NO EXACT MATCH OR END OF FILE IS
      ' TRUE, FOUND% IS SET TO 0 ELSE FOUND% = 1.

         SEEKGE FILENUM%, FINDNAME$
         IF NOT EOF(FILENUM%) THEN
            RETRIEVE FILENUM%, RECORD
            IF TEXTCOMP(FINDNAME$, LEFT$(RECORD.NAM, 2)) = 0 THEN
               FOUND% = 1
            ELSE
               FOUND% = 0
            END IF
         ELSE
            FOUND% = 0
         END IF
      '----------------------------------------------------------------------

         IF FOUND% = 0 THEN
           CALL RSTRWIND(3, 1)
           CALL GETANS("MATCH FOR -- " + FINDNAME$ + " -- NOT FOUND!  Press any key..", "", "", 100, 100, 143, 0, 11)
         '------------------------------------------------------------------
         ' GO BACK TO THE OLD RECORD. ADJUST IF THERE WERE DUPLICATE RECORDS
         ' OFFSET% HOLDS THE NUMBER OF DUPLICATES

           SEEKGE FILENUM%, OLDRECORD.NAM
           RETRIEVE FILENUM%, RECORD
           FOR X% = 1 TO OFFSET%: MOVENEXT FILENUM%: NEXT
         '------------------------------------------------------------------
         END IF
         FC% = 1                         ' FOR VIRTUAL SCROLL WINDOWS.
         GOSUB FOUNDRECORD

      END IF                          ' IF RKEY% <> 27

'----------------------------------------------------------------------------
   ' SCRLWIND EXIT WAS CAUSED BY AN ATTEMPT TO MOVE BEFORE THE FIRST
   ' ENTRY ( A$(START) ) IN THE SCROLL WINDOW.

   CASE 11, 16                 ' SCROLLING BEFORE START = UP ARROW OR PGUP
       IF ONLAST% = 1 THEN
         GOSUB MOVE.TO.START
       END IF
       MOVEPREVIOUS FILENUM%

       IF LI% = 1 AND BOF(FILENUM%) THEN             ' ALREADY ON 1ST RECORD
         CALL DOSOUND: MOVENEXT FILENUM%
       ELSE
         IF ENTRIES% = ROWS% THEN
            IF RK% = 11 THEN                           ' MUST BE PAGE UP
               FOR X% = 1 TO ROWS% - 1
                  MOVEPREVIOUS FILENUM%
                  WHILE INKEY$ <> "": WEND             ' CLEAR KEYBOARD
               NEXT
               IF BOF(FILENUM%) THEN MOVEFIRST FILENUM%
               GOSUB GETRECORDS
            ELSE
               FOR X% = ROWS% TO 2 STEP -1
                  SWAP A$(X%), A$(X% - 1)
               NEXT
               RETRIEVE FILENUM%, RECORD
               A$(1) = RECORD.NAM + RECORD.ADD1 + RECORD.CITY + RECORD.STATE + RECORD.ZIP
               SCROLLMARK$ = RECORD.MARK + LEFT$(KIND$, ENTRIES% - 1)
            END IF
         END IF
       END IF
       LIN% = 1: RTRN% = 1
' ---------------------------------------------------------------------------
 ' SCRLWIND EXIT WAS CAUSED BY ATTEMPT TO MOVE PAST THE END OF
 ' THE SCROLL WINDOW ( A$(ENTRIES%) ).  PROGRAM ALSO MOVES HERE IF
 ' Mark (+) /Un-mark (-)  WAS PRESSED ON THE LAST ENTRY IN THE SCROLL
 ' WINDOW.

   CASE 12, 19                                  ' SCROLLING PAST THE END OF
                                                ' LIST.  DOWN ARROW OR PGUP.
DOWN:
       IF ONLAST% = 0 THEN                      ' IF FILE POSITION IS ON
          FOR X% = 1 TO ENTRIES% - 1            ' FIRST ENTRY IN THE SCROLL
             MOVENEXT FILENUM%                  ' WINDOW MOVE IT TO THE
          NEXT                                  ' LAST ENTRY.
          ONLAST% = 1
       END IF
       MOVENEXT FILENUM%     ' MOVE FILE POSITION TO RECORD AFTER LAST ENTRY

       IF LI% = ENTRIES% AND EOF(FILENUM%) THEN       ' END OF FILE?
          CALL DOSOUND: MOVEPREVIOUS FILENUM%
       ELSE                                           ' NOT EOF()
          IF ENTRIES% = ROWS% THEN
             IF RK% = 12 THEN                         ' PAGE DOWN
                FOR X% = 1 TO ROWS% - 1
                   WHILE INKEY$ <> "": WEND           ' CLEAR KEYBOARD
                   MOVENEXT FILENUM%
                 NEXT
                 IF EOF(FILENUM%) THEN MOVELAST FILENUM%
                 FOR X% = 1 TO ROWS% - 1
                     WHILE INKEY$ <> "": WEND           ' CLEAR KEYBOARD
                     MOVEPREVIOUS FILENUM%
                 NEXT
                 GOSUB GETRECORDS
             ELSE                                 ' MUST BE DOWN ARROW
                FOR X% = 1 TO ROWS% - 1
                   SWAP A$(X%), A$(X% + 1)
                NEXT
                RETRIEVE FILENUM%, RECORD
                A$(ENTRIES%) = RECORD.NAM + RECORD.ADD1 + RECORD.CITY + RECORD.STATE + RECORD.ZIP
                SCROLLMARK$ = MID$(KIND$, 2) + RECORD.MARK
             END IF
          END IF
       END IF
       RTRN% = ENTRIES%

 CASE 50, 55
   IF ONLAST% = 1 THEN          ' SET FILE POINTER TO 1ST RECORD
      GOSUB MOVE.TO.START       ' IN THE SCROLL WINDOW.
   END IF
   FOR X% = 1 TO RTRN% - 1      ' SET FILE POINTER TO THE MARKED/UNMARKED
      MOVENEXT FILENUM%         ' ENTRY IN THE SCROLL WINDOW
   NEXT

   RETRIEVE FILENUM%, RECORD    ' GET THE RECORD

   IF RK% = 50 THEN             ' WAS MARK
      RECORD.MARK = CHR$(16)    ' SET RECORD TO MARKED
   ELSE                         ' WAS UN-MARK (RK%=55)
      RECORD.MARK = " "         ' SET RECORD TO UN-MARKED
   END IF

   UPDATE FILENUM%, RECORD      ' UPDATE THE RECORD
   CHECKPOINT

   SCROLLMARK$ = KIND$          ' REFRESH SCROLLMARK$

   FOR X% = 1 TO RTRN% - 1      ' MOVE FILE POINTER BACK TO FIRST
      MOVEPREVIOUS FILENUM%     ' RECORD IN SCROLL WINDOW.
   NEXT
   RTRN% = RTRN% + 1            ' ADVANCE TO NEXT ENTRY IN SCROLL WINDOW.
   IF RTRN% > ENTRIES% THEN     ' ATTEMPT TO ADVANCE PAST END OF ENTRIES IN
     RK% = 19: GOTO DOWN        ' IN SCROLL WINDOW. SIMULATE DOWN ARROW.
   END IF

 CASE 27
   CALL PRINTINFO(" Enter Y to quit or N to continue.  Press ENTER to accept your choice.")
   ANS$ = "N"
   CALL GETANS("Quit! (Y/N) ", "YN", ANS$, 13, 100, 240, 15, 11)
   IF ANS$ = "Y" THEN CLOSE : CLS : END
   NOREFRESH% = 1
 END SELECT

GOTO MAKESCRL                  ' GO RE-ENTER SCROLL WINDOW

MOVE.TO.START:
   FOR X% = 1 TO ENTRIES% - 1
      WHILE INKEY$ <> "": WEND  ' NEED FOR SLOW MACHINES / LARGE ISAM TABLES
      MOVEPREVIOUS FILENUM%
   NEXT
   ONLAST% = 0
RETURN

'---------------------------------------------------------------------------
 ' READ RECORDS FROM THE FILE. READ UNTIL MAXIMUM NUMBER OF ENTRIES
 ' IN THE SCROLL WINDOWS ( ROWS% ) IS REACHED, OR UNTIL THE END
 ' OF FILE ( EOF(FILENUM%) ) IS REACHED.

GETRECORDS:
  SCROLLMARK$ = SPACE$(ROWS%)
  ENTRIES% = 0                                   ' ENTRIES IN SCROLL WINDOW.
  WHILE ENTRIES% < ROWS% AND NOT EOF(FILENUM%)
    ENTRIES% = ENTRIES% + 1                      ' INCREMENT ENTRIES.
    RETRIEVE FILENUM%, RECORD
    MID$(SCROLLMARK$, ENTRIES%) = RECORD.MARK
    MOVENEXT FILENUM%
    A$(ENTRIES%) = RECORD.NAM + RECORD.ADD1 + RECORD.CITY + RECORD.STATE + RECORD.ZIP
    WHILE INKEY$ <> "": WEND
  WEND
  MOVEPREVIOUS FILENUM%                      ' RESET FILE POSITION TO THE
  ONLAST% = 1                                ' LAST RECORD IN THE SCROLL
                                             ' WINDOW AND SET FLAG FOR SAME.
  SCROLLMARK$ = LEFT$(SCROLLMARK$, ENTRIES%) ' NEED IF ENTRIES% < ROWS%

RETURN
'----------------------------------------------------------------------------
COMPAREIT:
  COMPARE% = 1
  IF RECORD.MARK <> OLDRECORD.MARK THEN COMPARE% = 0
  IF RECORD.NAM <> OLDRECORD.NAM THEN COMPARE% = 0
  IF RECORD.ADD1 <> OLDRECORD.ADD1 THEN COMPARE% = 0
  IF RECORD.CITY <> OLDRECORD.CITY THEN COMPARE% = 0
  IF RECORD.STATE <> OLDRECORD.STATE THEN COMPARE% = 0
  IF RECORD.ZIP <> OLDRECORD.ZIP THEN COMPARE% = 0
RETURN

FOUNDRECORD:
  IF ENTRIES% = ROWS% THEN

    FOR X% = 1 TO RTRN% - 1             ' CHECK RECORDS
       MOVEPREVIOUS FILENUM%            ' BEFORE FOUND
       IF BOF(FILENUM%) THEN EXIT FOR   ' RECORD.
    NEXT

    IF BOF(FILENUM%) THEN         ' FOUND RECORD IN 1ST SCROLL WINDOW.
       MOVEFIRST FILENUM%         ' ADJUST SO 1ST RECORD = 1ST ENRTY IN
       GOSUB GETRECORDS           ' IN WINDOW.  ADJUST RTRN% TO POINT
       RTRN% = X%                 ' TO CORRECT ENTRY.
       RETURN
    END IF

    FOR X% = 1 TO RTRN% - 1      ' MOVE BACK TO "FOUND" RECORD
      MOVENEXT FILENUM%
    NEXT

    OFFSET% = 0
    FOR X% = 1 TO (ROWS%) - (RTRN% - 1)  ' IS THE "FOUND" RECORD ONE
       MOVENEXT FILENUM%                 ' OF THE LAST "ROWS%" OF
       IF EOF(FILENUM%) THEN EXIT FOR    ' RECORDS?
       OFFSET% = OFFSET% + 1
    NEXT

    IF EOF(FILENUM%) THEN                ' IT IS ONE OF THE LAST
       MOVELAST FILENUM%                 ' "ROWS%" OF RECORDS.
       FOR X% = 1 TO ROWS% - 1           ' FILL SCROLL WINDOW WITH
          MOVEPREVIOUS FILENUM%          ' LAST "ROWS%" OF RECORDS.
          WHILE INKEY$ <> "": WEND       ' CLEAR KEYBOARD.
       NEXT
       GOSUB GETRECORDS
       RTRN% = ROWS% - OFFSET%           ' ASJUST TO "FOUND" RECORD
       RETURN                            ' RE-ENTER SCROLL WINDOW
    END IF

    FOR X% = 1 TO ROWS%                  ' NOT 1ST "ROWS%" OF RECORDS
       MOVEPREVIOUS FILENUM%             ' OR LAST "ROWS%" OF RECORDS.
    NEXT
    GOSUB GETRECORDS

  ELSE                                    ' LESS ENTRIES THAN ROWS.
     FOR X% = 1 TO ROWS%                  ' FIND HOW MANY RECORDS ARE
        MOVEPREVIOUS FILENUM%             ' BEFORE THE "FOUND" RECORD.
        IF BOF(FILENUM%) THEN EXIT FOR
     NEXT
     MOVEFIRST FILENUM%
     RTRN% = X%                           ' ADJUST RTRN% TO NUMBER OF
     GOSUB GETRECORDS                     ' RECORDS BEFORE "FOUND" RECORD.
  END IF
RETURN

