'!!! ---------------------------------------------------------------------!!!
'!!!   NOTE: THIS MODULE MUST BE LOADED WITH DEMO.BAS AS THE MAIN MODULE  !!!
'!!! ---------------------------------------------------------------------!!!

'----------  MUST BE IN ANY MODULE USING "FINDDIR" DIRECTORY ROUTINE --------
TYPE DIREC
  SIZE AS LONG              ' SIZE
  DATE AS STRING * 10       ' DATE
  TIME AS STRING * 6        ' TIME
  ATTR AS INTEGER           ' ATTRIBUTE
END TYPE
COMMON SHARED /DIRECTORY/ DIREC$(), DIRINFO() AS DIREC
'----------------------------------------------------------------------------
DECLARE SUB B4INPT (INPTEXIT$, RESTRICT$)
DECLARE SUB B4SCRL (EXIT$, MARK$, TAGCOL%, NOREFRESH%)
DECLARE SUB BOXW (TR%, LC%, WD%, NR%, BORDER%)
DECLARE FUNCTION CHOICEBAR% (CHOICE$(), TR%, LC%, WD%, ATTR%, HATTR%, EXIT$)
DECLARE FUNCTION CHOICEWIND% (TITLE$, TX$(), CH$(), TR%, LC%, ATTR%, HCOL%, ESCEXIT%, BORDER%)
DECLARE SUB CHNGPULL (BAR%, WIND%, ATTR%)
DECLARE SUB CHNGWIND (W%)
DECLARE SUB CLRWIND ()
DECLARE SUB CUROFF ()
DECLARE SUB DELWIND (W%)
DECLARE SUB DISKSIZE (DISK%, DISKSZE&, FREESPACE&)
DECLARE SUB DOSOUND ()
DECLARE FUNCTION FINDPATH$ ()
DECLARE SUB FINDDIR (PATH$, TYPE$, F%)
DECLARE SUB GETANS (TEXT$, CHOICE$, ANS$, TR%, LC%, WATTR%, FATTR%, BORDER%)
DECLARE FUNCTION GETCUR& ()
DECLARE FUNCTION GETDISK% ()
DECLARE SUB INFOFIXED (FIXED$)
DECLARE SUB INFOLINE (TR%, LC%, WD%, ATTR%)
DECLARE SUB INPTINIT (DTYPE%, ISDOT%, STARTAT1%, NOBLANK%, SND%)
DECLARE SUB INPTWIND (PROMPT$, CODE$, TR%, LC%, WD%, WATTR%, FATTR%, RTRN$, RK%, BUT%, BRD%)
DECLARE FUNCTION GETAKEY% ()
DECLARE FUNCTION LBUTTON% ()
DECLARE SUB LINEW (ROW%, TYP%)
DECLARE SUB MAKEFIELD (SCRN%, FLD%, SCODE%, STR%, SLC%, SWD%, SBASEATTR%, SACTATTR%, MATTR%, RES$, EXTO$, HOT%, CURPOS%, BRACKET%)
DECLARE SUB MAKEWIND (W%, LABEL$, TR%, LC%, WD%, NR%, ATTR%, BORDER%)
DECLARE FUNCTION MARKED% (RTRN$, START%)
DECLARE FUNCTION MOUSECOL% ()
DECLARE SUB MOUSEINIT ()
DECLARE FUNCTION MOUSEINMULT% (MULTSCRN%)
DECLARE FUNCTION MOUSEINWIND% (WIND%)
DECLARE SUB MOUSELIMITS (TROW%, BROW%, LCOL%, RCOL%)
DECLARE FUNCTION MOUSEON% (ONFLAF%)
DECLARE SUB MOUSEPOS (ROW%, COL%)
DECLARE FUNCTION MOUSEROW% ()
DECLARE SUB MOUSESHOW ()
DECLARE SUB MULTINPT (SCRN%, TOFLD%, OPT$, FROMFLD%, RKEY%, RTRN$(), SELFLD%)
DECLARE SUB NEWCOLOR (ATTR%)
DECLARE FUNCTION PEEKASM& (S&, O&, BYVAL N%)
DECLARE SUB PRINTINFO (I$)
DECLARE SUB PRINTW (TEXT$, TR%, LC%)
DECLARE SUB PRINTWHOT (TEXT$, TR%, LC%, HOTCHAR%, ATTR%)
DECLARE SUB PULLDOWN (INFO$(), A%, B%, EXIT$, RKEY%, ATTR%, HATTR%, BORDER%)
DECLARE FUNCTION RBUTTON% ()
DECLARE SUB RESAVE ()
DECLARE SUB RSTRINFO (DELFLAG%)
DECLARE SUB RSTRINPT (DELFLAG%)
DECLARE SUB RSTRPULL (RSTRMBAR%)
DECLARE SUB RSTRWIND (W%, DELFLAG%)
DECLARE SUB SAVEWIND (W%, TR%, LC%, WD%, NR%)
DECLARE SUB SCRLWIND (LIST$(), INFO$(), TOPLINE$, ENTRIES%, RTRN$, RTRN%, LI%, FC%, RKEY%, HIATTR%, SCROLLBAR%, BUT%)
DECLARE SUB SETCUR (C&)
DECLARE SUB SETDISK (DRIVE%, BADFLAG%)
DECLARE SUB SETINPT (SCRN%, DISPLAYLEN%, EXIT$, HOTCOL%)
DECLARE SUB SETPULL (TR%, LC%, WD%, PWIND$())
DECLARE SUB SETWIND (FAST%, SND%, SHADCOL%, NOHIGH%, BRACKETATTR%)
DECLARE SUB UPDATEFIELD (SCRN%, FLD%, TEXT$)
DECLARE FUNCTION WAVAIL% (W%)
DECLARE SUB WINDSTATUS ()
'---------------------------------------------------------------------------
DECLARE FUNCTION COL% (A%)
DECLARE SUB PRINTFILEINFO ()
DECLARE FUNCTION FINDDRV% ()
DECLARE FUNCTION FINDSUB% ()
DECLARE FUNCTION FINDFILE% ()
DECLARE SUB MESSAGE (M%)


DIM SHARED PATH$, OLDPATH$, FOUNDFILE$, OLDDR%, MODE$, I$(0), SPEC$
DIM SHARED DISKERROR%, NUMFILES%, NUMSUBS%, LASTGOODPATH$, WASERR%
DIM SHARED FIL$(X%), SUBDIR$(X%)

DERROR:
  CALL MESSAGE(0)
  SELECT CASE ERR
    CASE 24, 57, 71, 72
      E$ = "DISK ERROR"
    CASE 52, 64, 75, 76
      E$ = "FILE SPEC ERROR"
    CASE ELSE
  END SELECT
  REDIM C$(2), T$(0)
  C$(1) = "Retry": C$(2) = "Abort"
  A% = COL%(31)
  X% = CHOICEWIND%("@        " + E$ + "        ", T$(), C$(), 7, 100, A%, 0, 0, 112)
  IF X% = 1 THEN CALL MESSAGE(1): RESUME
  DISKERROR% = 1: WASERR% = ERR: RESUME NEXT

SUB CHOICEDEMO
  A% = COL%(31): IF A% = 15 THEN A% = 112: B% = 127 ELSE B% = 28
  PRINTINFO " TAB to a selection and press ENTER or the SPACE BAR or use the MOUSE."
  REDIM C$(5), T$(10)
  FOR X% = 65 TO 69: C$(X% - 64) = CHR$(X%) + LCASE$(STRING$(5, X%)): NEXT
  T$(1) = " 1. One to ten choices are permitted."
  T$(2) = " 2. The windows width and length are automatically set."
  T$(3) = " 3. Hot characater selection is available."
  T$(4) = " 4. The area under the choice window is saved and restored on exit"
  T$(5) = " 5. Selection can be made via the keyboard or the MOUSE."
  T$(6) = " 6. Segmenting lines are permitted."
  T$(7) = "-"
  T$(9) = "@** Text can be automatically centered **"

  J% = CHOICEWIND%("@** Choice Window **", T$(), C$(), 100, 100, A%, B%, 1, 111)
  IF J% <> 27 THEN
    REDIM C$(1), T$(1)
    PRINTINFO " Select OK...."
    C$(1) = "OK": T$(1) = "@" + CHR$(J% + 64) + LCASE$(STRING$(5, J% + 64))
    J% = CHOICEWIND%("   Your choice was...   ", T$(), C$(), 100, 100, 112, 0, 1, 112)
  END IF
END SUB

FUNCTION FINDDRV% STATIC

'---------------------------------------------------------------------------
' look for drives only on first pass through this function

 IF PASS% = 0 THEN                           ' 1st pass only
   DR$ = SPACE$(26)                          ' room for 26 drive letters
   EQUIP& = PEEKASM&(64, 16, 2)              ' to see if B: is installed
   IF (EQUIP& AND 1) = 1 THEN
      IF 1 + (EQUIP& AND 192) / 64 = 1 THEN NOB% = 66 ' NOB%=66 if no B: drv
   END IF
   DRIVES% = 0                                 ' counter for number of drives
   FOR X% = 65 TO 90                           '
     IF X% <> NOB% THEN                        ' skip if X%=2 and NOB%=2
       CALL SETDISK(X% - 64, BAD%)             ' check for valid drive
       IF BAD% <> 1 THEN                       ' not valid - no more checks
          DRIVES% = DRIVES% + 1                ' increment drive counter
          MID$(DR$, DRIVES%, 1) = CHR$(X%)     ' place drive letter in DR$
       END IF
     END IF
   NEXT
   REDIM DRV$(DRIVES%)                          ' DIM to number of drives
   FOR X% = 1 TO DRIVES%
     DRV$(X%) = "[-" + MID$(DR$, X%, 1) + "-]"  ' make scroll window list
   NEXT
   CALL SETDISK(OLDDR%, B%)           ' make original default drive active
 END IF
'---------------------------------------------------------------------------
DO
  CHNGWIND 3                                    ' this scroll window active
  CALL B4SCRL("EOMCRT", "", 0, 0)               ' set exit keys
  CALL SCRLWIND(DRV$(), I$(), "", DRIVES%, MODE$, RTRN%, LI%, 1, RKEY%, 0, 1, 0)

  IF RKEY% = 13 THEN
     ' ENTER or double MOUSE click

    ' make selected drivv active
    CALL SETDISK(ASC(MID$(DRV$(RTRN%), 3, 1)) - 64, B%)

    ON ERROR GOTO DERROR                                 ' for FINDPATH$
    CALL MESSAGE(1)                                      ' reading message
    PATH$ = FINDPATH$                                    ' get drive path
    ON ERROR GOTO 0
    IF DISKERROR% = 1 THEN                               ' disk error
       DISKERROR% = 0: FINDDRV% = 100: EXIT FUNCTION     ' abort selected
    END IF
    IF PATH$ <> OLDPATH$ THEN
      ' new drive was selected so there is different path

      ON ERROR GOTO DERROR                               ' about to read disk
      DISKSIZE ASC(PATH$) - 64, DISKSZE&, FREESPACE&     ' get disk info
      ON ERROR GOTO 0
      IF DISKERROR% = 1 THEN                             ' disk error
         DISKERROR% = 0: FINDDRV% = 100: EXIT FUNCTION   ' abort selected
      END IF
      CHNGWIND 4                                         ' full screen window
      P$ = SPACE$(15): P1$ = P$
      LSET P$ = STR$(DISKSZE&)
      LSET P1$ = STR$(FREESPACE&)
      CALL PRINTW(P$, 17, 21)                            ' print disk bytes
      CALL PRINTW(P1$, 17, 61)                           ' print free bytes
      MODE$ = "NV"                     ' view - exit with scroll bar ereasd
      J% = FINDFILE%                   ' find the files
      J% = FINDSUB%                    ' find the sub directories
      MODE$ = "N"                      ' mode back to not view only
      CALL PRINTFILEINFO               ' erases any displayed file info
      OLDPATH$ = PATH$                 ' to check for future path changes
    END IF
    CALL MESSAGE(0)                    ' erase "reading" message
  END IF
LOOP WHILE RKEY% = 13

FINDDRV% = RKEY%                       ' "exit" key in FINDDRV%

END FUNCTION

FUNCTION FINDFILE% STATIC

RKEY% = 0                                ' no exit key
DO
  CHNGWIND 1                             ' make this the active window
  IF OLDPATH$ <> PATH$ THEN
     ' only if the path has changed

     FOUNDFILE$ = ""                     ' new path no selected file
     IF LEN(PATH$) = 3 THEN              ' must be A:\, B:\, C:\ ect.
        add$ = SPEC$                     ' add spec from File Spec: box
     ELSE                                ' must not be root
        add$ = "\" + SPEC$               ' add "\" + spec
     END IF
     ON ERROR GOTO DERROR
     CALL FINDDIR(PATH$ + add$, "AHSROL", NFIL%)   ' find all files
     ON ERROR GOTO 0
     IF DISKERROR% = 1 THEN              ' was a disk error
       PATH$ = LASTGOODPATH$             ' restore last good path
       DISKERROR% = 0: FINDFILE% = 100: EXIT FUNCTION   ' abort selected
     END IF
     FIL% = NFIL%                     ' FIL% = number of found files
     NUMFILES% = FIL%                 ' NUMFILES% shared with GETFILE
     NR% = 0                          ' tells B4SCRL refresh the scroll wind
     RTRN% = 1                        ' start on first file
     LI% = 1                          ' on line 1
     CLRWIND                          ' clear the scroll window
     REDIM FIL$(FIL%)                 ' make scroll window entries.
     FOR X% = 1 TO FIL%
      SWAP FIL$(X%), DIREC$(X%)       ' "       "
     NEXT
     ERASE DIREC$                     ' get the memory back
  ELSE                                ' no new path.
     NR% = 1                          ' tell B4SCRL no need to refresh wind
  END IF

  IF FIL% <> 0 THEN
    ' only if there are files

    ' set exit keys - determine if scroll window is refreshed. enter scroll wind
     CALL B4SCRL("OEMCRT", "", 0, NR%)
     CALL SCRLWIND(FIL$(), I$(), "", FIL%, MODE$, RTRN%, LI%, 1, RKEY%, 0, 1, 0)

     IF RKEY% = 13 THEN
       ' ENTER selected or double MOUSE click

       CALL PRINTFILEINFO                      ' erase last selected file info
       FOUNDFILE$ = FIL$(RTRN%)                ' new selected file
       CHNGWIND 4                              ' full screen window active
       P$ = SPACE$(12)
       P1$ = P$
       LSET P$ = FOUNDFILE$
       CALL PRINTW(P$, 5, 8)                   ' print file name
       LSET P1$ = STR$(DIRINFO(RTRN%).SIZE)
       CALL PRINTW(P1$, 5, 31)                 ' print file size
       CALL PRINTW(DIRINFO(RTRN%).DATE, 5, 50) ' print file date
       CALL PRINTW(DIRINFO(RTRN%).TIME, 5, 69) ' print file time
     END IF
  END IF
LOOP WHILE RKEY% = 13

FINDFILE% = RKEY%                               ' "exit" key in FINDFILE%

END FUNCTION

FUNCTION FINDSUB% STATIC

RKEY% = 0                                      ' no exit key
GOSUB GETSUBS                                  ' get any sub directories

DO
  CHNGWIND 2                                   ' make this window active
  IF NR% = 0 THEN CLRWIND                      ' clear it if to be refreshed
  IF SUBDIR% <> 0 THEN
     ' sub GETSUBS found some subs

     ' set exit keys and determine if window is to be refreshed - enter wind
     CALL B4SCRL("OEMCRT", "", 0, NR%)
     CALL SCRLWIND(SUBDIR$(), I$(), "", SUBDIR%, MODE$, RTRN%, LI%, 1, RKEY%, 0, 1, 0)

     IF RKEY% = 13 THEN
        ' ENTER selected or double MOUSE click

        IF SUBDIR$(RTRN%) = ".." THEN
          ' go "up" the dir tree

          DO
            PATH$ = LEFT$(PATH$, LEN(PATH$) - 1)
            IF LEN(PATH$) = 3 THEN EXIT DO
            IF RIGHT$(PATH$, 1) = "\" THEN
              PATH$ = LEFT$(PATH$, LEN(PATH$) - 1)
              EXIT DO
            END IF
          LOOP
        ELSE
          'add selected dir to existing to existing path

          IF LEN(PATH$) > 3 THEN add$ = "\" ELSE add$ = ""
          PATH$ = PATH$ + add$ + SUBDIR$(RTRN%)
        END IF
        CALL MESSAGE(1)           ' "reading" message
        GOSUB GETSUBS             ' find subs based on selection
        MODE$ = "NV"              ' call to FINDFILE% is view only
        J% = FINDFILE%            ' get the files for the new path
        CALL MESSAGE(0)           ' erase the message
        MODE$ = "N"               ' mode no longer view only
        CALL PRINTFILEINFO        ' erase any exiting file infp
        OLDPATH$ = PATH$
     END IF
  END IF
LOOP WHILE RKEY% = 13

FINDSUB% = RKEY%                  ' return with "exit" key in FINDSUB%

EXIT FUNCTION

'---------------------------------------------------------------------------
' get any sub directories

GETSUBS:
 IF PATH$ <> OLDPATH$ THEN
   ' only if the path has changed

   IF LEN(PATH$) = 3 THEN             ' must be A:\, B:\ etc...
     add$ = ""                        ' add nothing
   ELSE                               ' not the root
     add$ = "\*.*"                    ' add "\*.*"
   END IF
   ON ERROR GOTO DERROR
   CALL FINDDIR(PATH$ + add$, "D", F%)   ' find all dirs
   ON ERROR GOTO 0
   IF DISKERROR% = 1 THEN                ' was a disk error
      DISKERROR% = 0: FINDSUB% = 100     ' abort was selected
      PATH$ = OLDPATH$                   ' error, so restore the old path
      EXIT FUNCTION                      ' and get ot
   END IF
   LASTGOODPATH$ = PATH$                 ' save the path
   IF F% > 0 THEN
     ' dirs were found

     IF DIREC$(1) = "." THEN
        SUBDIR% = F% - 1: START% = 2     ' not using the root dir
     ELSE
        SUBDIR% = F%: START% = 1         ' path was changed to root dir
     END IF
     REDIM SUBDIR$(SUBDIR%)              ' to hold sub-directories
     Y% = 1
     FOR X% = START% TO F%
        SWAP SUBDIR$(Y%), DIREC$(X%)     ' put sub dirs in SUBDIR%()
        Y% = Y% + 1
     NEXT
     ERASE DIREC$                        ' get the memory back
   ELSE
     SUBDIR% = 0                         ' no sub dirs found
   END IF
   NUMSUBS% = SUBDIR%                    ' for GETFILE%
   NR% = 0                               ' tell B4SCRL to refresh wind
   RTRN% = 1                             ' start on first entry
 ELSE
   NR% = 1                               ' no new path - don't refresh wind
 END IF
RETURN

END FUNCTION

SUB GETFILE (P$, F$, RKEY%) STATIC

  WASERROR% = 0                          ' start no errors
  A% = COL%(31)                          ' color or b/w
  CALL MAKEWIND(4, "@[ Select a file ]", 1, 1, 80, 25, 112, 102)
  OLDDR% = GETDISK%                      ' save existing default drive
  ON ERROR GOTO DERROR
  PATH$ = FINDPATH$                      ' get existing path
  DISKSIZE OLDDR%, DISKSZE&, FREESPACE&  ' and existing disk size/ free space
  ON ERROR GOTO 0
  IF DISKERROR% = 1 THEN                 ' was a disk error
    DISKERROR% = 0                       ' abort was selected
    GOTO GETOUT
  END IF
  CALL PRINTW("DISK BYTES:" + STR$(DISKSZE&), 17, 10)   ' print disk bytes
  CALL PRINTW("FREE BYTES:" + STR$(FREESPACE&), 17, 50) ' print free bytes

  CALL PRINTW("Path:", 4, 2)             ' print in full screen window
  CALL PRINTW("File:", 5, 2)             ' "
  CALL PRINTW("Bytes:", 5, 25)           ' "
  CALL PRINTW("Date:", 5, 44)            ' "
  CALL PRINTW("Time:", 5, 63)            ' "
  CALL LINEW(18, 1)                      ' "
  CALL LINEW(20, 1)                      ' "
  '-------------------------------------------------------------------------
  ' make the three windows to be used as scroll windows

  CALL MAKEWIND(1, "@Files", 10, 10, 16, 9, A%, 101)
  CALL MAKEWIND(2, "@Directories", 10, 36, 16, 9, A%, 101)
  CALL MAKEWIND(3, "@Drives", 10, 61, 10, 9, A%, 101)

  '-------------------------------------------------------------------------
  ' print/update scroll windows -- print choicebar

  SPEC$ = "*.*"              ' start with all files
  GOSUB UPDATEALL            ' update scroll windows and choice bar
  WASERR% = 0
  '-------------------------------------------------------------------------
  LOOKIN% = 1                ' start in FILE SPEC: input window

  ' for info-line
  I$ = " Press ENTER of DOUBLE CLICK MOUSE to select.   Press tab to move."

DO
  SELECT CASE LOOKIN%

    CASE 1               ' file spec input window
      CALL PRINTINFO(" Enter a file spec. ( EX: *.BAS / *.DOC ).  ENTER accepts - TAB moves.")
      GOSUB GETSPEC
      IF RKEY% = 14 OR RKEY% = 15 THEN LOOKIN% = 2  ' TAB or SHIFT+TAB

    CASE 2               ' files scroll window
      INFOFIXED I$
      GOSUB GETFILES
      IF RKEY% = 15 OR RKEY% = 0 THEN LOOKIN% = 3   ' TAB "view" or no entries
      IF RKEY% = 14 THEN LOOKIN% = 1                ' SHIFT/TAB

    CASE 3               ' directory scroll window
      INFOFIXED I$
      GOSUB GETDIRS
      IF RKEY% = 15 OR RKEY% = 0 THEN LOOKIN% = 4   ' TAB "view" or no entries
      IF RKEY% = 14 THEN LOOKIN% = 2                ' SHIFT/TAB

    CASE 4               ' drives scroll window
      INFOFIXED I$
      GOSUB GETDRVS
      IF RKEY% = 15 OR RKEY% = 0 THEN LOOKIN% = 5   ' TAB "view" or no entries
      IF RKEY% = 14 THEN LOOKIN% = 3                ' SHIFT/TAB

    CASE 5               ' < OK >, < CANCEL > choicebar
      CALL PRINTINFO(" Select OK to accept or CANCEL to cancel.")
      GOSUB GETCHOICE
      IF RKEY% = 15 OR RKEY% = 0 THEN LOOKIN% = 1   ' TAB or "view"
      IF RKEY% = 14 THEN LOOKIN% = 4                ' SHIFT/TAB
  END SELECT

  INFOFIXED ""           ' erase infoline fixed string

  ' rkey% = 200 if left mouse button pressed out of window, field or choicebar.
  IF RKEY% = 200 THEN GOSUB PROCESSMOUSE

LOOP WHILE RKEY% <> 27 AND RKEY% <> 1  ' do until ESC, < CANCEL > or < OK >

SETDISK OLDDR%, J%                ' default drive back to original drive
GETOUT:
P$ = PATH$                        ' returned path
F$ = FOUNDFILE$                   ' returned file
CHNGWIND 4: LINEW 19, 0           ' erase < - OK - >, < CANCEL >
FOR X% = 1 TO 3: DELWIND X%: NEXT ' delete scroll windows from window mem.
CALL RSTRINPT(0)                  ' deactivate active input wind (FILE SPEC)
ERASE FIL$, SUBDIR$, DIRINFO
EXIT SUB

'---------------------------------------------------------------------------
GETDRVS:
  RKEY% = FINDDRV%             ' drive scroll window
RETURN
'---------------------------------------------------------------------------
GETDIRS:
  RKEY% = FINDSUB%             ' directory scroll window
RETURN
'---------------------------------------------------------------------------
GETFILES:
  RKEY% = FINDFILE%            ' files scroll window
RETURN
'---------------------------------------------------------------------------
' go to scroll window, choicebar or input window if left mouse button is
' pressed with mouse cursor in same.

PROCESSMOUSE:
  DO WHILE LBUTTON% = 1
   IF MOUSEINWIND%(1) > 0 AND NUMFILES% > 0 THEN LOOKIN% = 2: EXIT DO
   IF MOUSEINWIND%(2) > 0 AND NUMSUBS% > 0 THEN LOOKIN% = 3: EXIT DO
   IF MOUSEINWIND%(3) > 0 THEN LOOKIN% = 4: EXIT DO
   IF MOUSEINWIND%(21) > 0 THEN LOOKIN% = 1: EXIT DO
   IF MOUSEROW% = 22 THEN LOOKIN% = 5: EXIT DO
 LOOP
RETURN
'---------------------------------------------------------------------------
GETSPEC:
  OLDSPEC$ = SPEC$
  CALL B4INPT(EXIT$, "")
  CALL INPTWIND("File Spec: ", "A", 4, 100, 5, 112, 112, SPEC$, RKEY%, 0, 1)
  IF SPEC$ = "" THEN SPEC$ = "*.*"
  IF RKEY% <> 27 AND SPEC$ <> OLDSPEC$ THEN
     ' file spec has changed
     RR% = RKEY%                    ' save exit key
     GOSUB UPDATEALL                ' update all scroll windows
     RKEY% = RR%                    ' restore exit key
     IF WASERR% > 74 THEN SPEC$ = OLDSPEC$: WASERR% = 0
  END IF
RETURN
'---------------------------------------------------------------------------
GETCHOICE:
  REDIM C$(2): C$(1) = "- OK -": C$(2) = "CANCEL"
  RKEY% = CHOICEBAR%(C$(), 22, 15, 50, 112, 1, EXIT$)
  IF RKEY% = 2 THEN RKEY% = 27
RETURN
'---------------------------------------------------------------------------
UPDATEALL:
   EXIT$ = "VIEW"   ' view only for choice bar.  enter and exit to display
   GOSUB GETCHOICE
   CALL MESSAGE(1)
   MODE$ = "VN"     ' view scroll windows ( enter-exit ) no scroll bar on exit
   OLDPATH$ = ""    ' scroll windows update when OLDPATH$ <> PATH$
   GOSUB GETFILES
   IF WASERR% = 0 THEN
     GOSUB GETDIRS
     GOSUB GETDRVS
   END IF
   CALL MESSAGE(0)

  ' scroll windows/ choicebar/ input window will be active when entered.

   MODE$ = "N"        ' exit scroll windows with scroll bar erased.
   EXIT$ = "OTE"       ' mouse out of/ TAB / SHIFT TAB exit
                      ' CHOICEBAR and INPTWIND.

   CALL PRINTFILEINFO
   OLDPATH$ = PATH$   ' no scroll windows update if OLDPATH$ = PATH$

RETURN
'---------------------------------------------------------------------------

END SUB

SUB MESSAGE (M%)
  IF M% = 1 THEN
    CALL MAKEWIND(5, "", 4, 100, 50, 3, 15, 2)
    CALL PRINTW("Please wait.  Reading directory tree .....", 1, 100)
  ELSE
    RSTRWIND 5, 1
  END IF
END SUB

SUB PRINTFILEINFO
  ' print the path in the full screen window

  CALL CHNGWIND(4)                ' make full screen window active
  P$ = SPACE$(64)
  LSET P$ = PATH$
  CALL PRINTW(P$, 4, 8)           ' print the path in it
  IF OLDPATH$ <> PATH$ THEN       ' if it's a new path
    P$ = SPACE$(12)               ' erase all existing file info
    CALL PRINTW(P$, 5, 8)         ' " "
    CALL PRINTW(P$, 5, 32)        ' " "
    CALL PRINTW(P$, 5, 50)        ' " "
    CALL PRINTW(SPACE$(8), 5, 68) ' " "
  END IF
END SUB

