'**************************************************************************
'|    UIFILE.BAS
'|
'|    This module is a full featured file, drive and directory dialog
'|    box.  With the addition of the ERROR.BAS Module it is bullet
'|    proof addition to any project requiring file opening, saving
'|    and overwrites.
'|
'|
'|                           JORDAN/DENSKE SOFTWARE PUBLISHING-VERSION 1.00
'|                                     Serial Number UI_UIAQ3.47-920908-001
'**************************************************************************
	DEFINT A-Z
	REM $DYNAMIC
' Define all inclusion files.
	'$INCLUDE: 'ui.bi'
' Constants for button types.
	CONST YES = 1
	CONST NO = 2
	CONST OK = 1
	CONST CANCEL = 2
	CONST HELP = 3
	CONST SELECTED = 2
	CONST NOT.SELECTED = 1
	CONST COMMAND.BUTTON = 1
	CONST CHECK.BUTTON = 2
	CONST RADIO.BUTTON = 3
	CONST AREA.BUTTON = 4
	CONST VSCROLL.BUTTON = 6
	CONST HSCROLL.BUTTON = 7
	CONST BACK.COLOR = 3
' Set the Buffer size for the CopyFile procedure.
	CONST FILE.UPDATE = -2
	CONST FILE.WILDCARD = -3
' Set DTA and File structure arrays.
	TYPE DataTransferArea
		Reserved1   AS STRING * 21
		Attribute   AS STRING * 1
		FileTime    AS INTEGER
		FileDate    AS INTEGER
		FileSize    AS LONG
		FileName    AS STRING * 13
	END TYPE
	TYPE DirectoryRecord
		FileName    AS STRING * 13
		FileAttb    AS INTEGER
	END TYPE
' Global active variables.
	COMMON SHARED /jdprojs/ SaveDir           AS STRING
	COMMON SHARED /jdprojs/ FileNum           AS INTEGER
	COMMON SHARED /jdprojs/ DisplayType       AS INTEGER
	COMMON SHARED /jdprojs/ hfLOC             AS INTEGER
	COMMON SHARED /jdprojs/ hdLOC             AS INTEGER
	COMMON SHARED /uitools/ GloMenu           AS MenuMiscType
	COMMON SHARED /uitools/ GloTitle()        AS MenuTitleType
	COMMON SHARED /uitools/ GloItem()         AS MenuItemType
	COMMON SHARED /uitools/ GloWindow()       AS windowType
	COMMON SHARED /uitools/ GloButton()       AS buttonType
	COMMON SHARED /uitools/ GloEdit()         AS EditFieldType
	COMMON SHARED /uitools/ GloStorage        AS WindowStorageType
	COMMON SHARED /uitools/ GloWindowStack()  AS INTEGER
	COMMON SHARED /uitools/ GloBuffer$()
' Declare all Sub & Function calls.
	DECLARE FUNCTION GetFileCount% (FileSpec$)
	DECLARE FUNCTION ChangeDir% (PathChange$)
	DECLARE FUNCTION GetFirst% (attr%, FileName$, DEntry AS ANY)
	DECLARE FUNCTION GetNext% (DEntry AS ANY)
	DECLARE FUNCTION PageUp% (hCurTopPos%, hCurPosX%)
	DECLARE FUNCTION PageDown% (hCurTopPos%, hCurPosX%, hArray() AS STRING * 13)
	DECLARE FUNCTION ListUp% (hCurTopPos%, hCurPosX%)
	DECLARE FUNCTION ListDown% (hCurTopPos%, hCurPosX%, hArray() AS STRING * 13)
	DECLARE FUNCTION FileDialog$ (hType$, hFileList() AS STRING * 13, hGetDir() AS STRING * 13)
	DECLARE FUNCTION GetDir% (Prime%, hArray() AS STRING * 13)
	DECLARE FUNCTION IsValidFileName% (hType$, FileName$)
	DECLARE FUNCTION TestFileName% (hType$, FileName$)
	DECLARE FUNCTION ProcessFN$ (FileName$)
	DECLARE FUNCTION ParseFileName% (hPath$, hFileName$)
	DECLARE FUNCTION ErrorProcessor (a$)
	DECLARE FUNCTION OpenFile% (hType%, FileName$)
	DECLARE FUNCTION OpenFileHandler% (FileName$, FileType$, RecordLen%)
	DECLARE SUB About ()
	DECLARE SUB DrawDeskTop ()
	DECLARE SUB DisplayList (hType%, CurEDF%, hColLOC%, hCurTopPos%, hCurPosX%, hArray() AS STRING * 13)
	DECLARE SUB ShowList (hType%, CurBTN%, CurEDF%, hEntryFlag%, hLOC%, hCurTopPos%, hCurPosX%, hArray() AS STRING * 13)
	DECLARE SUB ListMove (scrollCode%, hEntryFlag%, hCurTopPos%, hCurPosX%, hArray() AS STRING * 13)
	DECLARE SUB ToggleList (CurBTN%, hCurTopPos%, hCurPosX%, hArray() AS STRING * 13)
	DECLARE SUB GetDrives ()
	DECLARE SUB GetFiles (hFileList() AS STRING * 13, FileSpec$)
	DECLARE SUB SetDataXFerArea (DTA AS ANY)
	DECLARE SUB TransferDTA2DIR (DEntry AS ANY)
	DECLARE SUB SortRecords (Array() AS STRING * 13)
' Dimension all arrays.
	DIM GloTitle(MAXMENU)            AS MenuTitleType
	DIM GloItem(MAXMENU, MAXITEM)    AS MenuItemType
	DIM GloWindow(MAXWINDOW)         AS windowType
	DIM GloButton(MAXBUTTON)         AS buttonType
	DIM GloEdit(MAXEDITFIELD)        AS EditFieldType
	DIM GloWindowStack(MAXWINDOW)    AS INTEGER
	DIM GloBuffer$(MAXWINDOW + 1, 2)
	DIM hFileList(1 TO 1)            AS STRING * 13
	DIM hGetDir(1 TO 1)              AS STRING * 13
	DIM SHARED hGetDrive(1 TO 1)     AS STRING * 13
	DIM DirArray(1 TO 1)             AS STRING * 13
	DIM SHARED InRegsX               AS RegTypeX
	DIM SHARED OutRegsX              AS RegTypeX
	DIM SHARED DTA                   AS DataTransferArea
	DIM SHARED DirEntry              AS DirectoryRecord
	DIM SHARED FileSpec              AS STRING
' Set the on error functions.
	ON ERROR GOTO ERRORHANDLER
' Initialize the program.
	WindowInit
	MouseShow
' Set Backdrop color and logo.
	CALL DrawDeskTop
' Save current directory or startup directory.
	SaveDir = CURDIR$
START:
' Now load the installed drives.
	CALL GetDrives
' Load the current Directory
	FileSpec = "*.*"
	CALL GetFiles(hFileList(), FileSpec)
	r = GetDir(TRUE, hGetDir())
	r = GetDir(FALSE, hGetDir())
' Show the file dialog box.
	hType$ = "File Open"
	a$ = UCASE$(FileDialog$(hType$, hFileList(), hGetDir()))
	IF a$ > "" THEN
		r = OpenFile(hType%, a$)
		IF r THEN GOTO START
	END IF
' End Program
	MouseHide
	COLOR 15, 0
	CLS
	END
ERRORHANDLER:
' Now call the error handling function.
	result = ErrorProcessor(a$)
	ERR = 0
	SELECT CASE result
		CASE 1
			' Ok button and message displayed.
				z = 0: DO: SOUND 987, 5: SOUND 329, 5: z = z + 1: LOOP UNTIL z = 3
				action = Alert(4, a$, 8, 25, 13, 55, "OK", "", "")
				CLOSE : ERR = 0: RESUME START
		CASE 2
			' Ok & Retry button and applicable message displayed.
				z = 0: DO: SOUND 987, 5: SOUND 329, 5: z = z + 1: LOOP UNTIL z = 3
				action = Alert(4, a$, 8, 25, 13, 55, "Abort", "Retry", "")
				IF action = 2 THEN CLOSE : RESUME NEXT
				CLOSE : ERR = 0: RESUME START
		CASE 3
		  ' Terminate message displayed and the program killed.
				z = 0: DO: SOUND 987, 5: SOUND 329, 5: z = z + 1: LOOP UNTIL z = 3
				action = Alert(4, a$, 8, 25, 13, 55, "OK", "", "")
				CLOSE : COLOR 7, 0: CLS
			' inform user of software problem.
				PRINT "There is an internal software error occuring. Please"
				PRINT "Contact  - Jordan/Denske Software for a solution."
				PRINT "Error is number " + STR$(ERR)
			' End with a error to DOS.
				END 1
		CASE 4
			' Ok button and applicable message displayed.
				z = 0: DO: SOUND 987, 5: SOUND 329, 5: z = z + 1: LOOP UNTIL z = 3
				action = Alert(4, a$, 8, 25, 13, 55, "Abort", "Retry", "")
				IF action = 2 THEN RESUME NEXT
				KillErr% = TRUE: CLOSE : RESUME
		CASE ELSE
		  ' Terminate message displayed and the program killed.
				z = 0: DO: SOUND 987, 5: SOUND 329, 5: z = z + 1: LOOP UNTIL z = 3
				action = Alert(4, a$, 8, 25, 13, 55, "OK", "", "")
				CLOSE : COLOR 7, 0: CLS
			' inform user of software problem.
				PRINT "There is an internal software error occuring. Please"
				PRINT "Contact  - Jordan/Denske Software for a solution."
				PRINT "Error is number " + STR$(ERR)
			' End with a error to DOS.
				END 1
	END SELECT

REM $STATIC
SUB About
			a$ = "File Dialog Demo for PDS 7.x|"
	 a$ = a$ + "|"
	 a$ = a$ + "Copyright Jordan/Denske Software v1.00|"
	 junk = Alert(4, a$, 9, 15, 13, 65, "", "", "")
END SUB

FUNCTION ChangeDir (PathChange$)
ON LOCAL ERROR RESUME NEXT
RETRY.DRIVE:
' Reset global error handler
	ERR = FALSE
' Retrieve the path change from user.
	 IF PathChange$ <> "" THEN
		IF INSTR(PathChange$, ":") THEN
			' Setup the drive change string.
				hDrive$ = MID$(PathChange$, 1, INSTR(PathChange$, ":"))
				CHDRIVE hDrive$
				DriveChange = TRUE
				CHDIR hDrive$ + "\"
				IF ERR THEN
					' Reset Err and return to orginal drive.
						a$ = hDrive$ + " drive not ready"
						r = Alert(4, a$, 10, 20, 12, 60, "Retry", "Cancel", "")
						IF r = YES THEN GOTO RETRY.DRIVE
						ERR = FALSE
						hDrive$ = MID$(SaveDir, 1, INSTR(SaveDir, ":"))
						CHDRIVE hDrive$
						EXIT FUNCTION
				END IF
			END IF
		' Now change to directory.
			CHDIR PathChange$
			IF ERR THEN
				' Reset Err and return to orginal drive.
					a$ = "Path Name is not valid"
					r = Alert(4, a$, 10, 20, 12, 60, "", "", "")
					hDrive$ = MID$(SaveDir, 1, INSTR(SaveDir, ":"))
					CHDRIVE hDrive$
					CHDIR SaveDir
					EXIT FUNCTION
			END IF
		 END IF
END FUNCTION

SUB DisplayList (hType%, CurEDF, hColLOC%, hCurTopPos%, hCurPosX%, hArray() AS STRING * 13)
' Now set the list elements.
	FOR x = hCurTopPos% TO hCurTopPos% + 8
		IF x <= UBOUND(hArray) THEN
			IF hCurTopPos% + hCurPosX% - 1 = x THEN
				WindowColor 7, 0
				IF hType% THEN
					EditFieldClose 1
					EditFieldOpen 1, RTRIM$(hArray(x)), 2, 13, 0, 0, 24, 40
					CurEDF = 0
				END IF
				Flag% = TRUE
			ELSE
				WindowColor 0, 7
			END IF
			WindowLocate x - hCurTopPos% + 8, hColLOC%
			WindowPrint -1, LEFT$(hArray(x) + STRING$(13 + 1, " "), 13 + 1)
			' The variable hLOC% marks the file element location highlighted.
				IF Flag THEN
					Flag = FALSE
					IF hColLOC% = 5 THEN
						hfLOC% = x
					ELSE
						hdLOC% = x
					END IF
				END IF
		ELSE
			WindowColor 0, 7
			WindowLocate x - hCurTopPos% + 8, hColLOC%
			WindowPrint -1, LEFT$(SPACE$(13) + STRING$(13 + 1, " "), 13 + 1)
		END IF
	 NEXT x
	 ' Retoggle the display color.
		WindowColor 0, 7
END SUB

SUB DrawDeskTop
	MouseHide
	WIDTH , 25
	COLOR 15, 1
	CLS
	LOCATE 22, 23
	PRINT "PDS 7.x File Dialog Demonstration"
	LOCATE 23, 18
	PRINT "(c) Jordan/Denske Software Publishing 1992"
	MouseShow
	DO: SOUND 440, 3: SOUND 560, 2: z = z + 1: LOOP UNTIL z = 2
	CALL About
END SUB

FUNCTION FileDialog$ (hType$, hFileList() AS STRING * 13, hGetDir() AS STRING * 13)
' Check global flag.
	IF LastDir$ <> CURDIR$ THEN                  ' Test the curdir$ on entry.
		CALL GetFiles(hFileList(), FileSpec)      ' Get the file in the dir$
		r = GetDir(FALSE, hGetDir())              ' if it changed in another
	END IF                                       ' area of the program.
' Set starting FILE variables to 1.
	hfCurTopPos% = 1: hfCurPosX% = 1
' Set starting DIRECTORY variables to 1.
	hdCurTopPos% = 1: hdCurPosX% = 1
' Set window header to hType$ which can be a Open, Save or Save As title bar.
	WindowOpen 1, 4, 21, 22, 59, 0, 7, 0, 7, 15, 0, 0, 0, TRUE, 1, hType$
	WindowLine 18
' Set up Command BUTTONs.
	ButtonOpen 6, 2, "OK", 19, 10, 0, 0, COMMAND.BUTTON
	ButtonOpen 7, 1, "Cancel", 19, 22, 0, 0, COMMAND.BUTTON
' Set up the directory list box.
	WindowBox 1, 12, 3, 37
	WindowBox 7, 3, 17, 19
	ButtonOpen 1, 1, "", 8, 19, 16, 20, VSCROLL.BUTTON
	ButtonOpen 2, 1, "", 8, 5, 16, 18, AREA.BUTTON
	WindowBox 7, 21, 17, 37
	ButtonOpen 3, 1, "", 8, 37, 16, 38, VSCROLL.BUTTON
	ButtonOpen 4, 1, "", 8, 2, 16, 36, AREA.BUTTON
' Set up the BUTTON to launch into scroll windows.
	WindowLocate 2, 2: WindowPrint 1, "File "
	WindowColor 15, 7
	WindowLocate 2, 7: WindowPrint 1, "N"
	WindowColor 0, 7
	WindowLocate 2, 8: WindowPrint 1, "ame:"
	WindowLocate 4, 2: WindowPrint 1, CURDIR$
	WindowColor 15, 7
	WindowLocate 6, 9: WindowPrint 1, "F"
	WindowColor 0, 7
	WindowLocate 6, 10: WindowPrint 1, "iles"
	WindowColor 15, 7
	WindowLocate 6, 24: WindowPrint 1, "D"
	WindowColor 0, 7
	WindowLocate 6, 25: WindowPrint 1, "irs/Drives"
' Open the edit field for the file spec.
	EditFieldOpen 1, FileSpec$, 2, 13, 0, 0, 24, 40
	CurBTN = 1
' Now display the file and directory list.
	CALL ShowList(FALSE, CurBTN, CurEDF, hfEntryFlag%, 5, hfCurTopPos%, hfCurPosX%, hFileList())
	CALL ShowList(FALSE, CurBTN, CurEDF, hdEntryFlag%, 23, hdCurTopPos%, hdCurPosX%, hGetDir())
	CurBTN = 0
	CurEDF = 1
	ExitFlag = FALSE
	WHILE NOT ExitFlag
	WindowDo CurBTN, CurEDF
	KEY.ACTIVE% = Dialog(0)                   ' Get the current dialog event.
	SELECT CASE KEY.ACTIVE%
		CASE 1
			CurBTN = Dialog(1)                  ' Get the current button active.
			SELECT CASE CurBTN
				CASE 1                           ' Click with the mouse into the
					scrollCode% = Dialog(19)      ' scroll bar on the files list.
					SELECT CASE scrollCode%
						CASE -1                    ' Upper arrow of scroll bar.
							r = PageUp(hfCurTopPos%, hfCurPosX%)
							IF r THEN
								CALL DisplayList(TRUE, CurEDF, 5, hfCurTopPos%, hfCurPosX%, hFileList())
								CALL ToggleList(CurBTN, hfCurTopPos%, hfCurPosX%, hFileList())
							END IF
						 CASE -2                   ' Lower arrow of scroll bar.
							 r = ListDown(hfCurTopPos%, hfCurPosX%, hFileList())
							 IF r THEN
								 CALL DisplayList(TRUE, CurEDF, 5, hfCurTopPos%, hfCurPosX%, hFileList())
								 CALL ToggleList(CurBTN, hfCurTopPos%, hfCurPosX%, hFileList())
							 END IF
						 CASE ELSE                 ' Grey area of scroll bar.
							 CALL ListMove(scrollCode%, hfEntryFlag, hfCurTopPos%, hfCurPosX%, hFileList())
							 CALL DisplayList(TRUE, CurEDF, 5, hfCurTopPos%, hfCurPosX%, hFileList())
							 CALL ToggleList(CurBTN, hfCurTopPos%, hfCurPosX%, hFileList())
					END SELECT
				CASE 2                           ' A click occurred in the files
					  IF hfTEST.CLICK = FALSE THEN   ' area button. Use a timer
						  hfCLICK1# = Now#            ' trick to simulate a dbl
						  hfTEST.CLICK = TRUE         ' click event.
					  ELSE
						  hfCLICK2# = Now#
						  IF hfCLICK1# = hfCLICK2# THEN
							  FileDialog$ = hFileList(hfCurTopPos% + hfCurPosX% - 1)
							  ExitFlag = TRUE
						  ELSE
							  hfTEST.CLICK = FALSE
						  END IF
					  END IF
					  GOSUB hfLIST.ASSIGN
				CASE 3
					  scrollCode% = Dialog(19)
					  SELECT CASE scrollCode%
							CASE -1
								  r = PageUp(hdCurTopPos%, hdCurPosX%)
								  IF r THEN
									  CALL DisplayList(FALSE, CurEDF, 23, hdCurTopPos%, hdCurPosX%, hGetDir())
									  CALL ToggleList(CurBTN, hdCurTopPos%, hdCurPosX%, hGetDir())
								  END IF
							CASE -2
								  r = ListDown(hdCurTopPos%, hdCurPosX%, hGetDir())
								  IF r THEN
									  CALL DisplayList(FALSE, CurEDF, 23, hdCurTopPos%, hdCurPosX%, hGetDir())
									  CALL ToggleList(CurBTN, hdCurTopPos%, hdCurPosX%, hGetDir())
								  END IF
							CASE ELSE
								  CALL ListMove(scrollCode%, hdEntryFlag, hdCurTopPos%, hdCurPosX%, hGetDir())
								  CALL DisplayList(FALSE, CurEDF, 23, hdCurTopPos%, hdCurPosX%, hGetDir())
								  CALL ToggleList(CurBTN, hdCurTopPos%, hdCurPosX%, hGetDir())
					  END SELECT
				CASE 4                           ' A click occurred in the Dirs
					  IF hdTEST.CLICK = FALSE THEN   ' area button. Use a timer
						  hdCLICK1# = Now#            ' trick to simulate a dbl
						  hdTEST.CLICK = TRUE         ' click event.
					  ELSE
						  hdCLICK2# = Now#
						  IF hdCLICK1# = hdCLICK2# THEN
							  IF INSTR(hGetDir(hdLOC), "[-") THEN
								  a$ = MID$(hGetDir(hdLOC), 3, 1)
								  PathChange$ = a$ + ":\"
								  r = ChangeDir(PathChange$)
							  ELSEIF INSTR(hGetDir(hdLOC), "..") THEN
								  CHDIR RTRIM$(hGetDir(hdLOC))
								  r = ParseFileName(discard$, FileSpec)
							  ELSE
								  IF NOT RIGHT$(CURDIR$, 1) = CHR$(92) THEN a$ = CHR$(92) ELSE a$ = ""
								  PathChange$ = CURDIR$ + a$ + RTRIM$(hGetDir(hdLOC))
								  r = ChangeDir(PathChange$)
							  END IF
							  CALL GetFiles(hFileList(), FileSpec)
							  r = GetDir(TRUE, hGetDir())
							  r = GetDir(FALSE, hGetDir())
							  CALL ShowList(TRUE, CurBTN, CurEDF, hfEntryFlag%, 5, hfCurTopPos%, hfCurPosX%, hFileList())
							  CALL ShowList(TRUE, CurBTN, CurEDF, hdEntryFlag%, 23, hdCurTopPos%, hdCurPosX%, hGetDir())
							  WindowLocate 4, 2: WindowPrint 1, SPACE$(40)
							  WindowLocate 4, 2: WindowPrint 1, CURDIR$
						  ELSE
							  hdTEST.CLICK = FALSE
						  END IF
					  END IF
					  GOSUB hdLIST.ASSIGN
				CASE 6
					  FileDialog$ = hFileList(hfCurTopPos% + hfCurPosX% - 1)
					  ExitFlag = TRUE
			  CASE 7
					  FileDialog$ = ""
					  ExitFlag = TRUE
		  END SELECT
	 CASE 6, 14
		  SELECT CASE CurBTN
			  CASE 0
				  a$ = EditFieldInquire(1)
				  r = IsValidFileName(hType$, (a$))
				  IF r = TRUE THEN
						FileDialog$ = a$
						ExitFlag = TRUE
				  ELSEIF r = FILE.UPDATE THEN
						IF a$ <> ".." THEN FileSpec = a$ ELSE FileSpec = "*.*"
						CALL GetFiles(hFileList(), FileSpec)
						r = GetDir(TRUE, hGetDir())
						r = GetDir(FALSE, hGetDir())
						CALL ShowList(TRUE, CurBTN, CurEDF, hfEntryFlag%, 5, hfCurTopPos%, hfCurPosX%, hFileList())
						CALL ShowList(FALSE, CurBTN, CurEDF, hdEntryFlag%, 23, hdCurTopPos%, hdCurPosX%, hGetDir())
						WindowLocate 4, 2: WindowPrint 1, SPACE$(40)
						WindowLocate 4, 2: WindowPrint 1, CURDIR$
				  ELSEIF r = FILE.WILDCARD THEN
						FileSpec = a$
						r = ParseFileName(discard$, FileSpec)
						CALL GetFiles(hFileList(), FileSpec)
						r = GetDir(TRUE, hGetDir())
						r = GetDir(FALSE, hGetDir())
						CALL ShowList(TRUE, CurBTN, CurEDF, hfEntryFlag%, 5, hfCurTopPos%, hfCurPosX%, hFileList())
						CALL ShowList(FALSE, CurBTN, CurEDF, hdEntryFlag%, 23, hdCurTopPos%, hdCurPosX%, hGetDir())
						WindowLocate 4, 2: WindowPrint 1, SPACE$(40)
						WindowLocate 4, 2: WindowPrint 1, CURDIR$
				  END IF
			  CASE 1, 2, 6
				  FileDialog$ = hFileList(hfCurTopPos% + hfCurPosX% - 1)
				  ExitFlag = TRUE
			  CASE 3, 4                              ' Change Directory.
				  IF INSTR(hGetDir(hdLOC), "[-") THEN
					  a$ = MID$(hGetDir(hdLOC), 3, 1)
					  PathChange$ = a$ + ":\"
					  r = ChangeDir(PathChange$)
				  ELSEIF INSTR(hGetDir(hdLOC), "..") THEN
					  CHDIR RTRIM$(hGetDir(hdLOC))
				  ELSE
					  IF NOT RIGHT$(CURDIR$, 1) = CHR$(92) THEN a$ = CHR$(92) ELSE a$ = ""
					  PathChange$ = CURDIR$ + a$ + RTRIM$(hGetDir(hdLOC))
					  r = ChangeDir(PathChange$)
				  END IF
				  CALL GetFiles(hFileList(), FileSpec)
				  r = GetDir(TRUE, hGetDir())
				  r = GetDir(FALSE, hGetDir())
				  CALL ShowList(TRUE, CurBTN, CurEDF, hfEntryFlag%, 5, hfCurTopPos%, hfCurPosX%, hFileList())
				  CALL ShowList(TRUE, CurBTN, CurEDF, hdEntryFlag%, 23, hdCurTopPos%, hdCurPosX%, hGetDir())
				  WindowLocate 4, 2: WindowPrint 1, SPACE$(40)
				  WindowLocate 4, 2: WindowPrint 1, CURDIR$
			  CASE 7
				  FileDialog$ = ""
				  ExitFlag = TRUE
			  CASE ELSE
		  END SELECT
	 CASE 7                                        ' (Tab Key.)
		  SELECT CASE CurBTN
				CASE 0
					 CurEDF = 0
					 CurBTN = 1
				CASE 1, 2
					 CurBTN = 3
				CASE 3, 4
					 CurBTN = 6
					 ButtonSetState CurBTN, 2
				CASE 6
					 ButtonToggle CurBTN
					 CurBTN = 7
					 ButtonSetState CurBTN, 2
				CASE 7
					 ButtonToggle CurBTN
					 CurBTN = 0
					 CurEDF = 1
					 ButtonSetState 6, 2
		  END SELECT
	 CASE 8
		  SELECT CASE CurBTN
				CASE 0
					 CurEDF = 0
					 CurBTN = 7
				CASE 1, 2
					 ButtonToggle CurBTN
					 CurBTN = 0
					 CurEDF = 1
					 ButtonToggle 6
				CASE 3, 4
					 ButtonToggle CurBTN
					 CurBTN = 1
					 ButtonToggle CurBTN
				CASE 6
					 ButtonToggle CurBTN
					 CurBTN = 3
					 ButtonToggle CurBTN
				CASE 7
					 ButtonToggle CurBTN
					 CurBTN = 6
					 ButtonToggle CurBTN
		  END SELECT
	 CASE 9
		  FileDialog$ = ""
		  ExitFlag = TRUE
	 CASE 10
		  SELECT CASE CurBTN
			  CASE 1, 2
				  r = ListUp(hfCurTopPos%, hfCurPosX%)
				  IF r THEN
					  CALL DisplayList(TRUE, CurEDF, 5, hfCurTopPos%, hfCurPosX%, hFileList())
					  CALL ToggleList(CurBTN, hfCurTopPos%, hfCurPosX%, hFileList())
				  END IF
			  CASE 3, 4
				  r = ListUp(hdCurTopPos%, hdCurPosX%)
				  IF r THEN
					  CALL DisplayList(FALSE, CurEDF, 23, hdCurTopPos%, hdCurPosX%, hGetDir())
					  CALL ToggleList(CurBTN, hdCurTopPos%, hdCurPosX%, hGetDir())
				  END IF
		  END SELECT
	 CASE 11
		  SELECT CASE CurBTN
			  CASE 1, 2
				  IF hfEntryFlag% THEN
					  r = ListDown(hfCurTopPos%, hfCurPosX%, hFileList())
					  IF r THEN
						  CALL DisplayList(TRUE, CurEDF, 5, hfCurTopPos%, hfCurPosX%, hFileList())
						  CALL ToggleList(CurBTN, hfCurTopPos%, hfCurPosX%, hFileList())
					  END IF
				  ELSE
					  CALL DisplayList(TRUE, CurEDF, 5, hfCurTopPos%, hfCurPosX%, hFileList())
					  CALL ToggleList(CurBTN, hfCurTopPos%, hfCurPosX%, hFileList())
					  hfEntryFlag% = TRUE
				  END IF
				  CALL ShowList(FALSE, FALSE, FALSE, hdEntryFlag%, 23, hdCurTopPos%, hdCurPosX%, hGetDir())
			  CASE 3, 4
				  IF hdEntryFlag% THEN
					  r = ListDown(hdCurTopPos%, hdCurPosX%, hGetDir())
					  IF r THEN
						  CALL DisplayList(FALSE, CurEDF, 23, hdCurTopPos%, hdCurPosX%, hGetDir())
						  CALL ToggleList(CurBTN, hdCurTopPos%, hdCurPosX%, hGetDir())
					  END IF
				  ELSE
					  CALL DisplayList(FALSE, CurEDF, 23, hdCurTopPos%, hdCurPosX%, hGetDir())
					  CALL ToggleList(CurBTN, hdCurTopPos%, hdCurPosX%, hGetDir())
					  hdEntryFlag% = TRUE
				  END IF
				  CALL ShowList(TRUE, FALSE, FALSE, hfEntryFlag%, 5, hfCurTopPos%, hfCurPosX%, hFileList())
		  END SELECT
	 CASE 16
		  scrollCode% = 1
		  SELECT CASE CurBTN
			  CASE 1, 2
				  CALL ListMove(scrollCode%, hfEntryFlag%, hfCurTopPos%, hfCurPosX%, hFileList())
				  CALL DisplayList(TRUE, CurEDF, 5, hfCurTopPos%, hfCurPosX%, hFileList())
				  CALL ToggleList(CurBTN, hfCurTopPos%, hfCurPosX%, hFileList())
			  CASE 3, 4
				  CALL ListMove(scrollCode%, hdEntryFlag%, hdCurTopPos%, hdCurPosX%, hGetDir())
				  CALL DisplayList(FALSE, CurEDF, 23, hdCurTopPos%, hdCurPosX%, hGetDir())
				  CALL ToggleList(CurBTN, hdCurTopPos%, hdCurPosX%, hGetDir())
		  END SELECT
	 CASE 17
		  scrollCode% = 10
		  SELECT CASE CurBTN
			  CASE 1, 2
				  CALL ListMove(scrollCode%, FALSE, hfCurTopPos%, hfCurPosX%, hFileList())
				  CALL DisplayList(TRUE, CurEDF, 5, hfCurTopPos%, hfCurPosX%, hFileList())
				  CALL ToggleList(CurBTN, FALSE, hfCurPosX%, hFileList())
			  CASE 3, 4
				  CALL ListMove(scrollCode%, FALSE, hdCurTopPos%, hdCurPosX%, hGetDir())
				  CALL DisplayList(FALSE, CurEDF, 23, hdCurTopPos%, hdCurPosX%, hGetDir())
				  CALL ToggleList(CurBTN, hdCurTopPos%, hdCurPosX%, hGetDir())
		  END SELECT
	  CASE 18
		  SELECT CASE CurBTN
			  CASE 1, 2
				  r = PageUp(hfCurTopPos%, hfCurPosX%)
				  IF r THEN
					  CALL DisplayList(TRUE, CurEDF, 5, hfCurTopPos%, hfCurPosX%, hFileList())
					  CALL ToggleList(CurBTN, hfCurTopPos%, hfCurPosX%, hFileList())
				  END IF
			  CASE 3, 4
				  r = PageUp(hdCurTopPos%, hdCurPosX%)
				  IF r THEN
					  CALL DisplayList(FALSE, CurEDF, 23, hdCurTopPos%, hdCurPosX%, hGetDir())
					  CALL ToggleList(CurBTN, hdCurTopPos%, hdCurPosX%, hGetDir())
				  END IF
			  END SELECT
	  CASE 19
		  SELECT CASE CurBTN
			  CASE 1, 2
				  r = PageDown(hfCurTopPos%, hfCurPosX%, hFileList())
				  IF r THEN
					  CALL DisplayList(TRUE, CurEDF, 5, hfCurTopPos%, hfCurPosX%, hFileList())
					  CALL ToggleList(CurBTN, hfCurTopPos%, hfCurPosX%, hFileList())
				  END IF
			  CASE 3, 4
				  r = PageDown(hdCurTopPos%, hdCurPosX%, hGetDir())
				  IF r THEN
					  CALL DisplayList(FALSE, CurEDF, 23, hdCurTopPos%, hdCurPosX%, hGetDir())
					  CALL ToggleList(CurBTN, hdCurTopPos%, hdCurPosX%, hGetDir())
				  END IF
		  END SELECT
	END SELECT
	WEND
' Hey we otta here...
	WindowClose 1
	EXIT FUNCTION
hfLIST.ASSIGN:
	 hfCurPosX% = Dialog(17)
	 IF hfCurPosX% > UBOUND(hFileList) THEN hfCurPosX% = UBOUND(hFileList)
	 CALL DisplayList(TRUE, CurEDF, 5, hfCurTopPos%, hfCurPosX%, hFileList())
	 CALL ToggleList(CurBTN, hfCurTopPos%, hfCurPosX%, hFileList())
	 RETURN
hdLIST.ASSIGN:
	 hdCurPosX% = Dialog(17)
	 IF hdCurPosX% > UBOUND(hGetDir) THEN hdCurPosX% = UBOUND(hGetDir)
	 CALL DisplayList(FALSE, CurEDF, 23, hdCurTopPos%, hdCurPosX%, hGetDir())
	 CALL ToggleList(CurBTN, hdCurTopPos%, hdCurPosX%, hGetDir())
	 RETURN
END FUNCTION

FUNCTION GetDir (Prime%, hArray() AS STRING * 13)
' Set up the hArray() and preserve current contents.
	IF LEN(CURDIR$) = 3 THEN x = FALSE ELSE x = 1: hArray(x) = ".."
' Set Attribute for retrival to 16 for a directory entry.
	Attb = 16
	FindStatus = GetFirst(Attb, "*.*", DirEntry)
' Do While directorys/files are present.
	WHILE FindStatus = 0
		IF DirEntry.FileAttb = Attb THEN
			IF INSTR(MID$(DirEntry.FileName, 1, 1), ".") = FALSE AND NOT Prime% THEN
				' Increament hArray() counter.
					x = x + 1
				' Set up the hArray() and preserve current contents.
					REDIM PRESERVE hArray(1 TO x) AS STRING * 13
				' Swap variables.
					hArray(x) = DirEntry.FileName
				' Set a flag to indicate that directories were found.
					Flag% = TRUE
			END IF
		END IF
		FindStatus = GetNext(DirEntry)
		CALL SetDataXFerArea(DTA)
	WEND
' Test for startup condition.
	IF Prime% THEN EXIT FUNCTION
' Now if no directories were found in current directory then test flags
' and redimension array to 1 element.
	IF Flag% = FALSE THEN REDIM PRESERVE hArray(1 TO 1) AS STRING * 13
' Attach the drives to the array
	IF UBOUND(hArray) > 1 THEN
		FOR x = (UBOUND(hArray) + 1) TO UBOUND(hArray) + UBOUND(hGetDrive)
			y = y + 1
			REDIM PRESERVE hArray(1 TO x) AS STRING * 13
			hArray(x) = hGetDrive(y)
		NEXT
	ELSEIF UBOUND(hArray) = 1 AND INSTR(hArray(1), "..") THEN
		FOR x = (UBOUND(hArray) + 1) TO UBOUND(hArray) + UBOUND(hGetDrive)
			y = y + 1
			REDIM PRESERVE hArray(1 TO x) AS STRING * 13
			hArray(x) = hGetDrive(y)
		NEXT
	ELSE
		FOR x = UBOUND(hArray) TO UBOUND(hGetDrive)
			y = y + 1
			REDIM PRESERVE hArray(1 TO x) AS STRING * 13
			hArray(x) = hGetDrive(y)
		NEXT
	END IF
' Now sort the directories into alphabetical order.
	CALL SortRecords(hArray())
END FUNCTION

SUB GetDrives
ON LOCAL ERROR GOTO DRIVE.ERROR
' Do to find all available drives.
	FOR FindDrive = 65 TO 90
		IsDrive = TRUE
		CHDRIVE CHR$(FindDrive)
		IF IsDrive THEN
			' Increament hGetDrive counter.
				x = x + 1
			' Set up the hGetDrive and preserve current contents.
				REDIM PRESERVE hGetDrive(1 TO x) AS STRING * 13
			' Swap variables.
				FoundDrive$ = "[-" + CHR$(FindDrive) + "-]"
				SWAP hGetDrive(x), FoundDrive$
		END IF
	NEXT FindDrive
	hDrive$ = MID$(SaveDir, 1, INSTR(SaveDir, ":"))
	CHDRIVE hDrive$
	EXIT SUB
DRIVE.ERROR:
	IsDrive = FALSE
	RESUME NEXT
END SUB

FUNCTION GetFileCount (FileSpec$)
	 count = 0
	 FileName$ = DIR$(FileSpec$)
	 DO WHILE FileName$ <> ""
		  count = count + 1
		  FileName$ = DIR$
	 LOOP
	 GetFileCount = count
END FUNCTION

SUB GetFiles (hFileList() AS STRING * 13, FileSpec$)
' Set global flag.
	LastDir$ = CURDIR$
' Make sure its a valid file name
	 Delimiter = INSTR(FileSpec$, ".")
	 IF Delimiter THEN
		 FileName$ = LEFT$(FileSpec$, Delimiter - 1)
		 fileExt$ = RIGHT$(FileSpec$, LEN(FileSpec$) - (Delimiter))
	 ELSE
		 FileName$ = FileSpec$
		 fileExt$ = ""
	 END IF
 ' Get the file in the current directory.
	FILE.REC.LEN% = GetFileCount(FileSpec$)
 ' Get outta routine if a bust.
	IF FILE.REC.LEN% = FALSE THEN
		REDIM hFileList(FALSE TO FALSE) AS STRING * 13
		EXIT SUB
	END IF
 ' Otherwise redimension array.
	IF FILE.REC.LEN% THEN
		REDIM hFileList(1 TO FILE.REC.LEN%) AS STRING * 13
	END IF
' Now load the dimensioned array.
	hFileList(1) = DIR$(FileSpec$)
	FOR Indx = 2 TO FILE.REC.LEN%
		 hFileList(Indx) = DIR$
	NEXT Indx
' Now sort the files into alphabetical order.
	CALL SortRecords(hFileList())
END SUB

FUNCTION GetFirst (attr, FileName$, DEntry AS DirectoryRecord)
	InRegsX.ax = &H4E00
	InRegsX.cx = attr
' DOS requires an ASCIIZ string so add CHR$(0)
	Spec$ = FileName$ + CHR$(0)
	InRegsX.ds = SSEG(Spec$)                        ' Load DS:DX with
	InRegsX.dx = SADD(Spec$)                        ' address of Spec$
	CALL InterruptX(&H21, InRegsX, OutRegsX)
' The next line sets an error as default condition
	GetFirst = OutRegsX.ax
' Check if carry flag is clear in the next line
	IF (OutRegsX.flags AND 1) = 0 THEN
		CALL TransferDTA2DIR(DEntry)
		GetFirst = 0               'Clear error condition setting
	END IF
END FUNCTION

FUNCTION GetNext (DEntry AS DirectoryRecord)
	DTA.FileName = SPACE$(13)
	InRegsX.ax = &H4F00
	CALL InterruptX(&H21, InRegsX, OutRegsX)
	GetNext = OutRegsX.ax
	IF (OutRegsX.flags AND 1) = 0 THEN
		CALL TransferDTA2DIR(DEntry)
		GetNext = 0
	END IF
END FUNCTION

FUNCTION IsValidFileName (hType$, FileName$)
' Dimension some local variables for the testing of files.
	DIM index AS INTEGER
	DIM NewDir AS STRING
' On errors continue with local trapping.
	ON LOCAL ERROR RESUME NEXT
' Upercase the passed file name.
	FileName$ = UCASE$(FileName$)
' Test the passed filename.
	IF MID$(FileName$, 2, 1) = ":" THEN       ' Does it specify new drive?
		hDrive$ = MID$(FileName$, 1, 1) + ":"
		FOR x = 1 TO UBOUND(hGetDrive)
			a$ = MID$(hGetDrive(x), 3, 1) + ":"
			IF hDrive$ = a$ THEN
				ValidDrive = TRUE
				EXIT FOR
			END IF
		NEXT
RETRY.ISDRIVE:
		' Based upon the installed drive test, check to verify that the
		' drive name is at least valid.
			IF ValidDrive THEN
				CHDRIVE hDrive$
				CHDIR hDrive$ + "\"
				IF ERR THEN
					' Reset Err and return to orginal drive.
						a$ = hDrive$ + " drive not ready"
						r = Alert(4, a$, 10, 20, 12, 60, "Retry", "Cancel", "")
						IF r = YES THEN GOTO RETRY.ISDRIVE
						ERR = FALSE
						hDrive$ = MID$(SaveDir, 1, INSTR(SaveDir, ":"))
						CHDRIVE hDrive$
						IsValidFileName = FALSE
						EXIT FUNCTION
				END IF
			ELSE
				a$ = hDrive$ + " drive does not exist!|"
				r = Alert(4, a$, 10, 20, 12, 60, "", "", "")
				IsValidFileName = FALSE
				EXIT FUNCTION
			END IF
		' Other wise assume drive exists, now trap for a not ready
		' disk drive error.
			IF ERR THEN
				' Reset Err and return to orginal drive.
					a$ = hDrive$ + " drive not ready"
					r = Alert(4, a$, 10, 20, 12, 60, "Retry", "Cancel", "")
					IF r = YES THEN GOTO RETRY.ISDRIVE
					ERR = FALSE
					hDrive$ = MID$(SaveDir, 1, INSTR(SaveDir, ":"))
					CHDRIVE hDrive$
					EXIT FUNCTION
			END IF
	END IF
' Now test the directory condition if included in the passed
' filename, verify that its valid
	 CHDIR FileName$
	 IF ERR THEN                     'Separate path/filename, try again
		  r = ParseFileName(NewDir, FileName$)
		  IF NewDir <> "" THEN
				IF LEN(NewDir) > 1 THEN NewDir = LEFT$(NewDir, LEN(NewDir) - 1)'Remove ending "\"
				ERR = 0
				CHDIR (NewDir)
				IF ERR THEN
					a$ = "Invalid path: '" + NewDir + "'|"
					r = Alert(4, a$, 10, 20, 12, 60, "", "", "")
					IsValidFileName = FALSE
				ELSE
					 IF TestFileName(hType$, FileName$) THEN
						IF INSTR(FileName$, "*") OR INSTR(FileName$, "?") THEN
							IsValidFileName = FILE.WILDCARD
						ELSE
							IsValidFileName = TRUE
						END IF
					 ELSE
						  IF (INSTR(FileName$, "*") = 0) AND (INSTR(FileName$, "?") = 0) THEN
								CHDRIVE (SaveDir)
								CHDIR (SaveDir)
						  ELSE
								IsValidFileName = FILE.UPDATE
						  END IF
					 END IF
				END IF
		  ELSE
				IF FileName$ <> ".." THEN
					IsValidFileName = TestFileName(hType$, FileName$)
				ELSE
					IsValidFileName = FILE.UPDATE
				END IF
		  END IF
	 ELSE
		  'User specified a new, valid dir; update the file controls
				IsValidFileName = FILE.UPDATE
	 END IF
END FUNCTION

FUNCTION ListDown (hCurTopPos%, hCurPosX%, hArray() AS STRING * 13)
' Test the record elements active.
	oldRec = hCurTopPos% + hCurPosX% - 1
	IF UBOUND(hArray) > 9 THEN
		 hCurPosX% = hCurPosX% + 1
		 IF hCurPosX% > 9 THEN
			  hCurPosX% = 9
			  hCurTopPos% = hCurTopPos% + 1
			  IF hCurTopPos% + hCurPosX% - 1 > UBOUND(hArray) THEN
					hCurTopPos% = hCurTopPos% - 1
			  END IF
		 END IF
	ELSE
		 IF hCurPosX% + 1 <= UBOUND(hArray) THEN
			  hCurPosX% = hCurPosX% + 1
		 END IF
	END IF
	newRec = hCurTopPos% + hCurPosX% - 1
	IF oldRec <> newRec THEN ListDown = TRUE
END FUNCTION

SUB ListMove (scrollCode%, hEntryFlag%, hCurTopPos%, hCurPosX%, hArray() AS STRING * 13)
' This routine responds to the mouse events on the buttons.
	SELECT CASE scrollCode%
		 CASE 1:      newPos = 1
		 CASE 2 TO 9: newPos = scrollCode% * UBOUND(hArray) / 7
		 CASE 10:     newPos = UBOUND(hArray)
	END SELECT
	IF newPos < 1 THEN newPos = 1
	IF newPos > UBOUND(hArray) THEN newPos = UBOUND(hArray)
	hCurPosX% = newPos - hCurTopPos% + 1
	IF hCurPosX% <= 0 THEN
		 hCurTopPos% = newPos
		 hCurPosX% = 1
	ELSEIF hCurPosX% > 9 THEN
		 hCurPosX% = 9
		 hCurTopPos% = newPos - 8
	END IF
' Reset entry flag for down arrow.
	IF hCurPosX% = 1 THEN hEntryFlag% = FALSE
END SUB

FUNCTION ListUp (hCurTopPos%, hCurPosX%)
	oldRec = hCurTopPos% + hCurPosX% - 1
	hCurPosX% = hCurPosX% - 1
	IF hCurPosX% < 1 THEN
		 hCurPosX% = 1
		 hCurTopPos% = hCurTopPos% - 1
		 IF hCurTopPos% < 1 THEN
			  hCurTopPos% = 1
		 END IF
	END IF
	newRec = hCurTopPos% + hCurPosX% - 1
	IF oldRec <> newRec THEN ListUp = TRUE
END FUNCTION

FUNCTION OpenFile (hType%, FileName$)
ON LOCAL ERROR RESUME NEXT
'Open the file:
	FileType$ = "i"
	Num% = OpenFileHandler(FileName$, FileType$, RecordLen)
	IF Num% = 0 THEN OpenFile = FALSE: EXIT FUNCTION
' All of the files created by the GSTCHK Processing program,  add this
' header to the first part of the file. I use this to identify my record
' structures.  Elminate this section of the code to open your files.
	Header$ = CHR$(1) + CHR$(2) + CHR$(3) + CHR$(4) + CHR$(5)
' Calculate number of records in the file:
	INPUT #Num%, ID$
		IF ID$ <> Header$ OR ERR THEN
			SOUND 587, 2: SOUND 829, 2: SOUND 587, 2
			IF ERR THEN
				' Prompt user that file generated an error.
					a$ = "The chosen file " + RTRIM$(FileName$) + ",|"
					a$ = a$ + "generated error #" + LTRIM$(RTRIM$(STR$(ERR))) + "|"
					x = Alert(4, a$, 10, 25, 13, 55, "OK", "", "")
					ERR = FALSE
			ELSE
				' Prompt user that record is not a valid file.
					a$ = "The chosen file " + RTRIM$(FileName$) + ",|"
					a$ = a$ + "is not a valid file format!|"
					r = Alert(4, a$, 10, 25, 13, 55, "Retry", "End", "")
					IF r = YES THEN OpenFile = TRUE: EXIT FUNCTION
			END IF
			OpenFile = FALSE
			EXIT FUNCTION
		END IF
	OpenFile = TRUE
	CLOSE Num%
END FUNCTION

FUNCTION OpenFileHandler (FileName$, FileType$, RecordLen)
' Return on error.
	ON ERROR GOTO ERRORHANDLER
 ' Get the first free file #
	OpenFileNum = FREEFILE
	SELECT CASE UCASE$(FileType$)
		' Open for Seq Input
			CASE "I"
				OPEN FileName$ FOR INPUT AS OpenFileNum
		' Open for Seq Output
			CASE "O"
				OPEN FileName$ FOR OUTPUT AS OpenFileNum
		' Open for Seq Append
			CASE "A"
				OPEN FileName$ FOR APPEND AS OpenFileNum
		' Open for Binary Access
			CASE "B"
				OPEN FileName$ FOR BINARY AS OpenFileNum
		' Open for Random Access
			CASE "R"
				OPEN FileName$ FOR RANDOM AS OpenFileNum LEN = RecordLen
			CASE ELSE
				EXIT FUNCTION
	END SELECT
	' Now test and pass back a fail/success
		IF ErrValue% THEN
			OpenFileHandler = 0
			' Reset the Global Err Value.
				ErrValue% = 0
		ELSE
			OpenFileHandler = OpenFileNum
		END IF
END FUNCTION

FUNCTION PageDown (hCurTopPos%, hCurPosX%, hArray() AS STRING * 13)
' Move the list down by 8 to bottom of passed array.
	oldRec = hCurTopPos% + hCurPosX% - 1
	IF UBOUND(hArray) > 8 THEN
		 hCurTopPos% = hCurTopPos% + 8
		 IF hCurTopPos% + 8 > UBOUND(hArray) THEN
			  hCurTopPos% = UBOUND(hArray) - 7
			  hCurPosX% = 8
		 END IF
	ELSE
		 hCurPosX% = UBOUND(hArray)
	END IF
	newRec = hCurTopPos% + hCurPosX% - 1
	IF oldRec <> newRec THEN PageDown = TRUE
END FUNCTION

FUNCTION PageUp (hCurTopPos%, hCurPosX%)
' Set the list up by 8.
	oldRec = hCurTopPos% + hCurPosX% - 1
	hCurTopPos% = hCurTopPos% - 8
	IF hCurTopPos% < 1 THEN
		 hCurTopPos% = 1
		 hCurPosX% = 1
	END IF
	newRec = hCurTopPos% + hCurPosX% - 1
	IF oldRec <> newRec THEN PageUp = TRUE
END FUNCTION

FUNCTION ParseFileName (hPath$, hFileName$)
	WHILE INSTR(hFileName$, "\")      'Parse any directory info
	 'NewDir gets text to the left of & including FileName$'s first "\"
		 hPath$ = hPath$ + LEFT$(hFileName$, INSTR(hFileName$, "\"))
	 'FileName$ becomes the text to the right of the first "\"
		 hFileName$ = RIGHT$(hFileName$, LEN(hFileName$) - INSTR(hFileName$, "\"))
	WEND
END FUNCTION

SUB SetDataXFerArea (DTA AS DataTransferArea)
	InRegsX.ax = &H1A00
	InRegsX.ds = VARSEG(DTA)
	InRegsX.dx = VARPTR(DTA)
	CALL InterruptX(&H21, InRegsX, OutRegsX)
END SUB

SUB ShowList (hType%, CurBTN, CurEDF, hEntryFlag%, hLOC%, hCurTopPos%, hCurPosX%, hArray() AS STRING * 13)
' Display the file list with out a shadow toggle after a change directory
' operation or drive change.
	FOR x = 1 TO UBOUND(hArray)
		WindowLocate x + 7, hLOC%
		WindowPrint -1, LEFT$(hArray(x) + STRING$(13 + 1, " "), 13 + 1)
		IF x > 8 THEN EXIT FOR
	NEXT
' Now test for a short list and fill blanks.
	IF x < 9 THEN
		FOR y = x TO 9
			WindowLocate y + 7, hLOC%
			WindowPrint -1, LEFT$(SPACE$(13) + STRING$(13 + 1, " "), 13 + 1)
		NEXT
	END IF
' Now reset buttons and edit fields and positions.
	CurBTN = FALSE: CurEDF = 1: hCurTopPos% = 1: hCurPosX% = 1
	hEntryFlag% = FALSE
' Reset the contents of the edit field box.
	IF hType% THEN
		EditFieldClose 1
		EditFieldOpen 1, FileSpec, 2, 13, 0, 0, 24, 40
		ButtonSetState 1, 1
	ELSE
		ButtonSetState 3, 1
	END IF
END SUB

SUB SortRecords (Array() AS STRING * 13)
' QuickSort Routine
	Offset = UBOUND(Array) / 2
' Loop until offset gets to zero
	DO WHILE Offset > 0
		Limit = UBOUND(Array) - Offset
		DO
			Switch = FALSE
			' Compare elements and switch ones out of order
				FOR i = 1 TO Limit
					IF Array(i) > Array(i + Offset) THEN
						SWAP Array(i), Array(i + Offset)
					END IF
				NEXT i
			Limit = Switch
		LOOP WHILE Switch
		' No switches at last offset, try one half as big
			Offset = Offset / 2
	LOOP
END SUB

FUNCTION TestFileName (hType$, FileName$)
' Set error trapping to local.
	ON LOCAL ERROR RESUME NEXT
' Test file.
	IF FileName$ <> "" THEN
		ERR = 0
		CHDIR (FileName$)
		IF ERR THEN     ' FileName$ is a filename or wildcard, not a dir
		IF INSTR(FileName$, ".") = FALSE THEN FileName$ = FileName$ + ".BAL"
		IF LEN(FileName$) > 12 THEN
			a$ = "Filename too long: '" + FileName$ + "'|"
			r = Alert(4, a$, 10, 20, 12, 60, "", "", "")
			TestFileName = FALSE
		ELSE
			' Did user specify a new wildcard pattern?
				IF INSTR(FileName$, "*") OR INSTR(FileName$, "?") THEN
					'FileOpenForm.File1.Pattern = FileName$
					TestFileName = FILE.WILDCARD
				ELSE
				IF FileName$ <> ".." THEN
				' We're finished -- got a valid filename
					IF DIR$(FileName$) = "" THEN
						IF hType$ = "File Open" THEN
							a$ = "No such file: " + FileName$ + "|"
							r = Alert(4, a$, 10, 20, 12, 60, "", "", "")
							TestFileName = FALSE
						ELSE
							TestFileName = TRUE
						END IF
					ELSE
						IF hType$ = "Save As" THEN
							a$ = "Replace existing " + FileName$ + "?|"
							r = Alert(4, a$, 10, 20, 12, 60, "", "", "")
							IF r = 1 THEN
								KILL FileName$
								TestFileName = TRUE
							 ELSE
								TestFileName = FALSE
							 END IF
						ELSE
							 TestFileName = TRUE
						END IF
					END IF
				END IF
			END IF
		END IF
	ELSE   ' FileName$ was just a directory name
		 TestFileName = FALSE
	END IF
ELSE
	 ' The user only specified a new drive (handled in IsFileName)
		TestFileName = FALSE
END IF
END FUNCTION

SUB ToggleList (CurBTN, hCurTopPos%, hCurPosX%, hArray() AS STRING * 13)
' This routine moves the specific scroll bar.
	IF hCurPosX% = 1 AND hCurTopPos% = 1 THEN
		hState% = 1
	ELSE
		hState% = (hCurTopPos% + hCurPosX% - 1) * 7 / UBOUND(hArray)
		IF hState% < 1 THEN hState% = 1
		IF hState% > 10 THEN hState% = 7
	END IF
	ButtonSetState CurBTN, hState%
END SUB

SUB TransferDTA2DIR (DEntry AS DirectoryRecord)
	DEntry.FileName = DTA.FileName
	DEntry.FileAttb = ASC(DTA.Attribute)
END SUB

