'---------------------------------------------------------------------------
'       UI.BI
'
'       Copyright Jordan/Denske Software Publishing 1992.
'---------------------------------------------------------------------------
' Set RegType for CALL INTERRUPT.
    TYPE RegType
         ax                         AS INTEGER
         bx                         AS INTEGER
         cx                         AS INTEGER
         dx                         AS INTEGER
         bp                         AS INTEGER
         si                         AS INTEGER
         di                         AS INTEGER
         flags                      AS INTEGER
    END TYPE
' Define the type needed for InterruptX
    TYPE RegTypeX
         ax                         AS INTEGER
         bx                         AS INTEGER
         cx                         AS INTEGER
         dx                         AS INTEGER
         bp                         AS INTEGER
         si                         AS INTEGER
         di                         AS INTEGER
         flags                      AS INTEGER
         ds                         AS INTEGER
         es                         AS INTEGER
    END TYPE
' Set types for User Interface Window Arrays.
    TYPE windowType
        handle                      AS INTEGER
        row1                        AS INTEGER
        col1                        AS INTEGER
        row2                        AS INTEGER
        col2                        AS INTEGER
        cursorRow                   AS INTEGER
        cursorCol                   AS INTEGER
        highlight                   AS INTEGER
        textFore                    AS INTEGER
        textBack                    AS INTEGER
        fore                        AS INTEGER
        back                        AS INTEGER
        windowType                  AS INTEGER
        title                       AS STRING * 15
    END TYPE
' Set buttonType to store info about buttons
    TYPE buttonType
        handle                      AS INTEGER
        windowHandle                AS INTEGER
        text                        AS STRING * 30
        state                       AS INTEGER
        buttonOn                    AS INTEGER
        row1                        AS INTEGER
        col1                        AS INTEGER
        row2                        AS INTEGER
        col2                        AS INTEGER
        buttonType                  AS INTEGER
    END TYPE
' EditField Type stores info about edit fields
    TYPE EditFieldType
        handle                      AS INTEGER
        windowHandle                AS INTEGER
        text                        AS STRING * 255
        fore                        AS INTEGER
        back                        AS INTEGER
        row                         AS INTEGER
        col                         AS INTEGER
        visLength                   AS INTEGER
        maxLength                   AS INTEGER
    END TYPE
' Define the Area hot spots for a specific button.
    TYPE hotSpotType
        row1                        AS INTEGER
        row2                        AS INTEGER
        col1                        AS INTEGER
        col2                        AS INTEGER
        action                      AS INTEGER
        misc                        AS INTEGER
        misc2                       AS INTEGER
    END TYPE
' Define the array that store the saved info about a window.
    TYPE WindowStorageType
        currWindow                  AS INTEGER
        numWindowsOpen              AS INTEGER
        numButtonsOpen              AS INTEGER
        numEditFieldsOpen           AS INTEGER
        DialogEdit                  AS INTEGER
        DialogClose                 AS INTEGER
        DialogButton                AS INTEGER
        DialogWindow                AS INTEGER
        DialogEvent                 AS INTEGER
        DialogScroll                AS INTEGER
        DialogRow                   AS INTEGER
        DialogCol                   AS INTEGER
        oldDialogEdit               AS INTEGER
        oldDialogClose              AS INTEGER
        oldDialogButton             AS INTEGER
        oldDialogWindow             AS INTEGER
        oldDialogEvent              AS INTEGER
        oldDialogScroll             AS INTEGER
        oldDialogRow                AS INTEGER
        oldDialogCol                AS INTEGER
    END TYPE
' MenuTitleType stores information about each menu's title, and the left and
' right margins of the actual pull down menus.
    TYPE MenuTitleType
        text                        AS STRING * 15      'Menu title's text
        state                       AS INTEGER          'Menu's state  -1 empty, 0 disabled, 1 enabled
        lowestRow                   AS INTEGER          'lowest row of the menu
        rColItem                    AS INTEGER          'Right hand side of the menu
        lColItem                    AS INTEGER
        rColTitle                   AS INTEGER
        lColTitle                   AS INTEGER
        itemLength                  AS INTEGER
        accessKey                   AS INTEGER
    END TYPE
' MenuItemType stores information about menu items
    TYPE MenuItemType               '(GloItem)
        text                        AS STRING * 30
        state                       AS INTEGER
        index                       AS INTEGER
        row                         AS INTEGER
        accessKey                   AS INTEGER
    END TYPE
' MenuMiscType stores information about menu color attributes, current menu,
' previous menu, and an assortment of other miscellaneous information
    TYPE MenuMiscType               '(GloStorage)
        lastMenu                    AS INTEGER
        lastItem                    AS INTEGER
        currMenu                    AS INTEGER
        currItem                    AS INTEGER
        MenuOn                      AS INTEGER
        altKeyReset                 AS INTEGER
        menuIndex                   AS STRING * 160
        shortcutKeyIndex            AS STRING * 100
        fore                        AS INTEGER
        back                        AS INTEGER
        highlight                   AS INTEGER
        disabled                    AS INTEGER
        cursorFore                  AS INTEGER
        cursorBack                  AS INTEGER
        cursorHi                    AS INTEGER
    END TYPE
' Global Constants as defined by Microsoft for UI and Support.
    CONST FALSE = 0
    CONST TRUE = -1
    CONST MINROW = 2
    CONST MAXROW = 25
    CONST MINCOL = 1
    CONST MAXCOL = 80
    CONST MAXMENU = 10
    CONST MAXITEM = 20
    CONST MAXWINDOW = 10
    CONST MAXBUTTON = 50
    CONST MAXEDITFIELD = 70
    CONST MAXHOTSPOT = 30
' Sub Routine Declartions and Function Calls.
    DECLARE FUNCTION GetShiftState% (bit%)
    DECLARE FUNCTION AltToASCII$ (kbd$)
    DECLARE FUNCTION WhichWindow% (row%, col%)
    DECLARE FUNCTION ListBox% (text$(), maxRec%)
    DECLARE FUNCTION MaxScrollLength% (handle%)
    DECLARE FUNCTION WindowCurrent% ()
    DECLARE FUNCTION WindowBorder$ (winType%)
    DECLARE FUNCTION WindowCols% (handle%)
    DECLARE FUNCTION WindowRows% (handle%)
    DECLARE FUNCTION Alert% (style%, text$, row1%, col1%, row2%, col2%, b1$, b2$, b3$)
    DECLARE FUNCTION Dialog% (op%)
    DECLARE FUNCTION ButtonInquire% (handle%)
    DECLARE FUNCTION WindowNext% ()
    DECLARE FUNCTION FindButton% (handle%)
    DECLARE FUNCTION EditFieldInquire$ (handle%)
    DECLARE FUNCTION FindEditField% (handle%)
    DECLARE FUNCTION MenuCheck% (action%)
    DECLARE FUNCTION MenuInkey$ ()
    DECLARE FUNCTION DateSerial# (Years%, Months%, Days%)
    DECLARE FUNCTION DateValue#  (DateText$)
    DECLARE FUNCTION Year&  ( SerialNumber#)
    DECLARE FUNCTION Month&  ( SerialNumber#)
    DECLARE FUNCTION Day&  ( SerialNumber#)
    DECLARE FUNCTION Weekday&  ( SerialNumber#)
    DECLARE FUNCTION Hour&  ( SerialNumber#)
    DECLARE FUNCTION Minute&  ( SerialNumber#)
    DECLARE FUNCTION Now#  ()
    DECLARE FUNCTION Second&  ( SerialNumber#)
    DECLARE FUNCTION TimeSerial# (Hours%, Minutes%, Seconds%)
    DECLARE FUNCTION TimeValue# (TimeText$)
    DECLARE FUNCTION FormatI$ (byval a%, b$)
    DECLARE FUNCTION FormatL$ (byval a&, b$)
    DECLARE FUNCTION FormatS$ (byval a!, b$)
    DECLARE FUNCTION FormatD$ (byval a#, b$)
    DECLARE FUNCTION FormatC$ (byval a@, b$)
    DECLARE SUB SetFormatCC (byval a%)
    DECLARE SUB MouseHide ()
    DECLARE SUB MouseShow ()
    DECLARE SUB MousePoll (row%, col%, lButton%, rButton%)
    DECLARE SUB MouseBorder (row1%, col1%, row2%, col2%)
    DECLARE SUB MouseDriver (m0%, m1%, m2%, m3%)
    DECLARE SUB MouseInit ()
    DECLARE SUB InterruptX (intnum AS INTEGER,inreg AS RegTypeX, outreg AS RegTypeX)
    DECLARE SUB Absolute (address AS INTEGER)
    DECLARE SUB Int86Old (intnum AS INTEGER, inarray(1) AS INTEGER, outarray(1) AS INTEGER)
    DECLARE SUB Int86XOld (intnum AS INTEGER, inarray(1) AS INTEGER, outarray(1) AS INTEGER)
    DECLARE SUB Interrupt (intnum AS INTEGER, inregs AS RegType, outregs AS RegType)
    DECLARE SUB GetCopyBox (row1%, col1%, row2%, col2%, buffer$)
    DECLARE SUB PutCopyBox (row%, col%, buffer$)
    DECLARE SUB AttrBox (row1%, col1%, row2%, col2%, attr%)
    DECLARE SUB PutBackground (row%, col%, buffer$)
    DECLARE SUB GetBackground (row1%, col1%, row2%, col2%, buffer$)
    DECLARE SUB Box (row1%, col1%, row2%, col2%, fore%, back%, border$, fillFlag%)
    DECLARE SUB Scroll (row1%, col1%, row2%, col2%, lines%, attr%)
    DECLARE SUB ButtonSetState (handle%, state%)
    DECLARE SUB WindowDo (startButton%, startEdit%)
    DECLARE SUB ButtonOpen (handle%, state%, title$, row%, col%, row2%, col2%, buttonType%)
    DECLARE SUB WindowLine (row%)
    DECLARE SUB WindowPrint (printMode%, text$)
    DECLARE SUB WindowOpen (handle%, row1%, col1%, row2%, col2%, textFore%, textBack%, fore%, back%, highlight%, movewin%, closewin%, sizewin%, modalwin%, borderchar%, title$)
    DECLARE SUB ButtonClose (handle%)
    DECLARE SUB WindowClose (handle%)
    DECLARE SUB WindowShadowSave ()
    DECLARE SUB WindowShadowRefresh ()
    DECLARE SUB WindowPrintTitle ()
    DECLARE SUB ButtonShow (handle%)
    DECLARE SUB WindowSave (handle%)
    DECLARE SUB WindowRefresh (handle%)
    DECLARE SUB BackgroundSave (handle%)
    DECLARE SUB BackgroundRefresh (handle%)
    DECLARE SUB WindowScroll (lines%)
    DECLARE SUB EditFieldClose (handle%)
    DECLARE SUB ButtonToggle (handle%)
    DECLARE SUB EditFieldOpen (handle%, text$, row%, col%, fore%, back%, visLength%, maxLength%)
    DECLARE SUB WindowBox (boxRow1%, boxCol1%, boxRow2%, boxCol2%)
    DECLARE SUB WindowCls ()
    DECLARE SUB WindowColor (fore%, back%)
    DECLARE SUB WindowInit ()
    DECLARE SUB WindowLocate (row%, col%)
    DECLARE SUB WindowSetCurrent (handle%)
    DECLARE SUB MenuItemToggle (menu%, item%)
    DECLARE SUB MenuInit ()
    DECLARE SUB MenuColor (fore%, back%, highlight%, disabled%, cursorFore%, cursorBack%, cursorHi%)
    DECLARE SUB MenuSet (menu%, item%, state%, text$, accessKey%)
    DECLARE SUB MenuShow ()
    DECLARE SUB MenuPreProcess ()
    DECLARE SUB MenuEvent ()
    DECLARE SUB MenuOn ()
    DECLARE SUB MenuOff ()
    DECLARE SUB ShortCutKeySet (menu%, item%, shortcutKey$)
    DECLARE SUB ShortCutKeyDelete (menu%, item%)
    DECLARE SUB ShortCutKeyEvent (theKey$)
    DECLARE SUB MenuSetState (menu%, item%, state%)
    DECLARE SUB MenuDo ()
' Set a common block for the mouse drive presense.
    COMMON SHARED /uitools/ MousePresent AS INTEGER



