'---------------------------------------------------------------------------
'  ERROR.BAS
'  *********
'  This is a full function error handler for use with BASIC PDS 7.x and
'  the User Interface Toolbox Library.
'  Add the following references in you module level code you want to
'  be able to access this error module...
'  DECLARATIONS
'  ************
'  DECLARE FUNCTION ErrorProcessor
'---------------------------------------------------------------------------
' Define all integers as alpha.
	DEFINT A-Z
' Set all global ErrVal%s.
	CONST OverFlow = 6
	CONST OutOfMemory = 7
	CONST SubscriptOutOfRange = 9
	CONST DivideByZero = 11
	CONST OutOfStringSpace = 14
	CONST DeviceTimeout = 24
	CONST DeviceFault = 25
	CONST OutOfPaper = 27
	CONST InternalError = 51
	CONST BadFileNum = 52
	CONST FileNotFound = 53
	CONST BadFileMode = 54
	CONST FileAlreadyOpen = 55
	CONST DeviceIOError = 57
	CONST FileAllreadyExists = 58
	CONST BadRecordLength = 59
	CONST DiskFull = 61
	CONST InputPastEOF = 62
	CONST BadRecordNumber = 63
	CONST BadFileName = 64
	CONST TooManyFiles = 67
	CONST DeviceUnavailable = 68
	CONST CommBufferOverFlow = 69
	CONST PermisionDenied = 70
	CONST DiskNotReady = 71
	CONST DiskMediaError = 72
	CONST AdvanceFeatureUnavailable = 73
	CONST RenameAcrossDisks = 74
	CONST PathFileAccessError = 75
	CONST PathNotFound = 76
' Declare function to evaluate the errors and reset.
	DECLARE FUNCTION ErrorProcessor% (a$)

FUNCTION ErrorProcessor (a$)
' This is a complete error handling routine for QuickBasic and PDS
' This is the Header for all errors.
			a$ = "Error Occurred|"
	 a$ = a$ + "|"
' Now pass the "ErrValue" thru the select case function to determine
' the action and message to be contructed from the const's declared
' in the main module.
	' Level One (1) errors are "OK" errors.
	' Level Two (2) errors are "Abort/Retry" errors.
	' Level Two (3) errors are "Fatal" errors.
	SELECT CASE ERR
			CASE OverFlow
				a$ = a$ + "Internal OverFlow.|"
				a$ = a$ + "Terminating program...|"
				ErrorProcessor = 3
			CASE OutOfMemory
				a$ = a$ + "Out of Memory.|"
				a$ = a$ + "Terminating program...|"
				ErrorProcessor = 3
			CASE SubscriptOutOfRange
				a$ = a$ + "Array allocation error.|"
				a$ = a$ + "Terminating program...|"
				ErrorProcessor = 3
			CASE DivideByZero
				a$ = a$ + "Division by Zero.|"
				a$ = a$ + "Terminating program...|"
				ErrorProcessor = 3
			CASE OutOfStringSpace
				a$ = a$ + "Out of String Memory.|"
				a$ = a$ + "Terminating program...|"
				ErrorProcessor = 3
			CASE OutOfStringSpace
				a$ = a$ + "Out of String Memory.|"
				a$ = a$ + "Terminating program...|"
				ErrorProcessor = 3
			CASE DeviceUnavailable
				a$ = a$ + "Requested device is unavailable.|"
				a$ = a$ + "Correct the problem & retry|"
				ErrorProcessor = 1
			CASE DeviceTimeout
				a$ = a$ + "Device Time Out|"
				a$ = a$ + "Please correct!|"
				ErrorProcessor = 2
			CASE DeviceFault
				a$ = a$ + "Device Fault|"
				a$ = a$ + "Please correct!|"
				ErrorProcessor = 2
			CASE OutOfPaper
				a$ = a$ + "Out of Paper.|"
				a$ = a$ + "Please correct!|"
				ErrorProcessor = 2
			CASE InternalError
				a$ = a$ + "Internal Error!|"
				a$ = a$ + "Terminating program...|"
				ErrorProcessor = 3
			CASE BadFileNum
				a$ = a$ + "Bad File Number.|"
				a$ = a$ + "Terminating program...|"
				ErrorProcessor = 3
			CASE FileNotFound
				a$ = a$ + "Cannot find file in current|"
				a$ = a$ + "path or directory.|"
				ErrorProcessor = 1
			CASE BadFileMode
				a$ = a$ + "You may not access that file|"
				a$ = a$ + "in the requested file mode.|"
				ErrorProcessor = 1
			CASE FileAlreadyOpen
				a$ = a$ + "File is Already open.|"
				a$ = a$ + "Terminating program...|"
				ErrorProcessor = 3
			CASE DeviceIOError
				a$ = a$ + "Drive does not support format.|"
				a$ = a$ + "Disk media error.|"
				ErrorProcessor = 1
			CASE FileAllreadyExists
				a$ = a$ + "That file already exists|"
				a$ = a$ + "in the requested directory.|"
				ErrorProcessor = 1
			CASE BadRecordLength
				a$ = a$ + "Bad Record Length.|"
				a$ = a$ + "Terminating program...|"
				ErrorProcessor = 3
			CASE BadFileName
				a$ = a$ + "That filename is a illegal|"
				a$ = a$ + "DOS syntax error.|"
				ErrorProcessor = 1
			CASE TooManyFiles
				a$ = a$ + "There are too many files|"
				a$ = a$ + "to match your config.sys|"
				ErrorProcessor = 3
			CASE DeviceUnavailable
				a$ = a$ + "That Device is|"
				a$ = a$ + " Unavailable.|"
				ErrorProcessor = 1
			CASE CommBufferOverFlow
				a$ = a$ + "Comm Port Data|"
				a$ = a$ + "Overflow!|"
				ErrorProcessor = 2
			CASE PermisionDenied
				a$ = a$ + "That file is unavailable|"
				a$ = a$ + "for you to access.|"
				ErrorProcessor = 1
			CASE DiskNotReady
				a$ = a$ + "Your drive or printer is|"
				a$ = a$ + "not ready. Please Correct!|"
				ErrorProcessor = 2
			CASE DiskMediaError
				a$ = a$ + "Disk Media Error|"
				a$ = a$ + "Corrupt or Improper Format.|"
				ErrorProcessor = 2
			CASE AdvanceFeatureUnavailable
				a$ = a$ + "That feature is|"
				a$ = a$ + "Unavailable.|"
				ErrorProcessor = 1
			CASE RenameAcrossDisks
				a$ = a$ + "You cannot rename files|"
				a$ = a$ + "across disk drives!|"
				ErrorProcessor = 1
			CASE DiskFull
				a$ = a$ + "This disk is full and cannot|"
				a$ = a$ + "accept the file. Try a new disk?|"
				ErrorProcessor = 2
			CASE PathNotFound, PathFileAccessError
				a$ = a$ + "The requested path does|"
				a$ = a$ + "not exist.|"
				ErrorProcessor = 1
			CASE ELSE
				a$ = a$ + "Unrecoverable application|"
				a$ = a$ + "Error!|"
				ErrorProcessor = 3
	END SELECT
END FUNCTION

