DECLARE SUB PopWind(Title$,TopRow%,LeftColumn%,BottomRow%,RightColumn%,Attr%,Shadow%,Border%)
DECLARE SUB SaveScreen(ScreenID$,TopRow%,LeftColumn%,BottomRow%,RightColumn%,Shadow%)
DECLARE SUB RestoreScreen(ScreenID$,TopRow%,LeftColumn%)
DECLARE SUB CalcByte(Attr%,LowByte%,HiByte%)
DECLARE SUB Clicked(Rgt%,Lft%,Row%,Col%)
DECLARE SUB HideCursor()
DECLARE SUB ShowCursor()
DECLARE FUNCTION LeftButtonReleased%()

FUNCTION Question%(QuestionText$(),CorrectAnswer$,Mouse%,ButtonAttr%,Attr%,TxtColor%,Shadow%,Border%) PUBLIC

$CODE SEG "DNASEG2"

CalcByte Attr%,FGround%,BGround%
CalcByte ButtonAttr%,BtFG%,BtBG%

IF Mouse% THEN HideCursor

SELECT CASE CorrectAnswer$        'set up the minimium width of window
  CASE "Y","y","N","n"  'Yes/No   'so that button fit, set QuestionType%
    QuestionType% = 1             'so we dont end up in an endless loop
    MinWidth% = 17
  CASE "T","t","F","f"  'True/False
    QuestionType% = 2
    MinWidth% = 21
  CASE "A","a","B","b","C","c","D","d"  'A/B/C/D
    QuestionType% = 3
    MinWidth% = 28
END SELECT

i% = 0: j% = 0: Maxlength% = 0

DO

INCR i%
INCR j%                                 'first find out how many
																						'strings there are and the
IF LEN (QuestionText$(i%)) = 0 THEN     'length of the longest one
  DECR i%
ELSE
  IF LEN(QuestionText$(i%)) > Maxlength% THEN Maxlength% = LEN(QuestionText$(i%))
END IF

LOOP WHILE i% = j%

Count% = i% + 3      'add three rows for the buttons

INCR Maxlength%      'add a space

IF Maxlength% < MinWidth% THEN Maxlength% = MinWidth%

LeftColumn% = 40 - ((Maxlength% + 2) / 2)
RightColumn% = LeftColumn% + (Maxlength% + 2)
TopRow% = (25 - Count%) \ 2
BottomRow% = TopRow% + (Count% + 1)

SaveScreen Ques$,TopRow%,LeftColumn%,BottomRow%,RightColumn%,Shadow%

PopWind Title$,TopRow%,LeftColumn%,BottomRow%,RightColumn%,Attr%,Shadow%,Border%


Row% = TopRow% + 1
Col% = LeftColumn% + 1

FOR a% = 1 TO Count% - 3
  COLOR TxtColor%,BGround%
  LOCATE Row%,Col%,0
  PRINT SPACE$(1) + QuestionText$(a%) + SPACE$(Maxlength% - LEN(QuestionText$(a%)))
  INCR Row%
NEXT a%

Col% = LeftColumn% + 3
Row% = BottomRow% - 2

SELECT CASE QuestionType%      'only print the buttons we need
  CASE 1  'Yes/No
    COLOR BtFG%,BtBG%: LOCATE Row%, Col%,0: PRINT " YES ";
    COLOR 0,BGround%: LOCATE Row%, Col% + 5,0: PRINT "";
    COLOR 0,BGround%: LOCATE Row% + 1,Col% + 1,0: PRINT "";

    COLOR BtFG%,BtBG%: LOCATE Row%,Col% + 9,0: PRINT " NO ";
    COLOR 0,BGround%: LOCATE Row%,Col% + 13,0: PRINT "";
    COLOR 0,BGround%: LOCATE Row% + 1,Col% + 10,0: PRINT ""
  CASE 2  'True/False
    COLOR BtFG%,BtBG%: LOCATE Row%, Col%,0: PRINT " TRUE ";
    COLOR 0,BGround%: LOCATE Row%, Col% + 6,0: PRINT "";
    COLOR 0,BGround%: LOCATE Row% + 1,Col% + 1,0: PRINT "";

    COLOR BtFG%,BtBG%: LOCATE Row%,Col% + 10,0: PRINT " FALSE ";
    COLOR 0,BGround%: LOCATE Row%,Col% + 17,0: PRINT "";
    COLOR 0,BGround%: LOCATE Row% + 1,Col% + 11,0: PRINT ""
  CASE 3  'A/B/C/D
    COLOR BtFG%,BtBG%: LOCATE Row%, Col%,0: PRINT " A ";
    COLOR 0,BGround%: LOCATE Row%, Col% + 3,0: PRINT "";
    COLOR 0,BGround%: LOCATE Row% + 1,Col% + 1,0: PRINT "";

    COLOR BtFG%,BtBG%: LOCATE Row%,Col% + 7,0: PRINT " B ";
    COLOR 0,BGround%: LOCATE Row%,Col% + 10,0: PRINT "";
    COLOR 0,BGround%: LOCATE Row% + 1,Col% + 8,0: PRINT ""

    COLOR BtFG%,BtBG%: LOCATE Row%, Col% + 14,0: PRINT " C ";
    COLOR 0,BGround%: LOCATE Row%, Col% + 17,0: PRINT "";
    COLOR 0,BGround%: LOCATE Row% + 1,Col% + 15,0: PRINT "";

    COLOR BtFG%,BtBG%: LOCATE Row%,Col% + 21,0: PRINT " D ";
    COLOR 0,BGround%: LOCATE Row%,Col% + 24,0: PRINT "";
    COLOR 0,BGround%: LOCATE Row% + 1,Col% + 22,0: PRINT ""
END SELECT

DO

WHILE NOT INSTAT
  IF Mouse% THEN
    ShowCursor
    Clicked Rgt%,Lft%,MRow%,MCol%
    IF LeftButtonReleased% THEN
      SELECT CASE MRow%
        CASE Row%
          SELECT CASE QuestionType%
            CASE 1  'Yes/No
              SELECT CASE MCol%
                CASE Col% TO Col% + 4
                  Ky$ = "Y": GOTO KeyBoard
                CASE Col% + 9 TO Col% + 12
                  Ky$ = "N": GOTO KeyBoard
              END SELECT
            CASE 2  'True/False
              SELECT CASE MCol%
                CASE Col% TO Col% + 5
                  Ky$ = "T": GOTO KeyBoard
                CASE Col% + 10 TO Col% + 16
                  Ky$ = "F": GOTO KeyBoard
              END SELECT
            CASE 3  'A/B/C/D
              SELECT CASE MCol%
                CASE Col% TO Col% + 2
                  Ky$ = "A": GOTO KeyBoard
                CASE Col% + 7 TO Col% + 9
                  Ky$ = "B": GOTO KeyBoard
                CASE Col% + 14 TO Col% + 16
                  Ky$ = "C": GOTO KeyBoard
                CASE Col% + 21 TO Col% + 23
                  Ky$ = "D": GOTO KeyBoard
              END SELECT
          END SELECT
      END SELECT
    END IF
  END IF
WEND

Ky$ = INKEY$

KeyBoard:

IF Mouse% THEN HideCursor

SELECT CASE QuestionType%
  CASE 1  'Yes/No
    SELECT CASE Ky$
      CASE "N","n"
        COLOR BtFG%,BtBG%: LOCATE Row%,Col% + 10,0: PRINT " NO ";
        COLOR 0,BGround%: LOCATE Row%,Col% + 9,0: PRINT " ";
        COLOR 0,BGround%: LOCATE Row% + 1,Col% + 10,0: PRINT "    "
        QuestionAnswered% = 1
      CASE "Y","y"
        COLOR BtFG%,BtBG%: LOCATE Row%, Col% + 1,0: PRINT " YES ";
        COLOR 0,BGround%: LOCATE Row%, Col%,0: PRINT " ";
        COLOR 0,BGround%: LOCATE Row% + 1,Col% + 1,0: PRINT "     ";
        QuestionAnswered% = 1
    END SELECT
  CASE 2  'True/False
    SELECT CASE Ky$
      CASE "F","f"
        COLOR BtFG%,BtBG%: LOCATE Row%,Col% + 11,0: PRINT " FALSE ";
        COLOR 0,BGround%: LOCATE Row%,Col% + 10,0: PRINT " ";
        COLOR 0,BGround%: LOCATE Row% + 1,Col% + 11,0: PRINT "       "
        QuestionAnswered% = 1
      CASE "T","t"
        COLOR BtFG%,BtBG%: LOCATE Row%, Col% + 1,0: PRINT " TRUE ";
        COLOR 0,BGround%: LOCATE Row%, Col%,0: PRINT " ";
        COLOR 0,BGround%: LOCATE Row% + 1,Col% + 1,0: PRINT "      ";
        QuestionAnswered% = 1
    END SELECT
  CASE 3  'A/B/C/D
    SELECT CASE Ky$
      CASE "A","a"
        COLOR BtFG%,BtBG%: LOCATE Row%, Col% + 1,0: PRINT " A ";
        COLOR 0,BGround%: LOCATE Row%, Col%,0: PRINT " ";
        COLOR 0,BGround%: LOCATE Row% + 1,Col% + 1,0: PRINT "   ";
        QuestionAnswered% = 1
      CASE "B","b"
        COLOR BtFG%,BtBG%: LOCATE Row%,Col% + 8,0: PRINT " B ";
        COLOR 0,BGround%: LOCATE Row%,Col% + 7,0: PRINT " ";
        COLOR 0,BGround%: LOCATE Row% + 1,Col% + 8,0: PRINT "   "
        QuestionAnswered% = 1
      CASE "C","c"
        COLOR BtFG%,BtBG%: LOCATE Row%, Col% + 15,0: PRINT " C ";
        COLOR 0,BGround%: LOCATE Row%, Col% + 14,0: PRINT " ";
        COLOR 0,BGround%: LOCATE Row% + 1,Col% + 15,0: PRINT "   ";
        QuestionAnswered% = 1
      CASE "D","d"
        COLOR BtFG%,BtBG%: LOCATE Row%,Col% + 22,0: PRINT " D ";
        COLOR 0,BGround%: LOCATE Row%,Col% + 21,0: PRINT " ";
        COLOR 0,BGround%: LOCATE Row% + 1,Col% + 22,0: PRINT "   "
        QuestionAnswered% = 1
    END SELECT
END SELECT

LOOP UNTIL QuestionAnswered%

IF UCASE$(Ky$) = UCASE$(CorrectAnswer$) THEN
  Question% = 1
ELSE
  Question% = 0
END IF

DELAY .5

RestoreScreen Ques$,TopRow%,LeftColumn%

END FUNCTION