$INCLUDE "DNALIB.INC"
$LINK "DNALIB.PBL"

IF MouseThere% THEN Mouse% = 1
'----------------------------------------------------------------------------
DIM FDirectory$(500)
DIM DemoName$(101)
DIM About$(15)
DIM Menu$(12)
DIM Info$(12)
DIM TempMessage$(7)
'----------------------------------------------------------------------------
HorzMenu$(1) = "@Miscellaneous"
HorzMenu$(2) = "@Editing"
HorzMenu$(3) = "Sc@reen"
HorzMenu$(4) = "@Input"
HorzMenu$(5) = "@Answer"
HorzMenu$(6) = "@Help"
'----------------------------------------------------------------------------
VertMenu1$(1) = "Area@CLS"
VertMenu1$(2) = "Poke@Area"
VertMenu1$(3) = "_"
VertMenu1$(4) = "@Noise"
VertMenu1$(5) = "_"
VertMenu1$(6) = "@Moveable Window"
VertMenu1$(7) = "@Percentage"
VertMenu1$(8) = "@Scroll"

VertInfo1$(1) = "Clear an area of the Screen"
VertInfo1$(2) = "Poke an area of the Screen"
VertInfo1$(4) = "Make some noise"
VertInfo1$(6) = "Move a window around the Screen"
VertInfo1$(7) = "Show some activity"
VertInfo1$(8) = "Scroll a message in both directions"
'----------------------------------------------------------------------------
VertMenu2$(1) = "@Line Editing Demo"
VertMenu2$(2) = "_"
VertMenu2$(3) = "Data @Entry"
VertMenu2$(4) = "_"
VertMenu2$(5) = "@Full Screen Text Editor"
VertMenu2$(6) = "_"
VertMenu2$(7) = "@Single Edit Box"
VertMenu2$(8) = "@Double Edit Box"

VertInfo2$(1) = "Demo of LineEdit Routine"
VertInfo2$(3) = "Multi field Data Entry Routine"
VertInfo2$(5) = "Demo of DNA Write Text Editor"
VertInfo2$(7) = "Demo of Single Edit Box Routine"
VertInfo2$(8) = "Demo of Double Edit Box Routine"
'----------------------------------------------------------------------------
VertMenu3$(1) = "@Popwind"
VertMenu3$(2) = "Save & @Restore"
VertMenu3$(3) = "_"
VertMenu3$(4) = "@Browse"
VertMenu3$(5) = "@Dialog"
VertMenu3$(6) = "Scroll @Box"
VertMenu3$(7) = "@Virtual Box"

VertInfo3$(1) = "Demo of Popwind Routine"
VertInfo3$(2) = "Demo of SaveRest Routine"
VertInfo3$(4) = "Demo of Browse Routine"
VertInfo3$(5) = "Demo of Dialog Routine"
VertInfo3$(6) = "Demo of Scroll Box Routine"
VertInfo3$(7) = "Demo of Virtual Box Routine"
'----------------------------------------------------------------------------
VertMenu4$(1) = "@CalcBox"
VertMenu4$(2) = "_"
VertMenu4$(3) = "@Lotus"
VertMenu4$(4) = "@ScrollMenu"
VertMenu4$(5) = "_"
VertMenu4$(6) = "@DirectoryBox"
VertMenu4$(7) = "@PickBox"
VertMenu4$(8) = "@WriteToBox"

VertInfo4$(1) = "Demo of CalcBox Function"
VertInfo4$(3) = "Demo of Lotus Style Menu"
VertInfo4$(4) = "Demo of Scrolling Menu with Hot keys"
VertInfo4$(6) = "Recursive Directory Routine"
VertInfo4$(7) = "Demo of Full screen file selection"
VertInfo4$(8) = "Insert a fully pathed file name"
'----------------------------------------------------------------------------
VertMenu5$(1) = "@Ask"
VertMenu5$(2) = "@Maybe"
VertMenu5$(3) = "@YesNo"
VertMenu5$(4) = "_"
VertMenu5$(5) = "@Question"

VertInfo5$(1) = "Demo of Ask Routine"
VertInfo5$(2) = "Demo of Maybe Routine"
VertInfo5$(3) = "Demo of YesNo Function"
VertInfo5$(5) = "Multiple Answer Routine"
'----------------------------------------------------------------------------
VertMenu6$(1) = "@Help"
VertMenu6$(2) = "@Future"
VertMenu6$(3) = "About @DNALIB"
VertMenu6$(4) = "_"
VertMenu6$(5) = "@Quit"

VertInfo6$(1) = "Information on HELP System"
VertInfo6$(2) = "Plans for Future"
VertInfo6$(3) = "Information About DNA Library"
VertInfo6$(5) = "Quit DNALIB & Demo of Ask Routine"
'----------------------------------------------------------------------------
HelpTextColor% = 14
HelpAttr% = 79

SCREEN 0

TopRow% = 1
Marker% = 99
COLOR 0,3
LOCATE 3,1,0
A$ = REPEAT$(80," DNA for PowerBASIC 3")
PRINT A$
COLOR 14,0
LOCATE 2,1,0
PRINT STRING$(80,205);
LOCATE 24,1,0
PRINT STRING$(80,205);
COLOR 0,7
LOCATE 25,1,0
PRINT SPACE$(80);

DO

HORIZONTALMENU HorzMenu$(),BarSave$,HiLight%,Mouse%,HPointer%,4,112,15,TopRow%,5,Marker%

SELECT CASE HPointer%
  CASE 1  'Miscellaneous
    VERTICALMENU VertMenu1$(),VertInfo1$(),VRtrn$,BarSave$,Mouse%,4,HelpTextColor%,HelpAttr%,15,TopRow%,Marker%,HPointer%,112,1,1
    IF LEN(VRtrn$) THEN
      SELECT CASE VRtrn$
        CASE "AreaCLS"
          GOSUB AreaCLSDemo
        CASE "PokeArea"
          GOSUB PokeAreaDemo
        CASE "Noise"
          GOSUB NoiseDemo
        CASE "Moveable Window"
          GOSUB MoveableWinDemo
        CASE "Percentage"
          GOSUB PercentageDemo
        CASE "Scroll"
          GOSUB ScrollDemo
      END SELECT
    END IF
  CASE 2  'Edit
    VERTICALMENU VertMenu2$(),VertInfo2$(),VRtrn$,BarSave$,Mouse%,4,HelpTextColor%,HelpAttr%,15,TopRow%,Marker%,HPointer%,112,1,1
    IF LEN(VRtrn$) THEN
      SELECT CASE VRtrn$
        CASE "Line Editing Demo"
          GOSUB LineEditDemo
        CASE "Data Entry"
          GOSUB DataEntry
        CASE "Full Screen Text Editor"
          GOSUB DNAWriteDemo
        CASE "Single Edit Box"
          GOSUB SingleEditBox
        CASE "Double Edit Box"
          GOSUB DoubleEditBox
      END SELECT
    END IF
  CASE 3  'Screen
    VERTICALMENU VertMenu3$(),VertInfo3$(),VRtrn$,BarSave$,Mouse%,4,HelpTextColor%,HelpAttr%,15,TopRow%,Marker%,HPointer%,112,1,1
    IF LEN(VRtrn$) THEN
      SELECT CASE VRtrn$
        CASE "Popwind"
          GOSUB PopwindDemo
        CASE "Save & Restore"
          GOSUB SaveRestoreDemo
        CASE "Browse"
          GOSUB BrowseDemo
        CASE "Dialog"
          GOSUB DialogDemo
        CASE "Scroll Box"
          GOSUB ScrollBoxDemo
        CASE "Virtual Box"
          GOSUB VirtualBoxDemo
      END SELECT
    END IF
  CASE 4  'Help
    VERTICALMENU VertMenu4$(),VertInfo4$(),VRtrn$,BarSave$,Mouse%,4,HelpTextColor%,HelpAttr%,15,TopRow%,Marker%,HPointer%,112,1,1
    IF LEN(VRtrn$) THEN
      SELECT CASE VRtrn$
	CASE "CalcBox"
          GOSUB CalcBoxDemo
	CASE "Lotus"
          GOSUB LotusDemo
	CASE "ScrollMenu"
          GOSUB ScrollMenuDemo
	CASE "DirectoryBox"
          GOSUB DirectoryBoxDemo
	CASE "PickBox"
          GOSUB PickBoxDemo
	CASE "WriteToBox"
          GOSUB WriteToBoxDemo
      END SELECT
    END IF
  CASE 5  'Help
    VERTICALMENU VertMenu5$(),VertInfo5$(),VRtrn$,BarSave$,Mouse%,4,HelpTextColor%,HelpAttr%,15,TopRow%,Marker%,HPointer%,112,1,1
    IF LEN(VRtrn$) THEN
      SELECT CASE VRtrn$
	CASE "Ask"
          GOSUB AskDemo
        CASE "Maybe"
          GOSUB MaybeDemo
	CASE "YesNo"
          GOSUB YesNoDemo
        CASE "Question"
          GOSUB QuestionDemo
      END SELECT
    END IF
  CASE 6  'Help
    VERTICALMENU VertMenu6$(),VertInfo6$(),VRtrn$,BarSave$,Mouse%,4,HelpTextColor%,HelpAttr%,15,TopRow%,Marker%,HPointer%,112,1,1
    IF LEN(VRtrn$) THEN
      SELECT CASE VRtrn$
        CASE "Help"
          GOSUB ErrorMessage
        CASE "Future"
          GOSUB FutureFeatures
        CASE "About DNALIB"
          GOSUB AboutDNA
        CASE "Quit"
          VRtrn$ = "Quit"
      END SELECT
    END IF
END SELECT

HiLight% = 1

IF Been% = 0 THEN
  GOSUB AboutDNA
  Been% = 1
END IF

LOOP UNTIL VRtrn$ = "Quit"

DELAY .5
COLOR 7,0
CLS

END
'============================================================================
AreaCLSDemo:

IF Mouse% THEN HideCursor

DEF SEG = &HB800
BaseScreen$ = PEEK$(0,4000)
POPWIND "AreaCLS Demo",5,20,20,60,31,0,1
COLOR 15,4:LOCATE 25,28,0:PRINT "  Press a key to continue  ";
WHILE NOT INSTAT:WEND
Dump$ = INKEY$
AreaCLS 5,33,1,14,1,79
WHILE NOT INSTAT:WEND
Dump$ = INKEY$
AreaCLS 19,20,2,41,2,31
WHILE NOT INSTAT:WEND
Dump$ = INKEY$
AreaCLS 5,20,14,12,11,112
WHILE NOT INSTAT:WEND
Dump$ = INKEY$
AreaCLS 5,60,14,1,12,44
WHILE NOT INSTAT:WEND
Dump$ = INKEY$
AreaCLS 5,20,16,41,32,0
WHILE NOT INSTAT:WEND
Dump$ = INKEY$
AreaCLS 3,1,21,80,176,30
WHILE NOT INSTAT:WEND
Dump$ = INKEY$

IF Mouse% THEN HideCursor

DEF SEG = &HB800
POKE$ 0,BaseScreen$
DEF SEG

RETURN
'----------------------------------------------------------------------------
PokeAreaDemo:

IF Mouse% THEN HideCursor

DEF SEG = &HB800
BaseScreen$ = PEEK$(0,4000)
COLOR 15,4:LOCATE 25,28,0:PRINT "  Press a key to continue  ";
WHILE NOT INSTAT:WEND
Dump$ = INKEY$
PokeArea 3,1,12,20,79
WHILE NOT INSTAT:WEND
Dump$ = INKEY$
PokeArea 13,21,23,40,31
WHILE NOT INSTAT:WEND
Dump$ = INKEY$
PokeArea 3,41,12,60,112
WHILE NOT INSTAT:WEND
Dump$ = INKEY$
PokeArea 13,61,23,80,14
WHILE NOT INSTAT:WEND
Dump$ = INKEY$
PokeArea 13,1,23,20,46
WHILE NOT INSTAT:WEND
Dump$ = INKEY$
PokeArea 3,21,12,40,85
WHILE NOT INSTAT:WEND
Dump$ = INKEY$
PokeArea 13,41,23,60,146
WHILE NOT INSTAT:WEND
Dump$ = INKEY$
PokeArea 3,61,12,80,55
WHILE NOT INSTAT:WEND
Dump$ = INKEY$

FOR i% = 1 TO 128
  PokeArea 3,1,23,80,i%
  DELAY .05
  PokeArea 5,10,21,71,i% + 1
  DELAY .05
  PokeArea 7,19,19,62,i% + 2
  DELAY .05
  PokeArea 9,28,17,53,i% + 3
  DELAY .05
  PokeArea 11,37,15,44,i% + 4
  DELAY .05
NEXT i%

IF Mouse% THEN HideCursor

DEF SEG = &HB800
POKE$ 0,BaseScreen$
DEF SEG

RETURN
'----------------------------------------------------------------------------
NoiseDemo:

FOR i% = 1 TO 6
  Noise i%
  IF i% = 4 THEN
    FOR j% = 1 TO 20
      Noise i%
      DELAY .1
    NEXT j%
  END IF
  DELAY 1
NEXT i%

RETURN
'----------------------------------------------------------------------------
PercentageDemo:

IF Mouse% THEN HideCursor

SaveScreen Msg$,8,13,15,66,1
Popwind "Percentage Demo",8,13,15,66,112,1,1

FOR i% = 0 to 100 STEP 20
  Percentage i%,13,15,4,112
  FOR j% = 0 TO 100
    Percentage j%,10,15,1,112
  NEXT j%
  DELAY .2
NEXT i%

DELAY 2
RestoreScreen Msg$,8,13

RETURN
'----------------------------------------------------------------------------
ScrollDemo:

IF Mouse% THEN HideCursor

SCROLL "Scroll a message in both Directions ",1,0,25,112
SCROLL "Scroll a message in both Directions ",1,1,25,112

RETURN
'----------------------------------------------------------------------------
MoveableWinDemo:

IF Mouse% THEN HideCursor

DEF SEG = &HB800
BaseScreen$ = PEEK$(0,4000)
POPWIND "Moveable Window",10,25,15,54,31,0,1
DELAY .5
TYPWRITE "Add some text",11,34,31
TYPWRITE "use ARROW KEYS to move",12,29,31
TYPWRITE "window, hit enter to end",13,28,31
TYPWRITE "Moveable window demo",14,30,31
SAVESCREEN Window1$,10,25,15,54,0
MOVEABLEWINDOW BaseScreen$,Window1$,10,25
DELAY .5

IF Mouse% THEN HideCursor

DEF SEG = &HB800
POKE$ 0,BaseScreen$
DEF SEG

RETURN
'----------------------------------------------------------------------------
LineEditDemo:

IF Mouse% THEN HideCursor

SAVESCREEN BaseScreen$,1,1,25,80,0
LOCATE 25,8,0
PRINT "Editing Keys = INSERT  DEL  ESC  HOME  END  BACKSPACE  ARROWKEYS";

Allow$ = CHR$(24) + "ABCDEFGHIJKLMNOPQRSTUVWXYZ "
Text$ = "                                         "
Fill% = 176 :Row% = 8 :Col% = 20
POPWIND "UPPER CASE Only",7,18,9,62,112,1,1
LINEEDIT Allow$,Text$,Mouse%,MouseRow%,MouseCol%,Fill%,Row%,Col%,Editkey%,14

IF LEN(RTRIM$(Text$)) THEN
  Mess$(1) = "You Entered >" + RTRIM$(Text$) + "<"
  DIALOG Mess$(),"",0,Mouse%,1,0,0,4,112,1,1
END IF

Allow$ = " ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz"
Text$ = "                                         "
Fill% = 176 :Row% = 8 :Col% = 20
POPWIND "Mixed Case Characters",7,18,9,62,112,1,1
LINEEDIT Allow$,Text$,Mouse%,MouseRow%,MouseCol%,Fill%,Row%,Col%,Editkey%,14

IF LEN(RTRIM$(Text$)) THEN
  Mess$(1) = "You Entered >" + RTRIM$(Text$) + "<"
  DIALOG Mess$(),"",0,Mouse%,1,0,0,4,112,1,1
END IF

Allow$ = CHR$(25) + "abcdefghijklmnopqrstuvwxyz "
Text$ = "                                         "
Fill% = 176 :Row% = 8 :Col% = 20
POPWIND "lower case Only",7,18,9,62,112,1,1
LINEEDIT Allow$,Text$,Mouse%,MouseRow%,MouseCol%,Fill%,Row%,Col%,Editkey%,14

IF LEN(RTRIM$(Text$)) THEN
  Mess$(1) = "You Entered >" + RTRIM$(Text$) + "<"
  DIALOG Mess$(),"",0,Mouse%,1,0,0,4,112,1,1
END IF

Allow$ = "1234567890"
Text$ = "                                         "
Fill% = 176 :Row% = 8 :Col% = 20
POPWIND "Numbers Only",7,18,9,62,112,1,1
LINEEDIT Allow$,Text$,Mouse%,MouseRow%,MouseCol%,Fill%,Row%,Col%,Editkey%,14

IF LEN(RTRIM$(Text$)) THEN
  Mess$(1) = "You Entered >" + RTRIM$(Text$) + "<"
  DIALOG Mess$(),"",0,Mouse%,1,0,0,4,112,1,1
END IF

Allow$ = " ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890-=`~!@#$%^&*()_+}{[]:;'?><,./\|"
Text$ = "                                         "
Fill% = 176 :Row% = 8 :Col% = 20
POPWIND "Any Characters",7,18,9,62,112,1,1
LINEEDIT Allow$,Text$,Mouse%,MouseRow%,MouseCol%,Fill%,Row%,Col%,Editkey%,14

IF LEN(RTRIM$(Text$)) THEN
  Mess$(1) = "You Entered >" + RTRIM$(Text$) + "<"
  DIALOG Mess$(),"",0,Mouse%,1,0,0,4,112,1,1
END IF

IF Mouse% THEN HideCursor

RESTORESCREEN BaseScreen$,1,1

RETURN
'----------------------------------------------------------------------------
DataEntry:

IF Mouse% THEN HideCursor

InitString$ = "ATZ                           "
DialCom$ = "ATDT"
ComPort$ = "COM2:"
BaudRate$ = "2400  "
DataBits$ = "8"
Parity$ = "None "
StopBit$ = "1"

SaveScreen SetUpScreen$,5,12,13,68,1
Popwind "Setup Menu",5,12,13,68,31,1,1

COLOR 14,1
LOCATE 6,14,0: PRINT  "Initialization string:";
LOCATE 7,14,0: PRINT  "Dial Command:";
LOCATE 8,14,0: PRINT "Communications Port:";
LOCATE 9,14,0: PRINT "Default Baud Rate:";
LOCATE 10,14,0: PRINT "Data Bits:";
LOCATE 11,14,0: PRINT "Parity:";
LOCATE 12,14,0: PRINT "Stop Bits:";
'----------------------------------------------------------------------------
Label1:
  GOSUB RePaint
Allow$ = " ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890~%&|"
LineEdit Allow$,InitString$,Mouse%,MouseRow%,MouseCol%,176,6,37,Editkey%,14
    SELECT CASE Editkey%
      CASE 27
        GOTO Finished
      CASE -72
        GOTO Label7
      CASE -255
        IF MouseRow% > 5 AND MouseRow% < 13 AND MouseCol% > 12 AND MouseCol% < 68 THEN
          SELECT CASE MouseRow%
            CASE 6
              IF MouseCol% >= 37 AND MouseCol% <= 66 THEN GOTO Label2
            CASE 7
              IF MouseCol% >= 28 AND MouseCol% <= 31 THEN GOTO Label2
            CASE 8
              IF MouseCol% >= 35 AND MouseCol% <= 39 THEN GOTO Label3
            CASE 9
              IF MouseCol% >= 33 AND MouseCol% <= 38 THEN GOTO Label4
            CASE 10
              IF MouseCol% >= 25 AND MouseCol% <= 26 THEN GOTO Label5
            CASE 11
              IF MouseCol% >= 22 AND MouseCol% <= 26 THEN GOTO Label6
            CASE 12
              IF MouseCol% >= 25 AND MouseCol% <= 26 THEN GOTO Label7
          END SELECT
        ELSE
          GOTO Finished
        END IF
    END SELECT
'----------------------------------------------------------------------------
Label2:
  GOSUB RePaint
Allow$ = CHR$(24) + "ADPT"
LineEdit Allow$,DialCom$,Mouse%,MouseRow%,MouseCol%,176,7,28,Editkey%,14
    SELECT CASE Editkey%
      CASE 13
        Label2Pick:
        REDIM Choice$(1:3)
        Choice$(1) = "ATDT"
        Choice$(2) = "ATPT"
        ScrollBox Choice$(),DialRtrn$,"",Mouse%,3,0,Cntr%,1,14,79,6,33,1,1
        IF LEN(DialRtrn$) THEN
          DialCom$ = DialRtrn$
        END IF
      CASE 27
        GOTO Finished
      CASE -72
        GOTO Label1
      CASE -255
        IF MouseRow% > 5 AND MouseRow% < 13 AND MouseCol% > 12 AND MouseCol% < 68 THEN
          SELECT CASE MouseRow%
            CASE 6
              IF MouseCol% >= 37 AND MouseCol% <= 66 THEN GOTO Label1
            CASE 7
              IF MouseCol% >= 28 AND MouseCol% <= 31 THEN GOTO Label2Pick
            CASE 8
              IF MouseCol% >= 35 AND MouseCol% <= 39 THEN GOTO Label3
            CASE 9
              IF MouseCol% >= 33 AND MouseCol% <= 38 THEN GOTO Label4
            CASE 10
              IF MouseCol% >= 25 AND MouseCol% <= 26 THEN GOTO Label5
            CASE 11
              IF MouseCol% >= 22 AND MouseCol% <= 26 THEN GOTO Label6
            CASE 12
              IF MouseCol% >= 25 AND MouseCol% <= 26 THEN GOTO Label7
          END SELECT
        ELSE
          GOTO Finished
        END IF
    END SELECT
'----------------------------------------------------------------------------
Label3:
  GOSUB RePaint
LineEdit CHR$(24) + "1234COM:",ComPort$,Mouse%,MouseRow%,MouseCol%,176,8,35,Editkey%,14
    SELECT CASE Editkey%
      CASE 13
        Label3Pick:
        REDIM Choice$(1:3)
        Choice$(1) = "COM2:"
        Choice$(2) = "COM1:"
        ScrollBox Choice$(),ComRtrn$,"",Mouse%,3,0,Cntr%,1,14,79,7,41,1,1
        IF LEN(ComRtrn$) THEN
          ComPort$ = ComRtrn$
        END IF
      CASE 27
        GOTO Finished
      CASE -72
        GOTO Label2
      CASE -255
        IF MouseRow% > 5 AND MouseRow% < 13 AND MouseCol% > 12 AND MouseCol% < 68 THEN
          SELECT CASE MouseRow%
            CASE 6
              IF MouseCol% >= 37 AND MouseCol% <= 66 THEN GOTO Label1
            CASE 7
              IF MouseCol% >= 28 AND MouseCol% <= 31 THEN GOTO Label2
            CASE 8
              IF MouseCol% >= 35 AND MouseCol% <= 39 THEN GOTO Label3Pick
            CASE 9
              IF MouseCol% >= 33 AND MouseCol% <= 38 THEN GOTO Label4
            CASE 10
              IF MouseCol% >= 25 AND MouseCol% <= 26 THEN GOTO Label5
            CASE 11
              IF MouseCol% >= 22 AND MouseCol% <= 26 THEN GOTO Label6
            CASE 12
              IF MouseCol% >= 25 AND MouseCol% <= 26 THEN GOTO Label7
          END SELECT
        ELSE
          GOTO Finished
        END IF
    END SELECT
'----------------------------------------------------------------------------
Label4:
  GOSUB RePaint
LineEdit "0123456789",BaudRate$,Mouse%,MouseRow%,MouseCol%,176,9,33,Editkey%,14
    SELECT CASE Editkey%
      CASE 13
        Label4Pick:
        REDIM Choice$(1:15)
        Choice$(1) = "    75"
        Choice$(2) = "   110"
        Choice$(3) = "   150"
        Choice$(4) = "   300"
        Choice$(5) = "   600"
        Choice$(6) = "  1200"
        Choice$(7) = "  1800"
        Choice$(8) = "  2400"
        Choice$(9) = "  4800"
        Choice$(10) = "  9600"
        Choice$(11) = " 19200"
        Choice$(12) = " 38400"
        Choice$(13) = " 57600"
        Choice$(14) = "115200"
        ScrollBox Choice$(),BaudRtrn$,"",Mouse%,7,0,Cntr%,8,14,79,8,40,1,1
        IF LEN(BaudRtrn$) THEN
          BaudRate$ = LEFT$(BaudRtrn$ + "    ",6)
        END IF
      CASE 27
        GOTO Finished
      CASE -72
        GOTO Label3
      CASE -255
        IF MouseRow% > 5 AND MouseRow% < 13 AND MouseCol% > 12 AND MouseCol% < 68 THEN
          SELECT CASE MouseRow%
            CASE 6
              IF MouseCol% >= 37 AND MouseCol% <= 66 THEN GOTO Label1
            CASE 7
              IF MouseCol% >= 28 AND MouseCol% <= 31 THEN GOTO Label2
            CASE 8
              IF MouseCol% >= 35 AND MouseCol% <= 39 THEN GOTO Label3
            CASE 9
              IF MouseCol% >= 33 AND MouseCol% <= 38 THEN GOTO Label4Pick
            CASE 10
              IF MouseCol% >= 25 AND MouseCol% <= 26 THEN GOTO Label5
            CASE 11
              IF MouseCol% >= 22 AND MouseCol% <= 26 THEN GOTO Label6
            CASE 12
              IF MouseCol% >= 25 AND MouseCol% <= 26 THEN GOTO Label7
          END SELECT
        ELSE
          GOTO Finished
        END IF
    END SELECT
'----------------------------------------------------------------------------
Label5:
  GOSUB RePaint
LineEdit "8765",DataBits$,Mouse%,MouseRow%,MouseCol%,176,10,25,Editkey%,14
    SELECT CASE Editkey%
      CASE 13
        Label5Pick:
        REDIM Choice$(1:5)
        Choice$(1) = "8"
        Choice$(2) = "7"
        Choice$(3) = "6"
        Choice$(4) = "5"
        ScrollBox Choice$(),DataRtrn$,"",Mouse%,5,0,Cntr%,1,14,79,9,27,1,1
        IF LEN(DataRtrn$) THEN
          DataBits$ = DataRtrn$
        END IF
      CASE 27
        GOTO Finished
      CASE -72
        GOTO Label4
      CASE -255
        IF MouseRow% > 5 AND MouseRow% < 13 AND MouseCol% > 12 AND MouseCol% < 68 THEN
          SELECT CASE MouseRow%
            CASE 6
              IF MouseCol% >= 37 AND MouseCol% <= 66 THEN GOTO Label1
            CASE 7
              IF MouseCol% >= 28 AND MouseCol% <= 31 THEN GOTO Label2
            CASE 8
              IF MouseCol% >= 35 AND MouseCol% <= 39 THEN GOTO Label3
            CASE 9
              IF MouseCol% >= 33 AND MouseCol% <= 38 THEN GOTO Label4
            CASE 10
              IF MouseCol% >= 25 AND MouseCol% <= 26 THEN GOTO Label5Pick
            CASE 11
              IF MouseCol% >= 22 AND MouseCol% <= 26 THEN GOTO Label6
            CASE 12
              IF MouseCol% >= 25 AND MouseCol% <= 26 THEN GOTO Label7
          END SELECT
        ELSE
          GOTO Finished
        END IF
    END SELECT
'----------------------------------------------------------------------------
Label6:
  GOSUB RePaint
Allow$ = "NoEvenOdMarkSpc"
LineEdit Allow$,Parity$,Mouse%,MouseRow%,MouseCol%,176,11,22,Editkey%,14
    SELECT CASE Editkey%
      CASE 13
        Label6Pick:
        REDIM Choice$(1:6)
        Choice$(1) = "None "
        Choice$(2) = "Even "
        Choice$(3) = "Odd  "
        Choice$(4) = "Mark "
        Choice$(5) = "Space"
        ScrollBox Choice$(),ParaRtrn$,"",Mouse%,6,0,Cntr%,1,14,79,10,28,1,1
        IF LEN(ParaRtrn$) THEN
          Parity$ = ParaRtrn$
        END IF
      CASE 27
        GOTO Finished
      CASE -72
        GOTO Label5
      CASE -255
        IF MouseRow% > 5 AND MouseRow% < 13 AND MouseCol% > 12 AND MouseCol% < 68 THEN
          SELECT CASE MouseRow%
            CASE 6
              IF MouseCol% >= 37 AND MouseCol% <= 66 THEN GOTO Label1
            CASE 7
              IF MouseCol% >= 28 AND MouseCol% <= 31 THEN GOTO Label2
            CASE 8
              IF MouseCol% >= 35 AND MouseCol% <= 39 THEN GOTO Label3
            CASE 9
              IF MouseCol% >= 33 AND MouseCol% <= 38 THEN GOTO Label4
            CASE 10
              IF MouseCol% >= 25 AND MouseCol% <= 26 THEN GOTO Label5
            CASE 11
              IF MouseCol% >= 22 AND MouseCol% <= 26 THEN GOTO Label6Pick
            CASE 12
              IF MouseCol% >= 25 AND MouseCol% <= 26 THEN GOTO Label7
          END SELECT
        ELSE
          GOTO Finished
        END IF
    END SELECT
'----------------------------------------------------------------------------
Label7:
  GOSUB RePaint
LineEdit "12",StopBit$,Mouse%,MouseRow%,MouseCol%,176,12,25,Editkey%,14
    SELECT CASE Editkey%
      CASE 13
        Label7Pick:
        REDIM Choice$(1:3)
        Choice$(1) = "1"
        Choice$(2) = "2"
        ScrollBox Choice$(),StopRtrn$,"",Mouse%,6,0,Cntr%,1,14,79,10,28,1,1
        IF LEN(StopRtrn$) THEN
          StopBit$ = StopRtrn$
        END IF
      CASE 27
        GOTO Finished
      CASE -72
        GOTO Label6
      CASE -80
        GOTO Label1
      CASE -255
        IF MouseRow% > 5 AND MouseRow% < 13 AND MouseCol% > 12 AND MouseCol% < 68 THEN
          SELECT CASE MouseRow%
            CASE 6
              IF MouseCol% >= 37 AND MouseCol% <= 66 THEN GOTO Label1
            CASE 7
              IF MouseCol% >= 28 AND MouseCol% <= 31 THEN GOTO Label2
            CASE 8
              IF MouseCol% >= 35 AND MouseCol% <= 39 THEN GOTO Label3
            CASE 9
              IF MouseCol% >= 33 AND MouseCol% <= 38 THEN GOTO Label4
            CASE 10
              IF MouseCol% >= 25 AND MouseCol% <= 26 THEN GOTO Label5
            CASE 11
              IF MouseCol% >= 22 AND MouseCol% <= 26 THEN GOTO Label6
            CASE 12
              IF MouseCol% >= 25 AND MouseCol% <= 26 THEN GOTO Label7Pick
          END SELECT
        ELSE
          GOTO Finished
        END IF
    END SELECT
'----------------------------------------------------------------------------
Finished:

GOSUB RePaint

DELAY 2

RestoreScreen SetUpScreen$,5,12

RETURN
'----------------------------------------------------------------------------
RePaint:

LineEdit "",InitString$,0,0,0,176,6,37,255,31
LineEdit "",DialCom$,0,0,0,176,7,28,255,31
LineEdit "",ComPort$,0,0,0,176,8,35,255,31
LineEdit "",BaudRate$,0,0,0,176,9,33,255,31
LineEdit "",DataBits$,0,0,0,176,10,25,255,31
LineEdit "",Parity$,0,0,0,176,11,22,255,31
LineEdit "",StopBit$,0,0,0,176,12,25,255,31

RETURN
'----------------------------------------------------------------------------
DNAWriteDemo:

IF LEN(DIR$("DNAWRITE.EXE")) THEN
  MEMPACK
  IF Mouse% THEN HideCursor
  SaveScreen Dos$,1,1,25,80,0
  SHELL "DNAWRITE.EXE"
  IF Mouse% THEN HideCursor
  RestoreScreen Dos$,1,1
ELSE
  GOSUB ErrorMessage
END IF

RETURN
'----------------------------------------------------------------------------
SingleEditBox:

TextOne$ = SPACE$(45)
Allow$ = CHR$(24) + "ABCDEFGHIJKLMNOPQRSTUVWXYZ "
EditBox "Prompt String:",TextOne$,Allow$,Mouse%,176,6,79,14,112,1,1
TextOne$ = RTRIM$(TextOne$)

IF LEN(TextOne$) THEN
  Mess$(1) = "You Entered >" + TextOne$ + "<"
  Mess$(2) = ""
  DIALOG Mess$(),"",0,Mouse%,1,0,0,4,112,1,1
END IF

RETURN
'----------------------------------------------------------------------------
DoubleEditBox:

TextOne$ = SPACE$(40)
TextTwo$ = SPACE$(40)
Allow$ = " ACEGIKMOQSUWYbdfhjlnprtvxz24680"
DoubleBox "First Prompt:","Second Prompt:",TextOne$,TextTwo$,Allow$,Mouse%,255,176,6,79,14,112,1,1
TextOne$ = RTRIM$(TextOne$)
TextTwo$ = RTRIM$(TextTwo$)

IF LEN(TextOne$) AND LEN(TextTwo$) THEN
  Mess$(1) = "You Entered >" + TextOne$ + "<"
  Mess$(2) = "You Entered >" + TextTwo$ + "<"
  DIALOG Mess$(),"",0,Mouse%,1,0,0,4,112,1,1
END IF

RETURN
'----------------------------------------------------------------------------
PopwindDemo:

IF Mouse% THEN HideCursor

SAVESCREEN BaseScreen$,1,1,25,80,0
tr% = 12 :lc% = 28 :br% = 14 :rc% = 53

FOR i% = 1 TO 10
  POPWIND "",tr%,lc%,br%,rc%,112,0,1
  DECR tr% :INCR br% :DECR lc%,3 :INCR rc%,3
  FOR j% = 1 TO 10000
  NEXT j%
NEXT i%

DELAY .5

FOR l% = 1 TO 2
  FOR k% = 1 TO 5
    fg% = 15 :bg% = k% :bdr% = k% :shd% = 0
    IF l% = 2 THEN shd% = 1
    MakeByte DAttr%,fg%,bg%
    POPWIND "",5,14,21,68,DAttr%,shd%,bdr%
    DELAY .6
  NEXT k%
NEXT l%

DELAY .6
tr% = 3 :lc% = 1 :br% = 23 :rc% = 80

FOR i% = 1 TO 10
  POPWIND "",tr%,lc%,br%,rc%,112,0,1
  INCR tr% :DECR br% :INCR lc%,3 :DECR rc%,3
  FOR j% = 1 TO 2000
  NEXT j%
NEXT i%

IF Mouse% THEN HideCursor

RESTORESCREEN BaseScreen$,1,1

RETURN
'----------------------------------------------------------------------------
SaveRestoreDemo:

IF Mouse% THEN HideCursor

SAVESCREEN BaseScreen$,1,1,25,80,0
DELAY .5
SAVESCREEN Screen1$,4,2,12,39,0
POPWIND "Window 1",4,2,12,39,78,0,1
SAVESCREEN Window1$,4,2,12,39,0
DELAY .5
SAVESCREEN Screen2$,4,42,12,79,0
POPWIND "Window 2",4,42,12,79,31,0,2
SAVESCREEN Window2$,4,42,12,79,0
DELAY .5
SAVESCREEN Screen3$,14,2,22,39,0
POPWIND "Window 3",14,2,22,39,44,0,3
SAVESCREEN Window3$,14,2,22,39,0
DELAY .5
SAVESCREEN Screen4$,14,42,22,79,0
POPWIND "Window 4",14,42,22,79,110,0,4
SAVESCREEN Window4$,14,42,22,79,0
DELAY .5
SAVESCREEN Screen5$,5,5,21,77,0
POPWIND "Window 5",5,5,21,77,14,0,2
SAVESCREEN Window5$,5,5,21,77,0
DELAY .5
RESTORESCREEN Screen5$,5,5
DELAY .5
RESTORESCREEN Screen4$,14,42
DELAY .5
RESTORESCREEN Screen1$,4,2
DELAY .5
RESTORESCREEN Screen3$,14,2
DELAY .5
RESTORESCREEN Screen2$,4,42
DELAY .5
FOR i% = 1 TO 5
  RESTORESCREEN Window1$,4,2
  RESTORESCREEN Window2$,4,42
  RESTORESCREEN Window3$,14,2
  RESTORESCREEN Window4$,14,42
  DELAY .1
  RESTORESCREEN Window2$,4,2
  RESTORESCREEN Window3$,4,42
  RESTORESCREEN Window4$,14,2
  RESTORESCREEN Window1$,14,42
  DELAY .1
  RESTORESCREEN Window3$,4,2
  RESTORESCREEN Window4$,4,42
  RESTORESCREEN Window1$,14,2
  RESTORESCREEN Window2$,14,42
  DELAY .1
  RESTORESCREEN Window4$,4,2
  RESTORESCREEN Window1$,4,42
  RESTORESCREEN Window2$,14,2
  RESTORESCREEN Window3$,14,42
  DELAY .1
  RESTORESCREEN Window1$,4,2
  RESTORESCREEN Window2$,4,42
  RESTORESCREEN Window3$,14,2
  RESTORESCREEN Window4$,14,42
  DELAY .1
NEXT i%
RESTORESCREEN Window5$,5,5
DELAY .5
RESTORESCREEN Window2$,4,42
DELAY .5
RESTORESCREEN Window5$,5,5
DELAY .5
RESTORESCREEN Window1$,4,2
DELAY .5
RESTORESCREEN Window5$,5,5
DELAY .5
RESTORESCREEN Window4$,14,42
DELAY .5
RESTORESCREEN Window5$,5,5
DELAY .5
RESTORESCREEN Window3$,14,2
DELAY .5
RESTORESCREEN Window5$,5,5
DELAY .5
SAVESCREEN Corner1$,4,2,12,39,0
SAVESCREEN Corner2$,4,42,12,79,0
SAVESCREEN Corner3$,14,2,22,39,0
SAVESCREEN Corner4$,14,42,22,79,0
RESTORESCREEN Corner4$,4,2
RESTORESCREEN Corner1$,14,42
RESTORESCREEN Corner2$,14,2
RESTORESCREEN Corner3$,4,42
DELAY 2

IF Mouse% THEN HideCursor

RESTORESCREEN BaseScreen$,1,1

RETURN
'----------------------------------------------------------------------------
BrowseDemo:

IF LEN(DIR$("DNA.DOC")) THEN
  BROWSE "DNA.DOC",Mouse%,14,3,1,23,80,31,0,3
ELSE
  GOSUB ErrorMessage
END IF

RETURN
'----------------------------------------------------------------------------
DialogDemo:

DMess$(1) = "Dialog will dynamicaly size to the message you want to"
DMess$(2) = "display. And will allow you either to centre it on the"
DMess$(3) = "screen or place it anywhere you like."
DMess$(4) = "It will centre the text in the box for you as well."
DMess$(5) = "Dialog saves the area under the box and then waits"
DMess$(6) = "for a key press before it restores the screen."
DMess$(7) = "NEW. you can now pass Dialog how may seconds to"
DMess$(8) = "display on screen or leave the field blank and"
DMess$(9) = "wait for a key press."

DIALOG DMess$(),"Dialog box Demo",2,Mouse%,1,0,0,0,116,1,1
DELAY .2

DIALOG DMess$(),"Dialog box Demo",2,Mouse%,2,4,4,0,116,1,1
DELAY .2

DIALOG DMess$(),"Dialog box Demo",0,Mouse%,3,0,0,0,116,1,1

RETURN
'----------------------------------------------------------------------------
ScrollBoxDemo:

FOR Num% = 1 TO 100
  DemoName$(Num%) = CHR$(Num% + 32) + " This is Choice number " + STR$(Num%)
NEXT Num%

SCROLLBOX DemoName$(),PickName$,"Scroll Box Demo",Mouse%,10,0,1,0,14,112,0,0,1,1

IF LEN(PickName$) THEN
  Mess$(1) = "You Picked > " + PickName$ + " <"
  Mess$(2) = ""
  DIALOG Mess$(),"",0,Mouse%,1,0,0,4,112,1,1
END IF

SCROLLBOX DemoName$(),PickName$,"Scroll Box Demo",Mouse%,17,0,0,0,14,112,4,3,1,1

IF LEN(PickName$) THEN
  Mess$(1) = "You Picked > " + PickName$ + " <"
  Mess$(2) = ""
  DIALOG Mess$(),"",0,Mouse%,1,0,0,4,112,1,1
END IF


RETURN
'----------------------------------------------------------------------------
VirtualBoxDemo:

FOR Num% = 1 TO 100
  DemoName$(Num%) = CHR$(Num% + 32) + " This is to simulate a very wide Choice number " + STR$(Num%) + " that is wider than the eighty columns that are allowed"
NEXT Num%

VirtualBox DemoName$(),PickName$,"Virtual Box Demo",Mouse%,10,0,1,70,14,112,0,0,1,1

IF LEN(PickName$) THEN
  Mess$(1) = "You Picked > " + MID$(PickName$,35,18) + " <"
  Mess$(2) = ""
  DIALOG Mess$(),"",0,Mouse%,1,0,0,4,112,1,1
END IF

VirtualBox DemoName$(),PickName$,"Virtual Box Demo",Mouse%,16,0,0,40,14,112,4,3,1,1

IF LEN(PickName$) THEN
  Mess$(1) = "You Picked > " + MID$(PickName$,35,18) + " <"
  Mess$(2) = ""
  DIALOG Mess$(),"",0,Mouse%,1,0,0,4,112,1,1
END IF

RETURN
'----------------------------------------------------------------------------
CalcBoxDemo:

CalcBox Mouse%,176,6,47,79,14,112,1,1

RETURN
'----------------------------------------------------------------------------
LotusDemo:

IF Mouse% THEN HideCursor

DEF SEG = &HB800
BaseScreen$ = PEEK$(0,4000)

Menu$(1) = "@Open"
Menu$(2) = "@Create"
Menu$(3) = "@List"
Menu$(4) = "@Browse"
Menu$(5) = "@Add"
Menu$(6) = "@Delete"
Menu$(7) = "E@xtract"
Menu$(8) = "@Print"
Menu$(9) = "@Kill"
Menu$(10) = "@Erase"
Menu$(11) = "@Quit"

Info$(1) = "Open a PowerBASIC Library for modification"
Info$(2) = "Create a PowerBASIC Library"
Info$(3) = "List the OBJ's or PBU modules in a PowerBASIC Library"
Info$(4) = "Browse the current List/Map File"
Info$(5) = "Add OBJ's or PBU modules to a New or Existing PowerBASIC Library"
Info$(6) = "Delete OBJ's or PBU modules from an Existing PowerBASIC Library"
Info$(7) = "Extract OBJ's or PBU modules from an Existing PowerBASIC Library"
Info$(8) = "Print the currently selected library Map File"
Info$(9) = "Delete a PowerBASIC Library File from Disk"
Info$(10) = "Erase OBJ's or PBU modules from DNA Library Managers work Directory"
Info$(11) = "Quit the DNA Library Manager"

LPointer% = 1
POPWIND "",1,1,2,80,0,0,0
POPWIND "",3,1,25,80,31,0,1
COLOR 7,1

Jump:

LOTUS Menu$(),Info$(),HiLight%,Mouse%,LPointer%,14,14,79,7,112,1,2


IF LPointer% > 0 AND LPointer% < 11 THEN
  PasteIn$ = REMOVE$(Menu$(LPointer%),"@")
  Mess$(1) = "You Picked > " + PasteIn$ + " <"
  Mess$(2) = ""
  DIALOG Mess$(),"",0,Mouse%,1,0,0,4,112,1,1
ELSE
  IF LPointer% = 11 THEN Ky$ = CHR$(27):GOTO WayOut
END IF

DO
DELAY .5
WHILE NOT INSTAT
  IF Mouse% THEN
    ShowCursor: Rgt% = 0: Lft% = 0
    Clicked Rgt%,Lft%,MRow%,MCol%
    IF Lft% AND MRow% = 1 THEN
      FindMenu MRow%,MCol%,Found%
      IF Found% THEN
        LPointer% = Found%
        HideCursor: HiLight% = 1
        GOTO Jump
      END IF
    END IF
  END IF
  IF AltKey% THEN
    HiLight% = 1
    IF LPointer% = 0 THEN LPointer% = 1
    GOTO Jump
  END IF
WEND

Ky$ = INKEY$

WayOut:

LOOP UNTIL Ky$ = CHR$(27)

IF Mouse% THEN HideCursor

DEF SEG = &HB800
POKE$ 0,BaseScreen$
DEF SEG

RETURN
'----------------------------------------------------------------------------
ScrollMenuDemo:

Menu$(1) = "@Open"
Menu$(2) = "@Create"
Menu$(3) = "@List"
Menu$(4) = "@Browse"
Menu$(5) = "@Add"
Menu$(6) = "@Delete"
Menu$(7) = "E@xtract"
Menu$(8) = "@Print"
Menu$(9) = "@Kill"
Menu$(10) = "@Erase"
Menu$(11) = "@Quit"

Info$(1) = "Open a PowerBASIC Library for modification"
Info$(2) = "Create a PowerBASIC Library"
Info$(3) = "List the OBJ's or PBU modules in a Library"
Info$(4) = "Browse the current List/Map File"
Info$(5) = "Add OBJ's or PBU modules to a Library"
Info$(6) = "Delete OBJ's or PBU modules from Library"
Info$(7) = "Extract OBJ's or PBU modules"
Info$(8) = "Print the currently selected library Map File"
Info$(9) = "Delete a PowerBASIC Library File from Disk"
Info$(10) = "Erase OBJ's or PBU modules from work Directory"
Info$(11) = "Quit the DNA Library Manager"

ScrollMenu Menu$(),Info$(),Rtrn$,Mouse%,12,0,1,4,HelpTextColor%,HelpAttr%,14,112,0,0,1,1

IF LEN(Rtrn$) THEN
  Mess$(1) = "You Picked > " + Rtrn$ + " <"
  Mess$(2) = ""
  DIALOG Mess$(),"",0,Mouse%,1,0,0,4,112,1,1
END IF

ScrollMenu Menu$(),Info$(),Rtrn$,Mouse%,5,0,1,4,HelpTextColor%,HelpAttr%,14,112,0,0,1,1

IF LEN(Rtrn$) THEN
  Mess$(1) = "You Picked > " + Rtrn$ + " <"
  Mess$(2) = ""
  DIALOG Mess$(),"",0,Mouse%,1,0,0,4,112,1,1
END IF

ScrollMenu Menu$(),Info$(),Rtrn$,Mouse%,12,0,0,4,HelpTextColor%,HelpAttr%,14,112,4,4,1,1

IF LEN(Rtrn$) THEN
  Mess$(1) = "You Picked > " + Rtrn$ + " <"
  Mess$(2) = ""
  DIALOG Mess$(),"",0,Mouse%,1,0,0,4,112,1,1
END IF

RETURN
'----------------------------------------------------------------------------
DirectoryBoxDemo:

DirectoryBox FileName$,Mouse%,112,14,79,1,1

IF LEN(FileName$) THEN
  Mess$(1) = "You Picked > " + FileName$ + " <"
  Mess$(2) = ""
  DIALOG Mess$(),"",0,Mouse%,1,0,0,4,112,1,1
END IF

RETURN
'----------------------------------------------------------------------------
PickBoxDemo:

i% = 1
FDirectory$(i%) = DIR$("*.*")
DO
  INCR i%
  FDirectory$(i%) = DIR$
  IF i% = 500 THEN EXIT LOOP
LOOP WHILE FDirectory$(i%) <> ""

PickBox FDirectory$(),Picked$,"Listing of Files in the current directory",3,0,Mouse%,112,14,79,1,1

IF LEN(Picked$) THEN
  Mess$(1) = "You Picked > " + Picked$ + " <"
  Mess$(2) = ""
  DIALOG Mess$(),"",0,Mouse%,1,0,0,4,112,1,1
END IF

RETURN
'----------------------------------------------------------------------------
WriteToBoxDemo:

WriteToBox Rtrn$,"FILENAME.EXT",Mouse%,112,14,79,1,1

IF LEN(Rtrn$) THEN
  Mess$(1) = "You Picked > " + Rtrn$ + " <"
  Mess$(2) = ""
  DIALOG Mess$(),"",0,Mouse%,1,0,0,4,112,1,1
END IF

RETURN
'----------------------------------------------------------------------------
AskDemo:

Rtrn% = 1
ASK "Hit Return to Accept",Mouse%,Rtrn%,10,15,0,158,1,2
  SELECT CASE Rtrn%
    CASE 0
     Mess$(1) = " You Answered NO "
    CASE 1
     Mess$(1) = " You Answered YES "
    CASE 2
     Mess$(1) = " You CANCELED "
  END SELECT

Mess$(2) = ""
DIALOG Mess$(),"",0,Mouse%,1,0,0,4,112,1,1

RETURN
'----------------------------------------------------------------------------
MayBeDemo:

MayBe "MayBe you dont want to Answer ? (Y or N or Esc)",Answer%,Mouse%,10,79,112%,1,1
  SELECT CASE Answer%
    CASE 0
     Mess$(1) = " You Answered NO "
    CASE 1
     Mess$(1) = " You Answered YES "
    CASE 2
     Mess$(1) = " You CANCELED "
  END SELECT

Mess$(2) = ""
DIALOG Mess$(),"",0,Mouse%,1,0,0,4,112,1,1

RETURN
'----------------------------------------------------------------------------
YesNoDemo:

IF YesNo%("Answer Yes or No ? (Y or N)",Mouse%,10,112,31,1,1) THEN
  Mess$(1) = " You Answered YES "
ELSE
  Mess$(1) = " You Answered NO "
END IF

Mess$(2) = ""
DIALOG Mess$(),"",0,Mouse%,1,0,0,4,112,1,1

RETURN
'----------------------------------------------------------------------------
QuestionDemo:
REDIM TempMessage$(1:2)
CorrectAnswer$ = "y"
TempMessage$(1) = "DNA Library is the best freeware library available ?"

IF Question%(TempMessage$(),CorrectAnswer$,Mouse%,31,112,4,1,1) THEN
  Noise 1
ELSE
  Noise 6
END IF
'----------------------------------------------------------------------------
REDIM TempMessage$(1:7)
CorrectAnswer$ = "c"
TempMessage$(1) = "The best Basic compiler on the market is?"
TempMessage$(2) = " "
TempMessage$(3) = "(A) MicroSoft Visual Basic for Dos."
TempMessage$(4) = "(B) GFA Basic for Dos."
TempMessage$(5) = "(C) PowerBASIC version 3."
TempMessage$(6) = "(D) None of the above"

IF Question%(TempMessage$(),CorrectAnswer$,Mouse%,31,112,4,1,1) THEN
  Noise 1
ELSE
  Noise 6
END IF
'----------------------------------------------------------------------------
REDIM TempMessage$(1:3)
CorrectAnswer$ = "t"
TempMessage$(1) = "This is a good routine and may"
TempMessage$(2) = "come in handy some day."

IF Question%(TempMessage$(),CorrectAnswer$,Mouse%,31,112,4,1,1) THEN
  Noise 1
ELSE
  Noise 6
END IF

RETURN
'----------------------------------------------------------------------------
FutureFeatures:

Future$(1) = "I am currently working on an ASCII / ANSI communications terminal"
Future$(2) = "with XModem transfer, and dialing directory etc so keep watching."
Future$(3) = "I am also working on a virtual form generator, and various other"
Future$(4) = "goodies, which I expect will take a few months to finish."
Future$(5) = "And last but probably most importantly."
Future$(6) = "The Manual and online help will be ready for this fall."



DIALOG Future$(),VRtrn$ + " Features",0,Mouse%,3,0,0,4,112,1,1

RETURN
'----------------------------------------------------------------------------
AboutDNA:

About$(1) = "DNA Library for PowerBASIC version 3"
About$(2) = "by Chris Foot"
About$(3) = " "
About$(4) = "DNALIB is totally free and comes with source code"
About$(5) = "for you to modify to your own needs.  Please dont"
About$(6) = "distribute modified copies of DNALIB, if you find"
About$(7) = "a bug please let me know.   If you have any ideas"
About$(8) = "for improvements, or routines for the library.   "
About$(9) = " "
About$(10) = "I can be reached on BASNET in the PowerBASIC echo"
About$(11) = "or at this address                               "
About$(12) = "                               15305 - 117 avenue"
About$(13) = "                                Edmonton, Alberta"
About$(14) = "FAX (403)452-5969                 CANADA, T5M 3X4"

DIALOG About$(),"",0,Mouse%,3,0,0,14,31,1,1

RETURN
'----------------------------------------------------------------------------
ErrorMessage:

EMess$(1) = "In order to fully run all the Demos"
EMess$(2) = "there are several files which need to"
EMess$(3) = "be in the current directory."
EMess$(4) = "These are the files required for the Demo."
EMess$(5) = "DNAWRITE.EXE & DNA.DOC"
EMess$(6) = " "
EMess$(7) = "Also run the MAKEHELP.BAT and then press F1"
EMess$(8) = "when any of the menus are down, or you are"
EMess$(9) = "viewing the Lotus or ScrollMenu Demos."

DIALOG EMess$(),"",0,Mouse%,3,0,0,0,116,1,1

RETURN
'----------------------------------------------------------------------------
