'============================================================================
'
'    MOUSE.BAS - Mouse Support Routines for the User Interface Toolbox in
'           Microsoft BASIC 7.1, Professional Development System
'              Copyright (C) 1987-1990, Microsoft Corporation
'
' NOTE:     This sample source code toolbox is intended to demonstrate some
'           of the extended capabilities of Microsoft BASIC 7.1 Professional
'           Development system that can help to leverage the professional
'           developer's time more effectively.  While you are free to use,
'           modify, or distribute the routines in this module in any way you
'           find useful, it should be noted that these are examples only and
'           should not be relied upon as a fully-tested "add-on" library.
'
'  PURPOSE: These routines are required for mouse support in the user
'           interface toolbox, but they may be used independently as well.
'
'
'============================================================================

DEFINT A-Z
CONST True = -1, False = 0
TYPE RegType
     Ax    AS INTEGER
     Bx    AS INTEGER
     Cx    AS INTEGER
     Dx    AS INTEGER
     bp    AS INTEGER
     si    AS INTEGER
     di    AS INTEGER
     flags AS INTEGER
END TYPE

'in CSRASM.ASM:
DECLARE SUB Interrupt51 (Ax, Bx, Cx, Dx)

DECLARE SUB MouseBorder (row1, col1, row2, col2)
DECLARE SUB MouseDriver (m0, m1, m2, m3)
DECLARE SUB MouseHide ()
DECLARE FUNCTION MouseInit ()
DECLARE SUB MousePoll (row, col, lbutton, rButton)
DECLARE SUB MouseSet (x, y)
DECLARE SUB MouseShow ()

SUB MouseBorder (row1, col1, row2, col2) STATIC

    ' =======================================================================
    ' Sets max and min bounds on mouse movement both vertically, and
    ' horizontally
    ' =======================================================================

    MouseDriver 7, 0, col1, col2
    MouseDriver 8, 0, row1, row2

END SUB

SUB MouseDriver (m0, m1, m2, m3) STATIC

    DIM regs AS RegType
    SHARED MousePresent

    IF MouseChecked = False THEN
        DEF SEG = 0

        MouseSegment& = 256& * PEEK(207) + PEEK(206)
        MouseOffset& = 256& * PEEK(205) + PEEK(204)

        DEF SEG = MouseSegment&

        IF (MouseSegment& = 0 AND MouseOffset& = 0) OR PEEK(MouseOffset&) = 207 THEN
            MousePresent = False
            MouseChecked = True
            DEF SEG
        END IF
    END IF

    IF MousePresent = False AND MouseChecked = True THEN
        EXIT SUB
    END IF

    ' =======================================================================
    ' Calls interrupt 51 to invoke mouse functions in the MS Mouse Driver.
    ' =======================================================================
    
    Interrupt51 m0, m1, m2, m3

    IF MouseChecked THEN EXIT SUB

    ' =======================================================================
    ' Check for successful mouse initialization
    ' =======================================================================

    IF m0 AND NOT MouseChecked THEN
        MousePresent = True
        DEF SEG
    END IF

    MouseChecked = True
    
END SUB

SUB MouseHide

    ' =======================================================================
    ' Decrements internal cursor flag
    ' =======================================================================

   MouseDriver 2, 0, 0, 0

END SUB

FUNCTION MouseInit
    SHARED MousePresent
    ' =======================================================================
    ' Mouse driver's initialization routine
    ' =======================================================================

    MouseDriver 0, 0, 0, 0
    MouseInit = MousePresent

END FUNCTION

SUB MousePoll (row, col, lbutton, rButton) STATIC

    ' =======================================================================
    ' Polls mouse driver, then sets parms correctly
    ' =======================================================================

    MouseDriver 3, button, col, row
                                                
    IF button AND 1 THEN
        lbutton = True
    ELSE
        lbutton = False
    END IF

    IF button AND 2 THEN
        rButton = True
    ELSE
        rButton = False
    END IF

END SUB

SUB MouseSet (x, y)
    MouseDriver 4, 0, x, y
END SUB

SUB MouseShow

    ' =======================================================================
    ' Increments mouse's internal cursor flag
    ' =======================================================================

    MouseDriver 1, 0, 0, 0

END SUB

