'*****************************************************************************
' Smooth Text Mode Cursor Routines v1.1 for PDS and QB 4.5
' By Rich Geldreich July, 1992
' (QB4.5 users: I haven't tested these routines with QB yet, only PDS.
'  so if they don't work in QB, you know why.)
'
' The following routines are in the public domain.
'
' The driver should work on color VGA's and possibly EGA's (I haven't
' tested it on an EGA yet). It should also work in any text mode,
' from the dreaded 40x25 mode all the way up to 132x44...
' I've tested it on a TSENG ET4000 and a normal color VGA, and all
' seems fine. NOTE: while this driver is being used, the characters
' allocated for the cursor cannot be used anywhere else on the screen!
' Currently, characters 201 through 209 are used. To change this, modify
' the "firstchar" constant below.
'
' These routines cannot be used under DESQView. To detect DESQView, use
' something similar to this:
'
'   mov     ax, 02b01h
'   mov     cx, 04445h
'   mov     dx, 05351h
'   int     21h
'   cmp     al, 0ffh       ;Is DV there?
'   je      NODV
'   DV = True              ;DV is present - don't use smooth cursor
' NODV:
'
' I would of included this routine in this program, but since I don't
' have DESQView I wouldn't have any way to test it out...
'
'
' rg.cursor.deinit - Turns off the cursor(if it's visible), and restores
' the original bitmaps of the character cells the cursor took over.
' Must be called before your program ends, or otherwise the user will
' see some strange sights when another program is run!
'
' rg.cursor.init () - Initializes the cursor array, checks some BIOS vars
' for the current text mode, saves the character cells the cursor will
' occupy, possibly turns off the cursor if it's visible, and initializes
' the mouse driver. Must be called before any other routine in this driver.
' Returns False if a mouse driver isn't installed.
'
' rg.off.area (x.low,y.low,x.high,y.high) - Selectively turns off the
' cursor if it's in the specified area. Instead of always turning of the
' cursor when you update the screen, it's better to only turn it off if
' it's in danger of been overwritten by new, unexpected data. This improves
' both the speed and look of the cursor.
'
' rg.move.cursor (x,y,button.1,button.2,update.flag) - Polls the mouse
' driver and returns LOCATE compatible x,y coordinates and the buttons'
' states. If update.flag <> 0 then the cursor's position will be updated.
'
' rg.off.cursor () - Erases the cursor(if it's visible).
'
' When I get time additional code will be added to detect if the smooth
' cursor will work or not. If it cannot, then all calls to this driver
' will just be passed to the normal mouse driver.
'*****************************************************************************

DEFINT A-Z
'First released on 7-15-92
'Improvements made 7-18-92

CONST True = -1, False = 0

'Modify this constant to change which characters the driver uses.
'If firstchar=&HC9, for example, characters 201 through 209 will be
'allocated for the cursor. This constant should be in the range of
'&HC0 to &HD7, or else the pointer will have a vertical "gap" in it.

CONST firstchar = &HC9

'Routines in MOU.BAS (an example program which came with PDS from Microsoft)
DECLARE SUB MouseBorder (row1, col1, row2, col2)
DECLARE FUNCTION MouseInit ()
DECLARE SUB MousePoll (row, col, lButton, rButton)
DECLARE SUB MouseSet (x, y)

'Routines in this CSRBAS.BAS (this program, if you didn't already know)
DECLARE SUB rg.cursor.deinit ()
DECLARE FUNCTION rg.cursor.init ()
DECLARE SUB rg.move.cursor (current.x, current.y, button.1, button.2, update.flag)
DECLARE SUB rg.off.area (x.low, y.low, x.high, y.high)
DECLARE SUB rg.off.cursor ()

'Routines in CSRASM.ASM
DECLARE SUB VOn ()
DECLARE SUB VOff ()
DECLARE SUB ShrMask (BYVAL mask AS LONG, BYVAL ShiftCount AS INTEGER, c0, c1, c2)
DECLARE SUB Interrupt51 (Ax, Bx, Cx, Dx)

DIM SHARED pointer(15) AS LONG, mask(15) AS LONG
DIM SHARED chars(8), oldbitmaps(287)

'Use the program MAKECSR.BAS to design your own mouse cursor & mask.
'(The masks is AND'd with the 'screen', then cursor is OR'd with whatever
'is left over.)
cursor:
DATA &H00000000,&HFF3FFFFF,&H00400000,&HFF1FFFFF
DATA &H00600000,&HFF0FFFFF,&H00700000,&HFF07FFFF
DATA &H00780000,&HFF03FFFF,&H007C0000,&HFF01FFFF
DATA &H007E0000,&HFF00FFFF,&H007F0000,&HFF007FFF
DATA &H007F8000,&HFF003FFF,&H007FC000,&HFF001FFF
DATA &H007FE000,&HFF000FFF,&H007FF000,&HFF0007FF
DATA &H000F0000,&HFF0003FF,&H00078000,&HFFF03FFF
DATA &H0003C000,&HFFF81FFF,&H00000000,&HFFFC1FFF

'*****************************************************************************
'Example usage: (Please run this program compiled, it's just too slow in the
'environment.)

PRINT "Smooth Text Mode Cursor Routines for PDS and QuickBASIC 4.5"
PRINT "By Rich Geldreich July, 1992"

'Attempt to initialize the driver.

IF NOT rg.cursor.init THEN
    PRINT "No mouse driver found!"
    END
END IF

PRINT
xpos = POS(0): ypos = CSRLIN - 1

'Main loop.
DO
    'get the mouse's x,y coordinates and button status.
    rg.move.cursor x, y, a, b, -1
    
    'did it move?
    IF x <> xlast OR y <> ylast THEN
        'tell the driver we will be updating the screen
        'the driver will turn off the cursor if it's overtop of
        'the area that'll change
        rg.off.area 1, ypos, 20, ypos
        LOCATE ypos, xpos
        PRINT "X: "; MID$(STR$(x), 2); " Y:"; MID$(STR$(y), 2); STRING$(5, 32);
    END IF
    'remember last x,y coordinates
    xlast = x: ylast = y
LOOP UNTIL INKEY$ <> "" OR a OR b

'Deinitialize the driver.
rg.cursor.deinit
END

'Deinitializes the driver. You've got to call this before your program
'ends.
SUB rg.cursor.deinit
    SHARED bitmaps.loaded
    rg.off.cursor

    'are the bitmaps loaded?
    IF bitmaps.loaded THEN

        'yup, change 'em back then

        VOn
        DEF SEG = &HA000
        a = firstchar * 32
        FOR b = 0 TO 287
            POKE a, oldbitmaps(b)
            a = a + 1
        NEXT
        bitmaps.loaded = False
        VOff

    END IF

END SUB

'Initializes the driver. If this function returns False(0), then a mouse
'driver wasn't found.
'
FUNCTION rg.cursor.init
    SHARED screen.offset, bytes.character, bytes.line
    SHARED screen.columns, screen.rows
    SHARED max.x, max.y, total.lines
    SHARED bitmaps.loaded
    rg.off.cursor
    
    'Store the bitmaps of the characters the cursor is going to erase
    'for deinitialization.
    IF NOT bitmaps.loaded THEN
        VOn
        DEF SEG = &HA000
        a = firstchar * 32
        FOR b = 0 TO 287
            oldbitmaps(b) = PEEK(a)
            a = a + 1
        NEXT
        bitmaps.loaded = True
        VOff
    END IF
    
    'Read the cursor's bitmask
    RESTORE cursor
    FOR a = 0 TO 15: READ pointer(a), mask(a): NEXT
    
    'Get some BIOS vars
    DEF SEG = &H40

    'Trick the mouse driver into thinking we're in the 640x480x16 mode
    'so it returns pixel coordinates instead of character coordinates.
    a = PEEK(&H49): POKE &H49, &H12
    rg.cursor.init = MouseInit
    DEF SEG = &H40: POKE &H49, a
    
    screen.offset = PEEK(&H4E) + PEEK(&H4F) * 256&
    bytes.character = PEEK(&H85)

    screen.columns = PEEK(&H4A) - 1
    screen.rows = PEEK(&H84)

    bytes.line = (screen.columns + 1) * 2
    max.x = (screen.columns + 1) * 8
    max.y = (screen.rows + 1) * bytes.character
    total.lines = bytes.character * 3 - 1

    'Tell the mouse driver the coordinates to return.
    MouseBorder 0, 0, max.y - 1, max.x - 1
    MouseSet max.x \ 2, max.y \ 2
END FUNCTION

'Polls the mouse driver.
'current.x, current.y = cursor's screen coordinates(LOCATE compatible)
'button.1, button.2   = the state of the mouse's buttons
'If update.flag is non-zero, the cursor's position will be updated if
'required.
'
SUB rg.move.cursor (current.x, current.y, button.1, button.2, update.flag)
    SHARED on.flag, s.address, x.cell, y.cell
    SHARED last.x, last.y

    SHARED screen.offset, bytes.character, bytes.line
    SHARED screen.columns, screen.rows, total.lines
    SHARED max.x, max.y

    MousePoll new.y, new.x, a, b
    button.1 = a: button.2 = b

    IF update.flag = 0 THEN
        current.x = 1 + new.x \ 8: current.y = 1 + new.y \ bytes.character
        EXIT SUB
    END IF

    'did the cursor move?
    IF on.flag = True AND new.x = last.x AND new.y = last.y THEN
        current.x = x.cell + 1: current.y = y.cell + 1
        EXIT SUB
    'coordinates in range?
    ELSEIF new.x < 0 OR new.y < 0 OR new.x >= max.x OR new.y >= max.y THEN
        PRINT "?? Invalid cursor coordinates in rg.move.cursor!": STOP
    END IF

    'I have tried many times to get the cursor to appear "flickerless" on
    'my 286-10 in the 80x25 mode. There is a way, without going to assembly,
    'to accomplish this but it is actually slower than the following code.

    'turn off cursor
    rg.off.cursor
    
    'x.cell & y.cell have the character cell(in normal text mode coordinates)
    'that the cursor will occupy
    x.cell = new.x \ 8
    y.cell = new.y \ bytes.character

    current.x = x.cell + 1: current.y = y.cell + 1

    's.address has the address of the character cell
    s.address = screen.offset + (y.cell * bytes.line) + x.cell * 2

    'x.offset and y.offset contain the amount of offset which
    'must be applied to the cursor's bitmap within the character
    'cells it will occupy

    x.offset = new.x AND 7
    y.offset = new.y MOD bytes.character
    
    'find out what's under the cursor
    c = s.address
    d = 0
    FOR a = 0 TO 2
        chars(d) = PEEK(c)
        chars(d + 1) = PEEK(c + 2)
        chars(d + 2) = PEEK(c + 4)
        c = c + bytes.line: d = d + 3
    NEXT

    
    'copy the bitmaps of the characters under the cursor, and modify
    'them if the cursor is overtop
    '- the cursor is 2 characters by 1 character(in the 80x25 mode)
    '- a 3x3 area of the screen is remapped, (In the 80x25 mode, this
    '  is unnecessary, only a 3x2 area needs to be remapped. Change it
    '  if you want!)

    '(This routine is slowest in the 80x25 text mode, it's crying for
    'assembly! I have taken much of the load off by using a small
    'assembly procedure to shift 32 bit integers.)

    DEF SEG = &HA000

    'Disable odd/even
    VOn

    'a0, a1, & a2 contain the address's of the first 3 character bitmaps
    'to copy

    a0 = chars(0) * 32
    a1 = chars(1) * 32
    a2 = chars(2) * 32

    'b0, b1, & b2 contain the address's of the destination bitmaps
    b0 = firstchar * 32
    b1 = (firstchar + 1) * 32
    b2 = (firstchar + 2) * 32

    c = bytes.character
    d = 0

    'amount to skip after each character
    skip = (32 - bytes.character) + 64
    nextcell = 3
    x = y.offset + 15

    'This is the "backbone" of the entire program. It copies the original
    'bitmaps from VRAM, and modifies the ones if they are so lucky enough
    'to be occupied by the cursor's bitmap.
    
    'modify 3*bytes.per.character lines
    FOR a = 0 TO total.lines

        'time for a new vertical row of characters?
        IF c = 0 THEN
            c = bytes.character
            b0 = b0 + skip: b1 = b1 + skip: b2 = b2 + skip
            a0 = chars(nextcell) * 32
            a1 = chars(nextcell + 1) * 32
            a2 = chars(nextcell + 2) * 32
            nextcell = nextcell + 3
        END IF

        'is it ok to use the cursor's bitmap in the copy?
        IF a >= y.offset AND a <= x THEN
            'shift the pointer and mask right
            'This procedure could be sped up quite a bit if each
            'rotation of the cursor was calculated beforehand.
            ShrMask pointer(d), x.offset, c0, c1, c2
            ShrMask mask(d), x.offset, m0, m1, m2

            'AND the mask & OR the cursor

            POKE b0, c2 OR (PEEK(a0) AND m2)

            POKE b1, c1 OR (PEEK(a1) AND m1)
            POKE b2, c0 OR (PEEK(a2) AND m0)

            d = d + 1
        ELSE 'just sling the normal bytes over
            
            POKE b0, PEEK(a0)
            POKE b1, PEEK(a1)
            POKE b2, PEEK(a2)
             'the bytes have been slung now ;-)
        END IF

        'all this incrementing doesn't seem right to me...
        b0 = b0 + 1: b1 = b1 + 1: b2 = b2 + 1
        a0 = a0 + 1: a1 = a1 + 1: a2 = a2 + 1
        c = c - 1

    NEXT

    VOff

    DEF SEG = &HB800
    
    'Now modify normal text VRAM so the user sees the new bitmaps

    'is any clipping needed? (is the 3x3 cell near the corner of the screen?)
    IF x.cell < screen.columns - 1 AND y.cell < screen.rows - 1 THEN
        'a "fast" modify

        POKE s.address, firstchar
        POKE s.address + 2, firstchar + 1
        POKE s.address + 4, firstchar + 2

        a = s.address + bytes.line
        POKE a, firstchar + 3
        POKE a + 2, firstchar + 4
        POKE a + 4, firstchar + 5

        a = a + bytes.line
        POKE a, firstchar + 6
        POKE a + 2, firstchar + 7
        POKE a + 4, firstchar + 8
    ELSE
        'a slow modify
        a = s.address
        b = firstchar
        FOR a1 = y.cell TO y.cell + 2

            IF a1 > screen.rows THEN EXIT FOR
            FOR b1 = x.cell TO x.cell + 2
                IF b1 <= screen.columns THEN
                    POKE a, b
                END IF
                b = b + 1
                a = a + 2
            NEXT
            
            a = a + (bytes.line - 6)
        NEXT
    END IF
 
    'the cursor better be on now!
    on.flag = True

    'remember last x,y coordinates for later
    last.x = new.x
    last.y = new.y
    
END SUB

'Selectively turns off the cursor if it's within a specified area.
'It is up to you to turn the cursor back on.
SUB rg.off.area (x.low, y.low, x.high, y.high)
    SHARED x.cell, y.cell
    SHARED screen.columns, screen.rows

    x.cell.high = x.cell + 2
    IF x.cell.high > screen.columns THEN x.cell.high = screen.columns
    y.cell.high = y.cell + 2
    IF y.cell.high > screen.rows THEN y.cell.high = screen.rows

    IF NOT (x.cell.high < (x.low - 1) OR x.cell > (x.high - 1) OR y.cell.high < (y.low - 1) OR y.cell > (y.high - 1)) THEN
        rg.off.cursor
    END IF

END SUB

'Turns off the mouse cursor.
'
SUB rg.off.cursor
    SHARED on.flag, s.address, x.cell, y.cell
    SHARED bytes.line, screen.columns, screen.rows

    DEF SEG = &HB800

    IF on.flag THEN

        IF x.cell < screen.columns - 1 AND y.cell < screen.rows - 1 THEN
            POKE s.address, chars(0)
            POKE s.address + 2, chars(1)
            POKE s.address + 4, chars(2)

            a = s.address + bytes.line
            POKE a, chars(3)
            POKE a + 2, chars(4)
            POKE a + 4, chars(5)

            a = a + bytes.line
            POKE a, chars(6)
            POKE a + 2, chars(7)
            POKE a + 4, chars(8)
        ELSE
            a = s.address
            b = 0
            FOR a1 = y.cell TO y.cell + 2
                IF a1 > screen.rows THEN EXIT FOR
                FOR b1 = x.cell TO x.cell + 2
                    IF b1 <= screen.columns THEN
                        POKE a, chars(b)
                    END IF
                    b = b + 1
                    a = a + 2
                NEXT
                a = a + (bytes.line - 6)
            NEXT
        END IF
        on.flag = False

    END IF


END SUB

