;*******************************************************************************
;CSRASM.ASM - Assembly routines for CSRBAS 
;By Rich Geldreich July, 1992
;Assembled with TASM v2.00
;
;These routines are in the public domain.
;
Ideal
Model Small
Public ShrMask, Von, Voff, Interrupt51

Codeseg
Even
;Shifts a 32 bit integer right a specified number of times. If the 32 bit
;integer was in DX, for instance, then it would set C0 to the 1st byte(AL), 
;C1 to the 2nd byte(AH) and C2 to the 3rd byte(DL). This little assembly
;program here speeded up the QB program a lot...
Proc    ShrMask ;Mask& ShiftCount C0 C1 C2
                ;16 14      12    10 08 06
        Push    bp
        Mov     bp, sp
        Push    si di
        
        Mov     ax, [ss:bp+14]          ;get 32 bit mask
        Mov     dx, [ss:bp+16]          

        Mov     bx, [ss:bp+12]          ;Get # bits to shift
        Shl     bx, 1                   ;Multiply by 4
        Shl     bx, 1
        Neg     bx                      ;Negate
        Add     bx, offset @@IEntry     ;Jump to in-line code
        Jmp     bx                      ;Do it

        Even                            ;In-Line code
        Rept    7                       
        Shr     dx, 1
        Rcr     ax, 1
        Endm
@@IEntry:                               ;Seperate the first 3 lsb's into
        Mov     di, [ss:bp+06]          ;easy to handle integers for QB
        And     dx, 0ffh
        Mov     [ds:di], dx             ;Give 'em the 3rd byte
        
        Mov     dl, al
        Mov     di, [ss:bp+10] 
        Mov     [ds:di], dx             ;Now throw the 1st byte at 'em
        
        Mov     dl, ah
        Mov     di, [ss:bp+08]
        Mov     [ds:di], dx             ;Finally, let 'em have the 2nd byte
               
@@Exit:        

        Pop     di si bp                ;Return to caller
        Retf    12
Endp    ShrMask
;
;Disables the text mode's odd/even addressing and CGA emulation to allow
;the QB program to modify the character bitmaps directly, which are in plane
;2. Each character bitmap uses 32 bytes of video RAM. To change the space 
;character to a solid block, for instance, this could be used in the 80x25
;mode(which uses 16 bytes for each character):
;
;VOn
;DEF SEG=&HA000
;FOR A=32*32 to 32*32+15   '32*32 = start of space's bitmap
;    POKE A, &HFF          'all bits on
;NEXT
;VOff
;
;
;Thanks to Dave Cooper, who helped with this part.
;(If the text mode cursor does not work on a particular adaptor, the most
;likely cause is the following two routines...)
;
;I'd document them if Dave would tell me _exactly_ what they're doing!
Even
Proc    Von
 

        Mov     dx, 03c4h
        Mov     ax, 0402h
        Out     dx, ax          ;enables plane 2 for CPU writes
        Mov     ax, 0704h
        Out     dx, ax
        
        Mov     dx, 03ceh
        Mov     ax, 0204h       ;enables plane 2 for CPU reads
        Out     dx, ax
        Mov     ax, 0005h
        Out     dx, ax
        Mov     ax, 0406h
        Out     dx, ax
        
        Retf    0
Endp    Von
;Fixes the "damage" that Von did... Re-enables odd/even and CGA emulation.
Even        
Proc    Voff
 
        Mov     dx, 03ceh
        Mov     ax, 0104h       ;enables plane 1 for CPU reads (?)
        Out     dx, ax
        Mov     ax, 0e06h
        Out     dx, ax
        Mov     ax, 01005h
        Out     dx, ax
        
        Mov     dx, 03c4h
        Mov     ax, 0302h       ;enables planes 0 and 1 for CPU writes
        Out     dx, ax
        Mov     ax, 0304h
        Out     dx, ax
        
        Retf    0
Endp    Voff
Even
Proc    Interrupt51 ;Ax Bx Cx Dx
                    ;12 10 08 06
        Push    bp
        Mov     bp, sp
        Push    si
                
        Mov     si, [ss:bp+06]
        Mov     dx, [ds:si]
        Mov     si, [ss:bp+08]
        Mov     cx, [ds:si]
        Mov     si, [ss:bp+10]
        Mov     bx, [ds:si]
        Mov     si, [ss:bp+12]
        Mov     ax, [ds:si]

        Int     033h

        Mov     si, [ss:bp+06]
        Mov     [ds:si], dx
        Mov     si, [ss:bp+08]
        Mov     [ds:si], cx
        Mov     si, [ss:bp+10]
        Mov     [ds:si], bx
        Mov     si, [ss:bp+12]
        Mov     [ds:si], ax
        
        Pop     si bp
        Retf    8
Endp    Interrupt51
End
