/loaded variables.tf

;; saves a variable or variables at quit
;; variables are loaded at the same time as this file,
;; or manually with load saved_variables.tf
;; Antti Pietikinen (heidel@operamail.com)
;; 2005

/require -q at_quit.tf
/quit_add /savevar_save

/require -q help_list.tf
/help_add /help_savevar automatic variable saving

/set savevar_filename=saved_variables.tf

/def -i help_savevar=\
	/echo -aB Help for saving variables:%;\
	/echo /savevar_show            Show which variables are going to be saved by savevar.%;\
	/echo /savevar_add <name*>     Add variables to list.%;\
	/echo /savevar_remove <name*>  Remove something from the list.%;\
	/echo /savevar_save            Do the save now. (Automatically done at quit).%;\
	/echo /savevar_load            Load the saved variables.%;\
	/echo

/def -i savevar_add=\
	/if (strstr(savevar_list,textencode({*})) == -1) \
		/test savevar_list := strcat(savevar_list," ",textencode({*}))%;\
	/endif

/def -i savevar_remove=\
	/test savevar_list := replace(textencode({*}),"", savevar_list)%;\
	/if (regmatch(savevar_list,"^[ ]*$")) \
		/set savevar_list=%;\
	/endif

/def -i savevar_list=/savevar_show %{savevar_list}

/def -i savevar_show=\
	/if ({#}==0) \
		/if (savevar_list !~ "") \
			/savevar_show %{savevar_list}%;\
		/else \
			/echo -aB % No variables named for saving.%;\
		/endif%;\
	/else \
		/echo -aB % Variables savevar saves:%;\
		/while ({#}) \
			/echo -aCgreen - $[textdecode({1})]%;\
			/shift%;\
		/done%;\
	/endif

/def -i savevar_load=\
	/def -F -q -ag -hLOADFAIL savevar_gag_loadfail%;\
	/let filehandle=$[tfopen(savevar_filename,"r")]%;\
	/if (filehandle != -1) \
		/test tfclose(filehandle)%;\
		/eval /load -q %{savevar_filename}%;\
		/echo -aCgreen % Saved variables loaded.%;\
	/else \
		/echo -aCred % No saved variables.%;\
	/endif%;\
	/undef savevar_gag_loadfail

/def -i savevar_saveline=\
	/test tfwrite({1},{-1})

/def -i savevar_save=\
	/if ({#} == 0 & savevar_list !~ "") \
		/savevar_save %{savevar_list}%;\
	/else \
		/let filehandle=$[tfopen(savevar_filename,"w")]%;\
		/while ({#}) \
			/quote -S /savevar_saveline %{filehandle} `"/listvar $[textdecode({1})]"%;\
			/shift%;\
		/done%;\
		/test tfclose(filehandle)%;\
		/echo -aCgreen % Savevar: variables saved.%;\
	/endif


/if (!isvar("savevar_list")) \
	/savevar_load%;\
/endif

/savevar_add savevar_list
