;; Antti Pietikinen (Heidel@Batmud) 2004

;; setup the status bar and some macros for it
;; 

/set warn_status 0
/set status_pad _
/set status_height 2
/set clock_format %H:%M
/set status_var_set_worn=strlen({set_worn})==3 ? strcat(" ",{set_worn}," ") : ""
/set status_var_off_target=off_target !~ "" ? strcat(" ",{off_target}," ") : ""
/set status_var_heal_target=heal_target !~ "" ? strcat(" ",{heal_target}," ") : ""
/set status_var_insert=insert ? "" : " over "
/set status_int_active=nactive() ? pad(" active:", 0, nactive(), 2, " ") : ""
/set status_int_clock=strcat(" ",ftime(clock_format))
/set status_int_log=nlog() ? " log " : ""
/set status_int_mail=!nmail() ? "" : nmail()==1 ? " mail " : pad("mail", 0, nmail(), 2)
/set status_int_more=(limit() | morepaused()) ? strcat(" ", status_int_more()," ") : ""
/set status_int_read=nread() ? " read " : ""
/set status_int_world=fg_world() =~ "" ? " no world " : strcat(" ",!is_open(fg_world()) ? "!" : "", fg_world()," ")

/status_add -s0 -c @more:10:rCyellow
/status_add -s1 -A ""
/status_add -s1 -A @read:6:r
/status_add -s1 -A @active:11:r
/status_add -s1 -A @log:5:r
/status_add -s1 -A insert:6:r
/status_add -s1 -A kbnum:4:r
/status_add -s1 -A @world:12:r
/status_add -s1 -A @clock:6:r
/status_add -s0 -A -c -r1 " ":1
/status_add -s0 -A -r1 statusbar_hp:5
/status_add -s0 -A -r1 "/":1
/status_add -s0 -A -r1 statusbar_hpmax:5:B
/status_add -s0 -A -r1 "  ":2
/status_add -s0 -A -r1 statusbar_sp:5
/status_add -s0 -A -r1 "/":1
/status_add -s0 -A -r1 statusbar_spmax:5:B
/status_add -s0 -A -r1 "  ":2
/status_add -s0 -A -r1 statusbar_ep:5
/status_add -s0 -A -r1 "/":1
/status_add -s0 -A -r1 statusbar_epmax:5:B
/status_add -s0 -A -r1 " \\":3
/status_add -s1 -A -r1 set_worn:5:r
/status_add -s1 -A -r1 heal_target:1:r
/status_add -s1 -A -r1 off_target::r

/def -hRESIZE -F -q -i statusbar_resize_hook=\
	/let new_size=%;\
	/test new_size:= trunc( ({1}-50)*0.5 )%;\
	/status_edit heal_target:%{new_size}:r

/statusbar_resize_hook $[columns()]

;; handle hp/sp
;; statusbar_handle(hp,hpmax,sp,spmax,ep,epmax)
/def -i statusbar_handle= \
	/test status_edit(strcat("statusbar_hp:5",$(/statusbar_color %{1} %{2})))%;\
	/test statusbar_hp := pad(%{1},5)%;\
	/test statusbar_hpmax := pad(%{2},5)%;\
	/test status_edit(strcat("statusbar_sp:5",$(/statusbar_color %{3} %{4})))%;\
	/test statusbar_sp := pad(%{3},5)%;\
	/test statusbar_spmax := pad(%{4},5)%;\
	/if ({#}==6) \
		/test status_edit(strcat("statusbar_ep:5",$(/statusbar_color %{5} %{6})))%;\
		/test statusbar_ep := pad(%{5},5)%;\
		/test statusbar_epmax := pad(%{6},5)%;\
	/endif

/def -i statusbar_color =\
	/if ({2}==0) \
		/echo ":BCblue"%;\
		/break%;\
	/endif%;\
	/test tmpvar :=%{1}*100./%{2} %; \
	/if (tmpvar==100)      /echo ":BCyellow"%; \
	/elseif (tmpvar>100)   /echo ":BCwhite"%; \
	/elseif (tmpvar>74)    /echo ":BCgreen"%; \
	/elseif (tmpvar>34)    /echo ":BCmagenta"%; \
	/elseif (tmpvar>9)     /echo ":Cred"%; \
	/elseif (tmpvar>=0)    /echo ":BCred"%; \
	/else                  /echo ":BCblue"%; \
	/endif

;; init hp/sp/ep
/test statusbar_handle(0,0,0,0,0,0)

