/loaded prot_template.tf

;; timeformat required
/require -q misc.tf

;; templates for prot-system

;; Antti Pietikinen (heidel@operamail)
;; 2005

;; -------------------------
;; TEMPLATES FOR PROTS
;; -------------------------

;; -------------------------
;; PROT ON
;; -------------------------
;; -q         quiet-flag
;; -m         stacking-flag
;; -l<name>   linked <name>
;; -s         sticky-flag
;; -------------------------

/def -i prot_on=\
	/test getopts("qml:s")%;\
	/test ++%{1}%;\
	/set %{1}_time=$[time()]%;\
	/if (opt_s) \
		/prot_off -q prot_sticky%;\
		/set %{1}_sticky=1%;\
	/endif%;\
	/if (opt_l!~"") \
		/set %{1}_link=%{opt_l}%;\
	/endif%;\
	/if (!opt_q) \
		/if (opt_m) \
			/let p_multicount $(/eval /expr %%{%{1}})%;\
			/prot %{-1} ( %{p_multicount} on )%;\
		/else \
			/if (opt_l!~"") \
				/prot %{-1} ( %{opt_l} )%;\
			/else \
				/prot %{-1}%;\
			/endif%;\
		/endif%;\
	/endif


;; -------------------------
;; PROT OFF
;; -------------------------
;; -q         quiet-flag
;; -m         stacking-flag
;; -n         notime-flag
;; -------------------------

/def -i prot_off=\
	/test getopts("qmn")%;\
	/if (opt_m) \
		/test --%{1}%;\
		/let p_multicount $(/eval /expr %%{%{1}})%;\
		/if (p_multicount < 1) \
			/set %{1}=0%;\
			/let opt_n=1%;\
		/endif%;\
	/else \
		/unset %{1}%;\
	/endif%;\
	/if (!opt_q) \
		/if (opt_n) \
			/prot %{-1}%;\
		/else \
			/if (opt_m) \
				/prot %{-1} ( %{p_multicount} left )%;\
			/else \
				/let p_start %{1}_time%;\
				/let p_dur $[time()-{p_start}]%;\
				/if (p_start==0|p_dur==0) \
					/prot %{-1}%;\
				/else \
					/prot %{-1} ($(/timeformat %{p_dur}))%;\
				/endif%;\
			/endif%;\
		/endif%;\
	/endif%;\
	/unset %{1}_time%;\
	/unset %{1}_sticky

