;; helper for setting up a bard play
;; Antti Pietikinen (Heidel@batmud)

/require -q help_list.tf
/help_add /help_play tool for bardic plays

/def -i playstart=\
	/set plmark=1

/def -i playdo=\
	/set pltar=plist_%{plmark}%;\
	/eval /echo [play] [%{plmark}] Send: %%{%{pltar}}%;\
	/eval /send %%{%{pltar}}%;\
	/set plmark=$[plmark+1]%;\
	/set pltar=plist_%{plmark}%;\
	/eval /echo [play] [%{plmark}] Next: %%{%{pltar}}%;\
	/unset pltar

/def -i playskip=\
	/eval /set pltar=plist_%{plmark}%;\
	/eval /echo [play] [%{plmark}] Skipped: %%{%{pltar}}%;\
	/set plmark=$[plmark+1]%;\
	/eval /set pltar=plist_%{plmark}%;\
	/eval /echo [play] [%{plmark}] Next: %%{%{pltar}}%;\
	/unset pltar

/def -i playshow=\
	/eval /set pltar=plist_%{plmark}%;\
	/eval /echo [play] [%{plmark}] Next: %%{%{pltar}}%;\
	/unset pltar

/def -i playlast=\
	/set plmark=$[plmark-1]%;\
	/eval /set pltar=plist_%{plmark}%;\
	/eval /echo [play] [%{plmark}] Recalled: %%{%{pltar}}%;\
	/unset pltar
	
/def -i playgo=\
	/set plmark=%{1}%;\
	/eval /set pltar=plist_%{plmark}%;\
	/eval /echo [play] [%{plmark}] Recalled: %%{%{pltar}}%;\
	/unset pltar

/def -i playbind=\
	/echo -aB Do this: press f2, and then press gggg  (yes, four times g).%;\
	/echo -aB Now you should have bound f2 as /playdo%;\
	/echo -aB Note: if you have already bound f2 to something else, this won't work. Choose some other key and do the gggg.%;\
	/echo -aB (if you 'kdetit' and bound some crap, do '/undef playbind' and retry with '/playbind'%;\
	/echo -aB ('/undef temp-playbound' to cancel now)%;\
	/def -b'gggg' temp-playbind=\
		/def -b'$$(/recall -i /1)' playbound=/playdo%%;\
		/grab%%;\
		/undef temp-playbind

/def -i playch=\
	/set plmark=%{1}%;\
	/eval /set pltar=plist_%{plmark}%;\
	/eval /echo [play] [%{plmark}] Recalled: %%{%{pltar}}%;\
	/eval /grab %%{%{pltar}}%;\
	/unset pltar

/def -i help_play=\
	/echo -aB Help for play-triggers.%;\
	/echo -aCgreen | /playstart - Goes to the first line.%;\
	/echo -aCgreen | /playdo    - Sends your line, and moves on to next line.%;\
	/echo -aCgreen | /playskip  - Goes forward one line.%;\
	/echo -aCgreen | /playlast  - Goes back one line.%;\
	/echo -aCgreen | /playgo    - /playgo <x> :  Goes to line <x>.%;\
	/echo -aCgreen | /playbind  - Little helper to bind /playdo to a key.%;\
	/echo -aCgreen | /playch    - /playch <x> :  Recalls line <x> into command-line for editing.%;\
	/echo -aCgreen | /playshow  - Shows what is going to be the next line sent

/echo -aCyellow % Play helper loaded.
