/loaded misc.tf

;; some useful (or not) macros, mostly used by other macros
;; Antti Pietikinen (Heidel@bat) 2004

;; -------------------------
;; start the timer
;; -------------------------

;; if no variable is given, use timer instead
/def -i timer_start=\
	/if ({1}!~"") \
		/set %{1}_time=$[time()]%;\
	/else \
		/set timer=$[time()]%;\
	/endif

;; -------------------------
;; time from timer_start
;; -------------------------

/def -i timer_show=\
	/if ({1}!~"") \
		/eval /set starttime %%{%{1}_time}%;\
	/else \
		/set starttime %{timer}%;\
	/endif%;\
	/let dur=$[time()-{starttime}]%;\
	/unset starttime%;\
	/if (dur < 100000) \
		/echo $(/timeformat %{dur})%;\
	/else \
		/echo%;\
	/endif

;; -------------------------
;; format time	
;; -------------------------

;; (no, ftime is not ok, handles hours wrong)
/def -i timeformat=\
	/let minutes $[trunc({1}/60)]%;\
	/let hours $[trunc((minutes/60))]%;\
	/let seconds $[{1}-60*{minutes}]%;\
	/let minutes $[mod(minutes,60)]%;\
	/if (hours!=0) /let hours %{hours}h %;\
		/else /let hours=%;/endif%;\
	/if (minutes!=0) /let minutes %{minutes}m %;\
		/else /let minutes=%;/endif%;\
	/if (seconds!=0) /let seconds %{seconds}s%;\
		/else /let seconds=%;/endif%;\
	/let output $[strcat(hours,minutes,seconds)]%;\
	/result {output}

;; -------------------------
;; /purgevar
;; -------------------------
;; takes all the parameters /listvar does, but this one clears all the variables that
;; would have been shown

/def -i purgevar =\
	/if ({*}=~"") \
		/echo -aB % This would purge all variables, cancelled. Use "/purgevar *" instead.%;\
	/return -1%;\
	/endif%;\
	/quote -S /purgehelper `"/listvar %{*}"

/def -i purgehelper =\
	/let tempfindequal $[strstr({*},"=")]%;\
	/let temptoclear $[substr({*},0,{tempfindequal})]%;\
	/let temptoclear $[replace("/set","/unset",{temptoclear})]%;\
;	/echo - %{*} -> %{temptoclear}%;\
	/eval -s0 %{temptoclear}
