;; mapping tool
;; Antti Pietikinen (heidel@operamail.com)
;; 2005

;; use brief mode

;;==================
;; START
;;==================
/def -i map_start=\
	/set map_started 1%;\
	/if (m_roomname=~"") \
		/if (!m_brief_done) \
			/def -F -q -1 -hPROMPT map_temp_prompt=/map_start%;\
			/set m_brief_done 1%;\
			/send bl%;\
		/else \
			/echo -aCred % map: couldn't get brief look, abort.%;\
		/endif%;\
	/else \
		/set m_brief_done=0%;\
		/set map_x=100000%;\
		/set map_y=100000%;\
		/if (map_roomcount=~"") \
			/set map_roomcount=0%;\
		/endif%;\
		/let m_start_index=$[map_add_room(m_roomname,m_exits,map_x,map_y)]%;\
		/set m_lastroom %{m_start_index}%;\
		/map_add_unknown_exits %{m_start_index} %{m_exits}%;\
	/endif

;;==================
;; ADD ROOM
;;==================
;; map_add_room(name,exits,x,y)
;;------------------
/def -i map_add_room=\
	/let m_index=$[++map_roomcount]%;\
	/set rooms_%{m_index}_desc=%{1}%;\
	/set rooms_%{m_index}_exits=%{2}%;\
	/set rooms_%{m_index}_x=%{3}%;\
	/set rooms_%{m_index}_y=%{4}%;\
;	/echo -aCgreen % Mapper: Room added.%;\
	/return m_index

;; mark some exits unknown
/def -i map_add_unknown_exits=\
	/let m_index=%{1}%;\
	/shift%;\
	/while ({#}) \
		/map_add_link %{m_index} %{1} 0%;\
		/shift%;\
	/done

/def -i map_add_link=\
	/set rooms_%{1}_exit_%{2}=%{3}

;; connect room 1 with room 2 using 3
/def -i map_connect=\
	/set rooms_%{1}_exit_%{3}=%{2}%;\
	/set rooms_%{2}_exit_$[map_reverse({3})]=%{1}

;;==================
;; TRIGGER ROOM
;;==================
/def -i -F -P2BCyellow -t"^(.*) \((.*)\)\.$" map_room=\
	/if (map_started) \
		/set m_roomname=%{P0}%;\
		/map_parse_exits %{P2}%;\
		/set m_move_ok=1%;\
	/endif
	
;; parse exits
;;------------------
/def -i map_parse_exits=\
	/let m_string=%{*}%;\
	/set m_exits=%;\
	/while (strlen(m_string)) \
		/let m_comma=$[strstr(m_string,",")]%;\
		/if (m_comma != -1) \
			/test m_exits := strcat(m_exits,(m_exits=~""?"":" "),map_shorten(substr(m_string,0,m_comma)))%;\
			/test m_string := substr(m_string,m_comma+2)%;\
		/else \
			/test m_exits := strcat(m_exits," ",map_shorten(m_string))%;\
			/let m_string=%;\
		/endif%;\
	/done

;;==================
;; TRIGGER FAILED MOVE
;;==================
/def -i -F -msimple -t"It doesn't appear possible to go that way." map_failed_move=\
	/set m_move_ok 0
/def -i -F -msimple -t"You cannot leave, you have been AMBUSHED." map_failed_move_ambush=\
	/set m_move_ok 0
/def -i -F -msimple -t"You are so exhausted you fail to move." map_failed_move_exhaust=\
	/set m_move_ok 0

;;==================
;; SEND HOOK
;;==================
/def -i -F -q -mregexp -h"SEND ^@?(n|ne|e|se|s|sw|w|nw|north|northeast|east|southeast|south|southwest|west|northwest)$" map_send_hook=\
	/set m_move_ok=1%;\
	/set m_last_dir=$[map_shorten({P1})]%;\
;	/echo -aCgreen % Trying to move %{m_last_dir}%;\
	/def -F -q -1 -hPROMPT room_temp_prompt=/map_move_done

;;==================
;; MOVE DONE
;;==================
/def -i map_move_done=\
	/if (m_move_ok) \
		/map_dir_to_xy %{m_last_dir}%;\
		/let m_found=$[map_find_room()]%;\
		/if (m_found==0) \
			/let m_index $[map_add_room(m_roomname,m_exits,map_x,map_y)]%;\
			/map_add_unknown_exits %{m_index} %{m_exits}%;\
			/map_connect %{m_lastroom} %{m_index} %{m_last_dir}%;\
			/map_show_unvisited %{m_index}%;\
		/elseif (m_found == -1) \
			/echo % can't place this room.%;\
		/else \
			/let m_index $[m_indexlist]%;\
			/map_connect %{m_lastroom} %{m_index} %{m_last_dir}%;\
			/map_show_unvisited %{m_index}%;\
		/endif%;\
		/set m_lastroom %{m_index}%;\
	/endif

;;==================
;; FIND ROOM
;;==================
/def -i map_find_room=\
	/set m_findcount=0%;\
	/set m_indexlist=%;\
	/quote -S /map_find_desc `"/listvar rooms_*_desc"%;\
	/if (m_findcount == 0) \
		/return 0%;\
	/elseif (m_findcount == 1) \
		/map_set_xy %{m_indexlist}%;\
		/return %{m_indexlist}%;\
	/else \
		/let m_coord $(/map_find_coords %{m_indexlist})%;\
		/if (m_coord > 0) \
			/return %{m_coord}%;\
		/else \
			/return -1%;\
		/endif%;\
	/endif

/def -i map_set_xy=\
	/eval /test map_x:=rooms_%{*}_x%;\
	/eval /test map_y:=rooms_%{*}_y

/def -i map_find_desc=\
	/let m_title $[substr({*},strchr({*},"=")+1)]%;\
	/if (m_title=~m_roomname) \
		/test ++m_findcount%;\
		/test m_indexlist := strcat(substr({*},strchr({*},"=")-6,1)," ",m_indexlist)%;\
	/endif

/def -i map_find_coords=\
	/let m_result=0%;\
	/while ({#}) \
		/eval /if (map_x == rooms_%{1}_x & map_y == rooms_%{1}_y) \
			/let m_result=%{1}%;\
		/endif%;\
	/done%;\
	/return %{m_result}

/def -i map_show_unvisited=\
	/eval /set m_unvisited=$$(/map_show_unvisited_aux %{1} %%{rooms_%{1}_exits})%;\
	/if (m_unvisited!~"") \
		/echo -aCgreen -p % Mapper: unvisited exits: @{BCyellow}%{m_unvisited}%;\
	/endif

/def -i map_show_unvisited_aux=\
	/let m_aux=%{1}%;\
	/shift%;\
	/while ({#}) \
		/eval /if (rooms_%{m_aux}_exit_%{1}==0) \
			/_echo %{1}%%;\
		/endif%;\
		/shift%;\
	/done

/def -i map_shorten=\
	/if     ({1}=~"northeast") /result "ne"%;\
	/elseif ({1}=~"southeast") /result "se"%;\
	/elseif ({1}=~"southwest") /result "sw"%;\
	/elseif ({1}=~"northwest") /result "nw"%;\
	/elseif ({1}=~"east")      /result "e"%;\
	/elseif ({1}=~"south")     /result "s"%;\
	/elseif ({1}=~"north")     /result "n"%;\
	/elseif ({1}=~"west")      /result "w"%;\
	/else                      /result "%{1}"%;\
	/endif

/def -i map_reverse=\
	/if     ({1}=~"n")         /result "s"%;\
	/elseif ({1}=~"ne")        /result "sw"%;\
	/elseif ({1}=~"e")         /result "w"%;\
	/elseif ({1}=~"se")        /result "nw"%;\
	/elseif ({1}=~"s")         /result "n"%;\
	/elseif ({1}=~"sw")        /result "ne"%;\
	/elseif ({1}=~"w")         /result "e"%;\
	/elseif ({1}=~"nw")        /result "se"%;\
	/endif

/def -i map_dir_to_xy=\
	/if     ({1}=~"n")  /test --map_y%;\
	/elseif ({1}=~"ne") /test --map_y%;/test ++map_x%;\
	/elseif ({1}=~"e")                 /test ++map_x%;\
	/elseif ({1}=~"se") /test ++map_y%;/test ++map_x%;\
	/elseif ({1}=~"s")  /test ++map_y%;\
	/elseif ({1}=~"sw") /test ++map_y%;/test --map_x%;\
	/elseif ({1}=~"w")                 /test --map_x%;\
	/elseif ({1}=~"nw") /test --map_y%;/test --map_x%;\
	/endif


;; visualizing the map
;; first, get the min and max coords
;; then, assign space
;; then, start placing rooms in order to the space
;; then, output the space
;;==================
;; CREATE MAP
;;==================
/def -i map_create=\
	/let opt_f=%;\
	/test getopts("f:")%;\
	/set map_min_x=200000%;\
	/set map_min_y=200000%;\
	/set map_max_x=0%;\
	/set map_max_y=0%;\
	/quote -S /map_get_size_x `"/listvar rooms_*_x"%;\
	/quote -S /map_get_size_y `"/listvar rooms_*_y"%;\
	/for m_index %{map_min_y} %{map_max_y} \
		/set map_line_%%{m_index}_1=$$[strrep("#",(map_max_x-map_min_x+1)*5)]%%;\
		/set map_line_%%{m_index}_2=$$[strrep("#",(map_max_x-map_min_x+1)*5)]%%;\
		/set map_line_%%{m_index}_3=$$[strrep("#",(map_max_x-map_min_x+1)*5)]%;\
	/for m_index 1 %{map_roomcount} \
		/map_place_room %%{m_index}%;\
	/if (opt_f!~"") \
		/let m_file=$[tfopen(opt_f,"w")]%;\
	/else \
		/let m_file=-1%;\
	/endif%;\
	/for m_index %{map_min_y} %{map_max_y} \
		/test map_echo(m_index,m_file)%;\
	/if (m_file!=-1) \
		/test tfclose(m_file)%;\
	/endif

/def -i map_get_size_x=\
	/let m_num=$[substr({*},strrchr({*},"=")+1)]%;\
	/if (m_num < map_min_x) \
		/set map_min_x %{m_num}%;\
	/endif%;\
	/if (m_num > map_max_x) \
		/set map_max_x %{m_num}%;\
	/endif

/def -i map_get_size_y=\
	/let m_num=$[substr({*},strrchr({*},"=")+1)]%;\
	/if (m_num < map_min_y) \
		/set map_min_y %{m_num}%;\
	/endif%;\
	/if (m_num > map_max_y) \
		/set map_max_y %{m_num}%;\
	/endif

/def -i map_place_room=\
	/eval /set map_place_x=%%{rooms_%{*}_x}%;\
	/eval /set map_place_y=%%{rooms_%{*}_y}%;\
;	/test map_replace(map_place_x,map_place_y,2,strcat("#",pad({*},3),"#"),0)%;\
	/test map_replace(map_place_x,map_place_y,2,strcat("#   #"),0)%;\
	/eval /map_place_exits %%{rooms_%{*}_exits}

/def -i map_place_exits=\
	/while ({#}) \
		/if     ({1}=~"nw") /test map_replace(map_place_x,map_place_y,1,"\",0)%;\
		/elseif ({1}=~"n" ) /test map_replace(map_place_x,map_place_y,1,"|",2)%;\
		/elseif ({1}=~"ne") /test map_replace(map_place_x,map_place_y,1,"/",4)%;\
		/elseif ({1}=~"w" ) /test map_replace(map_place_x,map_place_y,2,"-",0)%;\
		/elseif ({1}=~"e" ) /test map_replace(map_place_x,map_place_y,2,"-",4)%;\
		/elseif ({1}=~"sw") /test map_replace(map_place_x,map_place_y,3,"/",0)%;\
		/elseif ({1}=~"s" ) /test map_replace(map_place_x,map_place_y,3,"|",2)%;\
		/elseif ({1}=~"se") /test map_replace(map_place_x,map_place_y,3,"\",4)%;\
		/else               /test map_replace(map_place_x,map_place_y,2,"*",1)%;\
		/endif%;\
		/shift%;\
	/done

/def -i map_replace=\
	/eval /set m_oldline %%{map_line_%{2}_%{3}}%;\
	/set map_line_%{2}_%{3}=$[strcat(substr(m_oldline,0,({1}-map_min_x)*5+{5}),{4},substr(m_oldline,({1}-map_min_x)*5 + {5} +strlen({4}) ))]


/def -i map_echo=\
	/if ({2} == -1) \
		/eval /echo - %%{map_line_%{1}_1}%;\
		/eval /echo - %%{map_line_%{1}_2}%;\
		/eval /echo - %%{map_line_%{1}_3}%;\
	/else \
		/eval /test tfwrite({2},map_line_%{1}_1)%;\
		/eval /test tfwrite({2},map_line_%{1}_2)%;\
		/eval /test tfwrite({2},map_line_%{1}_3)%;\
	/endif


