;; history saver

;; Antti Pietikinen (heidel@operamail.com)
;; 2005

;; autosave these two histories
/require -q at_quit.tf
/quit_add /history_save -g
/quit_add /history_save -i

;;-------------
;; usage:
;;-------------
;; /history_save -<history>
;; /history_load -<history>
;; e.g.
;; /history_save -wYourfavouritemud
;;-------------


;;-------------
;; histsize required
/if (!isvar("histsize"))\
	/set histsize 1000%;\
/endif
;;-------------


;;-------------
;; helpers
/def -i history_write=\
	/test tfwrite({1},encode_ansi({-1}))
/def -i history_read=\
	/recordline %{1} - $[decode_ansi({-1})]
;;-------------


;;-------------
;; save history {1} into file saved_history{1}.log
/def -i history_save=\
	/let temp_filename=$[strcat("saved_history",{1},".log")]%;\
	/let filehandle=$[tfopen(temp_filename,"w")]%;\
	/test tfflush(filehandle,"off")%;\
	/quote -S /history_write %{filehandle} #"%{1} -q /%{histsize} *"%;\
	/test tfclose(filehandle)
;;-------------


;;-------------
;; load history {1} from file saved_history{1}.log
/def -i history_load=\
	/def -ag -F -hLOADFAIL history_loadgag_temp%;\
	/let temp_filename=$[strcat("saved_history",{1},".log")]%;\
	/let filehandle=$[tfopen(temp_filename,"r")]%;\
	/if (filehandle != -1) \
		/test tfclose(filehandle)%;\
		/quote -S /history_read %{1} '%{temp_filename}%;\
		/echo -aCgreen % History %{1} loaded.%;\
	/else \
		/echo -aCred % %{1} : no such history saved.%;\
	/endif%;\
	/undef history_loadgag_temp
;;-------------


;;-------------
;; autoload these two histories (global and input)
/history_load -g
/history_load -i
;;-------------
