/loaded fn_keys.tf

;; Easy-to use f-keys
;; Antti Pietikinen (heidel@operamail.com)
;; 2005

/require -q at_quit.tf
/quit_add /keystore_save

/require -q help_list.tf
/help_add /help_keystore easy-to-use function key definer

/require -q variables.tf
/savevar_add keystore_no_edit

/def -i help_keystore=\
	/echo -aB Help for function key storing:%;\
	/echo f<n>                  Do saved command%;\
	/echo f<n> + shift          Save a command%;\
	/echo f<n> + alt            Edit saved command%;\
	/echo -f1                  Show saved commands%;\
	/echo /keystore_savelines   Save current commands%;\
	/echo %;\
	/echo notes:%;\
	/echo - - commands are saved at /quit%;\
	/echo - - default filename is saved_keys.tf%;\
	/echo - - when you have defined the keys, you may want to save the keys, %;\
	/echo     copy the 'saved_keys.tf' to some other name, e.g. ranger_keys.tf.%;\
	/echo     This way you have a backup when you overwrite a key accidently.%;\
	/echo - - set keystore_no_edit on if you want to disable aforementioned accidents.%;\
	/echo

;; load saved keys
/load -q saved_keys.tf

;; ---------------------------------
;; ----------- F1 - F10 ------------
;; ---- (alt=edit, shift=store) ----
;; ---------------------------------
/def -i key_f1 = /keystore_getline 1
/def -i key_f2 = /keystore_getline 2
/def -i key_f3 = /keystore_getline 3
/def -i key_f4 = /keystore_getline 4
/def -i key_f5 = /keystore_getline 5
/def -i key_f6 = /keystore_getline 6
/def -i key_f7 = /keystore_getline 7
/def -i key_f8 = /keystore_getline 8
/def -i key_f9 = /keystore_getline 9
/def -i key_f10 = /keystore_getline 10
/def -i key_esc_f1 = /keystore_inputline 1
/def -i key_esc_f2 = /keystore_inputline 2
/def -i key_esc_f3 = /keystore_inputline 3
/def -i key_esc_f4 = /keystore_inputline 4
/def -i key_esc_f5 = /keystore_inputline 5
/def -i key_esc_f6 = /keystore_inputline 6
/def -i key_esc_f7 = /keystore_inputline 7
/def -i key_esc_f8 = /keystore_inputline 8
/def -i key_esc_f9 = /keystore_inputline 9
/def -i key_esc_f10 = /keystore_inputline 10
/def -i key_meta_f1 = /keystore_inputline 1
/def -i key_meta_f2 = /keystore_inputline 2
/def -i key_meta_f3 = /keystore_inputline 3
/def -i key_meta_f4 = /keystore_inputline 4
/def -i key_meta_f5 = /keystore_inputline 5
/def -i key_meta_f6 = /keystore_inputline 6
/def -i key_meta_f7 = /keystore_inputline 7
/def -i key_meta_f8 = /keystore_inputline 8
/def -i key_meta_f9 = /keystore_inputline 9
/def -i key_meta_f10 = /keystore_inputline 10
/def -i key_f11 = /keystore_putline 1
/def -i key_f12 = /keystore_putline 2
/def -i key_f13 = /keystore_putline 3
/def -i key_f14 = /keystore_putline 4
/def -i key_f15 = /keystore_putline 5
/def -i key_f16 = /keystore_putline 6
/def -i key_f17 = /keystore_putline 7
/def -i key_f18 = /keystore_putline 8
/def -i key_f19 = /keystore_putline 9
/def -i key_f20 = /keystore_putline 10
/def -i key_shift_f1 = /keystore_putline 1
/def -i key_shift_f2 = /keystore_putline 2
/def -i key_shift_f3 = /keystore_putline 3
/def -i key_shift_f4 = /keystore_putline 4
/def -i key_shift_f5 = /keystore_putline 5
/def -i key_shift_f6 = /keystore_putline 6
/def -i key_shift_f7 = /keystore_putline 7
/def -i key_shift_f8 = /keystore_putline 8
/def -i key_shift_f9 = /keystore_putline 9
/def -i key_shift_f10 = /keystore_putline 10
;; ---------------------------------
;; -------- do stored line----------
;; ---------------------------------
/def -i keystore_getline = \
	/let store_temp_line=%;\
	/eval /test store_temp_line := stored_line_%{1}%;\
	/if (substr(store_temp_line,0,1) =~ "/") \
		/echo -p Doing command %{1}:@{Cgreen} %{store_temp_line}%;\
		/eval /eval -s0 $[store_temp_line]%;\
	/else \
		/echo -p Sending line %{1}:@{Cgreen} %{store_temp_line}%;\
		/eval $[store_temp_line]%;\
	/endif
;; ---------------------------------
;; ------- get stored line ---------
;; ---------------------------------
/def -i keystore_inputline = \
	/eval /grab $$[stored_line_%{1}]%;\
	/eval /echo -p Editing line %{1}:@{Cgreen} $$[stored_line_%{1}]
;; ---------------------------------
;; -------- store line -------------
;; ---------------------------------
/def -i keystore_putline = \
	/if (!keystore_no_edit) \
		/eval /set stored_line_%{1}=$$(/recall -i /1)%;\
		/grab%;\
		/eval /echo -p Stored line %{1}:@{Cgreen} $$[stored_line_%{1}]%;\
	/else \
		/echo -aCred -p % Edit disabled, unset @{Cyellow}keystore_no_edit@{nCred} first.%;\
	/endif
	
;; ---------------------------------
;; ------- show stored lines -------
;; ---------------------------------
/def -i -b'^[[11~' = /keystore_showlines
/def -i -b'^[OP' = /keystore_showlines
/def -i -b'^[[224z' = /keystore_showlines
/def -i -b'^[[M' = /keystore_showlines
/def -i keystore_showlines = \
	/echo -aB Stored lines:%;\
	/echo -p F1 :@{Cgreen} %{stored_line_1}%;\
	/echo -p F2 :@{Cgreen} %{stored_line_2}%;\
	/echo -p F3 :@{Cgreen} %{stored_line_3}%;\
	/echo -p F4 :@{Cgreen} %{stored_line_4}%;\
	/echo -p F5 :@{Cgreen} %{stored_line_5}%;\
	/echo -p F6 :@{Cgreen} %{stored_line_6}%;\
	/echo -p F7 :@{Cgreen} %{stored_line_7}%;\
	/echo -p F8 :@{Cgreen} %{stored_line_8}%;\
	/echo -p F9 :@{Cgreen} %{stored_line_9}%;\
	/echo -p F10:@{Cgreen} %{stored_line_10}
;; ---------------------------------
;; ------- save stored lines -------
;; ---------------------------------
/def -i keystore_save = \
	/let whereto=$[tfopen("saved_keys.tf","w")]%;\
	/test tfflush(%{whereto},"off")%;\
	/quote -S /test tfwrite(%{whereto},"`"/listvar -mregexp stored_line_[0-9]+"")%;\
	/test tfclose(%{whereto})
