;; varios useful, or not, things
;; Antti Pietikinen (Heidel@operamail.com)
;; 2005



;; need timer stuff
/require -q misc.tf

;; add to helps
/require -q help_list.tf
/help_add /help_various /shapes, /swapgagtemplate, tick timer, etc

;; save tick report status
/require -q variables.tf
/savevar_add tick_timer_*

;; in this file:
;; - /shape
;; - purse total counter
;; - round counter
;; - tick timer (and reporter)
;; - swapgag template
;; - etc...
;; some macros (curses) require bat_litecollection to work
;; just load that file too, order doesn't matter

/def -i help_various=\
	/echo -aB Help for various things:%;\
	/echo | /shapes                       Recall 10 last shapes%;\
	/echo | /shapes /n                    Recall n last shapes%;\
	/echo |%;\
	/echo | /swapgagtemplate <name>       Gag wearing and removing done by <name>.%;\
	/echo |                               (case sensetive!)%;\
	/echo | /purge swapgag_*              Remove all swap gags.%;\
	/echo |%;\
	/echo | /set tick_timer_report    =0  Report ticks if set to 1%;\
	/echo | /set tick_timer_timelimit =48 Maximum time between ticks%;\
	/echo | /set tick_timer_timelow   =14 Minimum time between ticks%;\
	/echo |                               These are used to avoid 3 minute ticks. Set the%;\
	/echo |                               limit to 9999 and low to 0 to count all as tick.%;\
	/echo | /set tick_timer_splimit   =60 Minimum sps per tick%;\
	/echo |                               This is used to avoid campfire-ticks.%;\
	/echo |                               Set to 0 to count everything as tick.%;\
	/echo |                               (note: tick timer settings save over /quit)%;\
	/echo | /curses                       Show times and targets%;\
	/echo | /rip <action|clear>           Set up action when monster dies%;\
	/echo |                               (E.G. /rip @dig grave, /rip clear)%;\
	/echo |%;\
	/echo | See file bat_various.tf for info about the other things in the file.%;\


;; ----------------------------------------
;; show last 10 or n lines with shapes
;; examples: /shapes
;;           /shapes /200		(note the '/')

/def -i shapes = \
	/recall -mregexp -w -ag -q -t"%T" %{1-/10} \
	(excellent shape|good shape|slightly hurt|noticeably hurt|bad shape|near death)


;; ----------------------------------------
;; automatically count purse contents, gold+
;; odd, have to /trigger, should run through priorities normally

/def -i    -Fp100 -mregexp -t"^It contains .* coins.$" purse_total = \
	/def -Fp305 -mregexp -t"([0-9]+) mithril"   purse_mith = /test pursetotal := pursetotal + {P1}*500%;\
	/def -Fp304 -mregexp -t"([0-9]+) batium"    purse_bati = /test pursetotal := pursetotal + {P1}*100%;\
	/def -Fp303 -mregexp -t"([0-9]+) anipium"   purse_anip = /test pursetotal := pursetotal + {P1}*50%;\
	/def -Fp302 -mregexp -t"([0-9]+) platinum"  purse_plat = /test pursetotal := pursetotal + {P1}*10%;\
	/def -Fp301 -mregexp -t"([0-9]+) gold"      purse_gold = /test pursetotal := pursetotal + {P1}*1%;\
	/def -p200 -mregexp -t"^It contains .* coins.$$" purse_summ = \
		/echo -aB % Purse contains money worth %%{pursetotal} gold.%%;\
		/purge purse_????%;\
	/unset pursetotal%;\
	/trigger %{*}

;; ----------------------------------------
;; counts rounds

/def -i -Fp0 -msimple -t'*****************************************************' round_mark_count=\
	/if (time()-last_rounds_time>4) \
		/set roundcounter=0%;\
		/endif%;\
	/substitute -p ********** @{B}ROUND $[++roundcounter]@{xn} ************%;\
	/set last_rounds_time=$[time()]

;; ----------------------------------------
;; adds time to sp ticks, and reports

/if (!isvar(tick_timer_splimit))    /set tick_timer_splimit=60    %;/endif
/if (!isvar(tick_timer_timelimit))  /set tick_timer_timelimit=48  %;/endif
/if (!isvar(tick_timer_timelow))    /set tick_timer_timelow=14    %;/endif
/if (!isvar(tick_timer_report))     /set tick_timer_report=0      %;/endif

/def -i -F -p0 -mregexp -t"^---- \
			Hp: [0-9]+ [+-]?([0-9]+)? \([0-9]+\) \
			Sp: [0-9]+ ([+-][0-9]+) \([0-9]+\) \
			Ep: [0-9]+ [+-]?([0-9]+)? \([0-9]+\) \
			----" tick_timer=\
	/if ( {P2} > tick_timer_splimit ) \
		/test tick_timechange := time() - tick_lasttime%;\
		/if (tick_timechange < tick_timer_timelimit & tick_timechange > tick_timer_timelow ) \
			/test substitute(strcat({*}," \( ",timeformat({tick_timechange})," \)"))%;\
			/if (tick_timer_report) \
				/prot tick %{P2} sps ( $[timeformat(tick_timechange)] )%;\
			/endif%;\
		/endif%;\
		/test tick_lasttime := time()%;\
	/endif

;; ----------------------------------------
;; template for creating swap-spam gagger
;; example /swapgagtemplate Nuane
;; /purge swapgag_* to remove these

/def -i swapgagtemplate=\
	/def -ag -F -t'%{1} wears *' swapgag_w_%{1}=/echo %{1} wears something.%;\
	/def -ag -F -t'%{1} removes *' swapgag_r_%{1}=/echo %{1} removes something.


;; ----------------------------------------
;; count barb reputation from the marks

/def -i -F -ag -mregexp -t"^\[([X]*)([@]*)([#]*)([:]*)([.]*)\]$" barbarian_reputation=\
	/let rep_count=$[10000*strlen({P1})+1000*strlen({P2})+100*strlen({P3})+10*strlen({P4})+strlen({P5})]%;\
	/echo %{P0} (%{rep_count})


;; ----------------------------------------
;; curses
;; requires bat_litecollection to work

/def -i curses=\
	/echo -aB Curses:%;\
	/echo - Spider touch      : %{spidertouch_target} ($(/timer_show timer_spidertouch))%;\
	/echo - Degenerate person : %{degen_target} ($(/timer_show timer_degen))%;\
	/echo - Curse of tarmalen : %{cot_target} ($(/timer_show timer_cot))

;; ----------------------------------------
;; rip
;; set up actions when you kill a monster

/def do_death

/def -i rip=\
	/if ({*}=~"") \
		/list do_death%;\
	/elseif ({*}=~"clear") \
		/edit do_death=%;\
	/else \
		/if (substr({*},0,1)=~"/") \
			/edit do_death=/eval -s0 %{*}%;\
		/else \
			/edit do_death=/send -h %{*}%;\
		/endif%;\
	/endif

/rip get all from corpse;;dig grave

;; ----------------------------------------
;; show exp change and last monster's name

/def -i -F -mregexp -t"^([a-z A-Z.,'-]+) is DEAD, R\.I\.P\.$" exp_monster_dead=\
	/set prompt_monster=%{P1}%;\
	/send -h

;; clear monster's name on prompt, to avoid explore-exp showing as kills
/def -i -Fp3000 -mregexp -h"PROMPT ^Hp: [0-9-]+/[0-9]+ Sp: [0-9-]+/[0-9]+ Exp: (.*) >" exp_prompt=\
	/if (!({P1}==prompt_oldexp)) \
		/let expchange=$[{P1}-{prompt_oldexp}]%;\
		/if (prompt_monster=~"") \
			/echo -aB % Exp: %{expchange}%;\
		/else \
			/echo -aB % Exp: %{expchange} - %{prompt_monster}%;\
			/do_death%;\
		/endif%;\
	/endif%;\
	/set prompt_monster=%;\
	/set prompt_oldexp=%{P1}




