;; automatic targetting heuristics, with 'buffering' using world features
;; and commands to use the targets.
;; Antti Pietikinen (heidel@operamail.com)
;; 2005

;; purgevar needed
/require -q misc.tf

;; manual targets stored
/require -q variables.tf
/savevar_add off_target_*
/savevar_add heal_target_*

;; help
/require -q help_list.tf
/help_add /help_target targetting helper

/def -i help_target=\
	/echo -aB Target helper usage:%;\
	/echo Commands:%;\
	/echo tt      show the latest heuristic targets%;\
	/echo uu      show off_target-list%;\
	/echo ee      show heal_target-list%;\
	/echo u <x>   set off_target to <x>%;\
	/echo u# <x>  set off_target_# to <x>%;\
	/echo e <x>   set heal_target to <x>%;\
	/echo e# <x>  set heal_target_# to <x>%;\
	/echo uc      clear off_target%;\
	/echo ec      clear heal_target%;\
	/echo %;\
	/echo Automatically replaced:%;\
	/echo t   ->  latest primary heuristic target%;\
	/echo tt  ->  latest secondary heuristic target%;\
	/echo ttt ->  latest tertiary heuristic target%;\
	/echo t#  ->  #th lastest heuristic target%;\
	/echo u   ->  off_target%;\
	/echo u#  ->  off_target_#%;\
	/echo e   ->  heal_target%;\
	/echo e#  ->  heal_target_#%;\
	/echo note:   heal_target_[1-3][1-3] are taken from party places%;\
	/echo %;\
	/echo Examples:%;\
	/echo cast 'magic missile' tt -> cast 'magic missile' dragon%;\
	/echo cast 'cure light wounds' e22 -> cast 'cure light wounds' heidel%;\
	/echo

;; -----------------------------
;; encode the colour, match
;; -----------------------------
/def -i -Fp0 -mregexp -t"^[A-Za-z]" target_get_color=\
	/let target_line $[encode_attr({*})]%;\
	/if (!regmatch("^[^@]",target_line)) \
		/if (regmatch("^@\{B?(Cgreen|Cyellow,Cbgred)\}([^@]*)@\{n\}",target_line))\
			/target_find $[tolower(strip_attr({*}))]%;\
			/substitute - %{*} [t-%{target_primary} tt-%{target_secondary} ttt-%{target_tertiary}]%;\
		/endif%;\
	/endif


;; -----------------------------
;; set the target
;; -----------------------------
/def -i target_find=\
	/set target_look=%{*}%;\
	/set target_primary=%;\
	/set target_secondary=%;\
	/target_rules %{target_rulelist}%;\
	/target_store %{target_tertiary} %{target_secondary} %{target_primary}

;; -----------------------------
;; start matching
;; -----------------------------
/def -i target_rules=\
	/set target_list=%;\
	/while ({#}) \
		/if (regmatch(textdecode({1}),target_look) > 0) \
			/test target_list := strcat({P1}," ",target_list)%;\
;			/echo %{P1} <- $[textdecode({1})]%;\
		/endif%;\
		/shift%;\
	/done%;\
	/target_set_names %{target_list}%;\
	/target_get_name %{target_list}%;\
;	/echo -aCgreen % %{target_look} : %{target_primary} %{target_secondary} %{target_tertiary}

;; -----------------------------
;; count the matches
;; -----------------------------
/def -i target_set_names=\
	/set target_list=%;\
	/purgevar target_names_*%;\
	/while ({#}) \
		/if (strlen({1}) > 2) \
			/eval /test ++target_names_$[textencode({1})]%;\
			/test target_list := strcat({1}," ",target_list)%;\
		/endif%;\
		/shift%;\
	/done

;; -----------------------------
;; get the most matched name
;; -----------------------------
/def -i target_get_name=\
	/set target_primary=%;\
	/set target_secondary=%;\
	/set target_tertiary=%;\
	/let target_primary_count=0%;\
	/let target_secondary_count=0%;\
	/let target_tertiary_count=0%;\
	/let target_names=%;\
	/let target_names_count=%;\
	/shift%;\
	/while ({#}) \
		/test target_names := strcat("target_names_",textencode({1}))%;\
		/eval /test target_names_count := %{target_names}%;\
		/if (target_names_count > target_primary_count) \
			/if (target_primary !~ {1}) \
				/set target_tertiary=%{target_secondary}%;\
				/set target_secondary=%{target_primary}%;\
				/set target_primary=%{1}%;\
				/let target_tertiary_count=%{target_secondary_count}%;\
				/let target_secondary_count=%{target_primary_count}%;\
				/let target_primary_count=%{target_names_count}%;\
			/endif%;\
		/elseif (target_names_count > target_secondary_count) \
			/if (target_secondary !~ {1} & target_primary !~ {1}) \
				/set target_tertiary=%{target_secondary}%;\
				/set target_secondary=%{1}%;\
				/let target_tertiary_count=%{target_secondary_count}%;\
				/let target_secondary_count=%{target_names_count}%;\
			/endif%;\
		/elseif (target_names_count > target_tertiary_count) \
			/if (target_tertiary !~ {1} & target_secondary !~ {1} & target_primary !~ {1}) \
				/set target_tertiary=%{1}%;\
				/let target_tertiary_count=%{target_names_count}%;\
			/endif%;\
		/endif%;\
		/shift%;\
	/done

;; -----------------------------
;; got the targets, buffering them
;; -----------------------------
/set target_histsize 30
/test addworld("target_buffer",     "", "", "", "", "", "", "e")
/test $(/histsize -wtarget_buffer %{target_histsize})

/def -i target_store=\
	/while ({#}) \
		/recordline -wtarget_buffer %{1}%;\
		/shift%;\
	/done

;; -----------------------------
;; target-inform done with this
;; -----------------------------
/def -i target_hook=\
	/if (!target_quiet) \
		/echo -aCgreen -p % target: %{1} -> @{BCyellow}%{-1}%;\
	/endif

;; -----------------------------
;; hooks for automatic targets
;; -----------------------------

;; t
/def -i -mregexp -p10 -h"SEND [ ]t\b" target_send_t=\
	/let target_t=$(/recall -q -wtarget_buffer - -1)%;\
	/target_hook %{P0} %{target_t}%;\
	/set off_target %{target_t}%;\
	/send -h %{PL} %{target_t}%{PR}
;; tt
/def -i -mregexp -p10 -h"SEND [ ]tt\b" target_send_tt=\
	/let target_t=$(/recall -q -wtarget_buffer - -2)%;\
	/target_hook %{P0} %{target_t}%;\
	/set off_target %{target_t}%;\
	/send -h %{PL} %{target_t}%{PR}
;; ttt
/def -i -mregexp -p10 -h"SEND [ ]ttt\b" target_send_ttt=\
	/let target_t=$(/recall -q -wtarget_buffer - -3)%;\
	/target_hook %{P0} %{target_t}%;\
	/set off_target %{target_t}%;\
	/send -h %{PL} %{target_t}%{PR}
;; t#
/def -i -mregexp -p10 -h"SEND [ ]t([0-9]+)\b" target_send_tnum=\
	/let target_t=$(/recall -wtarget_buffer %{P1}-%{P1})%;\
	/target_hook %{P0} %{target_t}%;\
	/set off_target %{target_t}%;\
	/send -h %{PL} %{target_t}%{PR}
;; tt
/def -i -F -h"SEND tt" target_send_t_show=\
	/echo -aB % Stored targets (auto):%;\
	/recall -q -wtarget_buffer #%{target_histsize}
;; t#
/def -i -F -mregexp -h"SEND ^t([0-9]+)$" target_send_t_get=\
	/let target_t=$(/recall -wtarget_buffer %{P1}-%{P1})%;\
	/set off_target %{t_target}%;\
	/echo -aCgreen -p % offensive target set to @{BCyellow}%{off_target}

;; -----------------------------
;; hooks for manual targets
;; -----------------------------

;; u
/def -i -p11 -q -h"SEND peer u" target_peer_u
/def -i -mregexp -p10 -h"SEND [ ]u\b" target_send_u=\
	/target_hook %{P0} %{off_target}%;\
	/send -h %{PL} %{off_target}%{PR}
;; u#
/def -i -mregexp -p10 -h"SEND [ ]u([0-9]+)\b" target_send_u_num=\
	/let target_t=%;\
	/eval /test target_t := off_target_%{P1}%;\
	/target_hook %{P0} %{target_t}%;\
	/send -h %{PL} %{target_t}%{PR}
;; u <x>
/def -i -F -h"SEND u *" target_send_utar=\
	/echo -aCgreen -p % offensive target set to @{BCyellow}%{-1}%;\
	/set off_target %{-1}
;; uu
/def -i -F -h"SEND uu" target_send_u_show=\
	/echo -aB % Stored targets (off):%;\
	/quote -S /target_show_helper `"/listvar off_target_*"
;; uc
/def -i -F -h"SEND uc" target_send_uc=\
	/set off_target=
/def -i -F -h"SEND cu" target_send_cu=\
	/set off_target=
;; u# <x>
/def -i -mregexp -F -h"SEND ^u([0-9]+) (.+)" target_send_u_set=\
	/set off_target_%{P1} %{P2}%;\
	/echo -aCgreen -p % offensive target %{P1} set to @{BCyellow}%{P2}
;; u#
/def -i -mregexp -F -h"SEND ^u([0-9]+)$" target_send_u_get=\
	/eval /set off_target %%{off_target_%{P1}}%;\
	/echo -aCgreen -p % offensive target set to @{BCyellow}%{off_target}


;; -----------------------------
;; hooks for party targets
;; -----------------------------
;; e
/def -i -p11 -q -h"SEND peer e" target_peer_e
/def -i -mregexp -p10 -h"SEND [ ]e\b" target_send_e=\
	/target_hook %{P0} %{heal_target}%;\
	/send -h %{PL} %{heal_target}%{PR}
;; e#
/def -i -mregexp -p10 -h"SEND [ ]e([0-9]+)\b" target_send_enum=\
	/let target_t=%;\
	/eval /test target_t := heal_target_%{P1}%;\
	/target_hook %{P0} %{target_t}%;\
	/send -h - %{PL} %{target_t}%{PR}
;; e <x>
/def -i -F -h"SEND e *" target_send_etar=\
	/echo -aCgreen -p % heal target set to @{BCyellow}%{-1}%;\
	/set heal_target %{-1}
;; ee
/def -i -F -h"SEND ee" target_send_e_show=\
	/echo -aB % Stored targets (heal):%;\
	/quote -S /target_show_helper `"/listvar heal_target_*"
;; ec
/def -i -F -h"SEND ec" target_send_ec=\
	/set heal_target=
;; e# <x>
/def -i -mregexp -F -h"SEND ^e([0-9]+) (.+)" target_send_e_set=\
	/set heal_target_%{P1} %{P2}%;\
	/echo -aCgreen -p % heal target %{P1} set to @{BCyellow}%{P2}
;; e#
/def -i -mregexp -F -h"SEND ^e([0-9]+)$" target_send_e_get=\
	/eval /set heal_target %%{heal_target_%{P1}}%;\
	/echo -aCgreen -p % heal target set to @{BCyellow}%{heal_target}

;; -----------------------------
;; get targets from party status
;; -----------------------------
/def -F -i -mregexp -t"\| ([1-3])\.([1-3])   ([A-Z][a-z]+)" target_party=\
	/set heal_target_%{P1}%{P2}=$[tolower({P3})]

;; -----------------------------
;; show helper
;; -----------------------------
/def -i target_show_helper=\
	/let target_equal $[strchr({*},"=")]%;\
	/let target_under $[strrchr({*},"_",target_equal)]%;\
	/let target_num $[substr({*},target_under+1,target_equal-target_under-1)]%;\
	/let target_name $[substr({*},target_equal+1)]%;\
	/echo -aCgreen -p $[pad(target_num,-6)] @{BCyellow}%{target_name}

;; -----------------------------
;; heuristic rules
;; -----------------------------
/def -i target_add_rule=\
	/test target_rulelist := strcat(textencode({*})," ",target_rulelist)

/unset target_rulelist
/target_add_rule ([a-zA-Z-]+)$
/target_add_rule ^([a-zA-Z-]+)
/target_add_rule (?i)(?:a |an |the |^)[a-z]+ed ([a-z-]+)
/target_add_rule (?i)(?:a |an |the |^)[a-z]+y ([a-z-]+)
/target_add_rule (?i)(?:a |an |the |^)[a-z]+ing ([a-z-]+)
/target_add_rule (?i)(?:a|an|the) ([a-z-]+)
/target_add_rule (?i)(?:a|an|the) [a-z-]+ ([a-z-]+)
/target_add_rule ([a-zA-Z-]+),
/target_add_rule ([a-zA-Z-]+) [a-z]+ing [a-z]+
/target_add_rule ([a-zA-Z-]+) of 
/target_add_rule ([a-zA-Z-]+) with [a-z]+
/target_add_rule ([a-z]+er)[ $]
/target_add_rule ([a-z]+) [a-z]+s [a-z]+
/target_add_rule ([A-Z][a-z-]+)
/target_add_rule ([A-Z][a-z-]+),
