;; chainer for skills and spells
;; Antti Pietikinen (heidel@operamail.com) 2005

;; save redo and autostart status
/require -q variables.tf
/savevar_add stack_autoredo
/savevar_add stack_autostart

/require -q help_list.tf
/help_add /help_stack Skill/spell/command stack

/def -i help_stack=\
	/echo -aB Help for command stack:%;\
	/echo /stack_add_last <x>   Add <x> to the end of stack%;\
	/echo /stack_add_first <x>  Add <x> to the beginning of stack%;\
	/echo /stack_show           Shows stack status%;\
	/echo /stack_remove [#]     Remove all or #th item from stack%;\
	/echo /stack_skip           Skip current/next item%;\
	/echo /stack_start          Start performing stacked commands%;\
	/echo c                     continue broken stack performance%;\
	/echo sv                    /stack_show%;\
	/echo sa <command>          add <command> to the end of the stack%;\
	/echo sk                    /stack_skip%;\
	/echo sr [#]                /stack_remove [#]%;\
	/echo sl                    list stack contents%;\
	/echo scast <spell>         add cast <spell> to the end of the stack%;\
	/echo suse <skill>          add use <skill> to the end of the stack%;\
	/echo %;\
	/echo Notes:%;\
	/echo (1) If variable 'stack_autoredo' is set, failed commands are%;\
	/echo automatically repeated, if possible.%;\
	/echo (2) If variable 'stack_autostart' is set, command stack is started%;\
	/echo whenever something is added to the stack%;\
	/echo 


/if (!isvar("stack_autoredo")) \
	/set stack_autoredo 1%;\
/endif

/if (!isvar("stack_autostart")) \
	/set stack_autostart 1%;\
/endif

;; variables:
;; stack_data            list of commands
;; stack_success         if success, move on, if not, redo
;; stack_doing           current command
;; stack_started         command sent, waiting start
;; stack_waiting         command started, waiting finish
;; stack_autostart       if 1, start when command added, if not, manual start via /stack_start 1
;; stack_autoredo        if 1, try again after break, else stop
;; stack_type            skill,spell,send,command
;; stack_blocked         if 1, manual restart

###############################
# stack_send
# handles all sends
###############################
/def -i stack_send=/send -h @%{*}

###############################
# add something to stack
# and start if stack_autostart
###############################
/def -i stack_add_last=\
	/test getopts("q")%;\
	/test stack_data := strcat(stack_data," ",textencode({*}))%;\
	/if (!opt_q) \
		/echo -aCgreen -p % Stack added (last): @{Cyellow}%{*}%;\
	/endif%;\
	/stack_autostart

/def -i stack_add_first=\
	/test getopts("q")%;\
	/test stack_data := strcat(textencode({*})," ",stack_data)%;\
	/if (!opt_q) \
		/echo -aCgreen -p % Stack added (first): @{Cyellow}%{*}%;\
	/endif%;\
	/stack_autostart

/def -i stack_add=\
	/stack_add_last -q %{*}

/def -i stack_autostart=\
	/if (stack_autostart==1) \
		/if ((!stack_waiting)&(!stack_started)) \
;			/echo -aCgreen % Stack starting.%;\
			/stack_start%;\
		/endif%;\
	/endif


###############################
# remove something from stack
###############################
/def -i stack_remove=\
	/if ({#} == 0) \
		/set stack_data=%;\
		/echo -aCred % Stack removed.%;\
	/else \
		/if ({#} == 1) \
			/if (stack_data!~"") \
				/stack_remove %{1} %{stack_data}%;\
			/else \
				/echo -aCred % Stack already empty.%;\
			/endif%;\
		/else \
			/let stack_t=%{1}%;\
			/let stack_c=1%;\
			/set stack_data=%;\
			/shift%;\
			/while ({#}) \
				/if (stack_c == stack_t) \
					/echo -aCred -p % Removed from stack: @{Cyellow}$[textdecode({1})]%;\
				/else \
					/test stack_data := strcat(stack_data," ",{1})%;\
				/endif%;\
				/shift%;\
				/test ++stack_c%;\
			/done%;\
		/endif%;\
	/endif


###############################
# show stack status
###############################
/def -i stack_show=\
	/echo -aB Stack status:%;\
	/if (stack_started==1) \
		/echo -aCgreen -p Sent @{Cyellow}%{stack_doing}@{n}, waiting response.%;\
	/endif%;\
	/if (stack_waiting==1) \
		/echo -aCgreen -p Waiting @{Cyellow}%{stack_doing}@{n} to finish.%;\
	/endif%;\
	/echo -aB Settings:%;\
	/if (stack_autostart==1) \
		/echo -p -aCgreen Adding commands starts stack automatically (@{Cyellow}stack_autostart@{n}).%;\
	/else \
		/echo -p -aCred Adding commands won't start stack automatically (@{Cyellow}stack_autostart@{n}).%;\
	/endif%;\
	/if (stack_autoredo==1) \
		/echo -p -aCgreen Broken skills and spells are automatically redone (@{Cyellow}stack_autoredo@{n}).%;\
	/else \
		/echo -p -aCred Broken skills or spells won't be redone (@{Cyellow}stack_autoredo@{n}).%;\
	/endif%;\
	/echo -aB Commands stacked:%;\
	/stack_list %{stack_data}

/def -i stack_list=\
	/if ({#} == 0) \
		/echo -aCred Stack is empty.%;\
	/else \
		/let stack_i=0%;\
		/while ({#}) \
			/echo -aCgreen -p $[++stack_i]: @{Cyellow}$[textdecode({1})]%;\
			/shift%;\
		/done%;\
	/endif


###############################
# start doing the stack
###############################
/def -i stack_start=\
	/set stack_blocked=0%;\
	/if (stack_waiting==0 & stack_started==0) \
		/stack_do_next %{stack_data}%;\
	/else \
		/echo -aCgreen -p % Stack restarting: @{Cyellow}%{stack_doing}%;\
		/stack_do%;\
	/endif%;\

###############################
# do current command
###############################
/def -i stack_do=\
	/if (stack_doing=~"") \
		/stack_do_next %{stack_data}%;\
	/else \
		/if (stack_type =~ "command") \
			/eval -s0 %{stack_doing}%;\
			/stack_done%;\
		/else \
			/set stack_started=1%;\
			/stack_send %{stack_doing}%;\
		/endif%;\
	/endif

###############################
# do the next stack item
###############################
/def -i stack_do_next=\
	/if ({#} == 0) \
		/if (stack_doing !~ "") \
			/set stack_doing=%;\
			/set stack_waiting=0%;\
			/set stack_started=0%;\
			/echo -aCgreen % Stack done.%;\
		/endif%;\
	/else \
		/set stack_doing=$[textdecode({1})]%;\
		/shift%;\
		/set stack_data=%{*}%;\
		/set stack_success=1%;\
		/stack_set_type%;\
		/echo -aCgreen -p % Stack doing now: @{Cyellow}%{stack_doing}%;\
		/stack_do%;\
	/endif


###############################
# item done
###############################
/def -i stack_done=\
	/set stack_waiting=0%;\
	/if (stack_success) \
;		/echo -aCgreen -p % Stack success: @{Cyellow}%{stack_doing}@{n}, moving on...%;\
		/stack_do_next %{stack_data}%;\
	/else \
		/echo -aCred -p % Stack failed, redoing: @{Cyellow}%{stack_doing}@{n}%;\
		/stack_do%;\
	/endif

###############################
# stop
###############################
/def -i stack_stop=\
	/echo -aCred -p % Stack interrupted, 'c' to redo: @{Cyellow}%{stack_doing}%;\
	/set stack_started=0%;\
	/set stack_waiting=0


###############################
# clear
###############################
/def -i stack_clear=\
	/set stack_data=%;\
	/set stack_doing=%;\
	/set stack_started=0%;\
	/set stack_waiting=0

###############################
# skip
###############################
/def -i stack_skip=\
	/if (stack_doing!~"") \
		/echo -aCgreen -p % Stack skipping: @{Cyellow}%{stack_doing}%;\
	/else \
		/echo -aCgreen -p % Stack skipping next item.%;\
	/endif%;\
	/if (stack_waiting | stack_started) \
		/send @zz%;\
		/stack_do_next %{stack_data}%;\
	/else \
		/if (stack_doing=~"") \
			/stack_remove 1%;\
		/else \
			/set stack_doing=%;\
		/endif%;\
	/endif


###############################
# set command type
###############################
/def -i stack_set_type=\
	/if (stack_doing=/"use *") \
		/set stack_type=skill%;\
	/elseif (stack_doing=/"cast *") \
		/set stack_type=spell%;\
	/elseif (stack_doing=/"/*") \
		/set stack_type=command%;\
	/else \
		/set stack_type=send%;\
	/endif


###############################
# skill/spell started
###############################
/def -i -F -msimple -t"You start chanting."                                       stack_begin_1=/stack_sent
/def -i -F -msimple -t"You start concentrating on the skill."                     stack_begin_2=/stack_sent
/def -i -F -mglob   -t"You You start to channel the forces magical*"              stack_begin_3=/stack_sent
/def -i -F -mglob   -t"You conceal your intent of channeling the forces magical*" stack_begin_4=/stack_sent

/def -i stack_sent=\
	/if (stack_started==1) \
		/set stack_started=0%;\
		/set stack_waiting=1%;\
		/set stack_success=1%;\
	/endif

/def -i -E(stack_started) -F -q -hPROMPT stack_prompt=\
	/if (stack_type=~"send") \
		/set stack_started=0%;\
		/stack_done%;\
	/endif

###############################
# skill/spell broken
###############################
# 0-can retry 1-cannot retry
/def -i -F -msimple -t"Your movement prevents you from casting the spell."     stack_broken_1=/stack_break 1
/def -i -F -msimple -t"Your movement prevents you from doing the skill."       stack_broken_2=/stack_break 1
/def -i -F -msimple -t"You lose your concentration and cannot cast the spell." stack_broken_3=/stack_break 0
/def -i -F -msimple -t"You lose your concentration and cannot do the skill."   stack_broken_4=/stack_break 0
/def -i -F -msimple -t"You do not have enough spell points to cast the spell." stack_broken_5=/stack_break 1
/def -i -F -msimple -t"A turbulence in the time-space continuum prevents you." stack_broken_6=/stack_break 1
/def -i -F -msimple -t"You're too concentrated on grave digging."              stack_broken_7=/stack_break 1

/def -i stack_break=\
	/set stack_blocked=%{1}%;\
	/set stack_waiting=0%;\
	/if (stack_autoredo & !stack_blocked) \
		/echo -aCred -p % Stack interrupted, redoing: @{Cyellow}%{stack_doing}%;\
		/stack_do%;\
	/else \
		/stack_stop%;\
	/endif

###############################
# skill/spell done
###############################
/def -i -F -msimple -t"You are done with the chant."       stack_done_1=/stack_done_on_prompt
/def -i -F -msimple -t"You are prepared to do the skill."  stack_done_2=/stack_done_on_prompt
/def -i -F -mglob   -t"You declare with a booming voice *" stack_done_3=/stack_done_on_prompt


/def -i stack_done_on_prompt=\
	/if (stack_waiting) \
		/def -F -q -1 -hPROMPT stack_temp_prompt=\
			/stack_done%;\
		/send -h%;\
	/endif


###############################
# spell fails
###############################
/def -i -F -msimple -t"Your spell just sputters."                                              stack_failed_0=/stack_failed
/def -i -F -msimple -t"You fail miserably in your spell."                                      stack_failed_1=/stack_failed
/def -i -F -msimple -t"You stumble and lose your concentration."                               stack_failed_2=/stack_failed
/def -i -F -msimple -t"You stutter the magic words and fail the spell."                        stack_failed_3=/stack_failed
/def -i -F -msimple -t"Your concentration fails and so does your spell."                       stack_failed_4=/stack_failed
/def -i -F -msimple -t"You are disturbed by something, your spell misfires."                   stack_failed_5=/stack_failed
/def -i -F -msimple -t"You lose touch with the magic and the spell fizzles."                   stack_failed_6=/stack_failed
/def -i -F -msimple -t"You poke yourself in the eye and your spell misfires."                  stack_failed_7=/stack_failed
/def -i -F -msimple -t"Your mind plays a trick with you and you fail in your spell."           stack_failed_8=/stack_failed
/def -i -F -msimple -t"Something touches you and spoils your concentration ruining the spell." stack_failed_9=/stack_failed
/def -i -F -msimple -t"Your concentration drifts away as you think you feel a malignant aura." stack_failed_10=/stack_failed

/def -i stack_failed=\
	/set stack_success=0

###############################
# skill fails (no universal)
###############################
/def -i -F -t"You fail to start the fire." stack_failed_firebuilding=/stack_failed



###############################
# command aliases
###############################
/def -i -F -h"SEND c" send_stack_continue=\
	/stack_start
/def -i -F -h"SEND cc" send_cc=\
	/send c
/def -i -F -h"SEND sv" send_stack_show=\
	/stack_show
/def -i -F -h"SEND sa *" send_stack_add_last=\
	/stack_add_last %{-1}
/def -i -F -h"SEND sk" send_stack_skip=\
	/stack_skip
/def -i -F -h"SEND sr *" send_stack_remove=\
	/stack_remove %{*}
/def -i -F -h"SEND sl" send_stack_list=\
	/stack_list %{stack_data}
/def -i -F -q -h"SEND zz" send_cast_stop_1=\
	/stack_stop
/def -i -F -q -h"SEND @zz" send_cast_stop_2=\
	/stack_stop
/def -i -F -h"SEND scast *" send_stack_cast=\
	/stack_add_last cast %{-1}
/def -i -F -h"SEND suse *" send_stack_use=\
	/stack_add_last use %{-1}