;; spider stuff
;; Antti Pietikinen (Heidel@batmud)

;; purgevar and timers
/require -q misc.tf

;; spider keys
/require -q bat_keys.tf

/def -i -b'Q' = @use 'stab'
/def -i -b'T' = @cast spider wrath
/def -i -b'r' = @lord_chaos blood corpse
/def -i -b'q' = @use 'stab' %{off_target}
/def -i -b'e' = @cast 'hemorrhage' %{off_target}
/def -i -b'd' = @cast 'cause serious wounds' %{off_target}
/def -i -b't' = @cast 'spider wrath' %{off_target}
/def -i -b'm' = @cast mellon collie at %{off_target}
/def -i -b'h' = @cast 'hunger of the spider' %{off_target}
/def -i -b'c' = @cast 'spider touch' %{off_target}
/off_template  q use 'stab'
/key_template  Q use 'stab'
/off_template  e cast 'spider wrath'
/key_template  E cast 'spider wrath'
/key_template  r lord_chaos blood corpse|@get all corpse
/def -i -b's' = @use ceremony
/def -i -b'f' = @use first aid at %{fa_target}%;/echo Reviving %fa_target
/def -i -b'a' = @cast cure light wounds at %{heal_target}
/def -i -b'A' = /cure 5 %{heal_target}
/off_template  h cast hunger of the spider at


;; demonihelpperi
/def -i call_demon = @cast 'spider demon conjuration' %{1} with %{2}%;\
/recordline -i @cast 'spider demon channeling' %{1}

;; whisperlite
/def -i -F -mregexp -P1Cred -t'^[a-zA-Z ]+ the spider whispers \'(.*)\'$' whisperlite

;; venom blade works
/def -i -P1Cgreen -F -mregexp \
	-t'suffers as (poison from your blade) flows into (his|her|its) system!' venom_hit_stab

;; hunger of the spider special dams
/def -i -F -aB -mglob -t'You twist your * inside *\'s belly!' hunger_twist
/def -i -F -aB -mglob -t'* cringes from pain as your venomed blade bites into * flesh!' hunger_venom

;; venom blade improves
/def -i -aCmagenta,Cbgwhite -mglob -t'You learn to channel more pure blood from Spider Queen.' venom_blade_imp

/def -i process_count=\
   /let count=$[$(/eval /_echo %%{%{*}})-$(/eval /_echo %%{%{*}_old})]%;\
   /_echo %{count}

;; spider demon favour, 1 luku
/def -i -F -t'A mystic number echoes in the dark corridors of your feeble mind \'*\'' count_demons =\
   /set d_count_old=%{d_count}%;\
   /set d_count=$[substr({13},1,-1)]%;\
   /set d_change=$(/process_count d_count)%;\
   /echo % Spider demon change : %{d_change}
/def -i show_demons=/echo % Last Spider Demon count : %{d_count}

;; spider demon favour, 2 luku
/def -i -F -t'Another number comes as an after echo of the first one \'*\'' count_wraths =\
   /set w_count_old=%{w_count}%;\
   /set w_count=$[substr({12},1,-1)]%;\
   /set w_change=$(/process_count w_count)%;\
   /echo % Spider wrath change : %{w_change}
/def -i show_wraths=/echo % Last Spider Wrath count : %{w_count}

/def -i -F -P1Cred -mregexp -t'^A wound opens on your palm and you guide the (.*) blood at (.*)!' wrath_hit=\

/def -i -F -mregexp -t'^A wound opens on your palm and you guide the (.*) blood at (.*)!' wrath_color = \
	/set tmp_wrath wrath_colors_%{P1}%;\
	/eval /set %{tmp_wrath} $$[%{tmp_wrath}+1]%;\
	/unset tmp_wrath

/def -i wrath_stats = \
	/set tmp_total $[wrath_colors_red\
			+wrath_colors_orange\
			+wrath_colors_yellow\
			+wrath_colors_green\
			+wrath_colors_blue\
			+wrath_colors_indigo\
			+wrath_colors_violet\
			+wrath_colors_brown\
			+wrath_colors_black]%;\
	/set tmp_wrath |$[pad(wrath_colors_red,3)]|\
			$[pad(wrath_colors_orange,3)]|\
			$[pad(wrath_colors_yellow,3)]|\
			$[pad(wrath_colors_green,3)]|\
			$[pad(wrath_colors_blue,3)]|\
			$[pad(wrath_colors_indigo,3)]|\
			$[pad(wrath_colors_violet,3)]|\
			$[pad(wrath_colors_brown,3)]|\
			$[pad(wrath_colors_black,3)]|%;\
	/set tmp_wrath_prc |$[pad(wrath_colors_red*100/tmp_total,3)]|\
			$[pad(wrath_colors_orange*100/tmp_total,3)]|\
			$[pad(wrath_colors_yellow*100/tmp_total,3)]|\
			$[pad(wrath_colors_green*100/tmp_total,3)]|\
			$[pad(wrath_colors_blue*100/tmp_total,3)]|\
			$[pad(wrath_colors_indigo*100/tmp_total,3)]|\
			$[pad(wrath_colors_violet*100/tmp_total,3)]|\
			$[pad(wrath_colors_brown*100/tmp_total,3)]|\
			$[pad(wrath_colors_black*100/tmp_total,3)]|%;\
	/echo - ,-----------------------------------.%;\
	/echo |red|orn|yel|grn|blu|ind|vio|bro|blk|%;\
	/echo %{tmp_wrath}%;\
	/echo %{tmp_wrath_prc}%;\
	/echo - `-----------------------------------%;\
	/unset tmp_wrath%;\
	/unset tmp_wrath_prc%;\
	/unset tmp_total

/def -i clear_wrath_stats = \
	/wrath_stats%;\
	/purgevar wrath_colors_*%;\
	/echo % Wrath stats cleared!

/def -i -Fp0 -mregexp -t"^([A-Z][a-z]+)\'s spider demon draws power from you.$" demon_sucksucks=\
	/eval /if (demon_suck_%{P1}_time>0) \
		/substitute %{*} ($(/timer_show demon_suck_%{P1}))%%;\
	/endif%;\
	/eval /timer_start demon_suck_%{P1}

/def -i -F -mregexp -t"^You feed ([A-Z][a-z]+)\'s spider demon\'s hunger with your ritual.$" demon_fed=\
	/eval /timer_start demon_suck_%{P1}

;;Heidel's spider demon draws power from you.
;;You feed Heidel's spider demon's hunger with your ritual.
;;Lung's demon  feels easier to control than usual.
;;Lung's spider demon draws power from you.

;;wrath resists
/def -i -F -t'* screams in pain.' monster_resist_0 = /note_resist --- 0% resist ---
/def -i -F -t'* writhes in agony.' monster_resist_20 = /note_resist --- 20% resist ---
/def -i -F -t'* shudders as the acidic blood burns * flesh.' monster_resist_40 = /note_resist --- 40% resist ---
/def -i -F -t'* grunts in pain.' monster_resist_60 = /note_resist --- 60% resist ---
/def -i -F -t'* winces a little from the pain.' monster_resist_80 = /note_resist --- 80% resist ---
/def -i -F -t'* shrugs off the wrath!' monster_resist_100 = /note_resist --- 100% resist ---

