;; spell eta reporting
;; Antti Pietikinen (Heidel@batmud)

/require -q help_list.tf
/help_add /help_spelltime remaining casting time reporter

/def -i help_spelltime=\
	/echo -aB Spelltime help:%;\
	/echo /st_report            toggles reporting on and off%;\
	/echo /st_time <n>          set maximum rounds to report%;\
	/echo (default rounds is 5)%;\
	/echo if essence eye is lower than 100, reporting may fail%;\
	/echo (edit tf-file for spell gagging)%;\
	/echo

/set st_report_on=0
;; 1 true,0 false
/set st_report_time=5
;; miss vaiheessa reporttia alkaa tulla
/set st_eta=0
/set st_casting=

/def -i st_report=\
	/set st_report_on=$[!st_report_on]%;\
	/echo % Reporting is now %{st_report_on} (1=on) at %{st_report_time} rounds.

/def -i st_time=\
	/set st_report_time=%{*}%;\
	/echo % Reporting is now %{st_report_on} (1=on) at %{st_report_time} rounds.

/def -i st_showtime=\
	/if ( (st_report_on==1) & (st_report_time>=st_eta) & !(st_report_gag(st_casting)) )\
;;		/def -1 -ag -F -t'\** is casting * in *.' st_gag_emote%;\
		@emote is casting %{st_casting} in %{st_eta}%;\
	/endif

;; spells that are never reported. Copy cure serious line and paste it before heal self and 
;; replace the name for the spell to be gagged. Case sensetive!
/def -i st_report_gag =\
	/if (({*} =~ "Cure light wounds") \
		| ({*} =~ "Cure serious wounds")\
	    | ({*} =~ "Heal self") )\
		/result 1%;\
	/endif
	
/def -i -F -mregexp -t'^([a-zA-Z \']*): (#+)' st_time_catch=\
	/set st_eta=$[strlen({P2})]%;\
	/set st_casting=%{P1}%;\
	/st_showtime%;\


/def -i -F -P1B -mregexp -t'^Your quick chant allows you to chant the runes (faster)\.$' st_rhaste=\
	/set st_eta=$[st_eta-1]%;\
	/st_showtime%;\

/def -i -F -P1BCyellow -mregexp -t'^Your quick chant allows you to chant the runes (considerably faster)\.$' st_rghaste=\
	/set st_eta=$[st_eta-2]%;\
	/st_showtime%;\

/def -i -F -P1B -mregexp -t'^You skillfully cast the spell with (haste)\.$' st_haste=\
	/set st_eta=$[st_eta-1]%;\
	/st_showtime%;\

/def -i -F -P1BCgreen -mregexp -t'^You feel (unearthly power) hasten your casting\.$' st_ql=\
	/set st_eta=$[st_eta-1]%;\
	/st_showtime%;\

/def -i -F -P1BCgreen -mregexp -t'^You feel (some power) hasten your casting\.$' st_oql=\
	/set st_eta=$[st_eta-1]%;\
	/st_showtime%;\

/def -i -F -P1BCgreen -mregexp -t'^You feel (godly power) hasten your casting\.$' st_gql=\
	/set st_eta=$[st_eta-1]%;\
	/st_showtime%;\

/def -i -F -P1BCyellow -mregexp -t'^You skillfully cast the spell with (greater haste)\.$' st_ghaste=\
	/set st_eta=$[st_eta-2]%;\
	/st_showtime%;\

/def -i -F -t'You are done with the chant.' st_clear_time= /set st_eta=999999
/def -i -F -t'You declare with a booming voice *' st_clear_time2= /set st_eta=999999
/def -i -F -t'You start chanting.' st_clear_time3= /set st_eta=999999
/def -i -F -t'You You start to channel the forces magical *' st_clear_time4= /set st_eta=999999


/def -i -F -p1 -mregexp -t'^([a-zA-Z \']*): (#+)' convert_hashes_num=\
	/set temp_number_xyz=$[strlen({P2})]%;\
	/substitute -p %{*} (@{B}%{temp_number_xyz}@{xn})%;\
	/unset temp_number_xyz


;; DONE!
/echo -aCyellow % Spelltime helper loaded.
