;; (C) 2003 Antti Pietikinen (Heidel)
;; Adds a +/- thingy that shows the spells/skills changed from your last "show skills"

;;		16.9.2004: save skill/spell data on quit, or with /saveskillspell
;;		9.2.2005: replaced convert_spaces with textencode, skill_kludge de-kludged out of existence
;;		6.5.2005: fixed things.. old data files won't work
;;		8.6.2005: /quit_add, smarter way to save data

;; need /purgevar
/require -q misc.tf

;; need to save at quit
/require -q at_quit.tf
/quit_add /skillspell_save

;; add to helplist 
/require -q help_list.tf
/help_add /help_skillspell add difference column to show skills/spells

;; where to save
/set skillspellfile saved_skillspell.tf

;; load the data
/eval /load -q %{skillspellfile}


/def -i help_skillspell = \
	/echo -aB - Skill and spell checker help:%;\
	/echo /skillspell_save    Saves current skills and spells to file %%{skillspellfile}%;\
	/echo /skillspell_clear   Clears skills and spells (leaves the savefile)%;\
	/echo /skillspell_show    Shows skills and spells currently tracked%;\
	/echo %;\
	/echo Notes:%;\
	/echo (1) The data is loaded at the same time the file is loaded. To force%;\
	/echo re-loading, simply /load the data file.%;\
	/echo (2) The default skillspellfile is 'saved_skillspell.tf'%;\
	/echo (3) Skills and spells are saved at quit.%;\
	/echo (4) These triggers will (should) only check output after "show skills" or%;\
	/echo "show spells", so if you have a command (e.g. ss->show skills), using that%;\
	/echo command doesn't trigger the checking.%;\
	/echo

;; reformat "box", (done via send hook because of common width and format of ,---.)
/def -i -q -F -mregexp -h"SEND ^show (skills|spells)" skillspell_begin_hook =\
	/set skillcheck %{P1}%;\
	/def -i -1 -p999999 -t",-----------------------------------------------------------------------------." skillspell_begin_gag=\
		/substitute ,-------------------------------------------------------------------------------------.%;\
	/def -i -1 -F -t"|================================|=====|================================|=====|" 	skillspell_begin_gag2=\
		/substitute |================================|=========|================================|=========|

;; handle the skill/spell info
;; skill helper, 1-skills/spells, 2-percentage , 3+ name
/def -i skillspell_set=\
	/let temp_var=%;\
	/let temp_change=%;\
	/let temp_substed=%;\
	/test temp_var := strcat({1}, "_", textencode({-2}))%;\
	/eval /test temp_change := {2} - %{temp_var}%;\
	/eval /test %{temp_var} := {2}%;\
	/if ({temp_change} < 0 ) \
		/test temp_substed := temp_change%;\
	/elseif ({temp_change} > 0 ) \
		/test temp_substed := strcat("+",temp_change)%;\
	/elseif ({temp_change} == 0) \
		/let temp_substed=%;\
	/endif%;\
	/result "| $[pad({-2},-30)] | $[pad({2},3)]$[pad(temp_substed,4)] |"


;; set up the capture the skill/spell info- triggers
/def -F -i -mregexp -t"^\| (S..ll)                          \|  %  \| (S..ll)                          \|  %  \|$" skillspell_begin=\
	/substitute | %{P1}                          |  % (+/-)| %{P2}                          |  % (+/-)|%;\
	/def -Fp19999 -P1Cred -mregexp -t"(-[0-9]+)" skillspell_lite_plus%;\
	/def -Fp19998 -P1Cgreen -mregexp -t"([+][0-9]+)" skillspell_lite_minus%;\
	/def -1 -F -t\"|--------------------------------+--------------------------------------------\'" skillspell_end=\
			/substitute |--------------------------------+----------------------------------------------------'%%;\
			/undef skillspell_lite_plus%%;\
			/undef skillspell_lite_minus%%;\
			/unset skillcheck%%;\
			/if /ismacro skillspell_begin_gag%%;\
				/then /undef skillspell_begin_gag%%;\
			/endif%%;\
			/if /ismacro skillspell_begin_gag2%%;\
				/then /undef skillspell_begin_gag2%%;\
			/endif

/def -i -E(skillcheck!~"") -Fp20002 -mregexp -t"^[|] ([A-Za-z ]+) [|][ ]+([0-9]+) [|]" skillspell_subst_1 =\
	/let temp_result=%{PR}%;\
	/test temp_result := strcat("$(/skillspell_set %{skillcheck} %{P2} %{P1})",temp_result)%;\
	/substitute %{temp_result}

/def -i -E(skillcheck!~"") -Fp20001 -mregexp -t"[|] ([A-Za-z ]+) [|][ ]+([0-9]+) [|]$" skillspell_subst_2 =\
	/let temp_result=%{PL}%;\
	/test temp_result := strcat(temp_result,"$(/skillspell_set %{skillcheck} %{P2} %{P1})")%;\
	/substitute %{temp_result}

/def -i -E(skillcheck!~"") -Fp20000 -mregexp -t"[|]([ ]*)[|]([ ]*)[|]$" skillspell_subst_3 =\
	/substitute %{PL}|%{P1}|  %{P2}  |


;; purge data
/def -i skillspell_purge=/purgevar -mregexp s(kill|pell)s_.*

;; save data
/def -i skillspell_save = \
	/let whereto=$[tfopen({skillspellfile},"w")]%;\
	/test tfflush(%{whereto},"off")%;\
	/quote -S /test tfwrite(%{whereto},"`"/listvar -mregexp (skills|spells)_.*"")%;\
	/test tfclose(%{whereto})%;\
	/echo -aB % skills and spells saved!

;; show skills and spells, decrypted
/def -i skillspell_show = \
	/echo -aB Skills:%;\
	/quote -S /skillspell_show_help `/listvar skills_*%;\
	/echo%;\
	/echo -aB Spells:%;\
	/quote -S /skillspell_show_help `/listvar spells_*

;; helper to reformat listvar
/def -i skillspell_show_help = \
	/let temp_start=$[strstr({*},"_")+1]%;\
	/let temp_end=$[strstr({*},"=",{temp_start})]%;\
	/echo - $[pad(textdecode(substr({*},temp_start,temp_end-temp_start)),-30,substr({*},temp_end+1),4)]


;; DONE!
/echo -aCyellow % Skill and spell checker loaded.