/loaded bat_prots.tf
;; Prot handler
;; should be rather complete
;; hard or impossible to abuse (laatutrigut hits you)

;; things to add: times for stackable stuff, better handling of tweak+sticky

;; Antti Pietikinen 2004 (Heidel@batmud)

/require -q misc.tf
/require -q prot_template.tf

/require -q help_list.tf
/help_add /help_prot prots and tweak

;; -------------------------
;; where do the messages go
;; -------------------------
;; /def prot=@party say %{*}
/def prot=@party report %{*}

;; -------------------------
;; CONJURER PROTS, MINOR
;; -------------------------

;; helper, all the minor prots give the same up-message
;; can fail if someone fumbles at the same time someone succeeds
/def -i prot_aura = \
	/def -F -p100 -n2 -t'*' %{1} = \
	/if ({*}=~'You sense a powerful protective aura around you.') \
		/prot_on %{1} %{-1}%%;\
	/elseif ({*}=~'You sense an extra powerful protective aura around you.') \
		/prot_on -s %{1} sticky %{-1}%%;\
	/endif

;; ---- force absorption
/def -F -i -t'* {utter|utters} the magic words \'ztonez des deckers\'' prot_fabs_cast = \
	/prot_aura prot_fabs force absorption on
/def -F -i -t'A skin brown flash momentarily surrounds you and then vanishes.' prot_fabs_off =\
	/prot_off prot_fabs force absorption off

;; ---- toxic dilution
/def -F -i -t'* {utter|utters} the magic words \'morri nam pantoloosa\'' prot_pois_cast = \
	/prot_aura prot_pois toxic dilution on
/def -F -i -t'A green flash momentarily surrounds you and then vanishes.' prot_pois_off =\
	/prot_off prot_pois toxic dilution off

;; ---- psychic sanctuary
/def -F -i -t'* {utter|utters} the magic words \'toughen da mind reeez un biis\'' prot_psi_cast = \
	/prot_aura prot_psi psychic sanctuary on
/def -F -i -t'A transparent flash momentarily surrounds you and then vanishes.' prot_psi_off =\
	/prot_off prot_psi psychic sanctuary off

;; ---- heat reduction
/def -F -i -t'* {utter|utters} the magic words \'hot hot not zeis daimons\'' prot_fire_cast = \
	/prot_aura prot_fire heat reduction on
/def -F -i -t'A burning red flash momentarily surrounds you and then vanishes.' prot_fire_off =\
	/prot_off prot_fire heat reduction off

;; ---- magic dispersion
/def -F -i -t'* {utter|utters} the magic words \'meke tul magic\'' prot_mana_cast = \
	/prot_aura prot_mana magic dispersion on
/def -F -i -t'A golden flash momentarily surrounds you and then vanishes.' prot_mana_off =\
	/prot_off prot_mana magic dispersion off

;; ---- energy channeling
/def -F -i -t'* {utter|utters} the magic words \'kablaaaammmmm bliitz zundfer\'' prot_elec_cast = \
	/prot_aura prot_elec energy channeling on
/def -F -i -t'A crackling blue flash momentarily surrounds you and then vanishes.' prot_elec_off =\
	/prot_off prot_elec energy channelling off

;; ---- ether boundary
/def -F -i -t'* {utter|utters} the magic words \'qor monoliftus\'' prot_asph_cast = \
	/prot_aura prot_asph ether boundary on
/def -F -i -t'A dull black flash momentarily surrounds you and then vanishes.' prot_asph_off =\
	/prot_off prot_asph ether boundary off

;; ---- frost insulation
/def -F -i -t'* {utter|utters} the magic words \'skaki barictos yetz fiil\'' prot_cold_cast = \
	/prot_aura prot_cold frost insulation on
/def -F -i -t'A cold white flash momentarily surrounds you and then vanishes.' prot_cold_off =\
	/prot_off prot_cold frost insulation off

;; ---- corrosion shield
/def -F -i -t'* {utter|utters} the magic words \'sulphiraidzik hydrochloodriz gidz zuf\'' prot_acid_cast =\
	/prot_aura prot_acid corrosion shield on
/def -F -i -t'A disgusting yellow flash momentarily surrounds you and then vanishes.' prot_acid_off =\
	/prot_off prot_acid corrosion shield off

;; -------------------------
;; CONJURER PROTS, MAJOR
;; -------------------------

;; Armour of Aether
/def -F -i -t"You see a crystal clear shield fade into existance around you." prot_aoa_on =\
	/prot_on prot_aoa armour of aether on
/def -F -i -t"You see an extra crystal clear shield fade into existance around you." prot_aoa_s_on =\
	/prot_on -s prot_aoa sticky armour of aether on
/def -F -i -t"Your crystal clear shield fades out." prot_aoa_off =\
	/prot_off prot_aoa armour of aether off

;; Repulsor Aura
/def -F -i -t"You see a flickering golden shield fade into existance around you." prot_gmana_on =\
	/prot_on prot_gmana repulsor aura on
/def -F -i -t"You see an extra flickering golden shield fade into existance around you." prot_gmana_s_on =\
	/prot_on -s prot_gmana sticky repulsor aura on
/def -F -i -t"Your flickering golden shield fades out." prot_gmana_off =\
	/prot_off prot_gmana repulsor aura off

;; Acid Shield
/def -F -i -t"You see a bubbling yellow shield fade into existance around you." prot_gacid_on =\
	/prot_on prot_gacid acid shield on
/def -F -i -t"You see an extra bubbling yellow shield fade into existance around you." prot_gacid_s_on =\
	/prot_on -s prot_gacid sticky acid shield on
/def -F -i -t"Your bubbling yellow shield fades out." prot_gacid_off =\
	/prot_off prot_gacid acid shield off

;; Frost Shield
/def -F -i -t"You see a frosty blue-white shield fade into existance around you." prot_gcold_on =\
	/prot_on prot_gcold frost shield on
/def -F -i -t"You see an extra frosty blue-white shield fade into existance around you." prot_gcold_s_on =\
	/prot_on -s prot_gcold sticky frost shield on
/def -F -i -t"Your frosty blue-white shield fades out." prot_gcold_off =\
	/prot_off prot_gcold frost shield off

;; Flame Shield
/def -F -i -t"You see a crackling red-orange shield fade into existance around you." prot_gfire_on =\
	/prot_on prot_gfire flame shield on
/def -F -i -t"You see an extra crackling red-orange shield fade into existance around you." prot_gfire_s_on =\
	/prot_on -s prot_gfire sticky flame shield on
/def -F -i -t"Your crackling red-orange shield fades out." prot_gfire_off =\
	/prot_off prot_gfire flame shield off

;; Shield of Detoxification
/def -F -i -t"You see a slimy olive green shield fade into existance around you." prot_gpois_on =\
	/prot_on prot_gpois shield of detoxification on
/def -F -i -t"You see an extra slimy olive green shield fade into existance around you." prot_gpois_s_on =\
	/prot_on -s prot_gpois sticky shield of detoxification on
/def -F -i -t"Your slimy olive green shield fades out." prot_gpois_off =\
	/prot_off prot_gpois shield of detoxification off

;; Aura of Wind
/def -F -i -t"You see a swirling foggy white shield fade into existance around you." prot_gasph_on =\
	/prot_on prot_gasph aura of wind on
/def -F -i -t"You see an extra swirling foggy white shield fade into existance around you." prot_gashp_s_on =\
	/prot_on -s prot_gashp sticky aura of wind on
/def -F -i -t"Your swirling foggy white shield fades out." prot_gasph_off =\
	/prot_off prot_gasph aura of wind off

;; Lightning Shield
/def -F -i -t"You see a neon purple shield fade into existance around you." prot_gelec_on =\
	/prot_on prot_gelec lightning shield on
/def -F -i -t"You see an extra neon purple shield fade into existance around you." prot_gelec_s_on =\
	/prot_on -s prot_gelec sticky lightning shield on
/def -F -i -t"Your neon purple shield fades out." prot_gelec_off =\
	/prot_off prot_gelec lightning shield off

;; Psionic Phalanx
/def -F -i -t"You see a misty pale blue shield fade into existance around you." prot_gpsi_on =\
	/prot_on prot_gpsi psionic phalanx on
/def -F -i -t"You see an extra misty pale blue shield fade into existance around you." prot_gpsi_s_on =\
	/prot_on -s prot_gpsi sticky psionic phalanx on
/def -F -i -t"Your misty pale blue shield fades out." prot_gpsi_off =\
	/prot_off prot_gpsi psionic phalanx off

;; -------------------------
;; CONJURER PROTS, MISC
;; -------------------------

;; ---- shield of protection
/def -F -i -t'You feel a slight tingle.' prot_sop = \
	/prot_on prot_sop shield of protection on
/def -F -i -t'You feel more vulnerable now.' prot_sop_off = \
	/prot_off prot_sop shield of protection off

;; ---- displacement/blurred image
/def -F -i -t'You feel a powerful aura.' prot_disblu_on =\
	/prot_on prot_disblu_on displacement/blur on
/def -F -i -t'You feel less invisible.' prot_disblu_off =\
	/prot_off prot_disblu_on displacement/blur down

;; ---- resist dispel
/def -F -i -t"You feel extra sticky for protection." prot_dispel_on=\
	/prot_on -q prot_dispel

;; ---- resist entropy
/def -F -i -t'You feel your life force expanding.' prot_entro_on =\
	/prot_on -q prot_entro
/def -F -i -t'You feel your hair is getting grayer.' prot_entro_off =\
	/prot_off prot_entro resist entropy off

;; ---- resist disintegrate up
;; You feel very firm.
;; has no down message?

;; -------------------------
;; BARD
;; -------------------------

;; ---- war ensemble
/def -F -i -t'You feel full of battle rage! Victory is CERTAIN!' prot_wen_on =\
	/prot_on -q prot_wen war ensemble up
/def -F -i -t'The effect of war ensemble wears off.' prot_wen_off =\
	/prot_off prot_wen war ensemble off

;; ---- melodical embracemet
/def -F -i -t'You embrace yourself with your melody.' prot_mel_on =\
	/prot_on -q prot_mel
/def -F -i -mregexp -t'^[A-Z][a-z]+ wraps you into an embracing melody.$' prot_mel_on2 =\
	/prot_on -q prot_mel
/def -F -i -t'The embracing melody subsides, leaving you longing for more.' prot_mel_off =\
	/prot_off prot_mel melodical embracement off

;; ---- arches favour
/def -F -i -t'You feel optimistic about your near future!' prot_fav_on =\
	/prot_on -q prot_fav
/def -F -i -t'You no longer have Arches Favour on you. You feel sad.' prot_fav_off =\
	/prot_off prot_fav arches favour off

;; ---- misadventurer
/def -F -i -t'You feel miserable.' prot_misadv_on =\
	/prot_on prot_misadv misadventurer on
/def -F -i -t'You feel like a weight has been lifted from your mental shoulders.' prot_misadv_off =\
	/prot_off prot_misadv misadventurer off

;; ---- clandestine thoughts
/def -F -i -t"\[clandestine thought\]: activated. Snooping activities will be terminated and reported." prot_cland_on = \
	/prot_on -q prot_cland
/def -F -i -t"\[clandestine thought\]: scanning ended. Shielding from snoopers no longer active." prot_cland_off = \
	/prot_off prot_cland clandestine thoughts off

;; ---- achromatic eyes
/def -F -i -mregexp -t"^[A-Z][a-z]+ has just revealed you a true faith that you wish to follow!$" prot_achro_on = \
	/prot_on -q prot_achro
/def -F -i -msimple -t"The effect of achromatic eyes wears out." prot_achro_off = \
	/prot_off prot_achro achromatic eyes off

;; -------------------------
;; TARMALEN
;; -------------------------

;; ---- unstun
/def -F -i -mregexp -t'^[a-zA-Z]+\'s chanting appears to do absolutely nothing.' prot_unstun_on = \
	/prot_off -q prot_used_unstun%;\
	/prot_on prot_unstun unstun on
/def -F -i -t'It doesn\'t hurt at all!' prot_unstun_used = \
	/prot_on -m prot_used_unstun unstun used%;\
	/prot_off -q prot_unstun
/def -F -i -t'It doesn\'t hurt as much as it normally does!' prot_unstun_off = \
	/prot_off -q prot_unstun%;\
	/prot_off -q prot_used_unstun

;; ---- blessing of tarmalen
/def -F -i -t'You feel strong - like you could carry whole flat world on your back!' prot_bot_on =\
	/prot_on prot_bot blessing of tarmalen on
/def -F -i -t'You feel weaker.' prot_bot_off =\
	/if (prot_bot) /prot_off prot_bot blessing of tarmalen off%;/endif

;; ---- unpain
/def -F -i -t'You feel your will getting stronger.' prot_unpain_on =\
	/prot_on prot_unpain unpain on
/def -F -i -t'You feel your will returning normal.' prot_unpain_off =\
	/prot_off -n prot_unpain unpain off

;; ---- enhanced vitality
/def -F -i -mregexp -t'^A bright light exctract from ([A-Z][a-z]+)\'s hands covering your skin\.$' prot_evit_on =\
	/prot_on prot_evit enhanced vitality on
/def -F -i -t'Your skin stops glowing.' prot_evit_off = \
	/prot_off prot_evit enhanced vitality off

;; ---- life link
;; may be wrong
/def -F -i -mregexp -t"^You feel somehow linked to ([A-Za-z]+)\." prot_lifelink_on_1=\
	/prot_on -l%{P1} prot_llink life link on
/def -F -i -mregexp -t"^(You succeed. |)You create a link to ([A-Za-z]+)\." prot_lifelink_on_2=\
	/prot_on -l%{P1} prot_llink life link on
/def -F -i -t"^(You succeed. )You hear a loud snap like sound!" prot_lifelink_off_1=\
	/prot_off prot_llink life link off
/def -F -i -t"You remove your link." prot_lifelink_off_2=\
	/prot_off prot_llink life link off

;; -------------------------
;; DRUID
;; -------------------------

;; ---- flex shield
/def -F -i -t'You sense a flex shield covering your body like a second skin.' prot_flex_on = \
	/prot_on prot_flex flex shield on
/def -F -i -t'Your flex shield wobbles, PINGs and vanishes.' prot_flex_off = \
	/prot_off prot_flex flex shield off

;; ---- regeneration
/def -F -i -t'You feel your metabolism speed up.' prot_regen_on =\
	/prot_on prot_regen regeneration on
/def -F -i -t'You no longer have a active regeneration spell on you.' prot_regen_off =\
	/prot_off prot_regen regeneration off

;; ---- earth blood
/def -F -i -t'An icy chill runs through your veins.' prot_eblood_on =\
	/prot_on prot_eblood earth blood on
/def -F -i -t'The runic sigla \'\!\( \*\)\' fade away.. leaving you feeling strange.' prot_eblood_off =\
	/prot_off prot_eblood earth blood off

;; ---- earth skin
/def -F -i -t'You feel your skin harden.' prot_eskin_on =\
	/prot_on -m prot_eskin earth skin on
/def -F -i -t'Your skin feels softer.' prot_eskin_off =\
	/prot_off -m prot_eskin earth skin off

;; ---- vine mantle
/def -F -i -t'Vines entangle your body.' prot_vmantle_on =\
	/prot_on -m prot_vmantle vine mantle on
/def -F -i -t'The vines crumbles to dust.' prot_vmantle_off =\
	/prot_off -m prot_vmantle vine mantle off

;; ---- earth power
/def -F -i -t'You feel your strength changing. You flex you muscles experimentally.' prot_epower_on =\
	/prot_on prot_epower earth power on
/def -F -i -t"The runic sigla '% !^' fade away.. leaving you feeling strange." prot_epower_off =\
	/prot_off prot_epower earth power off

;; -------------------------
;; NUN
;; -------------------------
;; actually some vial-protthing?
;;/def -F -i -t'You glow softly.' prot_hprot_on =\
;;	/prot_on prot_hprot_on heavenly protection on
;;/def -F -i -t'Your golden glow fades away.' prot_hprot_off =\
;;	/prot_off prot_hprot_on heavenly protection off

;; ---- heavenly protection
/def -F -i -t"Holy particles slow down, rapidly fading away." prot_heavenly_off=\
	/prot heavenly protection off

;; ---- protection from evil
/def -F -i -mregexp -t"^([A-Z][a-z]+)'s (.*) with sheer power as you are surrounded" prot_pfe_on = \
	/prot_on prot_pfe protection from evil up
/def -F -i -t'You suddenly feel more vulnerable to evil.' prot_pfe_off = \
	/prot_off prot_pfe protection from evil down

;; ---- soul shield
/def -F -i -mregexp -t"^[A-Za-z]+ spiritually reach(es)? out for your soul, protecting it with holy force." prot_soulshield_on_1=\
	/prot_on prot_soulshield soul shield on
/def -F -i -mregexp -t"^[A-Za-z]+ places? (your|her) hand over you and blesses your soul in the name of Las." prot_soulshield_on_2=\
	/prot_on prot_soulshield soul shield on
/def -F -i -t"Your soul feels suddenly more vulnerable." soul_shield_off=\
	/prot_off prot_soulshield soul shield off

;; -------------------------
;; MISC
;; -------------------------

;; ---- shield of faith
/def -F -i -t'You are surrounded by divine glow!' prot_sof_on = \
	/prot_on prot_sof shield of faith on
/def -F -i -t'Your glow disappears.' prot_sof_off = \
	/prot_off prot_sof shield of faith off

;; ---- personal force field
/def -F -i -t'You surround yourself by a bubble of force.' prot_bubble_on =\
	/prot_on prot_bubble personal force field on
/def -F -i -t'Your field disperses with a soft \*pop\* and is gone.' prot_bubble_off =\
	/prot_off prot_bubble personal force field off

;; ---- aura of hate
;; up message is troublesome
/def -F -i -t'You feel your anger and hate of the world recede.' prot_aura_off = \
	/prot aoh down

;; ---- quicksilver
/def -F -i -t'You feel more agile.' prot_qs_on = /prot_on prot_qs quicksilver on
/def -F -i -t'You feel less agile.' prot_qs_off = /prot_off prot_qs quicksilver off

;; ---- force shield
/def -F -i -mregexp -t'^[A-Z][a-z]+ forms a shield of force around you.$' prot_fs_on =\
	/prot_on prot_fs force shield on
/def -F -i -t'Your armour feels thinner.' prot_fs_off = \
	/prot_off prot_fs force shield off

;; ---- protection from good
/def -F -i -t'A vile black aura surrounds you.' prot_pfg_on = \
	/prot_on prot_pfg protection from good on
/def -F -i -t'You no longer have a vile black aura around you.' prot_pfg_off =\
	/prot_off prot_pfg protection from good off

;; ---- water walking
/def -F -i -t'You feel light.' prot_ww_on =\
	/prot_on prot_ww_on water walking on
/def -F -i -t'You feel heavier.' prot_ww_off =\
	/prot_off prot_ww_on water walking off

;; ---- spider walk
/def -F -i -t'For some reason you want to run on the walls for a little while.' prot_swalk_on=\
	/prot_on prot_swalk spider walk on
/def -F -i -t'The walls don\'t look so inviting anymore.' prot_swalk_off = \
	/prot_off prot_swalk spider walk off

;; ---- floating
/def -F -i -t'You feel light, and rise into the air.' prot_float_on = \
	/prot_on -m prot_floating floating on
/def -F -i -t'You slowly descend until your feet are on the ground.' prot_float_off = \
	/prot_off -m prot_floating floating off

;; ---- iron will
;; has no up message?
/def -F -i -t'You feel no longer protected from being stunned.' prot_iw_off = \
	/prot iron will off

;; ---- psionic shield
/def -F -i -t"Psionic waves surge through your body and mind!" prot_psishield_on=\
	/prot_up -q prot_psishield
/def -F -i -t"The psionic shield vanishes." prot_psishield_off=\
	/prot_off prot_psishield psionic shield off

;; ---- mirror images
/def -F -i -t'^Suddenly * images of yourself appear.' prot_mirrors_on = \
	/prot_on -q prot_mirrors
/def -F -i -t'All of your images vanish!' prot_mirrors_gone = \
	/prot_off prot_mirrors mirror images gone

;; ---- heavy weight
/def -F -i -t'You suddenly feel magically heavier.' prot_hw_on = \
	/prot_on prot_hw heavy weight on
/def -F -i -t'You feel lighter, but it doesn\'t seem to affect your weight!' prot_hw_off = \
	/prot_off prot_hw heavy weight off 
/def -F -i -t'You feel magical forces binding the spell to you.' prot_hw_on_sticky = \
	/set prot_hw_sticky=1

;; ---- invisibility
/def -F -i -t'You suddenly can\'t see yourself.' prot_invis_on =\
	/prot_on -q prot_invis
/def -F -i -t'You twist the ring and suddenly you become invisible.' prot_invis_twister =\
	/prot_on -q prot_invis
/def -F -i -t'You turn visible.' prot_invis_off =\
	/prot_off prot_invis visible again

;; ---- (greater) light
/def -F -i -t'A small ball of light starts following you.' prot_light_on = \
	/prot_on -q prot_light
/def -F -i -t'Your light flickers briefly and disappears.' prot_light_off = \
	/prot_off prot_light light spell off

;; ---- (greater) darkness 
/def -F -i -t'You summon a circle of darkness that absorbs light.' prot_darkness_on = \
	/prot_on -q prot_darkness
/def -F -i -t'Your darkness spell dissolves.' prot_darkness_off = \
	/prot_off prot_darkness darkness spell off

;; ---- mind development
/def -F -i -t"You feel your mind developing." prot_mdev_on=\
	/prot_on -m -q prot_mdev
/def -F -i -t"Your brain suddenly seems smaller." prot_mdev_off=\
	/prot_off -m mind development off

;; ---- infravision
/def -F -i -t'You have infravision.' prot_infra_on = \
	/prot_on prot_infra infravision on
/def -F -i -t'Everything no longer seems so red.' prot_infra_off = \
	/prot_off prot_infra infravision off

;; ---- see magic

;; ---- see invis
/def -F -i -t"You feel you can see more than ever." prot_seeinvis_on=\
	/prot_on prot_sinv see invis on
/def -F -i -t"Your vision is less sensitive now." prot_seeinvis_off=\
	/prot_off prot_sinv see invis off


;; -------------------------
;; BARBARIAN
;; -------------------------

;; ---- pain threshold
/def -F -i -t'You begin to concentrate on pain threshold.' prot_pthr_on=\
	/prot_on prot_pthr pain treshold on
/def -F -i -t'Your concentration breaks and you feel less protected from physical damage.' prot_pthr_off=\
	/prot_off prot_pthr pain treshold off

;; ---- toxic immunity
/def -F -i -t'You begin to concentrate on toxic immunity.' prot_timm_on=\
	/prot_on prot_timm toxic immunity on
/def -F -i -t'Your concentration breaks and you feel less protected from poison.' prot_timm_off=\
	/prot_off prot_pthr toxic Immunity off

;; ---- cold tolerance
/def -F -i -t'You begin to concentrate on cold tolerance.' prot_ctol_up=\
	/prot_on prot_ctol cold tolerance on
/def -F -i -t'Your concentration breaks and you feel less protected from cold.' prot_ctol_down=\
	/prot_off prot_ctol cold tolerance off

;; ---- fire walking
/def -F -i -t'You begin to concentrate on fire walking.' prot_fwalk_up=\
	/prot_on prot_fwalk fire walking on
/def -F -i -t'Your concentration breaks and you feel less protected from fire.' prot_fwalk_down=\
	/prot_off prot_fwalk fire walking off

;; ---- enrage
;; missing proper on
/def -F -i -t"You no longer feel enraged." prot_enrage_off=\
	/prot enrage off
;	/prot_off prot_enrage enrage off


;; -------------------------
;; DEATH
;; -------------------------

/def -F -i -t'You can see Death, clad in black, collect your corpse\.' prot_clear_death = \
	/prot_off -q prot_flex%;\
	/prot_off -q prot_pfe%;\
	/prot_off -q prot_eskin%;\
	/prot_off -q prot_vmantle%;\
	/prot_off -q prot_stouch%;\
	/echo -aCred % You have died. Certain prots cleared.
	
/def -F -i -t'You can see Death, clad in black, collect your corpse\.' prot_dpenalty_on = \
	/prot_on -m -q prot_dpenalty
/def -F -i -aB -t'You feel more vital.' prot_dpenalty_off = \
	/prot_off -m prot_dpenalty death penalties gone

;; -------------------------
;; CURSES
;; -------------------------

;; ---- forget
/def -F -i -aCblack,Cbgyellow -t'You feel rather empty-headed.' prot_forget_on = \
	/prot_on prot_forget forget hit me
/def -F -i -t'A fog lifts from your mind. You can remember things clearly now.' prot_forget_off = \
	/prot_off prot_forget forget off

;; ---- suppress
/def -F -i -t'Your feel excruciating pain in your head.' prot_suppress_on = \
	/prot_on prot_suppress magic suppressed
/def -F -i -t'You feel relieved.' prot_suppress_off = \
	/prot_off prot_suppress no longer suppressed

;; ---- spider touch
/def -F -i -t"Suddenly you don't feel too good. Your blood feels like it is on fire." prot_stouch_on=\
	/prot_on prot_stouch spider touch on
/def -F -i -t"Your blood does not burn anymore." prot_spidertouch_off = \
	/prot_off prot_stouch spider touch off


;; -------------------------
;; DMP
;; -------------------------

/def -F -i -t'You feel much more vulnerable.' prot_clear_dmp=\
	/prot Prots dispelled!%;\
	/check_clear_list sof disblu fs fabs pois psi mana fire elec asph cold acid \
        aoa gpois gpsi gmana gfire gelec gasph gcold gacid

/def -F -i -t'You feel unprotected.' prot_clear_dmp2 = \
	/prot_clear_dmp

/def -i check_clear_list=\
        /while ({#}>0) \
		/eval /if (prot_%{1}=1 & prot_%{1}_sticky=0) /prot_%{1}_off%%;/endif%;\
                /shift%;\
        /done

;; -------------------------
;; TWEAK
;; -------------------------

/def -i create_protlist = \
	/set temp_protlist=\
	$(/if (prot_fabs)     /echo |fabs%;/prottimer prot_fabs%;/endif)\
	$(/if (prot_pois)     /echo |pois%;/prottimer prot_pois%;/endif)\
	$(/if (prot_psi)      /echo |psi%; /prottimer prot_psi%; /endif)\
	$(/if (prot_fire)     /echo |fire%;/prottimer prot_fire%;/endif)\
	$(/if (prot_mana)     /echo |mana%;/prottimer prot_mana%;/endif)\
	$(/if (prot_elec)     /echo |elec%;/prottimer prot_elec%;/endif)\
	$(/if (prot_asph)     /echo |asph%;/prottimer prot_asph%;/endif)\
	$(/if (prot_cold)     /echo |cold%;/prottimer prot_cold%;/endif)\
	$(/if (prot_acid)     /echo |acid%;/prottimer prot_acid%;/endif)\
	$(/if (prot_aoa)      /echo |aoa%;/prottimer prot_aoa%;/endif)\
	$(/if (prot_gpois)    /echo |g-pois%;/prottimer prot_gpois%;/endif)\
	$(/if (prot_gpsi)     /echo |g-psi%; /prottimer prot_gpsi%; /endif)\
	$(/if (prot_gfire)    /echo |g-fire%;/prottimer prot_gfire%;/endif)\
	$(/if (prot_gmana)    /echo |g-mana%;/prottimer prot_gmana%;/endif)\
	$(/if (prot_gelec)    /echo |g-elec%;/prottimer prot_gelec%;/endif)\
	$(/if (prot_gasph)    /echo |g-asph%;/prottimer prot_gasph%;/endif)\
	$(/if (prot_gcold)    /echo |g-cold%;/prottimer prot_gcold%;/endif)\
	$(/if (prot_gacid)    /echo |g-acid%;/prottimer prot_gacid%;/endif)\
	$(/if (prot_flex)     /echo |flex%;/prottimer prot_flex%;/endif)\
	$(/if (prot_wen)      /echo |war%;/prottimer prot_wen%;/endif)\
	$(/if (prot_bubble)   /echo |pff%;/prottimer prot_bubble%;/endif)\
	$(/if (prot_pfe)      /echo |pfe%;/prottimer prot_pfe%;/endif)\
	$(/if (prot_unstun)   /echo |us%;/endif)\
	$(/if (prot_used_unstun) /echo |us\( used:%;/expr prot_used_unstun%;/echo \)%;/endif)\
	$(/if (prot_fs)       /echo |fs%;/prottimer prot_fs%;/endif)\
	$(/if (prot_sof)      /echo |sof%;/prottimer prot_sof%;/endif)\
	$(/if (prot_pfg)      /echo |pfg%;/prottimer prot_pfg%;/endif)\
	$(/if (prot_hw)       /echo |hw%;/prottimer prot_hw%;/endif)\
	$(/if (prot_eblood)   /echo |eblood%;/prottimer prot_eblood%;/endif)\
	$(/if (prot_unpain)   /echo |unpain%;/endif)\
	$(/if (prot_psishield)/echo |psishield%;/endif)\
	$(/if (prot_floating) /echo |float%;/endif)\
	$(/if (prot_dispel)   /echo |sticky%;/endif)\
	$(/if (prot_stouch)   /echo |stouch%;/prottimer prot_stouch%;/endif)\
	$(/if (prot_forget)   /echo |forget%;/prottimer prot_forget%;/endif)\
	$(/if (prot_misadv)   /echo |misadv%;/prottimer prot_misadv%;/endif)\
	$(/if (prot_suppress) /echo |suppress%;/prottimer prot_suppress%;/endif)%;\
	/if (temp_protlist !~ "") /echo %{temp_protlist}|%;/else /echo prots: none%;/endif%;\
	/unset temp_protlist


;; compability, use timer_show from now on
/def -i prottimer=\
	/timer_show %{1}

/def -i show_prots = \
	/prot $(/create_protlist)

;; ---- tweak
/def -F -i -mregexp -t"^[A-Z][a-z]+ tweaks your nose mischievously\.$" tweaked_1 = /show_prots
/def -F -i -msimple -t"You tweak your own nose mischievously." tweaked_2 = /show_prots

;; -------------------------
;; HELP and CLEAR
;; -------------------------

;; new 
/def -i clear_prots=\
	/if ({#} == 0) \
		/purgevar prot_*%;\
		/echo -aB % Prots cleared%;\
	/else \
		/while ({#}) \
			/eval /prot_off -q prot_%{1}%;\
			/shift%;\
		/done%;\
	/endif

/def -i help_prot=\
	/echo -aB Help for prot-system:%;\
	/echo /clear_prots                   clear all prots%;\
	/echo /clear_prots <protnames>       clear specific prots%;\
	/echo /show_prots                    reports prots%;\
	/echo %;\
	/echo Edit /prot to change where reports go%;\
	/echo %;\
	/echo Examples:%;\
	/echo /clear_prots aoa gfire hw%;\
	/echo /edit prot=/echo - %%{*}%;\
	/echo

;; DONE!
/echo -aCyellow % Prot helper loaded.
