;; do the move created with path_find
;; Antti Pietikinen (heidel@operamail.com)

/require -q pathfinder.tf

/require -q help_list.tf
/help_add /help_path_go follow a path created by the pathfinder

/def -i help_path_go=\
	/echo -aB % Help for speedwalker:%;\
	/echo 1. Use /path_find to get the path.%;\
	/echo 2. /path_go starts moving.%;\
	/echo 3. If movement is broken, use /path_resume to start moving again.%;\
	/echo

/def -i path_go=\
	/echo -aCgreen % Starting move...%;\
	/path_mover $(/path_create_command %{linklist_route})

/def -i path_mover=\
	/if (path_break_count > 0) \
		/echo -aCred % Move broken, resume with /path_resume%;\
		/path_setup_resume %{path_doing} %{*}%;\
	/else \
		/if ({#}==0) \
			/echo -aCgreen % Move done!%;\
			/return%;\
		/endif%;\
		/let path_split=$[strstr({*},";")]%;\
		/if (path_split != -1) \
			/let path_head=$[substr({*},0,path_split)]%;\
			/let path_tail=$[substr({*},path_split+1)]%;\
		/else \
			/let path_head=%{*}%;\
			/let path_tail=%;\
		/endif%;\
		/def -F -q -1 -hPROMPT path_continue=/path_mover %{path_tail}%;\
		/set path_doing=%{path_head}%;\
		/set path_break_count=0%;\
		/send %{path_head}%;\
	/endif

/def -i path_setup_resume=\
	/if (regmatch("[0-9]+",{1})) \
		/let path_movecommand=$[strcat(path_break_count," ",{2})]%;\
	/else \
		/let path_movecommand=$[strcat({1}," ",{2})]%;\
	/endif%;\
	/def path_resume=\
		/set path_break_count=0%%;\
		/def -F -q -1 -hPROMPT path_continue=/path_mover %{-2}%%;\
		/send %{path_movecommand}

/def -i -F -au -msimple -t"You are so exhausted you fail to move." path_break_exhaust=\
	/test ++path_break_count

/def -i -F -au -msimple -t"You cannot leave, you have been AMBUSHED." path_break_ambush=\
	/test ++path_break_count

