;; adds colour and modifies party status output
;; adds hpdiff, hpmaxdiff, spdiff, epdiff
;; removes level&exp
;; optional spmaxdiff and epmaxdiff
;; gags the original, echoes this one, /recall -ag to view original
;; disable with /purge -i ps_*
;; invis messes up everything, small loss

;; Antti Pietikinen (heidel@batmud)
;; 2005


/def -Fp3001 -i -mregexp -ag -t"^\|..\.. +([A-Z][a-z]+) +.... +(.*)\((.+)\) (.+)\((.+)\) (.+)\((.+)\) \| (...) \| ([0-9 ]+) \|$" ps_line =\
	/test dhp  := {P2} - pss_%{P1}_hp%;\
	/test dhpm := {P3} - pss_%{P1}_hpm%;\
	/test dsp  := {P4} - pss_%{P1}_sp%;\
	/test dspm := {P5} - pss_%{P1}_spm%;\
	/test dep  := {P6} - pss_%{P1}_ep%;\
	/test depm := {P7} - pss_%{P1}_epm%;\
	/set pss_%{P1}_hp=%{P2}%;\
	/set pss_%{P1}_sp=%{P4}%;\
	/set pss_%{P1}_ep=%{P6}%;\
	/set pss_%{P1}_hpm=%{P3}%;\
	/set pss_%{P1}_spm=%{P5}%;\
	/set pss_%{P1}_epm=%{P7}%;\
	/let ps_hp=$(/ps_col %{P2} %{P3})$[pad({P2},5)]@{n}%;\
	/let ps_sp=$(/ps_col %{P4} %{P5})$[pad({P4},5)]@{n}%;\
	/let ps_ep=$(/ps_col %{P6} %{P7})$[pad({P6},5)]@{n}%;\
	/let ps_status=$[substr({P0},21,4)]%;\
	/let ps_status=$(/ps_col_status %{ps_status}) %{ps_status} @{n}%;\
	/if (dhp==0) /set dhp=$[pad(" ",5)]%;\
		/elseif (dhp<0) /set dhp=@{Cred}$[pad({dhp},5)]@{n}%;\
		/else /set dhp=@{B}$[pad(strcat("+",{dhp}),5)]@{n}%;/endif%;\
	/if (dsp==0) /set dsp=$[pad(" ",5)]%;\
		/elseif (dsp<0) /set dsp=@{Cred}$[pad({dsp},5)]@{n}%;\
		/else /set dsp=@{B}$[pad(strcat("+",{dsp}),5)]@{n}%;/endif%;\
	/if (dep==0) /set dep=$[pad(" ",5)]%;\
		/elseif (dep<0) /set dep=@{Cred}$[pad({dep},5)]@{n}%;\
		/else /set dep=@{B}$[pad(strcat("+",{dep}),5)]@{n}%;/endif%;\
	/if (dhpm==0) /set dhpm=$[pad(" ",5)]%;\
		/elseif (dhpm<0) /set dhpm=@{Cred}$[pad({dhpm},5)]@{n}%;\
		/else /set dhpm=@{B}$[pad(strcat("+",{dhpm}),5)]@{n}%;/endif%;\
	/if (dspm==0) /set dspm=$[pad(" ",5)]%;\
		/elseif (dspm<0) /set dspm=@{Cred}$[pad({dspm},5)]@{n}%;\
		/else /set dspm=@{B}$[pad(strcat("+",{dspm}),5)]@{n}%;/endif%;\
	/if (depm==0) /set depm=$[pad(" ",5)]%;\
		/elseif (depm<0) /set depm=@{Cred}$[pad({depm},5)]@{n}%;\
		/else /set depm=@{B}$[pad(strcat("+",{depm}),5)]@{n}%;/endif%;\
	/let ps_output=\
		$[substr({P0},0,6)]\
		$[pad( {P1},11,	{ps_status},0,\
		{dhp},5,{ps_hp},5,"(",0,{P3},4,{dhpm},5,")",0,\
;		{dhp},5,{ps_hp},5,"(",0,{P3},4,")",0,\
;		{dsp},5,{ps_sp},5,"(",0,{P5},4,{dspm},5,")",0,\
		{dsp},5,{ps_sp},5,"(",0,{P5},4,")",0,\
;		{dep},5,{ps_ep},5,"(",0,{P7},4,{depm},5,")",0,\
		{dep},5,{ps_ep},5,"(",0,{P7},4,")",0,\
		" |",3)]%;\
	/echo -p %{ps_output}

;	"(",0,%{P5},4,%{dspm},5,")",0,\
;	%{dep},5,\
;	%{ps_ep},5,\
;	"(",0,%{P7},4,%{depm},5,")",0,\

;; colours for statuses
/def -i ps_col_status=\
	/if ({*}=~"dead") /_echo @{BCblue}%;/endif%;\
	/if ({*}=~"form") /_echo @{Cgreen}%;/endif%;\
	/if ({*}=~"fol" ) /_echo @{BCgreen}%;/endif%;\
	/if ({*}=~"ldr" ) /_echo @{BCcyan}%;/endif%;\
	/if ({*}=~"unc" ) /_echo @{BCred}%;/endif%;\
	/if ({*}=~"stun") /_echo @{BCyellow}%;/endif%;\
	/if ({*}=~"mbr" ) /_echo @{Cmagenta}%;/endif%;\
	/if ({*}=~"ld"  ) /_echo @{Cred}%;/endif

;; colours for numbers
/def -i ps_col =\
	/test tmpvar :=%{1}*100./%{2} %; \
	/if (tmpvar==100)/echo @{BCyellow}%; \
	/elseif (tmpvar>100)/echo @{BCwhite}%; \
	/elseif (tmpvar>74)/echo @{BCgreen}%; \
	/elseif (tmpvar>34)/echo @{BCmagenta}%; \
	/elseif (tmpvar>9)/echo @{Cred}%; \
	/elseif (tmpvar>=0)/echo @{BCred}%; \
	/else /echo @{BCblue}%;/endif

;; wrappers for party status
/def -i -F -ag -msimple -t"|========================================================|====================|" ps_gag_1 =\
	                 /echo |=============================================================================|
/def -i -F -ag -msimple -t"| Place  Name      Status      HP         SP        EP   | Lvl |   Experience |" ps_gag_2 =\
					 /echo | Place      Name               HP                    SP               EP     |
/def -i -F -ag -msimple -t"|========================================================|=====|==============|" ps_gag_3 =\
                     /echo |=============================================================================|

;; extra separator lines

/def -i -Fp3002 -mregexp -t"^\| 1\." ps_addline_1=\
	/test ++ps_row_1_count

/def -i -Fp3002 -mregexp -t"^\| 2\." ps_addline_2=\
	/test ++ps_row_2_count%;\
	/if (ps_row_1_count > 0) \
		/echo |-----------------------------------------------------------------------------|%;\
		/set ps_row_1_count=0%;\
	/endif

/def -i -Fp3002 -mregexp -t"^\| 3\." ps_addline_3=\
	/test ++ps_row_3_count%;\
	/if (ps_row_2_count > 0) \
		/echo |-----------------------------------------------------------------------------|%;\
		/set ps_row_2_count=0%;\
	/endif

/def -i -Fp3002 -mregexp -t"^\| \?\." ps_addline_4=\
	/if (ps_row_3_count > 0) \
		/echo |-----------------------------------------------------------------------------|%;\
		/set ps_row_3_count=0%;\
	/endif

