;; helper to keep the party places
;; (c) Antti Pietikainen (Heidel@batmud) 2004
;; may work, or may not

;; usage: set the formation, do /saveplaces (cyan places mean they were found and saved
;; if some people aren't cyan, something didn't work)
;; /loadplaces tries to revert to the old places (fails sometimes, should have some strange check)

;; add to helplist
/require -q help_list.tf
/help_add /help_partyplace tool for saving and loading party places

;; purgevar
/require -q misc.tf

/def -i help_partyplace=\
	/echo -aB Party placer help:%;\
	/echo /saveplaces            Save current places%;\
	/echo /loadplaces            Load saved places%;\
	/echo


/def -i saveplaces=\
	/purgevar partyplaces_*%;\
	/unset partymembers%;\
	/unset partynofollow%;\
	/set savingplaces=1%;\
	/repeat -3 1 /set savingplaces=0%;\
	/send @party status short

/def -i -p30000 -P3BCcyan -E(savingplaces) -t"^\|[ *]([1-3])\.([1-3])...([A-Z][a-z]+)[ ]+(....) [0-9() -]+ \|.....|[0-9 ]+\|$" partystatusline=\
	/set partymembers=$[tolower({P3})] %{partymembers} %;\
	/set partyplaces_%{P3}=%{P1},%{P2}%;\
	/if ({P4}=~"form") \
		/set partynofollow=$[tolower({P3})] %{partynofollow} %;\
	/endif

/def -i -F -E(savingplaces) -t"`-----------------------------------------------------------------------------'" partyend = \
	/set savingplaces=0%;\
	/echo -aCgreen % party places saved

/def -i loadplaces=\
	/send @party shake%;\
	/set partyplace_blocking=%;\
	/partyplace_move %{partymembers}%;\
	/partyplace_shake %{partynofollow}%;\
	/echo -aCgreen % party places loaded.

/def -i partyplace_move=\
	/if ({#} == 0) \
		/send @party forcefollow%;\
	/else \
		/if (partyplace_blocking=~"") \
			/def -hPROMPT partyplace_hook=/partyplace_move %{-1}%;\
			/set partyplace_placing %{1}%;\
			/eval /send @party place %{1} %%{partyplaces_%{1}}%;\
		/else \
			/send @party swap %{partyplace_placing} %{partyplace_blocking}%;\
			/set partyplace_blocking=%;\
			/partyplace_move %{*}%;\
		/endif%;\
	/endif

/def -i partyplace_shake=\
	/while ({#}) \
		/send @party shake %{1}%;\
	/done

/def -F -i -mregexp -t"^([A-Z][a-z]+) is already in that position.$" partyplacer_blocked=\
	/set partyplace_blocking=%{P1}

