;; --------------------------
;; LITECOLLECTION
;; --------------------------
;; Antti Pietikinen (Heidel@operamail.com)
;; 2005

;; some of these use /prot to report stuff
;; to change where messages go, do:
;; /edit prot=@emote stares at you intently, and you think %{*}. How odd.

;; timers in some triggers
/require -q misc.tf

;;### round mark ###
/def -i -Fp50 -msimple -t'*****************************************************' round_mark

;;### leadership, automatic forcefollow ###
/def -i -F -aB -msimple -t'You are the new leader of the party.' autopartyfollow =\
	@party forcefollow%;\
	/echo -aBCred,Cbgyellow **** GOT LEAD ****

;;### gatekeeper glace ###
/def -i -F -mregexp -t'^PUFF! Glaced ([A-Z][a-z]+) vanishes into thin air\.$' gk_glace=\
	party say %{P1} glaced!

;;### eq damage ###
/def -i -F -aBCred -t'Your * gets damaged; it\'s now in * condition.' stuff_damaged

;;### stunned maneuvers, sucky mode ###
/def -i -F -msimple -aBCblue -t'You feel your head clearing up.' shorten_stun

;;### parry, dodge, avoid ###
/def -i -F -P1Cmagenta -t'^You successfully (parry) .*' hit_parry
/def -i -F -P1Cmagenta -t'^You successfully (dodge) .*' hit_dodge
/def -i -F -P1Cmagenta -t"^[a-z A-Z.,'-]+(misses) you\.$" hit_miss

;;### discipline ###
/def -i -F -aBCblue -msimple -t'You get hit hard but your discipline saves concentration on spell.' discipline_spell
/def -i -F -aBCblue -msimple -t'You get hit hard but your discipline saves concentration on skill.' discipline_skill

;;### spider curse with wrath ###
/def -i -F -aCgreen -P1B -t'^You feel something (crawling) inside your spine!$' spider_curse

;;### mc demons ###
/def -i -F -auBCmagenta -t'A Nasty Multicolored Demon arrives with puff of * smoke.' demon_here

;;### lost skill/spell ###
/def -i -F -msimple -aBCred -t'You lose your concentration and cannot cast the spell.' lost_spell
/def -i -F -msimple -aBCred -t'You lose your concentration and cannot do the skill.' lost_skill

/def -i -F -msimple -aBCyellow -t'Your movement prevents you from casting the spell.' lost_spell_move
/def -i -F -msimple -aBCyellow -t'Your movement prevents you from doing the skill.' lost_skill_move

/def -i -F -msimple -aBCyellow -t'You interrupt the chant in order to start a new chant' lost_spell_recast

/def -i -F -msimple -aCred -t"A turbulence in the time-space continuum prevents you." lost_spell_turbulence

;;### spell start and finish ###
/def -i -Fp0 -aCcyan -msimple -t'You start chanting.' spell_start=/timer_start timer_spell
/def -i -Fp0 -aBCcyan -msimple -t'You are done with the chant.' spell_done=/substitute %{*} ( $(/timer_show timer_spell) )

;;### skill start and finish ###
/def -i -Fp10 -aCcyan -msimple -t'You start concentrating on the skill.' skill_start=/timer_start timer_skill
/def -i -Fp10 -aBCcyan -msimple -t'You are prepared to do the skill.' skill_done=/substitute %{*} ( $(/timer_show timer_skill) )

;;### offensive spell/skill  ###
/def -i -F -aBCred -P1BCYellow -t"^([a-z A-Z.,'-]+) starts concentrating on a new offensive spell\.$" offensive_spell
/def -i -F -aBCred -P1BCYellow -t"^([a-z A-Z.,'-]+) starts concentrating on a new offensive skill\.$" offensive_skill

;;### summon ###
/def -i -F -aBCmagenta -P1xBCyellow -t'^([A-Z][a-z]+) has summoned you!$' someone_summon

;;### reloc ###
/def -i -F -aBCmagenta -P1xBCyellow -t'^When your eyes clear, ([A-Z][a-z]+) stands before you\.$' someone_relocate

;;### bank transfer  ###
/def -i -F -aCred,Cbgyellow -t'Bank transfer from *' someone_transfer 

;;### skill/spell improves ###
/def -i -F -aBCyellow,Cbggreen -t'You feel like you just got slightly better *' improve_skill 
/def -i -F -aBCyellow,Cbggreen -t'You feel more proficient in Sabre *' improve_sabre_skill

;;### monster aggroes, skill/spell ###
/def -i -F -aCblack,Cbgred -t'* got mad at hostile actions.' aggro_skill
/def -i -F -aCblack,Cbgred -t'* is disturbed by spellcasting.' aggro_spell

;;### floating disc about to drop ###
/def -i -F -aBCcyan -msimple -t'Your disc wavers dangerously.' floating_disc_low

;;### concealed spellcasting ###
/def -i -F -aB -msimple -t'You surreptitiously conceal your spell casting.' conceal_spell

;;### monster skill/spell possibly lost ###
/def -i -aBCgreen -F -t'* seems hurt and confused.' mon_lostskill

;;### unconscious, automatic target ###
/def -i -F -aCred -P1xBCyellow -t'^([A-Z][a-z]+) lapses into unconsciousness from severe loss of blood\.$' unconscious_1=\
	/set fa_target %{P1}
/def -i -F -aCred -P1xBCyellow -t'^([A-Z][a-z]+) is unconscious and needs immediate medical care$' unconscious_2=\
	/set fa_target %{P1}

;;### out of stun, inform party ###
/def -i -aBCYellow -msimple -F -t'You are no longer stunned.' no_more_stunned = \
	/prot No longer stunned

;;### avoid death, inform party ###
/def -i -aB -F -msimple -t'You regenerate astonishingly fast. You avoid the death!' avoid_death = \
	/prot Avoided death

;;### desecrate out ###
/def -i -F -aB -msimple -t'Some good gods seem to reconsecrate the ground here.' desecrate_out

;;### battle cadence ###
/def -i -F -aB -msimple -t'Your battle cadence grants you another attack!' battle_cadence

;;### clandestine thoughts ###
/def -i -F -P1BCyellow -t'^(\[clandestine thought\]):(.*)$' clandestine_lite

;;### grapple ###
/def -i -F -mregexp -aB -t"^[a-z A-Z.,'-]+ starts grappling ([A-Z][a-z]+)\.$" grappled_someone= \
	/prot %{P1} is grappled!

;;### mudpit ###
/def -i -F -aCyellow -P2BCblue -t"^([a-z A-Z.,'-]+) turns the ground beneath (.*) into mud.$" mudpit_cast
/def -i -F -aCyellow -P1BCblue -t"^([a-z A-Z.,'-]+) falls down, arms flailing, helplessly into the mudpit.$" mudpit_fall
/def -i -F -aCyellow -P1BCblue -t"^([a-z A-Z.,'-]+) climbs out of the mudpit.$" mudpit_leave

;;### camping ###
/def -i -F -aB -msimple -t'You awaken from your short rest, and feel slightly better.' camp_done=\
	/timer_start timer_camping
/def -i -Fp0 -aB -msimple -t'You feel a bit tired.' camp_again_1 =\
	/substitute %{*} ( $(/timer_show timer_camping) )%;\
	/can_camp
/def -i -Fp0 -aB -msimple -t'You feel like camping a little.' camp_again_2 =\
	/substitute %{*} ( $(/timer_show timer_camping) )%;\
	/can_camp
/def -i -Fp0 -aB -msimple -t'You stretch yourself and consider about camping.' camp_again_3 =\
	/substitute %{*} ( $(/timer_show timer_camping) )%;\
	/can_camp
/def -i can_camp=/test 0

;;### lounging ###
/def -i -F -aB -msimple -t'You are done with your lounging for now, you feel better!' lounge_done
/def -i -F -aB -msimple -t'You are in a mood for a bit of lounging again.' lounge_again

;;### heal all ###
/def -i -F -aB -t"You feel like * healed you a bit." heal_all=/timer_start heal_all

;;### poison cast ###
/def -i -F -aCblack,Cbggreen -t'* utters the magic words \'saugaiii\'' poison_cast

;; ### poison save ###
/def -i -F -msimple -t"You SAVE against POISON." save_poison =\
	/prot saved against poison

;; ### poisoned ###
/def -i -F -P1BCgreen -aBCred -t"^You shiver and suffer from (POISON!!)$" poison_effect

;;### paralyze ###
/def -i -F -aCred,Cbgcyan -P2BCred,Cbgblue -t"^([a-z A-Z.,'-]+) paralyzes ([A-Za-z '-]) with (her|its|his) mind.$" paralyze
/def -i -F -P2u -t"^([a-z A-Z.,'-]+) paralyzes (you) with (her|its|his) mind.$" paralyze_me

;;### imprison ###
/def -i -F -aCblack,Cbgwhite -msimple -t'The banded green forcefield prevents you from leaving.' field_imprison

;;### field spells, lite with timer ###
/def -i -Fp10 -mregexp -t'An? [a-z]+ ([a-z]+) force field surrounds this area.' field_here=\
	/eval /def -i -1 -Fp9 -P1BC$[replace("gray","black",{P1})] \
				-t'An? ([a-z]+ [a-z]+) force field surrounds this area.' field_temp

/def -i -Fp10 -mregexp -t'^This location is now surrounded in an? ([a-z]+) ([a-z]+) forcefield.$' field_up=\
	/timer_start timer_field_%{P1}_%{P2}%;\
	/eval /def -i -1 -Fp9 -P1BC$[replace("gray","black",{P2})] \
				-t'^This location is now surrounded in an? ([a-z]+ [a-z]+) forcefield.$$$' field_temp

/def -i -Fp10 -mregexp -t'^The ([a-z]+) ([a-z]+) forcefield vanishes.$' field_down=\
	/let field_timer_var=$[strcat("timer_field_",{P1},"_",{P2})]%;\
	/let field_time=$(/eval /timer_show %{field_timer_var})%;\
	/eval /def -i -1 -Fp9 -P1BC$[replace("gray","black",{P2})] -t'^The ([a-z]+ [a-z]+) forcefield vanishes.$$$' field_temp=\
		/if ("%{field_time}" !~ "") \
			/substitute %%%{P0} (%{field_time})%%%;\
		/endif

;; aquamarine blue   = rain
;; electric blue     = electric field
;; shimmering blue   = shelter/force dome
;; light blue        = field of light
;; banded green      = imprison
;; shining green     = anti magic field
;; miserably gray    = field of fear
;; desert yellow     = drying wind

;;### new disintegrate  ###
/def -i -F -aCred,Cbgwhite -t"* utters the magic word 'sahanpurua'" disintegrate
/def -i -F -aCred,Cbgwhite -t"* 'se on sarki nyt'" dest_1
/def -i -F -aCred,Cbgwhite -t"* 'rikki ja poikki'" dest_2

;;### energy vortex ###
/def -i -F -aBCblue -t'* looks wobbly and starts shaking.' vortex_in

;;### curses ###
;; degenerate person
/def -i -F -aCyellow -P1Cgreen -t"^([a-z A-Z.,'-]+) appears weakened!" degenerate_in
/def -i -F -aCyellow -P1Cgreen -t"^You manipulate the lifeforce of ([a-z A-Z.,'-]+)!" degenerate_hit=\
	/timer_start timer_degen%;\
	/set degen_target %{P1}

;; spider touch
/def -i -F -aCyellow -P1Cgreen -t"^([a-z A-Z.,'-]+) turns very pale and shivers as if .* had just been poisoned.$" spider_touch_hit=\
	/timer_start timer_spidertouch%;\
	/Set spidertouch_target %{P1}

;;curse of tarmalen
;/def -i -F -aCyellow -P1Cgreen -t"MISSING!" cot_hit
;	/timer_start timer_cot%;\
;	/set cot_target %{P1}


;;### shapes ###
/def -i -F -P2BCwhite  -t"^([a-z A-Z.,'-]+) is (in excellent shape\.)$"  shape_excellen
/def -i -F -P2BCyellow -t"^([a-z A-Z.,'-]+) is (in a good shape\.)$"     shape_good
/def -i -F -P2Cyellow  -t"^([a-z A-Z.,'-]+) is (slightly hurt\.)$"       shape_slightly_hurt
/def -i -F -P2BCgreen  -t"^([a-z A-Z.,'-]+) is (noticeably hurt\.)$"     shape_noticeably_hurt
/def -i -F -P2Cgreen   -t"^([a-z A-Z.,'-]+) is (not in a good shape\.)$" shape_not_good
/def -i -F -P2Cmagenta -t"^([a-z A-Z.,'-]+) is (in bad shape\.)$"        shape_bad
/def -i -F -P2Cred     -t"^([a-z A-Z.,'-]+) is (in very bad shape\.)$"   shape_very_bad
/def -i -F -P2BCred    -t"^([a-z A-Z.,'-]+) is (near death\.)$"          shape_near_death
/def -i -F -P2BCred    -t"^([a-z A-Z.,'-]+) is (DEAD, R\.I\.P\.)$"       shape_dead_rip

;;### mage blast types ###
/def -i -F -P1BCcyan   -t"'(cah [a-z ]+)'"  blastlite_cold
/def -i -F -P1BCred    -t"'(fah [a-z ]+)'"  blastlite_fire
/def -i -F -P1Cyellow  -t"'(fzz [a-z ]+)'"  blastlite_acid
/def -i -F -P1BCyellow -t"'(zot [a-z ]+)'"  blastlite_elec
/def -i -F -P1Ccyan    -t"'(omm [a-z ]+)'"  blastlite_psio
/def -i -F -P1BCblack  -t"'(ghht [a-z ]+)'" blastlite_asph
/def -i -F -P1Cmagenta -t"'(gtzt [a-z ]+)'" blastlite_mana
/def -i -F -P1Cgreen   -t"'(krkz [a-z ]+)'" blastlite_pois

;;### successful blasts and harms ###
/def -i -F -P4xCred   -aB -t"^([a-z A-Z.,'-]+) grins as (its|hers|his) (.*) hits ([a-z A-Z.,'-]+)\.$" blast_hit_others
/def -i -F -P2xCgreen -aB -t"^You watch with selfpride as your (.*) hits ([a-z A-Z.,'-]+)\.$" blast_hit_my
/def -i -F -P2xCred   -aB -t"^([a-z A-Z.,'-]+) hits ([a-z A-Z.,'-]+) with (its|hers|his) ([a-z ]+)\.$" blast_hit_others_area
/def -i -F -P1xCgreen -aB -t"^You hit ([a-z A-Z.,'-]+) with your ([a-z ]+)\.$" blast_hit_my_area
/def -i -F -P2xCred   -aB -t"^([a-z A-Z.,'-]+) crushes ([a-z A-Z.,'-]+'s) mind with a powerful psychic attack!$" blast_hit_others_psi
/def -i -F -P1xCgreen -aB -t"^You crush ([a-z A-Z.,'-]+)'s mind with your psychic attack!$" blast_hit_my_psi
/def -i -F -P2xCred   -aB -t"^([a-z A-Z.,'-]+) casts a harming spell on ([a-z A-Z.,'-]+).$" blast_hit_others_harm
/def -i -F -P2xCred   -aB -t"^([a-z A-Z.,'-]+) harms (you)" blast_hit_others_harm_me
/def -i -F -P1xCgreen -aB -t"^You cast harming spell on ([a-z A-Z.,'-]+)\.$" blast_hit_my_harm

;;### bless ###
/def -Fp0 -i -msimple -t'You feel like you could see anything.'     bless_1=/substitute -p %{*} (@{B}see invisible@{n})
/def -Fp0 -i -msimple -t'You feel like you could do anything.'      bless_2=/substitute -p %{*} (@{B}+1 skills@{n})
/def -Fp0 -i -msimple -t'You feel fishy.'                           bless_3=/substitute -p %{*} (@{B}water walking@{n})
/def -Fp0 -i -msimple -t'You feel one with the soil.'               bless_4=/substitute -p %{*} (@{B}one with soil@{n})
/def -Fp0 -i -msimple -t'You feel one with the magic.'              bless_5=/substitute -p %{*} (@{B}+1 spells@{n})
/def -Fp0 -i -msimple -t'You feel one with the magic forces.'       bless_6=/substitute -p %{*} (@{B}see magic@{n})
/def -Fp0 -i -msimple -t'You feel one with the darkness.'           bless_7=/substitute -p %{*} (@{B}infravision@{n})
/def -Fp0 -i -msimple -t'Your heart seems to start working faster.' bless_8=/substitute -p %{*} (@{B}fast meta@{n})

;;### gravedigging ###
/def -F -i -t"You start digging a grave for the corpse of *, using your hands." digging_start=/timer_start gravedigging
/def -F -i -aB -t"You finish digging the grave and toss the corpse of * in." digging_end=/substitute %{*} ( $(/timer_show gravedigging) )

;;### unstun used (oldie)  ###
/def -i -F -aCcyan,Cbgblue -t'* is aided by the higher powers and resists the stun!' unstun_used

;;### luck improves  (oldie) ###
/def -i -F -aBCmagenta,Cbgcyan -msimple -t'You feel your luck changing.' improve_luck 

;;### old disintegrate  ### (it was better, why was it changed...:( )
;/def -i -F -aCred,Cbgwhite -t'* utters the magic words \'sahanpurua, shampanjaa ja vaahtokarkkeja\'' disintegrate_old
