;; hit counter

;; Antti Pietikinen (heidel@operamail.com)
;; 2005


;; purgevar needed
/require -q misc.tf

/require -q help_list.tf
/help_add /help_hitcount Hit counter

;; save selection over quit
/require -q variables.tf
/savevar_add hitcount_selected

/def -i help_hitcount=\
	/echo -aB Help for hitcounter:%;\
	/echo /hitcount_show            show your hitting statistics%;\
	/echo /hitcount_reset           reset hitcounter%;\
	/echo /hitcount_select <types>  select hit types to count%;\
	/echo (available types: cut, bash, pierce, monk, tiger)%;\
	/echo example: /hitcount_select cut bash

/def -i hitcount_select=\
	/set hitcount_selected=%{*}%;\
	/purge -i hitcount_hit_*%;\
	/while ({#}) \
		/eval /set hitcount_selected_%{1}=1%;\
		/hitcount_def %{1}%;\
		/shift%;\
	/done

/def -i hitcount_addlist=\
	/eval /test hitcount_pattern_%{1} := strcat(hitcount_pattern_%{1},"|",{-1})%;\
	/eval /if (substr(hitcount_pattern_%{1},0,1)=~"|") \
		/eval /test hitcount_pattern_%{1} := substr(hitcount_pattern_%{1},1)%%;\
	/endif%;\
	/eval /test hitcount_list_%{1} := strcat(hitcount_list_%{1}," ",textencode({-1}))

/purgevar hitcount_list_*
/purgevar hitcount_pattern_*
/hitcount_addlist cut solidly slash
/hitcount_addlist cut gash
/hitcount_addlist cut lightly cut
/hitcount_addlist cut cut
/hitcount_addlist cut tear
/hitcount_addlist cut incise
/hitcount_addlist cut shred
/hitcount_addlist cut horribly shred
/hitcount_addlist cut slash
/hitcount_addlist cut incisively cut
/hitcount_addlist cut pierce
/hitcount_addlist cut slit
/hitcount_addlist cut cruelly tatter
/hitcount_addlist cut rive
/hitcount_addlist cut savagely shave
/hitcount_addlist cut cruelly slash
/hitcount_addlist cut uncontrollably slash
/hitcount_addlist cut quickly cut
/hitcount_addlist cut savagely rip
/hitcount_addlist cut BRUTALLY TEAR
/hitcount_addlist cut SAVAGELY SHRED
/hitcount_addlist cut CRUELLY REND
/hitcount_addlist cut DISMEMBER
/hitcount_addlist cut CRUELLY DISMEMBER
/hitcount_addlist bash jostle
/hitcount_addlist bash butt
/hitcount_addlist bash bump
/hitcount_addlist bash thump
/hitcount_addlist bash stroke
/hitcount_addlist bash thrust
/hitcount_addlist bash jab
/hitcount_addlist bash bash
/hitcount_addlist bash strike
/hitcount_addlist bash sock
/hitcount_addlist bash cuff
/hitcount_addlist bash knock
/hitcount_addlist bash flail
/hitcount_addlist bash beat
/hitcount_addlist bash whack
/hitcount_addlist bash smash
/hitcount_addlist bash cruelly beat
/hitcount_addlist bash badly smash
/hitcount_addlist bash horribly thrust
/hitcount_addlist bash savagely strike
/hitcount_addlist bash savagely sock
/hitcount_addlist bash CRUELLY CUFF
/hitcount_addlist bash BARBARICALLY BASH
/hitcount_addlist bash REALLY WHACK
/hitcount_addlist bash BRUTALLY BEAT
/hitcount_addlist bash CRUELLY DISMEMBER
/hitcount_addlist pierce scratch
/hitcount_addlist pierce slightly pierce
/hitcount_addlist pierce pierce
/hitcount_addlist pierce puncture
/hitcount_addlist pierce sink
/hitcount_addlist pierce bore
/hitcount_addlist pierce crater
/hitcount_addlist pierce cavitate
/hitcount_addlist pierce shaft
/hitcount_addlist pierce really poke
/hitcount_addlist pierce riddle
/hitcount_addlist pierce dig into
/hitcount_addlist pierce gorge
/hitcount_addlist pierce dig through
/hitcount_addlist pierce drill
/hitcount_addlist pierce chasm
/hitcount_addlist pierce powerfully pierce
/hitcount_addlist pierce powerfully perforate
/hitcount_addlist pierce cruelly crater
/hitcount_addlist pierce savagely shaft
/hitcount_addlist pierce BARBARICALLY PIERCE
/hitcount_addlist pierce CRUELLY RIDDLE
/hitcount_addlist pierce REALLY DRILL
/hitcount_addlist pierce BRUTALLY BORE
/hitcount_addlist monk step
/hitcount_addlist monk kick
/hitcount_addlist monk smash
/hitcount_addlist monk circle kick
/hitcount_addlist monk stomp-kick
/hitcount_addlist monk spin-kick
/hitcount_addlist monk stomp
/hitcount_addlist monk lunge
/hitcount_addlist monk attack
/hitcount_addlist monk leg-twist
/hitcount_addlist monk side-kick
/hitcount_addlist monk thud
/hitcount_addlist monk gouge
/hitcount_addlist monk strike
/hitcount_addlist monk bearhug
/hitcount_addlist monk jump-kick
/hitcount_addlist monk back-kick
/hitcount_addlist monk SNAP-KICK
/hitcount_addlist monk FLY-KICK
/hitcount_addlist tiger step
/hitcount_addlist tiger kick
/hitcount_addlist tiger smash
/hitcount_addlist tiger punch
/hitcount_addlist tiger stomp-kick
/hitcount_addlist tiger spin-kick
/hitcount_addlist tiger sweep
/hitcount_addlist tiger attack
/hitcount_addlist tiger side-kick
/hitcount_addlist tiger poke
/hitcount_addlist tiger strike
/hitcount_addlist tiger hit
/hitcount_addlist tiger joint-lock
/hitcount_addlist tiger jump-kick
/hitcount_addlist tiger thrust
/hitcount_addlist tiger pummel
/hitcount_addlist tiger BARBARICALLY STRIKE

/set hitcount_critlist=Smiling demonically |Cackling demonically |

/def -i hitcount_def=\
	/eval /def -i -Fp3 -P2Cgreen -t"(?-i)^(%{hitcount_critlist})[Yy]ou (%%{hitcount_pattern_%{1}}) " hitcount_hit_%{1}=\
		/if ({P1}=~"") \
			/test ++hitcount_norm_$$$[textencode({P2})]%%%;\
			/test ++hitcount_norm%%%;\
		/else \
			/test ++hitcount_crit_$$$[textencode({P2})]%%%;\
			/test ++hitcount_crit%%%;\
		/endif%%%;\
		/test ++hitcount_hit

/def -i -F -t"You miss *" hitcount_miss=\
	/test ++hitcount_miss

/def -i -F -t"* successfully dodges your futile *" hitcount_dodge=\
	/test ++hitcount_dp
/def -i -F -t"* successfully parriest your *" hitcount_parry=\
	/test ++hitcount_dp

/def -i hitcount_show=\
	/if (hitcount_hit!=0 | hitcount_miss!=0 | hitcount_dp!=0) \
		/let hitcount_hitratio=$[100*hitcount_hit/(hitcount_hit+hitcount_miss+hitcount_dp)]%;\
	/endif%;\
	/if (hitcount_selected_cut) \
		/echo -aB Cutting:            normal hits   critical hits%;\
		/hitcount_show_hits %{hitcount_list_cut}%;\
	/endif%;\
	/if (hitcount_selected_bash) \
		/echo -aB Bashing:            normal hits   critical hits%;\
		/hitcount_show_hits %{hitcount_list_bash}%;\
	/endif%;\
	/if (hitcount_selected_pierce) \
		/echo -aB Piercing:           normal hits   critical hits%;\
		/hitcount_show_hits %{hitcount_list_pierce}%;\
	/endif%;\
	/if (hitcount_selected_monk) \
		/echo -aB Monk:               normal hits   critical hits%;\
		/hitcount_show_hits %{hitcount_list_monk}%;\
	/endif%;\
	/if (hitcount_selected_tiger) \
		/echo -aB Tiger:              normal hits   critical hits%;\
		/hitcount_show_hits %{hitcount_list_tiger}%;\
	/endif%;\
	/echo -aB Total hits:   %{hitcount_hit} ( %{hitcount_hitratio} % )%;\
	/echo -aB Total misses: $[hitcount_miss+hitcount_dp] ( $[100-hitcount_hitratio] % )

/def -i hitcount_show_hits=\
	/let hitcount_num=0%;\
	/while ({#}) \
		/test ++hitcount_num%;\
		/if (hitcount_norm>0) \
			/eval /set hitcount_ratio_norm=$$[(100*hitcount_norm_%{1})/hitcount_norm]%;\
		/else \
			/set hitcount_ratio_norm=0%;\
		/endif%;\
		/if (hitcount_crit>0) \
			/eval /set hitcount_ratio_crit=$$[(100*hitcount_crit_%{1})/hitcount_crit]%;\
		/else \
			/set hitcount_ratio_crit=0%;\
		/endif%;\
		/eval /if (hitcount_norm_%{1}>0 | hitcount_crit_%{1}>0) \
			/eval /echo $$$[pad(hitcount_num,2,textdecode({1}),25,\
						hitcount_norm_%{1},6," ( ",3,hitcount_ratio_norm,3," % )",4,\
						hitcount_crit_%{1},6," ( ",3,hitcount_ratio_crit,3," % )",4)]%%;\
		/endif%;\
		/shift%;\
	/done

;; block some non-hits

;; You cut off a piece of root with a sharp object.
/def -p4 -i -t"You cut off *" hitcount_block_1

;; reset
/def -i hitcount_reset=\
	/purgevar hitcount_*

/eval /hitcount_select %{hitcount_selected}

/eval /echo -aCyellow % Hit counter loaded (%{hitcount_selected}).