;; triggers for aura upkeep
;; Antti Pietikinen (heidel@operamail.com)
;; 2005

;; usage:
;; /aura to check last recast/warning
;; reports aura status using /prot

;; prot_on and prot_off
/require -q prot_template.tf

;; timeformat
/require -q misc.tf


/def -i -F -t'You try your hardest but cannot focus enough energy.' aura_start_1=\
	/prot_on -q energyaura
/def -i -F -t'You attempt to focus even more energy, but make very little progress.' aura_start_2=\
	/prot_on -q energyaura
/def -i -F -t'Tendrils of lightning flit around you as your aura changes*' aura_start_3=\
	/prot_on -q energyaura
/def -i -F -t'Suddenly a softly glowing aura of yellow light comes into being around you.' aura_start_4=\
	/prot_on -q energyaura
/def -i -F -t'With a burst of energy, your aura changes from soft yellow to bright red.' aura_start_5=\
	/prot_on -q energyaura


/def -i -F -t'Your aura is starting to weaken!' aura_low=\
	/prot_off energyaura aura low%;\
	/prot_on -q auraoff%;\
	/echo -aB ####### AURA WEAK ########%;\
	/repeat -60 1 /if (time()-{energyaura_time} > 59)\
		/echo -aB,Cred ######## AURA WEAK ############%%;\
		/endif


/def -i -F -t'Your aura of glowing light fades to nothing.' aura_falls=\
	/prot_off auraoff aura down, time after warning:

/def -i aura =\
	/let dur=$[time()-{energyaura_time}]%;\
	/if (dur>20*60) \
		/let dur=$[time()-{auraoff_time}]%;\
		/echo -aB % Aura warning $(/timeformat %{dur}) ago.%;\
	/else \
		/echo -aB % Aura recast $(/timeformat %{dur}) ago.%;\
	/endif

