;; blast analysis reporting
;; Antti Pietikinen (Heidel@batmud) 2003

;; missing quite a few spells, but has major mage blasts and channeller spells
;; todo: psi, and the 2nd best magespells, maybe nunstuff too

/require -q help_list.tf
/help_add /help_analysis spell analysis reporter

/def -i help_analysis=\
	/echo -aB Analysis reporter:%;\
	/echo /analysis_swap        Swap between reporting modes.%;\
	/echo %;\
	/echo Modes:%;\
	/echo - echo%;\
	/echo - report to party (uses /prot)%;\
	/echo
	

/set resistmode 1

/def -i analysis_swap =\
	/if (resistmode) \
		/def note_resist = /prot %%{*}%;\
		/echo -aB % Analyze now uses /prot, default: party channel%;\
	/else \
		/def note_resist = /echo -aB - %%{*}%;\
		/echo -aB % Analyze now echoed%;\
	/endif%;\
	/set resistmode=$[!resistmode]

/def -i -F -t'You start chanting.'                                       clear_blast_type_1 = /unset blast_type
/def -i -F -t'You start to channel the forces magical*'                  clear_blast_type_2 = /unset blast_type
/def -i -F -t'You conceal your intent of channeling the forces magical*' clear_blast_type_3 = /unset blast_type


;; mana
/def -i -F -t"You thrust your hands forward and scream 'shar ryo den...Haa!'"           blastmana1=\
	/set blast_type=mana
/def -i -F -t"You raise your hand to focus energy and intone 'lecaps meeb nonnock'"     blastmana2=\
	/set blast_type=mana
/def -i -F -t'You watch with selfpride as your golden arrow hits *.'                    blastmana3=\
	/set blast_type=mana


;; fire
/def -i -F -t"You clench your fists and scream 'grhagrhagrhagrah gra gra Hyaa!'"        blastfire1=\
	/set blast_type=fire
/def -i -F -t"You make a sweeping arc with one hand and grunt 'grinurb sdan imflagrum'" blastfire2=\
	/set blast_type=fire
/def -i -F -t"You play the instrument with an unbelievable speed: 'AeaH\*h\*\*\*Gdg'"   blastfire3=\
	/set blast_type=fire
/def -i -F -t'You watch with selfpride as your lava blast hits *.'                      blastfire4=\
	/set blast_type=fire


;; elec
/def -i -F -t"You wave your hand and say 'tsaibaa'"                                     blastelec1=\
	/set blast_type=elec
/def -i -F -t'You watch with selfpride as your electrocution hits *.'                   blastelec2=\
	/set blast_type=elec


;; acid
/def -i -F -t'You watch with selfpride as your acid blast hits *.'                      blastacid=\
	/set blast_type=acid


;; poison
/def -i -F -t'You watch with selfpride as your summon carnal spores hits *.'            blastpois=\
	/set blast_type=poison


;; cold
/def -i -F -t'You watch with selfpride as your cold ray hits *.'                        blastcold=\
	/set blast_type=cold


;; asphyx
/def -i -F -t'You watch with selfpride as your blast vacuum hits *.'                    blastasph=\
	/set blast_type=asphyx



;; analysis

/def -i -F -aB -P1Cgreen -t'^([A-Za-z,\' -]*) screams in pain.$'                       analyze_screams=\
	/note_resist %{P1} screams (0% resist) %{blast_type}

/def -i -F -aB -P1Cgreen -t'^([A-Za-z,\' -]*) writhes in agony.$'                      analyze_writhe=\
	/note_resist %{P1} writhes (20% resist) %{blast_type}

/def -i -F -aB -P1Cgreen -t'^([A-Za-z,\' -]*) shudders from the force of the attack.$' analyze_shudder=\
	/note_resist %{P1} shudders (40% resist) %{blast_type}

/def -i -F -aB -P1Cgreen -t'^([A-Za-z,\' -]*) grunts from the pain.$'                  analyze_grunt=\
	/note_resist %{P1} grunts (60% resist) %{blast_type}

/def -i -F -aB -P1Cgreen -t'^([A-Za-z,\' -]*) winces a little from the pain.$'         analyze_wince=\
	/note_resist %{P1} winces (80% resist) %{blast_type}

/def -i -F -aB -P1Cgreen -t'^([A-Za-z,\' -]*) shrugs off the attack.$'                 analyze_shrug=\
	/note_resist %{P1} shrugs (100% resist) %{blast_type}


;; damage criticality

;; lvl 1
/def -i -F -aBCwhite -t'You feel like your spell gained additional power.' dcrit_1 =\
	/note_resist (dcrit level 1)

;; lvl 2
/def -i -F -aBCmagenta -t'You feel like you managed to channel additional POWER to your spell.' dcrit_2 =\
	/note_resist (dcrit level 2)

;; lvl 3
/def -i -F -aBCred -t'Your fingertips are surrounded with swirling ENERGY as you cast the spell.' dcrit_3 =\
	/note_resist (dcrit level 3)

;; unseen
/def -i -F -aBCgreen -t'The air is filled with pure energy and crackles with power.' unseen_1
/def -i -F -aBCgreen -P1BCyellow -t'^Unseen (BURSTS) of magic are absorbed into the spell!$' unseen_2


/echo -aCyellow % Analysis helper loaded.
