/loaded at_quit.tf

;; Do something just before quit
;; Very useful for saving variables
;; Antti Pietikinen (heidel@operamail.com)
;; 2005

;; note: you can use this for autosaving, too!
;; /repeat -0:5:0 1000000 /quit_do
;; that'll save the settings every five minutes during the next 9 and half years


/require -q help_list.tf
/help_add /help_quit automatic actions at quit


/def -i help_quit=\
	/echo -aB Help for 'at quit':%;\
	/echo /quit_list            Show what will be done at /quit%;\
	/echo /quit_add             Add something to 'at quit' list%;\
	/echo /quit_remove          Remove something from the list%;\
	/echo /quit_do              Do the list now (useful for e.g. autosaving stuff)%;\
	/echo /@quit                Quit without doing the list;%;\
	/echo

/def -i quit_add=\
	/if (strstr(quit_todo_list,textencode({*})) == -1) \
		/test quit_todo_list := strcat(quit_todo_list," ",textencode({*}))%;\
	/endif

/def -i quit_remove=\
	/test quit_todo_list := replace({*},"", quit_todo_list)

/def -i quit_list=\
	/if ({#}==0) \
		/if (quit_todo_list !~ "") \
			/quit_show %{quit_todo_list}%;\
		/else \
			/echo -aB % No commands to be performed at quit%;\
		/endif%;\
	/else \
		/echo -aB % Commands to be performed at quit:%;\
		/while ({#}) \
			/echo -aCgreen - $[textdecode({1})]%;\
			/shift%;\
		/done%;\
	/endif

/def -i quit_do=\
	/while ({#}) \
		/eval /eval -s0 $[textdecode({1})]%;\
		/shift%;\
	/done

/def -ag -Fp4000 -1 -q -h"CONFLICT" temp_hide_conflict

/def -i quit=\
	/quit_do %{quit_todo_list}%;\
	/@quit %{*}

