import java.util.Scanner;
import java.io.*;
import java.lang.Double;
import java.util.LinkedList;
import java.util.List;
import java.text.NumberFormat;

/**
 * reads information from a file that contains the amounts of snowfall for various resorts
 * the amounts of snowfall are added together for the totals at each resort
 * 
 * @author Justin Vallelonga
 * @version 1.0
 */
public class Snowfall
{
    private LinkedList<Resort> list;
    private File snowFile;

    /**
     * Constructs a new Snowfall instance
     * @param address the address of the file that will be read from
     */
    public Snowfall(String address)
    {
        list = new LinkedList<Resort>();
        snowFile = new File(address);
        sortData();
    }
    
    /**
     * takes the information from the file and adds it to the linked list
     */
    public void sortData()
    {
        Scanner inFile;
        try
        {
            inFile = new Scanner(snowFile);
        }
        catch (FileNotFoundException e)
        {
            System.out.println("Error: " + e);
            return;
        }
        
        String line = "";
        String name = "";
        Double amount = 0.0;
        while (inFile.hasNext())
        {
            name = "";
            line = inFile.nextLine();
            String[] splitLine = line.split(" ");
            name = splitLine[0];
            if (splitLine.length > 2)
            {
                for (int i = 1; i < (splitLine.length - 1); i++)
                    name +=  (" " + splitLine[i]);
            }
            name = name.trim();
            try
            {
                amount = amount.parseDouble(splitLine[(splitLine.length - 1)]);
            }
            catch (NumberFormatException e)
            {
                System.out.println(e);
                System.out.println("One of the snow amounts in the file was invalid.");
            }
            if (!findAndAdd(name, amount))
                list.add(new Resort(name, amount));
        }
    }
    
    /**
     * finds out if the resort already exists using the name.
     * if the resort is found, the amount is added to the resort's amount
     * 
     * @param name the name of the resort
     * @param amount the amount of snowfall
     * @return found whether or not the resort was found
     */
    public boolean findAndAdd(String name, Double amount)
    {
        boolean found = false;
        if (list.size() != 0)
        {
            for (int i = 0; i < list.size() && !found; i++)
            {
                if (list.get(i).getName().equals(name))
                {
                    found = true;
                    list.get(i).addAmount(amount);
                }
            }
        }
        return found;
    }
    
    /**
     * saves the given text to a file with the given name
     * @param name the name of the saved file
     */
    public void saveAsFile(String name)
    {
        String fileOut = toString();
        Scanner fos = new Scanner(fileOut);
        try
        {
            File saveFile = new File(name);
            PrintWriter writer = new PrintWriter(saveFile);
            while (fos.hasNext())
            {
                writer.println(fos.nextLine());
            }
            writer.close();
        }
        catch (FileNotFoundException e)
        {
            System.out.println("" + e);
        }
    }
    
    /**
     * creates a string representation of the data
     * @return listValues the representation
     */
    public String toString()
    {
        String listValues = "RESORT NAME \t\tINCHES OF SNOW\n";
        for (int i = 0; i < list.size(); i++)
            listValues += (list.get(i) + "\n");
        return listValues;
    }
}
