import java.text.NumberFormat;
/**
 * represents a ski resort with a name and a total amount of snow
 * 
 * @author Justin Vallelonga
 * @version 1.0
 */
public class Resort
{
    private Double amount;
    private String name;

    /**
     * Constructs a new Resort instance
     * 
     * @param name the name of the resort
     * @param amount the initial amount of snowfall
     */
    public Resort(String name, Double amount)
    {
        this.amount = amount;
        this.name = name;
    }
    
    /**
     * gives the name of the resort
     * @return name the name of the resort
     */
    public String getName()
    {
        return name;
    }
    
    /**
     * gives the amount of snowfall for the resort
     * @return amount the amount of snowfall at the resort
     */
    public Double getAmount()
    {
        return amount;
    }
    
    /**
     * adds the given amount to the total amount of snowfall
     * @param amt the amount of snowfall to add to the total amount
     */
    public void addAmount(Double amt)
    {
        amount += amt;
    }
    
    /**
     * gives a string representation of the resort object
     * @return rep the string representation of the Resort object
     */
    public String toString()
    {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(1);
        String tabs = "\t\t";
        if (name.length() <= 7)
            tabs += "\t";
        String rep = name +  tabs + nf.format(amount);
        return rep;
    }
}
