import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
//import javax.swing.event.*;
import java.io.File;

/**
 * represents the graphic user interface of the snowfall calculator program
 * 
 * @author Justin Vallelonga
 * @version 1.0
 */
public class GUI extends JFrame
{
    private Snowfall snowfall;
    private JTextField field;
    private JTextArea area;
    
    /**
     * creates a runnable instance of GUI
     */
    public static void main(String[] args)
    {
        javax.swing.SwingUtilities.invokeLater(new Runnable()
        {
            public void run()
            {
                GUI gui = new GUI();
            }
        }
        );
    }
    
    /**
     * Constructs an instance of the GUI class
     */
    public GUI()
    {
        try
        {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException e)
        {
            System.out.println("Error: " + e);
        }
        catch (UnsupportedLookAndFeelException e)
        {
            System.out.println("Error: " + e);
        }
        catch (Exception e)
        {
            System.out.println("Error: " + e);
        }
        
        
        
        snowfall = null;
        JFrame window = new JFrame();
        JButton browse = new JButton("Browse...");
        JButton save = new JButton("Save As...");
        field = new JTextField();
        area = new JTextArea("");
        JPanel panel = new JPanel();
        JPanel footer = new JPanel();
        JMenuBar bar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        JMenuItem open = new JMenuItem("Open");
        JMenuItem saveAs = new JMenuItem("Save As...");
        JMenuItem close = new JMenuItem("Exit");
        
        fileMenu.add(open);
        fileMenu.add(saveAs);
        fileMenu.add(close);
        bar.add(fileMenu);
        
        open.addActionListener(
            new ActionListener()
            {
                public void actionPerformed(ActionEvent ae)
                {
                    JFileChooser browseBox = new JFileChooser();
                    int choice = browseBox.showOpenDialog(GUI.this);
                    if (choice == JFileChooser.APPROVE_OPTION)
                    {
                        field.setText(browseBox.getSelectedFile().getName());
                    }
                    if (choice != JFileChooser.CANCEL_OPTION)
                    {
                        snowfall = new Snowfall(field.getText());
                        area.setText(snowfall + "");
                    }
                }
            }
        );
        
        saveAs.addActionListener(
            new ActionListener()
            {
                public void actionPerformed(ActionEvent ae)
                {
                    JFileChooser saveBox = new JFileChooser();
                    int choice = saveBox.showSaveDialog(GUI.this);
                    if (choice == JFileChooser.APPROVE_OPTION)
                    {
                        if (!area.getText().equals(""))
                            snowfall.saveAsFile(saveBox.getSelectedFile().getName());
                        //else
                        //    statusBar.setText("Nothing to save in text area");
                    }
                }
            }
        );
        
        close.addActionListener(
            new ActionListener()
            {
                public void actionPerformed(ActionEvent ae)
                {
                    System.exit(0);
                }
            }
        );
        
        save.addActionListener(
            new ActionListener()
            {
                public void actionPerformed(ActionEvent ae)
                {
                    JFileChooser saveBox = new JFileChooser();
                    int choice = saveBox.showSaveDialog(GUI.this);
                    if (choice == JFileChooser.APPROVE_OPTION)
                    {
                        if (!area.getText().equals(""))
                            snowfall.saveAsFile(saveBox.getSelectedFile().getName());
                        //else
                        //    statusBar.setText("Nothing to save in text area");
                    }
                }
            }
        );
        
        browse.addActionListener(
            new ActionListener() 
            {
                public void actionPerformed(ActionEvent ae)
                {
                    JFileChooser browseBox = new JFileChooser();
                    int choice = browseBox.showOpenDialog(GUI.this);
                    if (choice == JFileChooser.APPROVE_OPTION)
                    {
                        field.setText(browseBox.getSelectedFile().getName());
                    }
                    if (choice != JFileChooser.CANCEL_OPTION)
                    {
                        snowfall = new Snowfall(field.getText());
                        area.setText(snowfall + "");
                    }
                }
            }
        );
       
        
        field.setColumns(20);
        
        area.setColumns(30);
        area.setRows(20);
        
        panel.add(field);
        panel.add(browse);
        panel.setBackground(new Color(255,0,0));
        
        JScrollPane scPane = new JScrollPane(area);
        
        footer.add(save);
        
        Container contain = window.getContentPane();
        contain.add(panel, BorderLayout.NORTH);
        contain.add(scPane, BorderLayout.CENTER);
        contain.add(footer, BorderLayout.SOUTH);
        
        window.setJMenuBar(bar);
        window.setTitle("Resort Total Snowfall Calculator");
        window.setBounds(300,100,600,600);    //x,y,width,height
        window.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        window.setVisible(true);
    }
}
