/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.Scanner;

public class Snowfall {
    private LinkedList<Resort> list = new LinkedList();
    private File snowFile;

    public Snowfall(String address) {
        this.snowFile = new File(address);
        this.sortData();
    }

    public void sortData() {
        Scanner inFile;
        try {
            inFile = new Scanner(this.snowFile);
        }
        catch (FileNotFoundException e) {
            System.out.println("Error: " + e);
            return;
        }
        String line = "";
        String name = "";
        Double amount = 0.0;
        while (inFile.hasNext()) {
            name = "";
            line = inFile.nextLine();
            String[] splitLine = line.split(" ");
            name = splitLine[0];
            if (splitLine.length > 2) {
                for (int i = 1; i < splitLine.length - 1; ++i) {
                    name = name + " " + splitLine[i];
                }
            }
            name = name.trim();
            try {
                amount = Double.parseDouble(splitLine[splitLine.length - 1]);
            }
            catch (NumberFormatException e) {
                System.out.println(e);
                System.out.println("One of the snow amounts in the file was invalid.");
            }
            if (this.findAndAdd(name, amount)) continue;
            this.list.add(new Resort(name, amount));
        }
    }

    public boolean findAndAdd(String name, Double amount) {
        boolean found = false;
        if (this.list.size() != 0) {
            for (int i = 0; i < this.list.size() && !found; ++i) {
                if (!this.list.get(i).getName().equals(name)) continue;
                found = true;
                this.list.get(i).addAmount(amount);
            }
        }
        return found;
    }

    public void saveAsFile(String name) {
        String fileOut = this.toString();
        Scanner fos = new Scanner(fileOut);
        try {
            File saveFile = new File(name);
            PrintWriter writer = new PrintWriter(saveFile);
            while (fos.hasNext()) {
                writer.println(fos.nextLine());
            }
            writer.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("" + e);
        }
    }

    public String toString() {
        String listValues = "RESORT NAME \t\tINCHES OF SNOW\n";
        for (int i = 0; i < this.list.size(); ++i) {
            listValues = listValues + this.list.get(i) + "\n";
        }
        return listValues;
    }
}

