import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.io.File;
import java.util.ArrayList;
import java.lang.Double;
import java.text.NumberFormat;

public class GUI extends JFrame
{
    private JFrame window;
    private JTextField date;
    private JTextField description;
    private JTextField amount;
    private JTextArea area;
    private JTextField total;
    private JPanel addPanel;
    private JPanel totalPanel;
    private Container contain;
    private File currDir;
    private File recentDir;
    private ExpenseList list;
    
    
    /**
     * creates a runnable instance of GUI
     */
    public static void main(String[] args)
    {
        javax.swing.SwingUtilities.invokeLater(new Runnable()
        {
            public void run()
            {
                GUI gui = new GUI();
            }
        }
        );
    }
    
    public GUI()
    {
        try
        {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException e)
        {
            JOptionPane.showMessageDialog(null, "Error: " + e, "Alert", JOptionPane.ERROR_MESSAGE);
        }
        catch (UnsupportedLookAndFeelException e)
        {
            JOptionPane.showMessageDialog(null, "Error: " + e, "Alert", JOptionPane.ERROR_MESSAGE);
        }
        catch (Exception e)
        {
            JOptionPane.showMessageDialog(null, "Error: " + e, "Alert", JOptionPane.ERROR_MESSAGE);
        }
        
        list = null;
        
        currDir = null;
        recentDir = null;  //have this open a recent directory file that contains the recent directory that recent files were saved to.
        window = new JFrame();
        
        date = new JTextField();
        description = new JTextField("GAS");
        amount = new JTextField();
        JButton addExpense = new JButton("Add Expense to Log");
        addExpense.setBackground(new Color(180,180,100));
        addPanel = new JPanel();
        
        area = new JTextArea();
        
        total = new JTextField();
        totalPanel = new JPanel();
        
        JMenuBar bar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        JMenu openMenu = new JMenu("Open Recent");
        JMenu viewMenu = new JMenu("View");
        //JMenuItem viewByDate = new JMenuItem("View By Date");
        //viewByDate.setBackground(new Color(180,180,100));
        JMenuItem viewByAmount = new JMenuItem("View By Amount");
        viewByAmount.setBackground(new Color(190,210,170));
        JMenuItem viewByNumber = new JMenuItem("View By Number");
        viewByNumber.setBackground(new Color(190,210,170));
        JMenuItem openFile = new JMenuItem("Open Expense Log...");
        openFile.setBackground(new Color(190,210,170));
        JMenuItem saveLog = new JMenuItem("Save Log");
        saveLog.setBackground(new Color(190,210,170));
        JMenuItem saveLogAs = new JMenuItem("Save Log As...");
        saveLogAs.setBackground(new Color(190,210,170));
        JMenuItem close = new JMenuItem("Close Log");
        close.setBackground(new Color(190,210,170));
        //JMenuItem startExpenseLog = new JMenuItem("Start New Expense Log");
        JMenuItem quit = new JMenuItem("Quit");
        quit.setBackground(new Color(190,210,170));
        
        
        fileMenu.setBackground(new Color(190,210,170));
        viewMenu.setBackground(new Color(190,210,170));
        
        //fileMenu.add(startExpenseLog);
        //openMenu.add(openFile);
        //fileMenu.add(openMenu);
        fileMenu.add(openFile);
        fileMenu.add(saveLog);
        fileMenu.add(saveLogAs);
        fileMenu.add(close);
        fileMenu.addSeparator();
        fileMenu.add(quit);
        //viewMenu.add(viewByDate);
        viewMenu.add(viewByAmount);
        viewMenu.add(viewByNumber);
        bar.add(fileMenu);
        bar.add(viewMenu);
        
        //                          ACTION LISTENERS START HERE
        
        addExpense.addActionListener(
            new ActionListener()
            {
                public void actionPerformed(ActionEvent ae)
                {
                    if (list == null)
                    {
                        list = new ExpenseList();
                    }
                    try
                    {
                        Double doub = new Double(amount.getText());
                        list.add(new Expense(date.getText(), description.getText(), doub));
                    }
                    catch (NumberFormatException e)
                    {
                        JOptionPane.showMessageDialog(null, "Error: " + e, "Alert", JOptionPane.ERROR_MESSAGE);
                        list = null;
                        return;
                    }
                    area.setText(list + "");
                    NumberFormat nf = NumberFormat.getInstance();
                    nf.setMaximumFractionDigits(2);
                    total.setText(nf.format(list.getTotal()) + "");
                }
            }
        );
        
        openFile.addActionListener(
            new ActionListener()
            {
                public void actionPerformed(ActionEvent ae)
                {
                    JFileChooser opener = new JFileChooser();
                    opener.setCurrentDirectory(currDir);
                    int choice = opener.showOpenDialog(GUI.this);
                    if (choice == JFileChooser.APPROVE_OPTION)
                    {
                        currDir = new File(opener.getSelectedFile().getPath());
                        list = new ExpenseList(currDir);
                    }
                    if (choice == JFileChooser.CANCEL_OPTION)
                        return;
                    area.setText(list + "");
                    NumberFormat nf = NumberFormat.getInstance();
                    nf.setMaximumFractionDigits(2);
                    total.setText(nf.format(list.getTotal()) + "");
                }
            }
        );
        
        saveLog.addActionListener(
            new ActionListener()
            {
                public void actionPerformed(ActionEvent ae)
                {
                    if (list == null)
                    {
                        JOptionPane.showMessageDialog(null, "Error: Nothing to save.", "Alert", JOptionPane.ERROR_MESSAGE);
                        return;
                    }
                    if (currDir == null)
                    {
                        JFileChooser saver = new JFileChooser();
                        saver.setCurrentDirectory(currDir);
                        int choice = saver.showSaveDialog(GUI.this);
                        if (choice == JFileChooser.APPROVE_OPTION)
                        {
                            currDir = new File(saver.getSelectedFile().getPath());
                            list.saveAs(currDir);
                        }
                        if (choice == JFileChooser.CANCEL_OPTION)
                            return;
                    }
                    else
                        list.saveAs(currDir);
                }
            }
        );
        
        saveLogAs.addActionListener(
            new ActionListener()
            {
                public void actionPerformed(ActionEvent ae)
                {
                    if (list == null)
                    {
                        JOptionPane.showMessageDialog(null, "Error: Nothing to save.", "Alert", JOptionPane.ERROR_MESSAGE);
                        return;
                    }
                    JFileChooser saver = new JFileChooser();
                    saver.setCurrentDirectory(currDir);
                    int choice = saver.showSaveDialog(GUI.this);
                    if (choice == JFileChooser.APPROVE_OPTION)
                    {
                        currDir = new File(saver.getSelectedFile().getPath());
                        list.saveAs(currDir);
                    }
                    if (choice == JFileChooser.CANCEL_OPTION)
                        return;
                }
            }
        );
        
        close.addActionListener(
            new ActionListener()
            {
                public void actionPerformed(ActionEvent ae)
                {
                    list = null;
                    area.setText("");
                }
            }
        );
        
        quit.addActionListener(
            new ActionListener()
            {
                public void actionPerformed(ActionEvent ae)
                {
                    System.exit(0);
                }
            }
        );
        
        viewByAmount.addActionListener(
            new ActionListener()
            {
                public void actionPerformed(ActionEvent ae)
                {
                    if (list != null)
                        area.setText(list.sortByAmount());
                    else
                        JOptionPane.showMessageDialog(null, "Open an expense log first.", "Alert!", JOptionPane.ERROR_MESSAGE);
                }
            }
        );
        
        viewByNumber.addActionListener(
            new ActionListener()
            {
                public void actionPerformed(ActionEvent ae)
                {
                    if (list != null)
                        area.setText(list + "");
                    else
                        JOptionPane.showMessageDialog(null, "Open an expense log first.", "Alert!", JOptionPane.ERROR_MESSAGE);
                }
            }
        );
        
       
        date.setColumns(10);
        description.setColumns(30);
        amount.setColumns(10);
        total.setColumns(10);
        
        area.setColumns(30);
        area.setRows(20);
        area.setBackground(new Color(190,210,170));
        
        addPanel.add(new JLabel("Date"));
        addPanel.add(date);
        addPanel.add(new JLabel("Description"));
        addPanel.add(description);
        addPanel.add(new JLabel("Amount"));
        addPanel.add(amount);
        addPanel.add(addExpense);
        addPanel.setBackground(new Color(200,150,100));
        
        totalPanel.add(new JLabel("total amount"));
        totalPanel.add(total);
        totalPanel.setBackground(new Color(200,150,100));
        
        JScrollPane scPane = new JScrollPane(area);
        
        contain = window.getContentPane();
        contain.add(addPanel, BorderLayout.NORTH);
        contain.add(scPane, BorderLayout.CENTER);
        contain.add(totalPanel, BorderLayout.SOUTH);
        
        bar.setBackground(new Color(190,210,170));
        window.setJMenuBar(bar);
        window.setTitle("Expense Logger");
        window.setBounds(100,100,900,600);    //x,y,width,height
        window.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        window.setVisible(true);
    }
}
