import javax.swing.*;
import java.util.ArrayList;
import java.util.Scanner;
import java.lang.Double;
import java.io.*;

public class ExpenseList
{
    private ArrayList<Expense> list;
    
    public ExpenseList()
    {
        list = new ArrayList<Expense>();
    }
    
    public ExpenseList(File log)
    {
        list = new ArrayList<Expense>();
        try
        {
            Scanner inFile = new Scanner(log);
            while (inFile.hasNext())
                list.add(formatToExpense(inFile.nextLine()));
        }
        catch (FileNotFoundException e)
        {
            JOptionPane.showMessageDialog(null, "Error: " + e, "Alert", JOptionPane.ERROR_MESSAGE);
        }
    }
    
    private Expense formatToExpense(String line)
    {
        String[] lineData = line.split("\t\t");
        Expense exp = new Expense(lineData[0], lineData[1], formatToDouble(lineData[2]));
        return exp;
    }
    
    private double formatToDouble(String unformattedString)
    {
        try
        {
            Double doub = new Double(unformattedString);
            return doub;
        }
        catch (NumberFormatException e)
        {
            JOptionPane.showMessageDialog(null, "Error: " + e, "Alert", JOptionPane.ERROR_MESSAGE);
            return 0.0; //this might cause problems.
        }
    }
    
    public void add(Expense e)
    {
        list.add(e);
    }
    
    public double getTotal()
    {
        double total = 0.0;
        for (int i = 0; i < list.size(); i++)
        {
            total += list.get(i).getAmount();
        }
        return total;
    }
    
    public void saveAs(File saveFile)
    {
        try
        {
            PrintWriter pw = new PrintWriter(saveFile);
            for (int i = 0; i < list.size(); i++)
            {
                pw.println("" + list.get(i));
            }
            pw.close();
        }
        catch (IOException e)
        {
            JOptionPane.showMessageDialog(null, "Error: " + e, "Alert", JOptionPane.ERROR_MESSAGE);
        }
    }
    
    /*
    public String sortByDate()
    {
        
    }
    */
   
    //                                             needs fixing
    public String sortByAmount()
    {
        String str = "";
        ArrayList<Expense> copyOfLog = new ArrayList<Expense>();
        copyOfLog.addAll(list);
        while (copyOfLog.size() >= 1)
        {
            double low = copyOfLog.get(0).getAmount();
            int lowIndex = 0;
            for (int i = 0; i < copyOfLog.size(); i++)
            {
                if (copyOfLog.get(i).getAmount() < low)
                    lowIndex = i;
            }
            str += (list.indexOf(copyOfLog.get(lowIndex)) + 1) + "\t\t" + copyOfLog.get(lowIndex) + "\n";
            copyOfLog.remove(lowIndex);
        }
        return str;
    }
    
    public String toString()
    {
        String str = "";
        for (int i = 0; i < list.size(); i++)
        {
            str += "" + (i + 1) + "\t\t" + list.get(i) + "\n";
        }
        return str;
    }
}