;Bitmap loader for 1, 4, 8, or 24 bit BMPs, by Zip. If you use anything from this program, please
;give credit where credit is due. This program uses VESA modes 118h and 105h, so make sure your
;computer supports those. It doesn't support 8-bit RLE encrypted BMPs. Specify the BMP filename
;on the command line.

.MODEL MEDIUM
.386
.STACK 200h
.DATA

vga_ptr dd ?
cur_bank dw 0
win_gran dw ?
set_bank_func dd ?

filename db 128 dup(0)
handle dw ?
buffer db 3072 dup(0)
err_no_param db "Syntax:",13,10,9,"loadbmp5 <filename>",13,10,13,10,9,"<filename>",9,"- Bitmap filename. Must be uncompressed.$"
err_open db "Error: Unable to open file.$"
err_read db "Error reading file.$"
err_not_bmp db "Not a valid bitmap file.$"
err_not_24bit db "Not a 1, 4, 8 or 24 bit bitmap.$"
err_not_win_bmp db "Not a windows bitmap.$"
err_rle db "File must be an uncompressed bitmap.$"
err_too_big db "Picture too big. Must be no bigger than 1024x768 pixels.$"
picwidth dd ?
picheight dd ?
bpp dw ?
x dw ?
y dw ?
picsize dd ?
comp dd ?
svga_info db 256 dup(?)
mode_info db 256 dup(?)
mode dw ?

color db 3 dup(?)
padding dw ?

.CODE
.STARTUP

mov ah,62h
int 21h
mov es,bx
mov bx,80h
cmp byte ptr es:[bx],0
jg gave_param

mov ah,9
mov dx,OFFSET err_no_param
int 21h
mov ax,4C00h
int 21h

gave_param:
mov si,82h
mov ch,0
mov cl,byte ptr es:[bx]
sub cl,1
mov di,OFFSET filename
mov bx,es
push ds
mov ds,bx
pop es
cld
rep movsb
push es
pop ds
mov ax,3D00h
mov dx,OFFSET filename
int 21h
jnc opened_ok

mov ah,9
mov dx,OFFSET err_open
int 21h
mov ax,4C00h
int 21h

opened_ok:
mov handle,ax
mov bx,ax
mov ah,3Fh
mov cx,54
mov dx,OFFSET buffer
int 21h
jnc check_bmp

read_error:
mov ah,9
mov dx,OFFSET err_read
int 21h
call close
mov ax,4C00h
int 21h

check_bmp:
cmp ax,54
jnz read_error
mov bx,dx
cmp word ptr [bx],4D42h
jz is_bmp

not_bmp:
mov ah,9
mov dx,OFFSET err_not_bmp
int 21h
call close
mov ax,4C00h
int 21h

is_bmp:
mov eax,dword ptr buffer[18]
mov picwidth,eax
mov ebx,eax
and ebx,1
add picwidth,ebx
mov eax,dword ptr buffer[22]
mov picheight,eax
mov ax,word ptr buffer[28]
mov bpp,ax
jmp is_24bit

mov ah,9
mov dx,OFFSET err_not_24bit
int 21h
call close
mov ax,4C00h
int 21h

is_24bit:
cmp dword ptr buffer[14],12
jnz is_win_bmp

mov ah,9
mov dx,OFFSET err_not_win_bmp
int 21h
call close
mov ax,4C00h
int 21h

is_win_bmp:
cmp dword ptr buffer[30],0
jz not_rle

mov ah,9
mov dx,OFFSET err_rle
int 21h
call close
mov ax,4C00h
int 21h

not_rle:
mov cx,54
call seek
call get_svga_info
mov mode,118h
cmp bpp,24
jz is_24
mov mode,105h
is_24:
call get_mode_info
call set_svga_mode
cmp bpp,24
jz no_pal
cmp bpp,4
jz is_4
cmp bpp,1
jz is_1
mov cx,1024
call read
mov di,256
xor si,si
mov cl,2
mov ch,0
jmp set_pal

is_4:
mov cx,64
call read
mov di,16
xor si,si
mov cl,2
mov ch,0

is_1:
mov cx,8
call read
mov di,2
xor si,si
mov cl,2
mov ch,0

set_pal:
mov dx,3C8h
mov al,ch
out dx,al
mov dx,3C9h
mov ah,byte ptr buffer[si]
shr ah,cl
inc si
mov bl,byte ptr buffer[si]
inc si
mov bh,byte ptr buffer[si]
shr bh,cl
shr bl,cl
add si,2
mov al,bh
out dx,al
mov al,bl
out dx,al
mov al,ah
out dx,al
inc ch
dec di
jnz set_pal

no_pal:

cmp picwidth,1024
jg too_big
cmp picheight,768
jle small_enough

too_big:
mov ah,9
mov dx,OFFSET err_too_big
int 21h
call close
mov ax,4C00h
int 21h

small_enough:
cmp bpp,8
jz load_8bit
cmp bpp,4
jz load_4bit
cmp bpp,1
jz load_1bit
mov ecx,picwidth
and ecx,1
add ecx,ecx
mov ebx,picwidth
add ebx,ebx
add picwidth,ebx	;picwidth = picwidth * 3
sub picwidth,ecx
mov x,0
mov ax,word ptr picheight[0]
mov y,ax
cld
mov bx,0A000h
mov es,bx
push ds
mov bx,SEG buffer
mov ds,bx

draw:
dec y
mov cx,word ptr picwidth[0]
call read
mov si,OFFSET buffer
mov ebx,0
mov bx,y
shl ebx,12		;ebx = y * 4096

mov edx,ebx
shr edx,16		;dx = bank
mov vga_ptr,ebx
cmp dx,cur_bank
jz same_bank
mov cur_bank,dx
mov di,cx
mov cx,win_gran
shl dx,cl
mov bx,0
call set_bank_func
mov cx,di
same_bank:
mov ebx,vga_ptr

row:
mov di,bx
movsw
movsb
add ebx,3
sub cx,3
cmp cx,0
jg row

cmp y,0
jg draw

loaded:

pop ds
call close
mov ah,0
int 16h
mov ax,3
int 10h
mov ax,4C00h
int 21h

load_8bit:
mov ax,word ptr picwidth[0]
and ax,3
mov padding,ax
mov ax,word ptr picheight[0]
mov y,ax
cld
mov bx,0A000h
mov es,bx
push ds
mov bx,SEG buffer
mov ds,bx

draw8:
dec y
mov cx,word ptr picwidth[0]
add cx,padding
call read
mov cx,word ptr picwidth[0]
mov si,OFFSET buffer
mov ebx,0
mov bx,y
shl ebx,10		;ebx = y * 1024

mov edx,ebx
shr edx,16		;dx = bank
mov vga_ptr,ebx
cmp dx,cur_bank
jz same_bank8
mov cur_bank,dx
mov di,cx
mov cx,win_gran
shl dx,cl
mov bx,0
call set_bank_func
mov cx,di
same_bank8:
mov ebx,vga_ptr
mov di,bx
rep movsb

cmp y,0
jg draw8

jmp loaded

load_4bit:
shr picwidth,1
mov ax,word ptr picheight[0]
mov y,ax
cld
mov bx,0A000h
mov es,bx
push ds
mov bx,SEG buffer
mov ds,bx

draw4:
dec y
mov cx,word ptr picwidth[0]
call read
mov si,OFFSET buffer
mov ebx,0
mov bx,y
shl ebx,10		;ebx = y * 1024

mov edx,ebx
shr edx,16		;dx = bank
mov vga_ptr,ebx
cmp dx,cur_bank
jz same_bank4
mov cur_bank,dx
mov di,cx
mov cx,win_gran
shl dx,cl
mov bx,0
call set_bank_func
mov cx,di
same_bank4:
mov ebx,vga_ptr
mov di,bx

row4:
lodsb
mov ah,al
and ah,0Fh
and al,0F0h
shr al,4
stosw
dec cx
cmp cx,0
jg row4

cmp y,0
jg draw4

jmp loaded

load_1bit:
shr picwidth,3
mov ax,word ptr picheight[0]
mov y,ax
cld
mov bx,0A000h
mov es,bx
push ds
mov bx,SEG buffer
mov ds,bx

draw1:
dec y
mov cx,word ptr picwidth[0]
call read
mov si,OFFSET buffer
mov ebx,0
mov bx,y
shl ebx,10		;ebx = y * 1024

mov edx,ebx
shr edx,16		;dx = bank
mov vga_ptr,ebx
cmp dx,cur_bank
jz same_bank1
mov cur_bank,dx
mov di,cx
mov cx,win_gran
shl dx,cl
mov bx,0
call set_bank_func
mov cx,di
same_bank1:
mov ebx,vga_ptr
mov di,bx

row1:
lodsb
mov bl,al
mov al,bl
and al,10000000b
setnz al
stosb
mov al,bl
and al,1000000b
setnz al
stosb
mov al,bl
and al,100000b
setnz al
stosb
mov al,bl
and al,10000b
setnz al
stosb
mov al,bl
and al,1000b
setnz al
stosb
mov al,bl
and al,100b
setnz al
stosb
mov al,bl
and al,10b
setnz al
stosb
mov al,bl
and al,1
setnz al
stosb
dec cx
cmp cx,0
jg row1

cmp y,0
jg draw1

jmp loaded

close:
mov ah,3Eh
mov bx,handle
int 21h
ret

read:
mov ax,handle
push ds
mov bx,SEG buffer
mov ds,bx
mov bx,ax
mov ah,3Fh
mov dx,OFFSET buffer
int 21h
pop ds
ret

seek:
mov ax,4200h
mov bx,handle
mov dx,cx
xor cx,cx
int 21h
ret

get_svga_info:
	mov ax,4F00h
	mov bx,SEG svga_info
	mov es,bx
	mov di,OFFSET svga_info
	int 10h
	ret

get_mode_info:
	mov ax,4F01h
	mov cx,mode
	mov bx,SEG mode_info
	mov es,bx
	mov di,OFFSET mode_info
	int 10h
	mov edx,dword ptr es:[di+12]
	mov set_bank_func,edx
	mov dx,word ptr es:[di+04]
	mov win_gran,0
	cmp dx,64
	jz getmodeinfo_1
	mov win_gran,2
	getmodeinfo_1:
	ret

set_svga_mode:
	mov bx,mode
	mov ax,4F02h
	int 10h
	ret

END