{ ********************************
 //    Properties unit for      //
 //        Indicator 1.0          //
 // by Tatiana Konstantinova,1999 //
   ******************************* }
unit Indicat2;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, ExtCtrls, ExtDlgs, StdCtrls;

type
  TfmProperties = class(TForm)
    Bevel1: TBevel;
    SbClose: TSpeedButton;
    sbAbout: TSpeedButton;
    sbBackground: TSpeedButton;
    paBackground: TPanel;
    opd1: TOpenPictureDialog;
    bbBrowse: TBitBtn;
    ImShow: TImage;
    bbOk: TBitBtn;
    SbNext: TSpeedButton;
    paColor: TPanel;
    bbOk2: TBitBtn;
    bbColor: TBitBtn;
    ColorDialog: TColorDialog;
    paImColor: TPanel;
    sbBack: TSpeedButton;
    paTitle: TPanel;
    LbTitle: TLabel;
    procedure SbCloseClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDeactivate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure sbBackgroundClick(Sender: TObject);
    procedure bbBrowseClick(Sender: TObject);
    procedure bbOkClick(Sender: TObject);
    procedure sbAboutClick(Sender: TObject);
    procedure SbNextClick(Sender: TObject);
    procedure SbBackClick(Sender: TObject);
    procedure bbOk2Click(Sender: TObject);
    procedure bbColorClick(Sender: TObject);
    procedure sbBackgroundMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure sbAboutMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure SbCloseMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure paTitleMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  fmProperties: TfmProperties;
  FileDir:string;
implementation

uses Indicat, About;

{$R *.DFM}

procedure ButtonResize (var BackPanel:TPanel;Button:TBitBtn);
begin
Button.Width:=Trunc(BackPanel.Width/2.06);
Button.Height:=Trunc(BackPanel.Height/6.12);
end;

procedure FontColor(var Background,About,Close:TSpeedButton);
begin
Background.Font.Color:=clBlue;
About.Font.Color:=clRed;
Close.Font.Color:=clGreen;
end;

procedure SmallButtonFont (var SmallButton1,SmallButton2,SmallButton3,SmallButton4:TBitBtn;Font:integer);
begin
SmallButton1.Font.Size:=Font;
SmallButton2.Font.Size:=Font;
SmallButton3.Font.Size:=Font;
SmallButton4.Font.Size:=Font;
end;

procedure ButtonLabelFont (var BackgroundButton,AboutButton,CloseButton:TSpeedButton;Title:TLabel;Size:integer);
begin
BackgroundButton.Font.Size:=Size;
AboutButton.Font.Size:=Size;
CloseButton.Font.Size:=Size;
Title.Font.Size:=Size;
end;

procedure StayOnBottom(var Button1:TSpeedButton;Bevel1:TBevel);
begin
 Button1.Width:=Bevel1.Width;
 Button1.Top:=Bevel1.Height-Button1.Height;
end;

procedure Center(var CenterObject:TBitBtn;BackObject:TPanel);
{This procedure sets TBitBtn position to center}
begin
CenterObject.Left:=(BackObject.Width-CenterObject.Width) div 2;
end;


procedure TfmProperties.SbCloseClick(Sender: TObject);
begin
if (MessageDlg('Exit Indicator?',mtConfirmation,[mbYes,mbNo],0)=mrYes )then 
fmIndicator.Close;
end;

procedure TfmProperties.FormCreate(Sender: TObject);
var
ButtonHeight:real;
begin
FileDir:=FullFilePath;
{create form size that depends on the size of the desktop}
fmProperties.Width:=h div 4;
fmProperties.Height:=v div 3;
{Set buttons size}
sbClose.Width:=Width;
sbAbout.Width:=Width;
sbBackground.Width:=Width;
paTitle.Width:=Width;

ButtonHeight:=Height/3.9;

paBackground.Width:=Width;
paBackground.Height:=Height;
paColor.Width:=paBackground.Width;
paColor.Height:=paBackground.Height;

sbClose.Height:=Trunc(ButtonHeight);
sbAbout.Height:=Trunc(ButtonHeight);
sbBackground.Height:=Trunc(ButtonHeight);
paTitle.Height:=(Height-sbClose.Height-sbAbout.Height-sbBackground.Height);

 StayOnBottom(sbClose,Bevel1);
 sbAbout.Top:=SbClose.Top-sbAbout.Height;
 sbBackground.Top:=sbAbout.Top-sbBackground.Height;

ImShow.Width:=Trunc(paBackground.Width /1.37);
paImColor.Width:=ImShow.Width;
ImShow.Height:=Trunc(paBackground.Height/2.09);
paImColor.Height:=ImShow.Height;

 ButtonResize(paBackground,bbOk);
 ButtonResize(paBackground,bbBrowse);
 ButtonResize(paColor,bbOk2);
 ButtonResize(paColor,bbColor);

case h of
640: begin
ButtonLabelFont(sbBackground,sbAbout,sbClose,LbTitle,12);
SmallButtonFont(bbOk,bbBrowse,bbOk2,bbColor,8);
end;
800: begin
ButtonLabelFont(sbBackground,sbAbout,sbClose,LbTitle,14);
SmallButtonFont(bbOk,bbBrowse,bbOk2,bbColor,10);
end;
1024:begin
ButtonLabelFont(sbBackground,sbAbout,sbClose,LbTitle,18);
SmallButtonFont(bbOk,bbBrowse,bbOk2,bbColor,12);
end;
1152:begin
ButtonLabelFont(sbBackground,sbAbout,sbClose,LbTitle,24);
SmallButtonFont(bbOk,bbBrowse,bbOk2,bbColor,14);
end;
1280..Maxint: begin
ButtonLabelFont(sbBackground,sbAbout,sbClose,LbTitle,24);
SmallButtonFont(bbOk,bbBrowse,bbOk2,bbColor,18);
end;

end;

{set position to center}
LbTitle.Left:=(Bevel1.Width-LbTitle.Width) div 2;

 Center(bbOk,paBackground);
 Center(bbOk2,paColor);
 Center(bbBrowse,paBackground);
 Center(bbColor,paColor);
 bbBrowse.Top:=(paBackground.Height-bbBrowse.Height-8);
 bbColor.Top:=(paColor.Height-bbColor.Height-8);


ImShow.Left:=(paBackground.Width-ImShow.Width)  div 2;
ImShow.Top:=(paBackground.Height-ImShow.Height) div 2;
paImColor.Left:=(paColor.Width-paImColor.Width) div 2;
paImColor.Top:=(paColor.Height-paImColor.Height)div 2;
sbNext.Left:=(paBackground.Width-sbNext.Width) div 2;
sbNext.Top:=(paBackground.Height-sbNext.Height) div 2;
sbBack.Left:=(paImColor.Width-sbBack.Width) div 2;
sbBack.Top:=(paImColor.Height-sbBack.Height) div 2;
end;

procedure TfmProperties.FormDeactivate(Sender: TObject);
begin
fmProperties.hide;
end;

procedure TfmProperties.FormActivate(Sender: TObject);
begin
h:=windows.GetSystemMetrics(0);
v:=windows.GetSystemMetrics(1);
fmProperties.Left:=(h-fmProperties.Width) div 2;
fmProperties.Top:=(v-fmProperties.Height) div 2;
paBackground.Hide;
paColor.Hide;
fmAboutIndicator.Hide;
paImColor.Color:=fmIndicator.Color;
end;

procedure TfmProperties.sbBackgroundClick(Sender: TObject);
begin
paBackground.show;
ImShow.Picture:=fmIndicator.ImBackGround.Picture;
end;

procedure TfmProperties.bbBrowseClick(Sender: TObject);
var
Old,New:TFileStream;
Name:string;
begin
try begin
Str:='background.bmp';
FullName:=FullFileName(FileDir,Str);
Opd1.Execute;
{Save new background to the file}
Name:=AnsiUpperCase(opd1.filename);
fmIndicator.ImBackGround.Picture.LoadFromFile(opd1.FileName);
Old:=TFileStream.Create(Name,fmOpenRead);
if (ExtractFileExt(Name))='.BMP' then
New:=TFileStream.Create(FullName,fmOpenWrite or fmCreate);
New.CopyFrom(Old,Old.Size);
New.Free;
Old.Free;
ImShow.Picture:=fmIndicator.ImBackGround.Picture;
end;
except
end;
end;

procedure TfmProperties.bbOkClick(Sender: TObject);
begin
PaBackground.Hide;
end;

procedure TfmProperties.sbAboutClick(Sender: TObject);
begin
fmAboutIndicator.show;
end;

procedure TfmProperties.SbNextClick(Sender: TObject);
begin
paColor.Show;
end;

procedure TfmProperties.SbBackClick(Sender: TObject);
begin
PaColor.Hide;
end;

procedure TfmProperties.bbOk2Click(Sender: TObject);
begin
PaColor.Hide;
paBackground.Hide;
end;

procedure TfmProperties.bbColorClick(Sender: TObject);
var
ColFile:file of TColor;
Color:TColor;
begin
ColorDialog.Execute;
fmIndicator.Color:=ColorDialog.Color;
fmIndicator.gaProgress.BackColor:=ColorDialog.Color;
paImColor.Color:=ColorDialog.Color;
{Save Color to file}
 Str:='color.ind';
 FullName:=FullFileName(FileDir,Str);
Color:=ColorDialog.Color;
if (not (FileExists(FullName))) then Color:=clBtnFace;
AssignFile(ColFile,FullName);
Rewrite(ColFile);
Write(ColFile,Color);
CloseFile(ColFile);

end;

procedure TfmProperties.sbBackgroundMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
FontColor(sbBackground,sbAbout,sbClose);
sbBackground.Font.Color:=clNavy;
end;

procedure TfmProperties.sbAboutMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
FontColor(sbBackground,sbAbout,sbClose);
sbAbout.Font.Color:=clMaroon;
end;

procedure TfmProperties.SbCloseMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
FontColor(sbBackground,sbAbout,sbClose);
sbClose.Font.Color:=clLime;
end;

procedure TfmProperties.paTitleMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
FontColor(sbBackground,sbAbout,sbClose);
end;

end.
