{ ****************************}
//       Indicator 1.0      //
// by Tatiana Konstantinova //
//           1999           //
{*****************************}
unit Indicat;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, jpeg, Gauges, Menus;

type
  TChrFile=file of char;
  TfmIndicator = class(TForm)
    Timer1: TTimer;
    ImBackGround: TImage;
    LbDelta: TLabel;
    gaProgress: TGauge;
    Timer2: TTimer;
    Timer3: TTimer;
    Timer4: TTimer;
    PopupMenu1: TPopupMenu;
    Purple1: TMenuItem;
    Fuchsia1: TMenuItem;
    Navy1: TMenuItem;
    Blue1: TMenuItem;
    Teal1: TMenuItem;
    Aqua1: TMenuItem;
    Olive1: TMenuItem;
    Yellow1: TMenuItem;
    Maroon1: TMenuItem;
    Green1: TMenuItem;
    Lime1: TMenuItem;
    Red1: TMenuItem;
    Gray1: TMenuItem;
    Black1: TMenuItem;
    White1: TMenuItem;
    PopupMenu2: TPopupMenu;
    Showlast1: TMenuItem;
    Showtotaltime1: TMenuItem;
    Setcountertozero1: TMenuItem;
    Analyzesize1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure LbDeltaMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure LbDeltaMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ImBackGroundMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ImBackGroundMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ImBackGroundDblClick(Sender: TObject);
    procedure LbDeltaDblClick(Sender: TObject);
    procedure Timer2Timer(Sender: TObject);
    procedure Timer3Timer(Sender: TObject);
    procedure Timer4Timer(Sender: TObject);
    procedure Purple1Click(Sender: TObject);
    procedure Fuchsia1Click(Sender: TObject);
    procedure Navy1Click(Sender: TObject);
    procedure Blue1Click(Sender: TObject);
    procedure Teal1Click(Sender: TObject);
    procedure Aqua1Click(Sender: TObject);
    procedure Green1Click(Sender: TObject);
    procedure Lime1Click(Sender: TObject);
    procedure Olive1Click(Sender: TObject);
    procedure Yellow1Click(Sender: TObject);
    procedure Maroon1Click(Sender: TObject);
    procedure Red1Click(Sender: TObject);
    procedure Gray1Click(Sender: TObject);
    procedure Black1Click(Sender: TObject);
    procedure White1Click(Sender: TObject);
    procedure Showlast1Click(Sender: TObject);
    procedure Showtotaltime1Click(Sender: TObject);
    procedure Setcountertozero1Click(Sender: TObject);
    procedure Analyzesize1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
 x1,y1:integer;
 DeltaTime:String;
 StartTime,NowTime :TTime;
  public
    { Public declarations }

  end;

  procedure StrToFile (var F:TChrFile;FileString:string);
  function FileToStr (var F:TChrFile):string;
  function TimeStrAdd (var Time1:TTime;TimeString:string):string;
  function FullFilePath:string;
  function FullFileName(var  FileDirPath,Filename:string):string;

  var
  fmIndicator: TfmIndicator;
  Str,FullName,FileDir:string;
  Col:TColor;
  h,v:integer;
  implementation

uses Indicat2;

{$R *.DFM}


procedure StrToFile (var F:TChrFile;FileString:string);
var
Sign:char;
StrLength,i :integer;
 begin
StrLength:=Length(FileString);
for i:=1 to StrLength do begin
Sign:=FileString[i];
Write(F,Sign);
end;
 end;

function FileToStr (var F:TChrFile):string;
var
Sign:char;
FileStr:string;
 begin
 FileStr:='';
 repeat
Read(F,Sign);
FileStr:=Concat(FileStr,Sign);
 until EOF(F);
   Result:=FileStr;
 end;


function TimeStrAdd (var Time1:TTime;TimeString:string):string;
{This function returns the total sum value of many
operands in TTime format when this value
is more then TTime format can save in
(for exmpl:'105:25:17')}

var
SubStr,StrTime1,StrSum,StrOprnd1,StrOprnd2,Time_Tmp1,Time_Tmp2:string;
l,i,j,IntSum,HourSum,MinuteSum,SecondSum:Integer;

procedure Mirror (var MirrorStr:string);
var
StrTmp:string;
k,StrLength:integer;

begin

StrLength:=Length(MirrorStr);
StrTmp:='';
for k:=StrLength downto 1 do begin
StrTmp:=Concat(StrTmp,MirrorStr[k]);
end ;
MirrorStr:=StrTmp;
end; {Mirror function}

begin
HourSum:=0;
MinuteSum:=0;
SecondSum:=0;
StrSum:='';
StrTime1:=TimeToStr(Time1);
i:=8;
j:=Length(TimeString);
SubStr:='0';

{delete last zeros in TimeString}
 l:=Length(TimeString);
  while TimeString[l]<>':' do begin
  l:=l-1;
  end;
 if (TimeString[l+3]='0')then
 Delete(TimeString,l+3,2);

while i>0 do begin

StrOprnd2:='';
Time_Tmp1:=TimeToStr(Time1);
Time_Tmp2:=TimeString;

{if time counter is null}
if Time_Tmp1[2]=':' then Insert(SubStr,Time_Tmp1,1);
if Time_Tmp1[5]=':' then Insert(SubStr,Time_Tmp1,4);

   StrOprnd1:=Concat(Time_Tmp1[i-1],Time_Tmp1[i]);

  while (Time_Tmp2[j]<>':')and(j>0) do begin
  StrOprnd2:=Concat(StrOprnd2,Time_Tmp2[j]);
  j:=j-1;
  end;
  Mirror(StrOprnd2);
  j:=j-1;

 IntSum:=StrToInt(StrOprnd1)+StrToInt(StrOprnd2);

 if (IntSum>59) and(i<>2) then begin

 IntSum:=IntSum-60;
case i of
8:MinuteSum:=MinuteSum+1;
5: HourSum:=HourSum+1;
end;
 end;
if(MinuteSum=60) then begin
MinuteSum:=0;
HourSum:=HourSum+1;
end;

  case i of
8:SecondSum:=IntSum+SecondSum;
5:MinuteSum:=IntSum+MinuteSum;
2:HourSum:=IntSum+HourSum;
 end;
i:=i-3;
end;

StrSum:=Concat(IntToStr(HourSum),':',IntToStr(MinuteSum),':',IntToStr(SecondSum));
Result:=StrSum;

end;

function FullFilePath:string;
var
Path:string;
begin
 Path:=ExpandFileName('indicator.exe');
 Result:=ExtractFilepath(Path);
end;

function FullFileName(var  FileDirPath,Filename:string):string;
begin
 Result:=FileDirPath+FileName;
 end;

procedure FontToFile (var Color:TColor);
var
Str,FullName:string;
FontFile: file of TColor;
begin

Str:='font.ind';
FullName:=FullFileName(FileDir,Str);
if (not FileExists(FullName))then Color:=clPurple;
AssignFile(FontFile,FullName);
Rewrite(FontFile);
Write(FontFile,Color);
CloseFile(FontFile);
end;

procedure TfmIndicator.FormCreate(Sender: TObject);
var
Counter:integer;
StrLeft,StrTop :string;
Separator,ReadSign:Char;
ReadFont,ReadColor:TColor;
PosFile:TChrFile;
FontColFile,ColFile:file of TColor;
begin
try begin
FileDir:=FullFilePath;
{creating form size that depends on the size of the desktop}
h:=windows.GetSystemMetrics(0);
v:=windows.GetSystemMetrics(1);
fmIndicator.Width:=h div 6;
fmIndicator.Height:=v div 15;
GaProgress.Left:=0;
GaProgress.Width:=fmIndicator.Width;
LbDelta.Height:=fmIndicator.Height div 2;
GaProgress.Top:=LbDelta.Height;
case h of
640: begin LbDelta.Font.Size:=10; gaProgress.Height:=17; end;
800: begin LbDelta.Font.Size:=12; gaProgress.Height:=21; end;
1024:begin LbDelta.Font.Size:=14; gaProgress.Height:=27; end;
1152:begin LbDelta.Font.Size:=18; gaProgress.Height:=31; end;
1280..Maxint:begin LbDelta.Font.Size:=24; gaProgress.Height:=36; end;
end;
StartTime:=Now;
LbDelta.Left:=(ImBackGround.Width-LbDelta.Width) div 2;
Str:='background.bmp';
FullName:=FullFileName(FileDir,Str);
if (FileExists(FullName))then
ImBackGround.Picture.LoadFromFile('background.bmp');

{Load form position}
Str:='position.ind';
FullName:=FullFileName(FileDir,Str);
 Counter:=0;
 StrLeft:='';StrTop:='';
if (FileExists(FullName))then begin
AssignFile(PosFile,FullName);
Reset(PosFile);

 while (ReadSign<>'|')and(not EOF(PosFile)) do begin
Read(PosFile,ReadSign);
StrLeft:=Concat(StrLeft,ReadSign);
Counter:=Counter+1;
 end;
Delete(StrLeft,Counter,1);
 while (not EOF(PosFile)) do begin
Read(PosFile,ReadSign);
StrTop:=Concat(StrTop,ReadSign);
 end;
CloseFile(PosFile);
 end
else  begin
Separator:='|';
AssignFile(PosFile,FullName);
Rewrite(PosFile);
StrToFile(PosFile,IntToStr(Left));
Write(PosFile,Separator);
StrToFile(PosFile,IntToStr(Top));
CloseFile(PosFile);
end;

 Left:=StrToInt(StrLeft);
 Top:=StrToInt(StrTop);

 {Load form color}
 Str:='color.ind';
  FullName:=FullFileName(FileDir,Str);
 if (FileExists(FullName))then begin
 AssignFile(ColFile,FullName);
 Reset(ColFile);
 Read(ColFile,ReadColor);
 CloseFile(ColFile);
 end
 else begin
Color:=clPurple;
AssignFile(ColFile,FullName);
Rewrite(ColFile);
Write(ColFile,Color);
CloseFile(ColFile);
 end;
Color:=ReadColor;
gaProgress.BackColor:=ReadColor;

{Load form font color}
 Str:='font.ind';
 FullName:=FullFileName(FileDir,Str);
if (FileExists(FullName))then begin
 AssignFile(FontColFile,FullName);
 Reset(FontColFile);
 Read(FontColFile,ReadFont);
 CloseFile(FontColFile);
 end
 else begin
Col:=clPurple;
FontToFile(Col);
LbDelta.Font.Color:=Col;
end;
LbDelta.Font.Color:=ReadFont;
end;
except
MessageDlg('File not found and will be created.',mtInformation,[mbOk],0);
end;
end;

procedure TfmIndicator.Timer1Timer(Sender: TObject);
begin
NowTime:=Now;
DeltaTime:=TimeToStr(Abs(StartTime-NowTime));
LbDelta.Caption:=DeltaTime;
end;

procedure TfmIndicator.LbDeltaMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
X1:=x;
y1:=y;
end;

procedure TfmIndicator.LbDeltaMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
  var
  modx,mody :integer;
  PosFile:TChrFile;
  Separator:Char;
  begin
modx:=x-x1;
mody:=y-y1;
 {set new form coordinats}
 Left:=Left+modx;
 Top:=Top+mody;
 {Save position after moving}

 Str:='position.ind';
 FullName:=FullFileName(FileDir,Str);
 Separator:='|';

AssignFile(PosFile,FullName);
Rewrite(PosFile);
StrToFile(PosFile,IntToStr(Left));
Write(PosFile,Separator);
StrToFile(PosFile,IntToStr(Top));
CloseFile(PosFile);
end;

procedure TfmIndicator.ImBackGroundMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
x1:=x;
y1:=y;
end;

procedure TfmIndicator.ImBackGroundMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
  var
  modx,mody :Integer;
  PosFile:TChrFile;
  Separator:Char;
  begin
modx:=x-x1;
mody:=y-y1;

{set new form coordinats}
 Left:=Left+modx;
 Top:=Top+mody;

{Save position after moving}

 Str:='position.ind';
 FullName:=FullFileName(FileDir,Str);
 Separator:='|';

AssignFile(PosFile,FullName);
Rewrite(PosFile);
StrToFile(PosFile,IntToStr(Left));
Write(PosFile,Separator);
StrToFile(PosFile,IntToStr(Top));
CloseFile(PosFile);

end;

procedure TfmIndicator.ImBackGroundDblClick(Sender: TObject);
begin
fmProperties.Show;
end;

procedure TfmIndicator.LbDeltaDblClick(Sender: TObject);
begin
fmProperties.Show;
end;

procedure TfmIndicator.Timer2Timer(Sender: TObject);
var
Progress :Integer;
begin
GaProgress.Progress:=GaProgress.Progress+1;
case GaProgress.Progress of           {GaProgress colors,}
0..9  :GaProgress.ForeColor:=clAqua ; {depends on DeltaTime}
10..19:GaProgress.ForeColor:=clBlue;
20..29:GaProgress.ForeColor:=clNavy;
30..39:GaProgress.ForeColor:=clGreen;
40..49:GaProgress.ForeColor:=clLime;
50..59:GaProgress.ForeColor:=clYellow;
60..69:GaProgress.ForeColor:=clFuchsia;
70..79:GaProgress.ForeColor:=clPurple;
80..89:GaProgress.ForeColor:=clMaroon;
90..Maxint:GaProgress.ForeColor:=clRed;
end;
Progress :=GaProgress.Progress;
if (Progress+1 >100)then begin
Timer2.Enabled:=False;  {Begin lightnings}
Timer3.Enabled:=True;
end;

end;

procedure TfmIndicator.Timer3Timer(Sender: TObject);
begin
{Progress twinkling when it reach 100%
(white mode)}

GaProgress.ForeColor:=clWhite;
Timer3.Enabled:=False;
Timer4.Enabled:=True;
end;

procedure TfmIndicator.Timer4Timer(Sender: TObject);
begin
{Progess twinkling when it reach 100%
(red mode)}
GaProgress.ForeColor:=clRed;
Timer4.Enabled:=False;
Timer3.Enabled:=True;
end;
{Set font colors from the popup menu}
procedure TfmIndicator.Purple1Click(Sender: TObject);
begin
Col:=clPurple;
FontToFile(Col);
LbDelta.Font.Color:=Col;
end;

procedure TfmIndicator.Fuchsia1Click(Sender: TObject);
begin
Col:=clFuchsia;
FontToFile(Col);
LbDelta.Font.Color:=Col;
end;

procedure TfmIndicator.Navy1Click(Sender: TObject);
begin
Col:=clNavy;
FontToFile(Col);
LbDelta.Font.Color:=Col;
end;

procedure TfmIndicator.Blue1Click(Sender: TObject);
begin
Col:=clBlue;
FontToFile(Col);
LbDelta.Font.Color:=Col;
end;

procedure TfmIndicator.Teal1Click(Sender: TObject);
begin
Col:=clTeal;
FontToFile(Col);
LbDelta.Font.Color:=Col;
end;

procedure TfmIndicator.Aqua1Click(Sender: TObject);
begin
Col:=clAqua;
FontToFile(Col);
LbDelta.Font.Color:=Col;
end;

procedure TfmIndicator.Green1Click(Sender: TObject);
begin
Col:=clGreen;
FontToFile(Col);
LbDelta.Font.Color:=Col;
end;

procedure TfmIndicator.Lime1Click(Sender: TObject);
begin
Col:=clLime;
FontToFile(Col);
LbDelta.Font.Color:=Col;
end;

procedure TfmIndicator.Olive1Click(Sender: TObject);
begin
Col:=clOlive;
FontToFile(Col);
LbDelta.Font.Color:=Col;
end;

procedure TfmIndicator.Yellow1Click(Sender: TObject);
begin
Col:=clYellow;
FontToFile(Col);
LbDelta.Font.Color:=Col;
end;

procedure TfmIndicator.Maroon1Click(Sender: TObject);
begin
Col:=clMaroon;
FontToFile(Col);
LbDelta.Font.Color:=Col;
end;

procedure TfmIndicator.Red1Click(Sender: TObject);
begin
Col:=clRed;
FontToFile(Col);
LbDelta.Font.Color:=Col;
end;

procedure TfmIndicator.Gray1Click(Sender: TObject);
begin
Col:=clGray;
FontToFile(Col);
LbDelta.Font.Color:=Col;
end;

procedure TfmIndicator.Black1Click(Sender: TObject);
begin
Col:=clBlack;
FontToFile(Col);
LbDelta.Font.Color:=Col;
end;

procedure TfmIndicator.White1Click(Sender: TObject);
begin
Col:=clWhite;
FontToFile(Col);
LbDelta.Font.Color:=Col;
end;

procedure TfmIndicator.Showlast1Click(Sender: TObject);
{This procedure returns the "last time"}
var
NowDelta,LastTime:TTime;
LastTimeFile:file of TTime;
begin
{Load "last time" from file}
Str:='last.ind';
FullName:=FullFileName(FileDir,Str);
if (FileExists(FullName))then begin
AssignFile(LastTimeFile,FullName);
Reset(LastTimeFile);
Read(LastTimeFile,LastTime);
CloseFile(LastTimeFile);
end
else begin
NowDelta:=StrToTime(fmIndicator.LbDelta.Caption);
AssignFile(LastTimeFile,FullName);
Rewrite(LastTimeFile);
Write(LastTimeFile,NowDelta);
CloseFile(LastTimeFile);
end;
MessageDlg('Last time :'+TimeToStr(LastTime),mtInformation,[mbOk],0);
end;

procedure TfmIndicator.Showtotaltime1Click(Sender: TObject);
{This procedure returns the total time
for all the period of using}
var
St,Total:string;
TotalTimeFile:TChrFile;
l:integer;
DeltaTime:TTime;
begin
try begin
{Load last total time from file}
Str:='total.ind';
FullName:=FullFileName(FileDir,Str);
if (FileExists(FullName))then begin
AssignFile(TotalTimeFile,FullName);
Reset(TotalTimeFile);
Total:=FileToStr(TotalTimeFile);
CloseFile(TotalTimeFile);
end
else begin
AssignFile(TotalTimeFile,FullName);
Rewrite(TotalTimeFile);
St:='00:00:00';
StrToFile(TotalTimeFile,St);

end;
{delete last zero in Total}
 l:=Length(Total);
while Total[l]<>':' do l:=l-1;

 if (Total[l+3]='0')then
 Delete(Total,l+3,2);
{Calculate new total including current time}
DeltaTime:=StrToTime(LbDelta.Caption);
Total:=TimeStrAdd(DeltaTime,Total);
 MessageDlg('Total time:'+Total,mtInformation,[mbOk],0);
 end;
 except
 MessageDlg('File not found and will be created.',mtInformation,[mbOk],0);
 end;
end;

procedure TfmIndicator.Setcountertozero1Click(Sender: TObject);
var
TotalTimeFile:TChrFile;
St:string;
begin
if( MessageDlg('Set total time counter to zero?',mtConfirmation,[mbYes,mbNo],0)=mrYes) then begin
Str:='total.ind';
FullName:=FullFileName(FileDir,Str);
AssignFile(TotalTimeFile,FullName);
Rewrite(TotalTimeFile);
St:='00:00:00';
StrToFile(TotalTimeFile,St);
MessageBeep(0);
end;
end;

procedure TfmIndicator.Analyzesize1Click(Sender: TObject);
{This procedure analizes form
size according to current Windows settings}
begin
{change metrics if Windows settings has been changed}
h:=windows.GetSystemMetrics(0);
v:=windows.GetSystemMetrics(1);
fmProperties.OnCreate(fmProperties);
fmIndicator.Width:=h div 6;
fmIndicator.Height:=v div 15;
GaProgress.Left:=0;
GaProgress.Width:=fmIndicator.Width;
LbDelta.Height:=fmIndicator.Height div 2;
GaProgress.Top:=LbDelta.Height;
case h of
640: begin LbDelta.Font.Size:=10; gaProgress.Height:=17; end;
800: begin LbDelta.Font.Size:=12; gaProgress.Height:=21; end;
1024:begin LbDelta.Font.Size:=14; gaProgress.Height:=27; end;
1152:begin LbDelta.Font.Size:=18; gaProgress.Height:=31; end;
1280..Maxint:begin LbDelta.Font.Size:=24; gaProgress.Height:=36; end;
end;
LbDelta.Left:=(ImBackGround.Width-LbDelta.Width) div 2;
end;

procedure TfmIndicator.FormClose(Sender: TObject;
  var Action: TCloseAction);
var
LastTotal,Total,St:string;
LastTimeFile: file of TTime;
TotalTimeFile:TChrFile;
NowDelta:TTime;
begin
{Save value for "last time"}
NowDelta:=StrToTime(fmIndicator.LbDelta.Caption);
Str:='last.ind';
FullName:=FullFileName(FileDir,Str);
AssignFile(LastTimeFile,FullName);
Rewrite(LastTimeFile);
Write(LastTimeFile,NowDelta);
CloseFile(LastTimeFile);

{Calculate total time value}
Str:='total.ind';
FullName:=FullFileName(FileDir,Str);
if (FileExists(FullName))then begin
AssignFile(TotalTimeFile,FullName);
Reset(TotalTimeFile);
Total:=FileToStr(TotalTimeFile);
CloseFile(TotalTimeFile);

LastTotal:= TimeStrAdd(NowDelta,Total);
AssignFile(TotalTimeFile,FullName);
Rewrite(TotalTimeFile);
StrToFile(TotalTimeFile,LastTotal);
CloseFile(TotalTimeFile);
end
else begin
AssignFile(TotalTimeFile,FullName);
Rewrite(TotalTimeFile);
St:='00:00:00';
StrToFile(TotalTimeFile,St);
end;
end;

end.
