// MAME includes
#include "driver.h"

#include <kos.h>

extern int key_port,key_unit;
kbd_state_t *state;


cont_cond_t 	ccond[4];

uint8 maple_joystick_addr[4] = {0, 0, 0, 0};

#define KBD_KEY_LSHIFT 		0x70
#define KBD_KEY_RSHIFT 		0x71
#define KBD_KEY_LCONTROL 	0x72
#define KBD_KEY_RCONTROL 	0x73
#define KBD_KEY_ALT 		0x74
#define KBD_KEY_ALTGR 		0x75

static struct KeyboardInfo keylist[] =
{
	{ "A",			KBD_KEY_A,				KEYCODE_A },
	{ "B",			KBD_KEY_B,				KEYCODE_B },
	{ "C",			KBD_KEY_C,				KEYCODE_C },
	{ "D",			KBD_KEY_D,				KEYCODE_D },
	{ "E",			KBD_KEY_E,				KEYCODE_E },
	{ "F",			KBD_KEY_F,				KEYCODE_F },
	{ "G",			KBD_KEY_G,				KEYCODE_G },
	{ "H",			KBD_KEY_H,				KEYCODE_H },
	{ "I",			KBD_KEY_I,				KEYCODE_I },
	{ "J",			KBD_KEY_J,				KEYCODE_J },
	{ "K",			KBD_KEY_K,				KEYCODE_K },
	{ "L",			KBD_KEY_L,				KEYCODE_L },
	{ "M",			KBD_KEY_M,				KEYCODE_M },
	{ "N",			KBD_KEY_N,				KEYCODE_N },
	{ "O",			KBD_KEY_O,				KEYCODE_O },
	{ "P",			KBD_KEY_P,				KEYCODE_P },
	{ "Q",			KBD_KEY_Q,				KEYCODE_Q },
	{ "R",			KBD_KEY_R,				KEYCODE_R },
	{ "S",			KBD_KEY_S,				KEYCODE_S },
	{ "T",			KBD_KEY_T,				KEYCODE_T },
	{ "U",			KBD_KEY_U,				KEYCODE_U },
	{ "V",			KBD_KEY_V,				KEYCODE_V },
	{ "W",			KBD_KEY_W,				KEYCODE_W },
	{ "X",			KBD_KEY_X,				KEYCODE_X },
	{ "Y",			KBD_KEY_Y,				KEYCODE_Y },
	{ "Z",			KBD_KEY_Z,				KEYCODE_Z },
	{ "0",			KBD_KEY_0,				KEYCODE_0 },
	{ "1",			KBD_KEY_1,				KEYCODE_1 },
	{ "2",			KBD_KEY_2,				KEYCODE_2 },
	{ "3",			KBD_KEY_3,				KEYCODE_3 },
	{ "4",			KBD_KEY_4,				KEYCODE_4 },
	{ "5",			KBD_KEY_5,				KEYCODE_5 },
	{ "6",			KBD_KEY_6,				KEYCODE_6 },
	{ "7",			KBD_KEY_7,				KEYCODE_7 },
	{ "8",			KBD_KEY_8,				KEYCODE_8 },
	{ "9",			KBD_KEY_9,				KEYCODE_9 },
	{ "0 PAD",		KBD_KEY_PAD_0,			KEYCODE_0_PAD },
	{ "1 PAD",		KBD_KEY_PAD_1,			KEYCODE_1_PAD },
	{ "2 PAD",		KBD_KEY_PAD_2,			KEYCODE_2_PAD },
	{ "3 PAD",		KBD_KEY_PAD_3,			KEYCODE_3_PAD },
	{ "4 PAD",		KBD_KEY_PAD_4,			KEYCODE_4_PAD },
	{ "5 PAD",		KBD_KEY_PAD_5,			KEYCODE_5_PAD },
	{ "6 PAD",		KBD_KEY_PAD_6,			KEYCODE_6_PAD },
	{ "7 PAD",		KBD_KEY_PAD_7,			KEYCODE_7_PAD },
	{ "8 PAD",		KBD_KEY_PAD_8,			KEYCODE_8_PAD },
	{ "9 PAD",		KBD_KEY_PAD_9,			KEYCODE_9_PAD },
	{ "F1",			KBD_KEY_F1,				KEYCODE_F1 },
	{ "F2",			KBD_KEY_F2,				KEYCODE_F2 },
	{ "F3",			KBD_KEY_F3,				KEYCODE_F3 },
	{ "F4",			KBD_KEY_F4,				KEYCODE_F4 },
	{ "F5",			KBD_KEY_F5,				KEYCODE_F5 },
	{ "F6",			KBD_KEY_F6,				KEYCODE_F6 },
	{ "F7",			KBD_KEY_F7,				KEYCODE_F7 },
	{ "F8",			KBD_KEY_F8,				KEYCODE_F8 },
	{ "F9",			KBD_KEY_F9,				KEYCODE_F9 },
	{ "F10",		KBD_KEY_F10,			KEYCODE_F10 },
	{ "F11",		KBD_KEY_F11,			KEYCODE_F11 },
	{ "F12",		KBD_KEY_F12,			KEYCODE_F12 },
	{ "ESC",		KBD_KEY_ESCAPE,			KEYCODE_ESC },
	{ "~",			KBD_KEY_TILDE,			KEYCODE_TILDE },
	{ "-",          KBD_KEY_MINUS,          KEYCODE_MINUS },
//	{ "=",          KBD_KEY_EQUALS,         KEYCODE_EQUALS },
	{ "BKSPACE",	KBD_KEY_BACKSPACE,		KEYCODE_BACKSPACE },
	{ "TAB",		KBD_KEY_TAB,			KEYCODE_TAB },
	{ "[",          KBD_KEY_LBRACKET,      KEYCODE_OPENBRACE },
	{ "]",          KBD_KEY_RBRACKET,     KEYCODE_CLOSEBRACE },
	{ "ENTER",		KBD_KEY_ENTER,			KEYCODE_ENTER },
	{ ";",          KBD_KEY_SEMICOLON,          KEYCODE_COLON },
	{ ":",          KBD_KEY_QUOTE,          KEYCODE_QUOTE },
	{ "\\",         KBD_KEY_BACKSLASH,      KEYCODE_BACKSLASH },
//	{ "<",          KBD_KEY_BACKSLASH2,     KEYCODE_BACKSLASH2 },
	{ ",",          KBD_KEY_COMMA,          KEYCODE_COMMA },
	{ ".",          KBD_KEY_PERIOD,           KEYCODE_STOP },
	{ "/",          KBD_KEY_SLASH,          KEYCODE_SLASH },
	{ "SPACE",		KBD_KEY_SPACE,			KEYCODE_SPACE },
	{ "INS",		KBD_KEY_INSERT,			KEYCODE_INSERT },
	{ "DEL",		KBD_KEY_DEL,			KEYCODE_DEL },
	{ "HOME",		KBD_KEY_HOME,			KEYCODE_HOME },
	{ "END",		KBD_KEY_END,			KEYCODE_END },
	{ "PGUP",		KBD_KEY_PGUP,			KEYCODE_PGUP },
	{ "PGDN",		KBD_KEY_PGDOWN,			KEYCODE_PGDN },
	{ "LEFT",		KBD_KEY_LEFT,			KEYCODE_LEFT },
	{ "RIGHT",		KBD_KEY_RIGHT,			KEYCODE_RIGHT },
	{ "UP",			KBD_KEY_UP,				KEYCODE_UP },
	{ "DOWN",		KBD_KEY_DOWN,			KEYCODE_DOWN },
	{ "/ PAD",      KBD_KEY_PAD_DIVIDE,      KEYCODE_SLASH_PAD },
	{ "* PAD",      KBD_KEY_PAD_MULTIPLY,       KEYCODE_ASTERISK },
	{ "- PAD",      KBD_KEY_PAD_MINUS,      KEYCODE_MINUS_PAD },
	{ "+ PAD",      KBD_KEY_PAD_PLUS,       KEYCODE_PLUS_PAD },
	{ ". PAD",      KBD_KEY_PAD_PERIOD,        KEYCODE_DEL_PAD },
	{ "ENTER PAD",  KBD_KEY_PAD_ENTER,      KEYCODE_ENTER_PAD },
	{ "PRTSCR",     KBD_KEY_PRINT,         KEYCODE_PRTSCR },
	{ "PAUSE",      KBD_KEY_PAUSE,          KEYCODE_PAUSE },
	{ "LSHIFT",		KBD_KEY_LSHIFT,			KEYCODE_LSHIFT },
	{ "RSHIFT",		KBD_KEY_RSHIFT,			KEYCODE_RSHIFT },
	{ "LCTRL",		KBD_KEY_LCONTROL,		KEYCODE_LCONTROL },
	{ "RCTRL",		KBD_KEY_RCONTROL,		KEYCODE_RCONTROL },
	{ "ALT",		KBD_KEY_ALT,			KEYCODE_LALT },
	{ "ALTGR",		KBD_KEY_ALTGR,			KEYCODE_RALT },
//	{ "LWIN",		KBD_KEY_LWIN,			KEYCODE_OTHER },
//	{ "RWIN",		KBD_KEY_RWIN,			KEYCODE_OTHER },
//	{ "MENU",		KBD_KEY_MENU,			KEYCODE_OTHER },
	{ "SCRLOCK",    KBD_KEY_SCRLOCK,        KEYCODE_SCRLOCK },
	{ "NUMLOCK",    KBD_KEY_PAD_NUMLOCK,        KEYCODE_NUMLOCK },
	{ "CAPSLOCK",   KBD_KEY_CAPSLOCK,       KEYCODE_CAPSLOCK },
	{ 0, 0, 0 }	/* end of table */
};


static void updatekeyboard(void)
{
	state=kbd_get_state(key_port,key_unit);
}


/* return a list of all available keys */
const struct KeyboardInfo *osd_get_key_list(void)
{
	return keylist;
}

void osd_led_w(int led, int on)
{
}

/* check if a key is pressed. The keycode is the standard PC keyboard code, as */
/* defined in osdepend.h. Return 0 if the key is not pressed, nonzero otherwise. */
int osd_is_key_pressed(int keycode)
{	
	int i;


	if ((keycode == KBD_KEY_LSHIFT) && (state->cond.modifiers & KBD_MOD_LSHIFT))
		return 1;
	if ((keycode == KBD_KEY_RSHIFT) && (state->cond.modifiers & KBD_MOD_RSHIFT))
		return 1;
	if ((keycode == KBD_KEY_LCONTROL) && (state->cond.modifiers & KBD_MOD_LCTRL))
		return 1;
	if ((keycode == KBD_KEY_RCONTROL) && (state->cond.modifiers & KBD_MOD_RCTRL))
		return 1;
	if ((keycode == KBD_KEY_ALT) && (state->cond.modifiers & KBD_MOD_LALT))
		return 1;
	if ((keycode == KBD_KEY_ALTGR) && (state->cond.modifiers & KBD_MOD_RALT))
		return 1;

		for (i = 0; i < 6; i++)
		{
			if (state->cond.keys[i] == keycode)
			{
				return 1;
			}
		}

	// add all joystick keys here
	if (maple_joystick_addr[0])
	{
	// special case for ESC
	if((keycode==KBD_KEY_ESCAPE) && !(ccond[0].buttons & CONT_A) 
		 && !(ccond[0].buttons & CONT_START))
	{
		// wait for release before returning
		do
		{
			poll_joysticks();
			timer_spin_sleep(100);
		}
		while (!(ccond[0].buttons & CONT_A) 
			 || !(ccond[0].buttons & CONT_START));
		
		return 1;
	}

		// coins
		if ((keycode==KBD_KEY_5) && !(ccond[0].rtrig > 16) && !(ccond[0].buttons & CONT_Y))
			return 1;
		
		// player
		if ((keycode==KBD_KEY_1) && !(ccond[0].buttons & CONT_START))
			return 1;
			
		if ((keycode==KBD_KEY_1) && !(ccond[0].buttons & CONT_A))
			return 1;
		
		// up
		if ((keycode==KBD_KEY_UP) && !(ccond[0].buttons & CONT_DPAD_UP))
			return 1;
	//	if ((keycode==KBD_KEY_UP) && ccond[0].joyy<(128-16))
	//		return 1;
		
		// down
		if ((keycode==KBD_KEY_DOWN) && !(ccond[0].buttons & CONT_DPAD_DOWN))
			return 1;
	//	if ((keycode==KBD_KEY_DOWN) && ccond[0].joyy>(128+16))
	//		return 1;
		
		// left
		if ((keycode==KBD_KEY_LEFT) && !(ccond[0].buttons & CONT_DPAD_LEFT))
			return 1;
	//	if ((keycode==KBD_KEY_LEFT) && ccond[0].joyx<(128-16))
	//		return 1;
		
		// right	
		if ((keycode==KBD_KEY_RIGHT) && !(ccond[0].buttons & CONT_DPAD_RIGHT))
			return 1;
	//	if ((keycode==KBD_KEY_RIGHT) && ccond[0].joyx>(128+16))
	//		return 1;
			
		// button 1	
		if ((keycode==KBD_KEY_LCONTROL) && !(ccond[0].buttons & CONT_A))
			return 1;
 

		// button 2
		if ((keycode==KBD_KEY_ALT) && !(ccond[0].buttons & CONT_X))
			return 1;
			
		// button 3
		if ((keycode==KBD_KEY_SPACE) && !(ccond[0].buttons & CONT_B))
			return 1;
		
		// button 4
		if ((keycode==KBD_KEY_LSHIFT) && !(ccond[0].buttons & CONT_Y))
			return 1;

	//	UI toggle
	//	if ((keycode==KBD_KEY_TAB) && (ccond[0].ltrig > 16))
		//	return 1;

		// UI select
		if ((keycode==KBD_KEY_ENTER) && !(ccond[0].buttons & CONT_A))
			return 1;
			
	}

	if (maple_joystick_addr[1])
	{
		if ((keycode==KBD_KEY_5) && !(ccond[0].rtrig > 16) && !(ccond[0].buttons & CONT_Y))
			return 1;

		if ((keycode==KBD_KEY_2) && !(ccond[1].buttons & CONT_START))
			return 1;

		if ((keycode==KBD_KEY_R) && !(ccond[1].buttons & CONT_DPAD_UP))
			return 1;
	//	if ((keycode==KBD_KEY_R) && ccond[1].joyy<(128-16))
	//		return 1;

		if ((keycode==KBD_KEY_F) && !(ccond[1].buttons & CONT_DPAD_DOWN))
			return 1;
	//	if ((keycode==KBD_KEY_F) && ccond[1].joyy>(128+16))
	//		return 1;

		if ((keycode==KBD_KEY_D) && !(ccond[1].buttons & CONT_DPAD_LEFT))
			return 1;
	//	if ((keycode==KBD_KEY_D) && ccond[1].joyx<(128-16))
	//		return 1;

		if ((keycode==KBD_KEY_G) && !(ccond[1].buttons & CONT_DPAD_RIGHT))
			return 1;
	//	if ((keycode==KBD_KEY_G) && ccond[1].joyx>(128+16))
	//		return 1;

		if ((keycode==KBD_KEY_A) && !(ccond[1].buttons & CONT_A))
			return 1;
			
		

		if ((keycode==KBD_KEY_S) && !(ccond[1].buttons & CONT_X))
			return 1;

		if ((keycode==KBD_KEY_Q) && !(ccond[1].buttons & CONT_B))
			return 1;

		if ((keycode==KBD_KEY_W) && !(ccond[1].buttons & CONT_Y))
			return 1;
	}
#if 0
	if (maple_joystick_addr[2])
	{
		if ((keycode==KBD_KEY_7) && (ccond[2].rtrig > 16))
			return 1;

		if ((keycode==KBD_KEY_3) && !(ccond[2].buttons & CONT_START))
			return 1;

		if ((keycode==KBD_KEY_I) && !(ccond[2].buttons & CONT_DPAD_UP))
			return 1;
		if ((keycode==KBD_KEY_I) && ccond[2].joyy<(128-16))
			return 1;

		if ((keycode==KBD_KEY_K) && !(ccond[2].buttons & CONT_DPAD_DOWN))
			return 1;
		if ((keycode==KBD_KEY_K) && ccond[2].joyy>(128+16))
			return 1;

		if ((keycode==KBD_KEY_J) && !(ccond[2].buttons & CONT_DPAD_LEFT))
			return 1;
		if ((keycode==KBD_KEY_J) && ccond[2].joyx<(128-16))
			return 1;

		if ((keycode==KBD_KEY_L) && !(ccond[2].buttons & CONT_DPAD_RIGHT))
			return 1;
		if ((keycode==KBD_KEY_L) && ccond[2].joyx>(128+16))
			return 1;

		if ((keycode==KBD_KEY_RCONTROL) && !(ccond[2].buttons & CONT_A))
			return 1;

		if ((keycode==KBD_KEY_RSHIFT) && !(ccond[2].buttons & CONT_X))
			return 1;

		if ((keycode==KEYCODE_STOP) && !(ccond[2].buttons & CONT_B))
			return 1;

		if ((keycode==KEYCODE_SLASH) && !(ccond[2].buttons & CONT_Y))
			return 1;
	}

	if (maple_joystick_addr[3])
	{
		if ((keycode==KBD_KEY_8) && (ccond[3].rtrig > 16))
			return 1;
			
		if ((keycode==KBD_KEY_4) && !(ccond[3].buttons & CONT_START))
			return 1;

		if ((keycode==KEYCODE_COLON) && !(ccond[3].buttons & CONT_DPAD_UP))
			return 1;
		if ((keycode==KEYCODE_COLON) && ccond[3].joyy<(128-16))
			return 1;

		if ((keycode==KEYCODE_QUOTE) && !(ccond[3].buttons & CONT_DPAD_DOWN))
			return 1;
		if ((keycode==KEYCODE_QUOTE) && ccond[3].joyy>(128+16))
			return 1;

		if ((keycode==KEYCODE_BACKSLASH) && !(ccond[3].buttons & CONT_DPAD_LEFT))
			return 1;
		if ((keycode==KEYCODE_BACKSLASH) && ccond[3].joyx<(128-16))
			return 1;

		if ((keycode==KEYCODE_COMMA) && !(ccond[3].buttons & CONT_DPAD_RIGHT))
			return 1;
		if ((keycode==KEYCODE_COMMA) && ccond[3].joyx>(128+16))
			return 1;

		if ((keycode==KEYCODE_F1) && !(ccond[3].buttons & CONT_A))
			return 1;
		if ((keycode==KEYCODE_F2) && !(ccond[3].buttons & CONT_X))
			return 1;

		if ((keycode==KEYCODE_OPENBRACE) && !(ccond[3].buttons & CONT_B))
			return 1;

		if ((keycode==KEYCODE_CLOSEBRACE) && !(ccond[3].buttons & CONT_Y))
			return 1;
	}
#endif	
	return 0;
}

int osd_readkey_unicode(int flush)
{
	return 0;
}

/* wait for a key press and return the keycode */
int osd_wait_keypress(void)
{
	return 0;
} 

#define JOYCODE(joy,stick,axis_or_button,dir) \
		((((dir)&0x03)<<14)|(((axis_or_button)&0x3f)<<8)|(((stick)&0x1f)<<3)|(((joy)&0x07)<<0))

#define GET_JOYCODE_JOY(code) (((code)>>0)&0x07)
#define GET_JOYCODE_BUTTON(code) (((code)>>8)&0x3f)

#define MAX_JOY 256
#define MAX_JOY_NAME_LEN 40

static int last_check = -1;

static int joyequiv[][2] =
{
	{ JOYCODE(1,0,1,0),	JOYCODE_1_BUTTON1 },
	{ JOYCODE(1,0,2,0),	JOYCODE_1_BUTTON2 },
	{ JOYCODE(1,0,3,0),	JOYCODE_1_BUTTON3 },
	{ JOYCODE(1,0,4,0),	JOYCODE_1_BUTTON4 },
	{ JOYCODE(1,0,5,0),	JOYCODE_1_BUTTON5 },
	{ JOYCODE(1,0,6,0),	JOYCODE_1_LEFT },
	{ JOYCODE(1,0,7,0),	JOYCODE_1_RIGHT },
	{ JOYCODE(1,0,8,0),	JOYCODE_1_UP },
	{ JOYCODE(1,0,9,0),	JOYCODE_1_DOWN },
	{ JOYCODE(1,0,10,0),JOYCODE_1_BUTTON6 },
	
	{ JOYCODE(2,0,1,0),	JOYCODE_2_BUTTON1 },
	{ JOYCODE(2,0,2,0),	JOYCODE_2_BUTTON2 },
	{ JOYCODE(2,0,3,0),	JOYCODE_2_BUTTON3 },
	{ JOYCODE(2,0,4,0),	JOYCODE_2_BUTTON4 },
	{ JOYCODE(2,0,5,0),	JOYCODE_2_BUTTON5 },
	{ JOYCODE(2,0,6,0),	JOYCODE_2_LEFT },
	{ JOYCODE(2,0,7,0),	JOYCODE_2_RIGHT },
	{ JOYCODE(2,0,8,0),	JOYCODE_2_UP },
	{ JOYCODE(2,0,9,0),	JOYCODE_2_DOWN },
	{ JOYCODE(2,0,10,0),JOYCODE_2_BUTTON6 },

	{ JOYCODE(3,0,1,0),	JOYCODE_3_BUTTON1 },
	{ JOYCODE(3,0,2,0),	JOYCODE_3_BUTTON2 },
	{ JOYCODE(3,0,3,0),	JOYCODE_3_BUTTON3 },
	{ JOYCODE(3,0,4,0),	JOYCODE_3_BUTTON4 },
	{ JOYCODE(3,0,5,0),	JOYCODE_3_BUTTON5 },
	{ JOYCODE(3,0,6,0),	JOYCODE_3_LEFT },
	{ JOYCODE(3,0,7,0),	JOYCODE_3_RIGHT },
	{ JOYCODE(3,0,8,0),	JOYCODE_3_UP },
	{ JOYCODE(3,0,9,0),	JOYCODE_3_DOWN },
	{ JOYCODE(3,0,10,0),JOYCODE_3_BUTTON6 },

	{ JOYCODE(4,0,1,0),	JOYCODE_4_BUTTON1 },
	{ JOYCODE(4,0,2,0),	JOYCODE_4_BUTTON2 },
	{ JOYCODE(4,0,3,0),	JOYCODE_4_BUTTON3 },
	{ JOYCODE(4,0,4,0),	JOYCODE_4_BUTTON4 },
	{ JOYCODE(4,0,5,0),	JOYCODE_4_BUTTON5 },
	{ JOYCODE(4,0,6,0),	JOYCODE_4_LEFT },
	{ JOYCODE(4,0,7,0),	JOYCODE_4_RIGHT },
	{ JOYCODE(4,0,8,0),	JOYCODE_4_UP },
	{ JOYCODE(4,0,9,0),	JOYCODE_4_DOWN },
	{ JOYCODE(4,0,10,0),JOYCODE_4_BUTTON6 },
	{ 0,0 }
};

static struct JoystickInfo joylist[MAX_JOY] =
{
	/* will be filled later */
	{ 0, 0, 0 }	/* end of table */
};

static char joynames[MAX_JOY][MAX_JOY_NAME_LEN+1];	/* will be used to store names for the above */

static char joy_button_name[11][MAX_JOY_NAME_LEN + 1] = 
{
	"A",
	"B",
	"X",
	"Y",
	"Start",
	"Left",
	"Right",
	"Up",
	"Down",
	"R Trig",
	"L Trig"
};

static int joy_button_mask[9] = 
{
	CONT_A,
	CONT_B,
  	CONT_X,
  	CONT_Y,
  	CONT_START,
  	CONT_DPAD_LEFT,
  	CONT_DPAD_RIGHT,
  	CONT_DPAD_UP,
  	CONT_DPAD_DOWN
};

static void init_joy_list(void)
{
	int tot,i,j;
	char buf[256];

// sorry but don't even think about adding real joysticks, it will slow it way down real fast
return;
#if 0
	tot = 0;

	// four dreamcast controllers
	for (i = 0;i < count;i++)
	{		
		// Start, A, B, X, & Y, up, down, left, right, right & left trigger
		for (j = 0;j < 11;j++)
		{
			sprintf(buf,"J%d %s",i+1,joy_button_name[j]);
			strncpy(joynames[tot],buf,MAX_JOY_NAME_LEN);
			joynames[tot][MAX_JOY_NAME_LEN] = 0;
			joylist[tot].name = joynames[tot];
			joylist[tot].code = JOYCODE(i+1,0,j+1,0);
			tot++;
		}
	}

	/* terminate array */
	joylist[tot].name = 0;
	joylist[tot].code = 0;
	joylist[tot].standardcode = 0;

	/* fill in equivalences */
	for (i = 0;i < tot;i++)
	{
		joylist[i].standardcode = JOYCODE_OTHER;

		j = 0;
		while (joyequiv[j][0] != 0)
		{
			if (joyequiv[j][0] == joylist[i].code)
			{
				joylist[i].standardcode = joyequiv[j][1];
				break;
			}
			j++;
		}
	}
#endif
}

/* return a list of all available joys */
const struct JoystickInfo *osd_get_joy_list(void)
{
//	init_joy_list();
	
	return joylist;
}

int osd_is_joy_pressed(int joycode)
{
	int joy_num,button;

// sorry but don't even think about adding real joysticks, it will slow it way down real fast
	return 0;

	// check for max joysticks
	joy_num = GET_JOYCODE_JOY(joycode) - 1;
	if (joy_num > 3)
	{
		return 0;
	}
	
	// no joystick
	if (maple_joystick_addr[joy_num] == 0)
	{
		return 0;
	}

	button = GET_JOYCODE_BUTTON(joycode) - 1;

	if (button == 9)
	{
		return (ccond[joy_num].rtrig > 16);
	}
	else if (button == 10)
	{
		return (ccond[joy_num].ltrig > 16);
	}
	else
	{
		return !(ccond[joy_num].buttons & joy_button_mask[button]);
	}
}

void poll_joysticks(void)
{
	
	static int count = 0;
	if (last_check == maple_state.vbl_cntr)
		return ;
	
	last_check = maple_state.vbl_cntr;

	updatekeyboard() ;

//	if (count != 2)
	{
		// read the joysticks, one at a time
		if (maple_joystick_addr[count])
		{
//		printf("contgetcond")+
		cont_get_cond(maple_joystick_addr[count], &ccond[count]);
		}
	}
	
	// increment and wrap
	count = (count + 1) & 1;
}

/* return a value in the range -128 .. 128 (yes, 128, not 127) */
void osd_analogjoy_read(int player,int *analog_x, int *analog_y)
{
	if (maple_joystick_addr[player] == 0)
	{
		*analog_x = 0;
		*analog_y = 0;
		return;
	}

	*analog_x = ccond[player].joyx - 128;
	*analog_y = ccond[player].joyy - 128;
}

int osd_joystick_needs_calibration (void)
{
	return 0;
}

void osd_joystick_start_calibration (void)
{
}

const char *osd_joystick_calibrate_next (void)
{
	return 0;
}

void osd_joystick_calibrate (void)
{
}

void osd_joystick_end_calibration (void)
{
}

void osd_trak_read(int player,int *deltax,int *deltay)
{
	// add mouse here
	*deltax = 0;
	*deltay = 0;
}

void osd_customize_inputport_defaults(struct ipd *defaults)
{
	while (defaults->type != IPT_END)
	{
		if (defaults->type == (IPT_BUTTON3 | IPF_PLAYER3)) seq_set_1(&defaults->seq,KEYCODE_STOP);
		if (defaults->type == (IPT_BUTTON4 | IPF_PLAYER3)) seq_set_1(&defaults->seq,KEYCODE_SLASH);

		if (defaults->type == (IPT_JOYSTICK_UP    | IPF_PLAYER4)) seq_set_1(&defaults->seq,KEYCODE_COLON);
		if (defaults->type == (IPT_JOYSTICK_DOWN  | IPF_PLAYER4)) seq_set_1(&defaults->seq,KEYCODE_QUOTE);
		if (defaults->type == (IPT_JOYSTICK_LEFT  | IPF_PLAYER4)) seq_set_1(&defaults->seq,KEYCODE_BACKSLASH);
		if (defaults->type == (IPT_JOYSTICK_RIGHT | IPF_PLAYER4)) seq_set_1(&defaults->seq,KEYCODE_COMMA);

		if (defaults->type == (IPT_BUTTON1 | IPF_PLAYER4)) seq_set_1(&defaults->seq,KEYCODE_F1);
		if (defaults->type == (IPT_BUTTON2 | IPF_PLAYER4)) seq_set_1(&defaults->seq,KEYCODE_F2);
		if (defaults->type == (IPT_BUTTON3 | IPF_PLAYER4)) seq_set_1(&defaults->seq,KEYCODE_OPENBRACE);
		if (defaults->type == (IPT_BUTTON4 | IPF_PLAYER4)) seq_set_1(&defaults->seq,KEYCODE_CLOSEBRACE);
		defaults++;
	}
}