///////////////////////////////////////////////////////////////////////////////
// File         : scoretab.cpp
// Info         : Show score table
// Written by   : Carlo Borreo borreo@softhome.net
///////////////////////////////////////////////////////////////////////////////

#include "lupengo.h"

#define QUANTUM 200

static struct coord { int x; int y; } titletab[]=
	{
	{ 28,1 },
	{ 27,4 },
	{ 27,6 },
	{ 26,7 },
	{ 25,9 },
	{ 25,10 },
	{ 24,13 },
	{ 22,15 },
	{ 22,17 },
	{ 21,20 },
	{ 20,22 },
	{ 20,24 },
	{ 19,25 },
	{ 19,27 },
	{ 18,29 },
	{ 18,31 },
	{ 18,33 },
	{ 17,35 },
	{ 15,38 },
	{ 14,39 },
	{ 12,41 },
	{ 11,43 },
	{ 10,44 },
	{ 8,47 },
	{ 7,49 },
	{ 5,51 },
	{ 4,52 },
	{ 3,54 },
	{ 2,57 },
	{ 1,59 },
	{ 0,60 },
	{ 0,61 },
	{ 0,63 },
	{ 1,65 },
	{ 2,65 },
	{ 4,66 },
	{ 8,67 },
	{ 10,68 },
	{ 12,68 },
	{ 14,68 },
	{ 15,69 },
	{ 19,69 },
	{ 21,69 },
	{ 26,69 },
	{ 30,69 },
	{ 34,68 },
	{ 39,68 },
	{ 43,68 },
	{ 50,67 },
	{ 53,67 },
	{ 59,67 },
	{ 64,67 },
	{ 69,67 },
	{ 72,67 },
	{ 72,66 },
	{ 72,66 },
	{ 72,66 },
	{ 73,66 },
	{ 107,30 },
	{ 107,32 },
	{ 107,34 },
	{ 107,37 },
	{ 107,40 },
	{ 107,42 },
	{ 107,45 },
	{ 107,49 },
	{ 107,51 },
	{ 107,54 },
	{ 107,57 },
	{ 108,59 },
	{ 109,61 },
	{ 111,62 },
	{ 114,64 },
	{ 116,65 },
	{ 119,66 },
	{ 122,67 },
	{ 127,68 },
	{ 130,68 },
	{ 134,68 },
	{ 137,67 },
	{ 141,66 },
	{ 145,64 },
	{ 149,62 },
	{ 152,60 },
	{ 154,58 },
	{ 156,54 },
	{ 156,52 },
	{ 157,49 },
	{ 157,45 },
	{ 158,42 },
	{ 158,39 },
	{ 157,36 },
	{ 157,33 },
	{ 157,30 },
	{ 157,29 },
	{ 157,29 },
	{ 157,29 },
	{ 157,28 },
	{ 193,24 },
	{ 193,24 },
	{ 193,24 },
	{ 193,27 },
	{ 193,30 },
	{ 194,33 },
	{ 195,37 },
	{ 196,41 },
	{ 196,46 },
	{ 197,49 },
	{ 197,52 },
	{ 197,56 },
	{ 197,57 },
	{ 197,59 },
	{ 197,60 },
	{ 197,62 },
	{ 198,64 },
	{ 198,66 },
	{ 198,67 },
	{ 198,68 },
	{ 198,68 },
	{ 198,68 },
	{ 198,68 },
	{ 202,20 },
	{ 203,20 },
	{ 207,20 },
	{ 219,22 },
	{ 227,23 },
	{ 233,25 },
	{ 238,28 },
	{ 241,31 },
	{ 241,34 },
	{ 237,37 },
	{ 231,41 },
	{ 226,43 },
	{ 220,45 },
	{ 216,46 },
	{ 212,46 },
	{ 209,46 },
	{ 206,46 },
	{ 205,46 },
	{ 204,46 },
	{ 203,46 },
	{ 203,47 },
	{ 203,46 },
	{ 276,19 },
	{ 276,19 },
	{ 276,21 },
	{ 275,25 },
	{ 274,30 },
	{ 274,33 },
	{ 274,36 },
	{ 274,40 },
	{ 273,43 },
	{ 273,46 },
	{ 273,50 },
	{ 273,53 },
	{ 274,56 },
	{ 274,59 },
	{ 274,61 },
	{ 275,63 },
	{ 276,63 },
	{ 277,64 },
	{ 278,64 },
	{ 279,64 },
	{ 282,65 },
	{ 287,65 },
	{ 290,65 },
	{ 295,65 },
	{ 299,66 },
	{ 302,66 },
	{ 306,66 },
	{ 311,66 },
	{ 312,66 },
	{ 312,66 },
	{ 312,66 },
	{ 279,40 },
	{ 280,40 },
	{ 283,40 },
	{ 290,40 },
	{ 294,40 },
	{ 295,40 },
	{ 298,40 },
	{ 300,40 },
	{ 303,40 },
	{ 304,40 },
	{ 307,40 },
	{ 308,40 },
	{ 308,40 },
	{ 276,15 },
	{ 276,15 },
	{ 285,15 },
	{ 292,16 },
	{ 295,17 },
	{ 298,17 },
	{ 301,17 },
	{ 303,17 },
	{ 307,17 },
	{ 310,17 },
	{ 312,17 },
	{ 313,17 },
	{ 313,17 },
	{ 313,17 },
	{ 354,17 },
	{ 354,17 },
	{ 354,17 },
	{ 354,21 },
	{ 354,23 },
	{ 354,27 },
	{ 355,32 },
	{ 355,35 },
	{ 355,38 },
	{ 355,41 },
	{ 355,44 },
	{ 355,48 },
	{ 355,51 },
	{ 354,54 },
	{ 354,58 },
	{ 353,59 },
	{ 353,61 },
	{ 353,63 },
	{ 353,63 },
	{ 353,64 },
	{ 353,64 },
	{ 353,64 },
	{ 353,65 },
	{ 353,65 },
	{ 353,15 },
	{ 354,16 },
	{ 356,18 },
	{ 360,20 },
	{ 362,22 },
	{ 367,25 },
	{ 373,29 },
	{ 377,33 },
	{ 381,38 },
	{ 386,44 },
	{ 388,46 },
	{ 389,48 },
	{ 390,48 },
	{ 391,50 },
	{ 392,52 },
	{ 393,53 },
	{ 395,55 },
	{ 396,57 },
	{ 397,59 },
	{ 398,61 },
	{ 399,62 },
	{ 400,63 },
	{ 400,64 },
	{ 400,64 },
	{ 403,12 },
	{ 403,14 },
	{ 404,16 },
	{ 405,19 },
	{ 405,21 },
	{ 406,24 },
	{ 407,27 },
	{ 408,29 },
	{ 408,33 },
	{ 409,36 },
	{ 409,39 },
	{ 409,44 },
	{ 409,48 },
	{ 408,51 },
	{ 407,55 },
	{ 405,57 },
	{ 404,61 },
	{ 403,63 },
	{ 403,64 },
	{ 402,65 },
	{ 503,13 },
	{ 501,12 },
	{ 499,11 },
	{ 496,11 },
	{ 491,10 },
	{ 484,11 },
	{ 477,12 },
	{ 470,14 },
	{ 466,16 },
	{ 462,19 },
	{ 458,22 },
	{ 453,27 },
	{ 449,30 },
	{ 448,34 },
	{ 447,37 },
	{ 447,39 },
	{ 446,43 },
	{ 447,45 },
	{ 448,48 },
	{ 450,52 },
	{ 452,54 },
	{ 455,57 },
	{ 458,59 },
	{ 462,60 },
	{ 469,63 },
	{ 475,64 },
	{ 480,64 },
	{ 486,63 },
	{ 492,62 },
	{ 497,60 },
	{ 502,58 },
	{ 506,55 },
	{ 508,52 },
	{ 508,49 },
	{ 508,48 },
	{ 508,46 },
	{ 508,44 },
	{ 508,44 },
	{ 508,44 },
	{ 508,44 },
	{ 508,46 },
	{ 508,51 },
	{ 508,55 },
	{ 509,59 },
	{ 509,64 },
	{ 510,67 },
	{ 510,72 },
	{ 510,74 },
	{ 510,75 },
	{ 510,76 },
	{ 510,76 },
	{ 510,76 },
	{ 510,76 },
	{ 516,72 },
	{ 582,11 },
	{ 579,9 },
	{ 578,9 },
	{ 575,9 },
	{ 570,9 },
	{ 566,10 },
	{ 562,12 },
	{ 558,14 },
	{ 554,18 },
	{ 551,21 },
	{ 547,28 },
	{ 546,31 },
	{ 545,35 },
	{ 545,38 },
	{ 545,41 },
	{ 545,43 },
	{ 545,48 },
	{ 547,51 },
	{ 548,53 },
	{ 549,55 },
	{ 551,56 },
	{ 554,58 },
	{ 555,59 },
	{ 559,61 },
	{ 562,62 },
	{ 564,62 },
	{ 567,62 },
	{ 572,62 },
	{ 578,61 },
	{ 583,60 },
	{ 586,59 },
	{ 590,57 },
	{ 594,55 },
	{ 598,52 },
	{ 602,49 },
	{ 603,46 },
	{ 604,43 },
	{ 604,39 },
	{ 604,34 },
	{ 604,29 },
	{ 604,26 },
	{ 602,23 },
	{ 600,20 },
	{ 598,17 },
	{ 596,16 },
	{ 593,14 },
	{ -1, -1 },
	} ;

// ScoreTabDesc commands:
// X: start title screen
// Y: finish title screen
// Dnnn: Delay nnn milliseconds
// Stext: Show "text"
// Px y n: draw image "n" at (x,y)
// M: Display menu
static char *ScoreTabDesc[] = {
	"X",
	"D8000",
	"Y",
	"C",
	"M",
	"SLupengo v" VERSION,
	"D1500",
	"SCrush Enemies",
	"P4 2 1",
	"P5 5 21",
	"P10 5 10",
	"P11 5 21",
	"D200",
	"P4 2 1",
	"D200",
	"P4 2 0",
	"P4 3 1",
	"D200",
	"P4 3 0",
	"P4 4 1",
	"D200",
	"P4 4 0",
	"P4 5 1",
	"D200",
	"P4 5 3",
	"D200",
	"P5 5 21",
	"D200",
	"P5 5 0",
	"P6 5 21",
	"D200",
	"P6 5 0",
	"P7 5 21",
	"D200",
	"P7 5 0",
	"P8 5 21",
	"D200",
	"P8 5 0",
	"P9 5 21",
	"D200",
	"P9 5 0",
	"P10 5 21",
	"D200",
	"P10 5 35",
	"S400 Points",
	"D1000",
	"B",
	"SCrush Enemies",
	"P4 2 1",
	"P5 5 21",
	"P9 5 10",
	"P10 5 10",
	"P11 5 21",
	"D200",
	"P4 2 1",
	"D200",
	"P4 2 0",
	"P4 3 1",
	"D200",
	"P4 3 0",
	"P4 4 1",
	"D200",
	"P4 4 0",
	"P4 5 1",
	"D200",
	"P4 5 3",
	"D200",
	"P5 5 21",
	"D200",
	"P5 5 0",
	"P6 5 21",
	"D200",
	"P6 5 0",
	"P7 5 21",
	"D200",
	"P7 5 0",
	"P8 5 21",
	"D200",
	"P8 5 0",
	"P9 5 21",
	"D200",
	"P9 5 0",
	"P10 5 21",
	"D200",
	"P10 5 36",
	"S1600 Points",
	"D1000",
	"B",
	"SCrush Enemies",
	"P4 2 1",
	"P5 5 21",
	"P8 5 10",
	"P9 5 10",
	"P10 5 10",
	"P11 5 21",
	"D200",
	"P4 2 1",
	"D200",
	"P4 2 0",
	"P4 3 1",
	"D200",
	"P4 3 0",
	"P4 4 1",
	"D200",
	"P4 4 0",
	"P4 5 1",
	"D200",
	"P4 5 3",
	"D200",
	"P5 5 21",
	"D200",
	"P5 5 0",
	"P6 5 21",
	"D200",
	"P6 5 0",
	"P7 5 21",
	"D200",
	"P7 5 0",
	"P8 5 21",
	"D200",
	"P8 5 0",
	"P9 5 21",
	"D200",
	"P9 5 0",
	"P10 5 21",
	"D200",
	"P10 5 37",
	"S6400 Points",
	"D1000",
	"B",
	"SCrush Enemies",
	"P4 2 1",
	"P5 5 21",
	"P7 5 10",
	"P8 5 10",
	"P9 5 10",
	"P10 5 10",
	"P11 5 21",
	"D200",
	"P4 2 1",
	"D200",
	"P4 2 0",
	"P4 3 1",
	"D200",
	"P4 3 0",
	"P4 4 1",
	"D200",
	"P4 4 0",
	"P4 5 1",
	"D200",
	"P4 5 3",
	"D200",
	"P5 5 21",
	"D200",
	"P5 5 0",
	"P6 5 21",
	"D200",
	"P6 5 0",
	"P7 5 21",
	"D200",
	"P7 5 0",
	"P8 5 21",
	"D200",
	"P8 5 0",
	"P9 5 21",
	"D200",
	"P9 5 0",
	"P10 5 21",
	"D200",
	"P10 5 38",
	"S25600 Points",
	"D1000",
	"B",
	"SStun Enemies",
	"P1 5 23",
	"P2 5 23",
	"P3 5 23",
	"P4 5 23",
	"P5 5 23",
	"P6 5 23",
	"P7 5 23",
	"P8 5 23",
	"P9 5 23",
	"P10 5 23",
	"P11 5 23",
	"P12 5 23",
	"P13 5 23",
	"P14 5 23",
	"P15 5 23",
	"P10 4 10",
	"P5 1 1",
	"D200",
	"P5 1 1",
	"D200",
	"P5 1 0",
	"P5 2 1",
	"D200",
	"P5 2 0",
	"P5 3 1",
	"D200",
	"P5 3 0",
	"P5 4 1",
	"P1 5 19",
	"P2 5 19",
	"P3 5 19",
	"P4 5 19",
	"P5 5 19",
	"P6 5 19",
	"P7 5 19",
	"P8 5 19",
	"P9 5 19",
	"P10 5 19",
	"P11 5 19",
	"P12 5 19",
	"P13 5 19",
	"P14 5 19",
	"P15 5 19",
	"P10 4 15",
	"D200",
	"P1 5 17",
	"P2 5 17",
	"P3 5 17",
	"P4 5 17",
	"P5 5 17",
	"P6 5 17",
	"P7 5 17",
	"P8 5 17",
	"P9 5 17",
	"P10 5 17",
	"P11 5 17",
	"P12 5 17",
	"P13 5 17",
	"P14 5 17",
	"P15 5 17",
	"D200",
	"D200",
	"P5 4 3",
	"D200",
	"P5 4 0",
	"P6 4 3",
	"D200",
	"P6 4 0",
	"P7 4 3",
	"D200",
	"P7 4 0",
	"P8 4 3",
	"D200",
	"P8 4 0",
	"P9 4 3",
	"D200",
	"P9 4 0",
	"P10 4 3",
	"D200",
	"P10 4 0",
	"P11 4 3",
	"S100 Points",
	"P1 5 23",
	"P2 5 23",
	"P3 5 23",
	"P4 5 23",
	"P5 5 23",
	"P6 5 23",
	"P7 5 23",
	"P8 5 23",
	"P9 5 23",
	"P10 5 23",
	"P11 5 23",
	"P12 5 23",
	"P13 5 23",
	"P14 5 23",
	"P15 5 23",
	"D2000",
	"B",
	"S3 in a row",
	"P4 2 1",
	"P5 5 22",
	"P10 5 22",
	"P11 5 22",
	"D200",
	"P4 2 1",
	"D200",
	"P4 2 0",
	"P4 3 1",
	"D200",
	"P4 3 0",
	"P4 4 1",
	"D200",
	"P4 4 0",
	"P4 5 1",
	"D200",
	"P4 5 3",
	"D200",
	"P5 5 22",
	"D200",
	"P5 5 0",
	"P6 5 22",
	"D200",
	"P6 5 0",
	"P7 5 22",
	"D200",
	"P7 5 0",
	"P8 5 22",
	"D200",
	"P8 5 0",
	"P9 5 22",
	"S5000 to 10000 Points",
	"D2000",
	"B",
	"S2 players is better than one",
	"P1 5 23",
	"P2 5 23",
	"P3 5 23",
	"P4 5 23",
	"P5 5 23",
	"P6 5 23",
	"P7 5 23",
	"P8 5 23",
	"P9 5 23",
	"P10 5 23",
	"P11 5 23",
	"P12 5 23",
	"P13 5 23",
	"P14 5 23",
	"P15 5 23",
	"P10 4 10",
	"P12 4 6",
	"P5 1 1",
	"D200",
	"P5 1 1",
	"D200",
	"P5 1 0",
	"P5 2 1",
	"D200",
	"P5 2 0",
	"P5 3 1",
	"D200",
	"P5 3 0",
	"P5 4 1",
	"P1 5 19",
	"P2 5 19",
	"P3 5 19",
	"P4 5 19",
	"P5 5 19",
	"P6 5 19",
	"P7 5 19",
	"P8 5 19",
	"P9 5 19",
	"P10 5 19",
	"P11 5 19",
	"P12 5 19",
	"P13 5 19",
	"P14 5 19",
	"P15 5 19",
	"P10 4 15",
	"D200",
	"P1 5 17",
	"P2 5 17",
	"P3 5 17",
	"P4 5 17",
	"P5 5 17",
	"P6 5 17",
	"P7 5 17",
	"P8 5 17",
	"P9 5 17",
	"P10 5 17",
	"P11 5 17",
	"P12 5 17",
	"P13 5 17",
	"P14 5 17",
	"P15 5 17",
	"D200",
	"P12 4 6",
	"D200",
	"P12 4 0",
	"P11 4 6",
	"D200",
	"P11 4 0",
	"P10 4 6",
	"D200",
	"P10 4 0",
	"P9 4 6",
	"S100 Points",
	"P1 5 23",
	"P2 5 23",
	"P3 5 23",
	"P4 5 23",
	"P5 5 23",
	"P6 5 23",
	"P7 5 23",
	"P8 5 23",
	"P9 5 23",
	"P10 5 23",
	"P11 5 23",
	"P12 5 23",
	"P13 5 23",
	"P14 5 23",
	"P15 5 23",
	"D2000",
// Top ten
	"T0",
	"D5000",
	"T1",
	"D5000",
	NULL
	} ;

static void MyDelay( int n )
	{
	if ( ! SpacePressed() )
		SDL_Delay( n ) ;
	}

static void ShowTitle( void )
	{
	static int CircleShape = CIRCLEMIN ;
	struct coord *p ;

	PictureSetRefresh( 0 ) ;

	CircleShape ++ ;
	if ( CircleShape > CIRCLEMAX )
		CircleShape = CIRCLEMIN ;
	for ( p = titletab ; p->x >= 0 ; p ++ )
		PictureDraw( p->x, p->y, CircleShape ) ;

	PictureSetRefresh( 1 ) ;
	PictureRefreshScreen() ;
	}

static char **ScoreTabPtr = NULL ;
static int RemainingDelay = 0 ;
static int TitleScreenDone = 0 ;

void AttractStart( void )
	{
	CurrentStatus = STATUS_ATTRACT ;
	ScoreTabPtr = ScoreTabDesc ;
	TitleScreenDone = 0 ;
	RemainingDelay = 0 ;
	}

int GetInt( char **s )
	{
	int n = 0 ;

	while ( isspace( **s ) )
		(*s) ++ ;
	while ( **s && isdigit( **s ) )
		{
		n = ( n * 10 ) + ( **s - '0' ) ;
		(*s) ++ ;
		}
	return n ;
	}

// Input: int Quantum: "Quantum" of time, i.e. duration of one call to the main function
// Return: 1=continue, 0=done

int DoAttractMode( int TimeQuantum )
	{
	char *s ;
	int x, y, n ;
	static int TitleCounter = 0 ;

	if ( TitleScreenDone && TitleCounter ++ % 10 == 0 )
		ShowTitle() ;

	// If we are starting now, initialize everything
	while ( TimeQuantum > 0 )
		{
		if ( RemainingDelay >= TimeQuantum )
			{
			MyDelay( TimeQuantum ) ;
			RemainingDelay -= TimeQuantum ;
			break ;
			}
		else if ( RemainingDelay > 0 )
			{
			MyDelay( RemainingDelay ) ;
			RemainingDelay = 0 ;
			TimeQuantum -= RemainingDelay ;
			}
		else
			{
			if ( ScoreTabPtr == NULL || *ScoreTabPtr == NULL )
				AttractStart() ;
			s = * ScoreTabPtr ++ ;
			if ( s == NULL )
				{
				ScoreTabPtr = NULL ;
				return 0 ;
				}
			switch ( *s ++ )
				{
				case 'X':
					PictureDraw( 0, 0, TITLESCR ) ;
					PlaySound( "title" ) ;
					TitleScreenDone = 0 ;
					break ;
				case 'Y':
					TitleScreenDone = 1 ;
					break ;
				case 'P':
					x = GetInt( &s ) ;
					y = GetInt( &s ) ;
					n = GetInt( &s ) ;
					PicturePutScreen( x, y + 8 + 2, n ) ;
					break ;
				case 'D':
					n = GetInt( &s ) ;
					RemainingDelay = n ;
					break ;
				case 'S':
					PictureDisplayText( s, DF_BOTTOM | DF_NOWAIT ) ;
					break ;
				case 'C':
					PictureClearAll() ;
					return 1 ;
				case 'B':
					PictureClearBottom() ;
					return 1 ;
				case 'T':
					n = GetInt( &s ) ;
					TopTenDisplay( n, -1 ) ;
					return 1 ;
				case 'M':
					DisplayMenuItems() ;
					return 1 ;
				case '#':	// Remark
				default:
					break ;
				}
			}
		}

	return 1 ;
	}
